/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.load.DeferredDownloadInformation;
import com.ibm.team.filesystem.client.internal.load.UpdateOrder;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport;
import com.ibm.team.filesystem.common.internal.dto.SharePoint;
import com.ibm.team.repository.client.IContentManagerSession;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.scm.common.dto.ISyncTime;
import java.io.UnsupportedEncodingException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UpdateMutator
extends FileSystemOperation {
    private final FileAreaUpdateReport updates;
    protected final ITeamRepository repository;
    private final IConnection connection;
    protected final IContextHandle connectionHandle;
    protected IContentManagerSession contentSession;
    private IComponentHandle lastComponent;
    private String lastPath;
    private boolean lastNewProjectAllowed;
    private boolean lastResult;
    private boolean lastComponentSharedResult;
    private IComponent lastComponentShareTested;
    private Set<UUID> versionablesToSkip = new HashSet<UUID>();
    private HashSet<ShareReference> inconsistentShares = new HashSet();
    private HashSet<ShareReference> newShares = new HashSet();
    private HashMap<UUID, IComponentStateSummary> componentStatesBefore;
    private HashMap<UUID, IComponentStateSummary> componentStatesAfter;
    private HashSet<UUID> componentNotShared;
    private HashMap<UUID, HashSet<UUID>> shareParents;
    private HashMap<UUID, List<FileAreaUpdate>> failedUpdates;

    public UpdateMutator(ITeamRepository repository, IConnection session, Collection<IComponentStateSummary> componentStatesBefore, Collection<IComponentStateSummary> componentStatesAfter, FileAreaUpdateReport updates, DilemmaHandler problemHandler) {
        super(problemHandler);
        if (repository == null) {
            throw new IllegalArgumentException();
        }
        this.repository = repository;
        if (session instanceof IWorkspaceConnection) {
            this.connectionHandle = ((IWorkspaceConnection)session).getResolvedWorkspace();
        } else if (session instanceof IBaselineConnection) {
            this.connectionHandle = ((IBaselineConnection)session).getBaseline();
        } else {
            throw new IllegalArgumentException();
        }
        this.connection = session;
        if (componentStatesBefore == null) {
            throw new IllegalArgumentException();
        }
        if (componentStatesAfter == null) {
            throw new IllegalArgumentException();
        }
        this.componentStatesBefore = new HashMap();
        for (IComponentStateSummary componentState : componentStatesBefore) {
            this.componentStatesBefore.put(componentState.getComponent().getItemId(), componentState);
        }
        this.componentStatesAfter = new HashMap();
        for (IComponentStateSummary componentState : componentStatesAfter) {
            this.componentStatesAfter.put(componentState.getComponent().getItemId(), componentState);
        }
        this.componentNotShared = new HashSet();
        this.shareParents = new HashMap();
        for (SharePoint sharePoint : updates.getShareParents()) {
            HashSet<Object> shareParentsForComponent = this.shareParents.get(sharePoint.getComponent().getItemId());
            if (shareParentsForComponent == null) {
                shareParentsForComponent = new HashSet();
                this.shareParents.put(sharePoint.getComponent().getItemId(), shareParentsForComponent);
            }
            shareParentsForComponent.add(sharePoint.getVersionable().getItemId());
        }
        this.updates = updates;
        this.failedUpdates = new HashMap();
    }

    protected abstract CopyFileAreaStore getCopyFileArea();

    protected abstract Shareable getRootFolder(String var1);

    protected abstract void preserve(IComponent var1, Shareable var2, IProgressMonitor var3) throws FileSystemClientException, TeamRepositoryException;

    protected abstract void createFile(IComponent var1, DeferredDownloadInformation var2, Shareable var3, IProgressMonitor var4) throws TeamRepositoryException, FileSystemClientException;

    protected abstract void createFolder(IComponent var1, IFolderHandle var2, Shareable var3, String var4, IFolderHandle var5, IProgressMonitor var6) throws TeamRepositoryException, FileSystemClientException;

    protected abstract void modifyFile(IComponent var1, DeferredDownloadInformation var2, Shareable var3, IProgressMonitor var4) throws FileSystemClientException, TeamRepositoryException;

    protected abstract void move(IComponent var1, IComponentHandle var2, Shareable var3, Shareable var4, IFolderHandle var5, String var6, IVersionableHandle var7, IProgressMonitor var8) throws FileSystemClientException, TeamRepositoryException;

    protected abstract Shareable getShareableFor(IPath var1, boolean var2);

    protected abstract void deleteSubtree(IComponent var1, Shareable var2, IProgressMonitor var3) throws FileSystemClientException;

    private final void createFile(IComponent component, FileAreaUpdate update, DeferredDownloadInformation downloadInfo, Date date, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        Shareable newFileShareable;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        String name = downloadInfo.getName();
        IFileItemHandle fileItemState = downloadInfo.getFileItem();
        IFolderHandle parent = downloadInfo.getParent();
        if (!this.isComponentShared(component)) {
            return;
        }
        if (this.skipUpdate(fileItemState.getItemId())) {
            return;
        }
        String errorMsgFileName = name;
        if (this.isShareParent(component, parent)) {
            return;
        }
        IPath parentPath = this.getCopyFileArea().getLocalPathFor((IVersionableHandle)parent, (IComponentHandle)component, this.connectionHandle, null);
        Shareable parentShareable = this.getShareableFor(parentPath, true);
        if (parentShareable == null || !parentShareable.isLocal()) {
            if (parentPath == null) {
                parentPath = this.getCopyFileArea().getRemotePathFor((IVersionableHandle)parent, (IComponentHandle)component, this.connectionHandle, null);
            }
            if (parentPath != null) {
                errorMsgFileName = parentPath.append(name).toString();
                this.recordInconsistentShare((IComponentHandle)component, parentPath.segment(0));
                this.collectStatus(new FileSystemStatus(4, 367, NLS.bind((String)Messages.UpdateMutator_0, (Object)errorMsgFileName, (Object)component.getName())));
            } else {
                this.failedUpdate(update);
            }
            return;
        }
        errorMsgFileName = parentPath.append(name).toString();
        if (!this.isPathValid((IComponentHandle)component, parentShareable.getLocalFullPath(), false)) {
            this.recordInconsistentShare((IComponentHandle)component, parentShareable.getLocalFullPath().segment(0));
            this.collectStatus(new FileSystemStatus(2, 367, NLS.bind((String)Messages.UpdateMutator_1, (Object)errorMsgFileName, (Object)component.getName())));
            return;
        }
        IFileStorage potentialCollision = parentShareable.getFileStorage().getChild(name);
        if (potentialCollision != null && !fileItemState.sameItemId((IItemHandle)potentialCollision.getRemote())) {
            this.handleCollision(component, potentialCollision.getShareable(), (IProgressMonitor)progress.newChild(25));
        }
        if ((newFileShareable = (Shareable)FileSystemCore.getSharingManager().findShareable(this.getCopyFileArea().getRoot(), (IVersionableHandle)fileItemState, (IComponentHandle)component, this.connectionHandle, null)) != null && newFileShareable.isLocal()) {
            IFileStorage existingParent = newFileShareable.getFileStorage().getParent();
            if (!parent.sameItemId((IItemHandle)existingParent.getRemote()) || !name.equals(newFileShareable.getLocalFullPath().lastSegment())) {
                this.move(component, (IComponentHandle)component, newFileShareable, parentShareable, parent, name, (IVersionableHandle)fileItemState, (IProgressMonitor)progress.newChild(25));
                newFileShareable = (Shareable)FileSystemCore.getSharingManager().findShareable(this.getCopyFileArea().getRoot(), (IVersionableHandle)fileItemState, (IComponentHandle)component, this.connectionHandle, null);
            }
            progress.setWorkRemaining(100);
            this.modifyFile(component, downloadInfo, newFileShareable, (IProgressMonitor)progress.newChild(100));
        } else {
            progress.setWorkRemaining(100);
            this.createFile(component, downloadInfo, parentShareable, (IProgressMonitor)progress.newChild(100));
        }
    }

    protected final void createFolder(IComponent component, FileAreaUpdate update, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        IFolderHandle parent = update.getDestinationParent();
        String name = update.getName();
        IFolderHandle folderItemState = (IFolderHandle)update.afterState();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (!this.isComponentShared(component)) {
            return;
        }
        String errorMsgFileName = name;
        Shareable parentShareable = null;
        if (this.isShareParent(component, parent)) {
            Path path = new Path(name);
        } else {
            IPath parentPath = this.getCopyFileArea().getLocalPathFor((IVersionableHandle)parent, (IComponentHandle)component, this.connectionHandle, null);
            parentShareable = this.getShareableFor(parentPath, true);
            if (parentShareable == null) {
                this.failedUpdate(update);
                return;
            }
            if (!parentShareable.isLocal()) {
                errorMsgFileName = parentPath.append(name).toString();
                this.recordInconsistentShare((IComponentHandle)component, parentPath.segment(0));
                this.collectStatus(new FileSystemStatus(4, 367, NLS.bind((String)Messages.UpdateMutator_2, (Object)errorMsgFileName, (Object)component.getName())));
                return;
            }
            IPath path = parentPath.append(name);
            errorMsgFileName = path.toString();
            if (!this.isPathValid((IComponentHandle)component, path, true)) {
                if (path != null) {
                    this.recordInconsistentShare((IComponentHandle)component, path.segment(0));
                }
                this.collectStatus(new FileSystemStatus(4, 368, NLS.bind((String)Messages.UpdateMutator_3, (Object)errorMsgFileName, (Object)component.getName())));
                return;
            }
        }
        Shareable potentialCollision = null;
        if (this.isShareParent(component, parent)) {
            potentialCollision = this.getRootFolder(name);
        } else {
            IFileStorage collision = parentShareable.getFileStorage().getChild(name);
            if (collision != null) {
                potentialCollision = collision.getShareable();
            }
        }
        Shareable newFolderShareable = (Shareable)SharingManager.getInstance().findShareable(this.getCopyFileArea().getRoot(), (IVersionableHandle)folderItemState, (IComponentHandle)component, this.connectionHandle, null);
        if (potentialCollision != null && potentialCollision.isLocal() && potentialCollision.getFileStorage().isFolder() && potentialCollision.getRemote() == null && newFolderShareable == null) {
            FileItemInfo proxy;
            if (this.isShareParent(component, parent)) {
                this.newShares.add(new ShareReference((IComponentHandle)component, name));
                SharingDescriptor descriptor = new SharingDescriptor(this.connection.teamRepository().getRepositoryURI(), this.connection.teamRepository().getId(), this.connection, (IComponentHandle)component, component.getName(), folderItemState);
                if (potentialCollision.getShare() == null) {
                    potentialCollision.share(descriptor, true, (IProgressMonitor)progress.newChild(40));
                } else {
                    this.getCopyFileArea().setSharingInfo(potentialCollision, descriptor, (IProgressMonitor)progress.newChild(40));
                }
                proxy = new FileItemInfo(folderItemState, null, null);
            } else {
                proxy = new FileItemInfo(folderItemState, parent, name);
            }
            this.getCopyFileArea().setItemInfo(potentialCollision, proxy, (IProgressMonitor)progress.newChild(50));
            return;
        }
        if (potentialCollision != null && potentialCollision.isLocal()) {
            IComponentHandle collisionComponent = null;
            IShare share = potentialCollision.getShare();
            if (share != null) {
                collisionComponent = share.getSharingDescriptor().getComponent();
            }
            if (!folderItemState.sameItemId((IItemHandle)potentialCollision.getRemote()) || !component.sameItemId((IItemHandle)collisionComponent)) {
                this.handleCollision(component, potentialCollision, (IProgressMonitor)progress.newChild(25));
            }
        }
        if (this.isShareParent(component, parent)) {
            this.newShares.add(new ShareReference((IComponentHandle)component, name));
        }
        if (newFolderShareable != null && newFolderShareable.isLocal()) {
            IFileStorage existingParent = newFolderShareable.getFileStorage().getParent();
            if (!(existingParent == null && parentShareable == null || existingParent != null && parent.sameItemId((IItemHandle)existingParent.getRemote()) && name.equals(newFolderShareable.getLocalFullPath().lastSegment()))) {
                this.move(component, (IComponentHandle)component, newFolderShareable, parentShareable, parent, name, (IVersionableHandle)folderItemState, (IProgressMonitor)progress.newChild(25));
            }
        } else {
            progress.setWorkRemaining(100);
            this.createFolder(component, parent, parentShareable, name, folderItemState, (IProgressMonitor)progress.newChild(100));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void deleteSubtree(IComponent component, IFolderHandle parent, String name, IVersionableHandle itemState, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (!this.isComponentShared(component)) {
            return;
        }
        try {
            progress.subTask(NLS.bind((String)Messages.UpdateMutator_4, (Object)name));
            IPath toDeletePath = this.getCopyFileArea().getLocalPathFor(itemState, (IComponentHandle)component, this.connectionHandle, null);
            if (toDeletePath == null) {
                this.getCopyFileArea().deleteTreeInfo(itemState, (IComponentHandle)component, this.connectionHandle, null);
                return;
            }
            if (!this.isPathValid((IComponentHandle)component, toDeletePath, false)) {
                this.recordInconsistentShare((IComponentHandle)component, toDeletePath.segment(0));
                this.collectStatus(new FileSystemStatus(2, 370, NLS.bind((String)Messages.UpdateMutator_5, (Object)name, (Object)component.getName())));
                return;
            }
            Shareable toDeleteShareable = this.getShareableFor(toDeletePath, itemState instanceof IFolderHandle);
            if (!toDeleteShareable.isLocal()) {
                if (this.isRoot(toDeleteShareable)) {
                    toDeleteShareable.unshare((IProgressMonitor)progress.newChild(100));
                    return;
                } else {
                    toDeleteShareable.forget((IProgressMonitor)progress.newChild(100));
                }
                return;
            } else {
                this.deleteSubtree(component, toDeleteShareable, (IProgressMonitor)progress.newChild(100));
            }
            return;
        }
        finally {
            progress.done();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void modifyFile(IComponent component, FileAreaUpdate update, DeferredDownloadInformation downloadInfo, Date timestamp, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        String errorMsgFileName = downloadInfo.getName();
        IFileItemHandle fileItemState = downloadInfo.getFileItem();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (!this.isComponentShared(component)) {
            return;
        }
        try {
            IPath toModifyPath = this.getCopyFileArea().getLocalPathFor((IVersionableHandle)fileItemState, (IComponentHandle)component, this.connectionHandle, (IProgressMonitor)progress.newChild(1));
            Shareable toModifyShareable = this.getShareableFor(toModifyPath, false);
            if (toModifyShareable == null) {
                if (this.isShareParent(component, update.getDestinationParent())) {
                    return;
                }
                if (toModifyPath == null) {
                    toModifyPath = this.getCopyFileArea().getRemotePathFor((IVersionableHandle)fileItemState, (IComponentHandle)component, this.connectionHandle, (IProgressMonitor)progress.newChild(1));
                    if (toModifyPath != null) {
                        errorMsgFileName = toModifyPath.toString();
                    } else {
                        toModifyPath = this.getCopyFileArea().getRemotePathFor((IVersionableHandle)update.getDestinationParent(), (IComponentHandle)component, this.connectionHandle, (IProgressMonitor)progress.newChild(1));
                        if (toModifyPath != null) {
                            errorMsgFileName = toModifyPath.append(downloadInfo.getName()).toString();
                        }
                    }
                }
                if (toModifyPath != null) {
                    this.recordInconsistentShare((IComponentHandle)component, toModifyPath.segment(0));
                    this.collectStatus(new FileSystemStatus(4, 369, NLS.bind((String)Messages.UpdateMutator_6, (Object)errorMsgFileName, (Object)component.getName())));
                    return;
                }
                this.failedUpdate(update);
                return;
            }
            errorMsgFileName = toModifyShareable.getLocalFullPath().toString();
            if (!this.isPathValid((IComponentHandle)component, toModifyPath, false)) {
                this.recordInconsistentShare((IComponentHandle)component, toModifyPath.segment(0));
                this.collectStatus(new FileSystemStatus(2, 369, NLS.bind((String)Messages.UpdateMutator_7, (Object)errorMsgFileName, (Object)component.getName())));
                return;
            }
            if (!toModifyShareable.isLocal()) {
                this.collectStatus(new FileSystemStatus(2, 369, NLS.bind((String)Messages.UpdateMutator_8, (Object)errorMsgFileName, (Object)component.getName())));
                return;
            }
            this.modifyFile(component, downloadInfo, toModifyShareable, (IProgressMonitor)progress);
            return;
        }
        finally {
            progress.done();
        }
    }

    protected final void moveSubtree(IComponent component, FileAreaUpdate update, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        IComponentHandle previousComponent = update.getPreviousComponent();
        String oldName = update.getOldName();
        IFolderHandle destinationParent = update.getDestinationParent();
        String newName = update.getName();
        IVersionableHandle itemMovedState = update.afterState();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (!this.isComponentShared(component)) {
            return;
        }
        boolean itemToMoveExists = false;
        boolean itemToMoveIsShare = false;
        boolean itemToMoveKnownRemotely = false;
        boolean targetFolderExistsLocally = false;
        boolean targetFolderKnownRemotely = false;
        boolean targetFolderIsShareParent = false;
        String targetShare = null;
        String sourceShare = null;
        IPath toMovePath = this.getCopyFileArea().getLocalPathFor(itemMovedState, previousComponent, this.connectionHandle, null);
        if (toMovePath != null) {
            sourceShare = toMovePath.segment(0);
            itemToMoveExists = true;
            itemToMoveIsShare = toMovePath.segmentCount() == 1;
        } else {
            itemToMoveExists = false;
            IPath bestGuess = this.getCopyFileArea().getRemotePathFor(itemMovedState, previousComponent, this.connectionHandle, null);
            if (bestGuess != null) {
                sourceShare = bestGuess.segment(0);
                itemToMoveKnownRemotely = true;
                itemToMoveIsShare = bestGuess.segmentCount() == 1;
            }
        }
        Shareable destinationParentShareable = null;
        if (this.isShareParent(component, destinationParent)) {
            targetShare = newName;
            targetFolderIsShareParent = true;
        } else {
            IPath destinationParentPath = this.getCopyFileArea().getLocalPathFor((IVersionableHandle)destinationParent, (IComponentHandle)component, this.connectionHandle, null);
            destinationParentShareable = this.getShareableFor(destinationParentPath, true);
            if (destinationParentPath != null) {
                targetShare = destinationParentPath.segment(0);
                targetFolderExistsLocally = true;
                targetFolderKnownRemotely = true;
            } else {
                targetFolderExistsLocally = false;
                IPath bestGuess = this.getCopyFileArea().getRemotePathFor((IVersionableHandle)destinationParent, (IComponentHandle)component, this.connectionHandle, null);
                if (bestGuess != null) {
                    targetShare = bestGuess.segment(0);
                    targetFolderKnownRemotely = true;
                } else if (itemToMoveIsShare) {
                    targetShare = newName;
                    targetFolderIsShareParent = true;
                }
            }
        }
        if (!itemToMoveExists) {
            this.recordInconsistentShare(previousComponent, sourceShare);
            this.recordInconsistentShare((IComponentHandle)component, targetShare);
            if (!itemToMoveKnownRemotely) {
                this.failedUpdate(update, update.getPreviousComponent());
            }
            if (targetFolderExistsLocally || targetFolderKnownRemotely) {
                this.collectStatus(new FileSystemStatus(4, 371, NLS.bind((String)Messages.UpdateMutator_9, (Object)oldName, (Object)component.getName())));
            } else if (!targetFolderIsShareParent) {
                this.failedUpdate(update);
            }
            return;
        }
        boolean sourceValid = this.isPathValid(previousComponent, toMovePath, false);
        boolean targetValid = false;
        if (targetFolderExistsLocally) {
            targetValid = this.isPathValid((IComponentHandle)component, destinationParentShareable.getLocalFullPath().append(newName), true);
        } else if (targetFolderIsShareParent) {
            targetValid = true;
        } else if (itemToMoveIsShare && !targetFolderKnownRemotely) {
            targetValid = true;
        } else {
            this.recordInconsistentShare(previousComponent, sourceShare);
            this.recordInconsistentShare((IComponentHandle)component, targetShare);
            this.collectStatus(new FileSystemStatus(4, 371, NLS.bind((String)Messages.UpdateMutator_10, (Object)toMovePath.toString(), (Object)component.getName())));
            return;
        }
        if (!sourceValid || !targetValid) {
            Shareable toMoveShareable;
            IShare share;
            this.recordInconsistentShare(previousComponent, sourceShare);
            this.recordInconsistentShare((IComponentHandle)component, targetShare);
            String toReloadMsg = component.getName();
            if (!previousComponent.sameItemId((IItemHandle)component) && (share = (toMoveShareable = this.getShareableFor(toMovePath, itemMovedState instanceof IFolderHandle)).getShare()) != null) {
                toReloadMsg = share.getSharingDescriptor().getComponentName();
            }
            toReloadMsg = String.valueOf(toReloadMsg) + " - " + toMovePath.segment(0);
            String target = component.getName();
            target = destinationParentShareable == null ? String.valueOf(target) + " - " + newName : String.valueOf(target) + destinationParentShareable.getLocalFullPath().segment(0);
            if (!toReloadMsg.equals(target)) {
                toReloadMsg = String.valueOf(toReloadMsg) + " & " + target;
            }
            if (!sourceValid && !targetValid) {
                this.collectStatus(new FileSystemStatus(2, 371, NLS.bind((String)Messages.UpdateMutator_14, (Object)toReloadMsg)));
            } else if (!sourceValid) {
                this.collectStatus(new FileSystemStatus(4, 371, NLS.bind((String)Messages.UpdateMutator_15, (Object)toReloadMsg)));
            } else if (!targetValid) {
                this.collectStatus(new FileSystemStatus(4, 371, NLS.bind((String)Messages.UpdateMutator_16, (Object)toReloadMsg)));
            }
            return;
        }
        Shareable toMoveShareable = this.getShareableFor(toMovePath, itemMovedState instanceof IFolderHandle);
        Shareable potentialCollision = null;
        if (targetFolderIsShareParent) {
            potentialCollision = this.getRootFolder(newName);
        } else {
            IFileStorage collision = destinationParentShareable.getFileStorage().getChild(newName);
            if (collision != null) {
                potentialCollision = collision.getShareable();
            }
        }
        if (potentialCollision != null) {
            if (itemMovedState.sameItemId((IItemHandle)potentialCollision.getRemote()) && component.sameItemId((IItemHandle)previousComponent)) {
                if (update.getName().equals(potentialCollision.getLocalFullPath().lastSegment())) {
                    this.updateMetaDataAfterMove(component, previousComponent, itemMovedState, true, toMoveShareable, potentialCollision, true, (IProgressMonitor)progress.newChild(75));
                    return;
                }
            } else if (potentialCollision.isLocal()) {
                if (potentialCollision.getLocalFullPath().equals((Object)toMoveShareable.getLocalFullPath())) {
                    this.updateMetaDataAfterMove(component, previousComponent, itemMovedState, true, toMoveShareable, potentialCollision, true, (IProgressMonitor)progress.newChild(75));
                    return;
                }
                this.handleCollision(component, potentialCollision, (IProgressMonitor)progress.newChild(25));
            }
        }
        this.move(component, previousComponent, toMoveShareable, destinationParentShareable, destinationParent, newName, itemMovedState, (IProgressMonitor)progress.newChild(75));
    }

    private void handleCollision(IComponent component, Shareable shareable, IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        IVersionableHandle remoteItem = shareable.getRemote();
        boolean shouldPreserve = false;
        if (remoteItem != null) {
            if (this.isRoot(shareable)) {
                boolean bl = shouldPreserve = this.pendingUpdate(remoteItem, this.updates.getDeletes()) || this.pendingUpdate(remoteItem, this.updates.getMoves());
                if (!shouldPreserve) {
                    this.collectStatus(new FileSystemStatus(2, 333, NLS.bind((String)Messages.UpdateMutator_17, (Object)shareable.getLocalFullPath())));
                }
            } else {
                shouldPreserve = true;
            }
        }
        if (shouldPreserve) {
            this.preserve(component, shareable, progress);
        } else {
            this.deleteSubtree(component, shareable, progress);
        }
    }

    private boolean pendingUpdate(IVersionableHandle item, Collection<FileAreaUpdate> pendingUpdates) {
        for (FileAreaUpdate update : pendingUpdates) {
            if (!update.item().sameItemId((IItemHandle)item)) continue;
            return true;
        }
        return false;
    }

    protected final boolean isRoot(Shareable shareable) {
        IShare share;
        boolean isRoot = false;
        IVersionableHandle remoteItem = shareable.getRemote();
        if (remoteItem != null && (share = shareable.getShare()) != null) {
            ISharingDescriptor descriptor = share.getSharingDescriptor();
            isRoot = descriptor != null && remoteItem.sameItemId((IItemHandle)descriptor.getRootFolder());
        }
        return isRoot;
    }

    protected boolean isPathValid(IComponentHandle component, IPath path, boolean newProjectAllowed) {
        if (path == null) {
            return true;
        }
        String[] segments = path.segments();
        if (component.sameItemId((IItemHandle)this.lastComponent) && segments[0].equals(this.lastPath) && newProjectAllowed == this.lastNewProjectAllowed) {
            return this.lastResult;
        }
        this.lastComponent = component;
        this.lastPath = segments[0];
        this.lastNewProjectAllowed = newProjectAllowed;
        ISharingDescriptor descriptor = this.getCopyFileArea().getSharingInfo((IPath)new Path(segments[0]));
        this.lastResult = descriptor != null ? this.sharedToSameComponent(descriptor, component) : newProjectAllowed && segments.length == 1 && !this.getRootFolder(segments[0]).isLocal();
        return this.lastResult;
    }

    protected final boolean sharedToSameComponent(ISharingDescriptor descriptor, IComponentHandle component) {
        if (descriptor.getComponent().sameItemId((IItemHandle)component)) {
            return descriptor.getConnectionHandle().sameItemId((IItemHandle)this.connectionHandle);
        }
        return false;
    }

    protected final boolean isComponentShared(IComponent component) throws FileSystemClientException {
        if (component.sameItemId((IItemHandle)this.lastComponentShareTested)) {
            return this.lastComponentSharedResult;
        }
        this.lastComponentShareTested = component;
        this.lastComponentSharedResult = this.getCopyFileArea().isLoaded((IComponentHandle)component, this.connectionHandle, null);
        if (!this.lastComponentSharedResult && !this.componentNotShared.contains(component.getItemId())) {
            this.componentNotShared.add(component.getItemId());
            this.collectStatus(new FileSystemStatus(2, 367, NLS.bind((String)Messages.UpdateMutator_18, (Object)component.getName())));
        }
        return this.lastComponentSharedResult;
    }

    protected final void recordInconsistentShare(IComponentHandle component, String segment) {
        if (segment != null) {
            this.inconsistentShares.add(new ShareReference(component, segment));
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final void execute(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        ThreadCheck.checkLongOpsAllowed();
        subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        orderer = new UpdateOrder(this.updates.getAdds(), this.updates.getDeletes(), this.updates.getMoves(), this.updates.getModifies());
        maxContentToDownLoad = orderer.getFileMoves().size() + orderer.getFileAdds().size() + orderer.getGroupedModifies().size();
        deferredDownloadInfo = new ArrayList<DeferredDownloadInformation>(maxContentToDownLoad);
        this.contentSession = this.repository.contentManager().createSession(NLS.bind((String)Messages.UpdateMutator_19, (Object)this.connection.getName()), true, (long)maxContentToDownLoad, (IProgressMonitor)subMonitor.newChild(80));
        progress = new CancellationMonitor((IProgressMonitor)subMonitor);
        component = null;
        try {
            for (FileAreaUpdate update : orderer.getFolderAdds()) {
                component = this.getFullComponent(update, component);
                this.createFolder(component, update, (IProgressMonitor)progress);
                this.checkCancelled((IProgressMonitor)progress);
            }
            for (FileAreaUpdate update : orderer.getFolderMoves()) {
                component = this.getFullComponent(update, component);
                this.moveSubtree(component, update, (IProgressMonitor)progress);
                this.checkCancelled((IProgressMonitor)progress);
            }
            for (FileAreaUpdate update : orderer.getFileMoves()) {
                component = this.getFullComponent(update, component);
                this.moveSubtree(component, update, (IProgressMonitor)progress);
                if (update.isChangeType(4)) {
                    deferredDownload = new DeferredDownloadInformation(update);
                    deferredDownloadInfo.add(deferredDownload);
                    this.modifyFile(component, update, deferredDownload, update.getTimestamp(), (IProgressMonitor)progress);
                } else {
                    this.contentSession.decrementTransferCount(1);
                }
                this.checkCancelled((IProgressMonitor)progress);
            }
            for (FileAreaUpdate update : orderer.getOrderedDeletes()) {
                component = this.getFullComponent(update, component);
                this.deleteSubtree(component, update.getSourceParent(), update.getName(), update.beforeState(), (IProgressMonitor)progress);
                this.checkCancelled((IProgressMonitor)progress);
            }
            for (FileAreaUpdate update : orderer.getGroupedModifies()) {
                if (!(update.getItem() instanceof IFileItemHandle)) continue;
                component = this.getFullComponent(update, component);
                deferredDownload = new DeferredDownloadInformation(update);
                deferredDownloadInfo.add(deferredDownload);
                this.modifyFile(component, update, deferredDownload, update.getTimestamp(), (IProgressMonitor)progress);
                this.checkCancelled((IProgressMonitor)progress);
            }
            for (FileAreaUpdate update : orderer.getFileAdds()) {
                component = this.getFullComponent(update, component);
                deferredDownload = new DeferredDownloadInformation(update);
                deferredDownloadInfo.add(deferredDownload);
                this.createFile(component, update, deferredDownload, update.getTimestamp(), (IProgressMonitor)progress);
                this.checkCancelled((IProgressMonitor)progress);
            }
            this.verifyUpdatesOutsideShares((IProgressMonitor)progress);
        }
        finally {
            this.contentSession.join();
            metaDataMonitor = subMonitor.newChild(5);
            metaDataMonitor.setWorkRemaining(deferredDownloadInfo.size() * 2);
            ** for (downloadInfo : deferredDownloadInfo)
        }
lbl-1000:
        // 1 sources

        {
            if (!downloadInfo.contentUpdated()) continue;
            this.updateMetaData(downloadInfo, (IProgressMonitor)metaDataMonitor.newChild(1));
            if (this.skipUpdate(downloadInfo.getShareable())) continue;
            downloadInfo.getShareable().getFileStorage().setExecutable(downloadInfo.isExecutable(), (IProgressMonitor)metaDataMonitor.newChild(1));
            continue;
        }
lbl68:
        // 1 sources

        metaDataMonitor.done();
        failures = this.getDownloadFailures(deferredDownloadInfo);
        if (failures.length > 0) {
            otherErrors = this.getErrors();
            if (otherErrors.length > 0) {
                allErrors = new IStatus[failures.length + otherErrors.length];
                System.arraycopy(otherErrors, 0, allErrors, 0, otherErrors.length);
                System.arraycopy(failures, 0, allErrors, otherErrors.length, failures.length);
                failures = allErrors;
            }
            RepositoryUtils.throwAppropriateException(Messages.UpdateMutator_20, failures);
        } else if (this.contentSession.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.updateConfigStates((IProgressMonitor)subMonitor.newChild(15));
    }

    private void verifyUpdatesOutsideShares(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        IPath[] allSharePaths;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.failedUpdates.size());
        if (this.failedUpdates.isEmpty()) {
            return;
        }
        HashMap<UUID, HashMap<UUID, IPath>> shares = new HashMap<UUID, HashMap<UUID, IPath>>();
        CopyFileAreaStore cfa = this.getCopyFileArea();
        IPath[] iPathArray = allSharePaths = cfa.allSharePaths();
        int n = allSharePaths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath sharePath = iPathArray[n2];
            ISharingDescriptor descriptor = cfa.getSharingInfo(sharePath);
            if (this.failedUpdates.containsKey(descriptor.getComponent().getItemId()) && descriptor.getConnectionHandle().sameItemId((IItemHandle)this.connectionHandle)) {
                HashMap<UUID, IPath> sharesForComponent = (HashMap<UUID, IPath>)shares.get(descriptor.getComponent().getItemId());
                if (sharesForComponent == null) {
                    sharesForComponent = new HashMap<UUID, IPath>();
                    shares.put(descriptor.getComponent().getItemId(), sharesForComponent);
                }
                sharesForComponent.put(descriptor.getRootFolder().getItemId(), sharePath);
            }
            ++n2;
        }
        for (Map.Entry<UUID, List<FileAreaUpdate>> entry : this.failedUpdates.entrySet()) {
            IConfiguration configuration = null;
            HashMap<UUID, UUID> itemsSeen = new HashMap<UUID, UUID>();
            HashMap<UUID, IVersionableHandle> itemsToLocate = new HashMap<UUID, IVersionableHandle>();
            HashMap<UUID, HashSet<FileAreaUpdate>> locateUpdates = new HashMap<UUID, HashSet<FileAreaUpdate>>();
            for (FileAreaUpdate update : entry.getValue()) {
                if (configuration == null) {
                    configuration = this.connection instanceof IWorkspaceConnection ? (entry.getKey().equals((Object)update.getComponent().getItemId()) ? ((IWorkspaceConnection)this.connection).configuration(update.component()) : ((IWorkspaceConnection)this.connection).configuration(update.getPreviousComponent())) : ((IBaselineConnection)this.connection).configuration();
                }
                if (update.isChangeType(8)) {
                    if (entry.getKey().equals((Object)update.getComponent().getItemId())) {
                        this.determineWhatToLocate(itemsSeen, itemsToLocate, locateUpdates, update);
                    }
                    if (!entry.getKey().equals((Object)update.getPreviousComponent().getItemId())) continue;
                    UUID parentId = update.getSourceParent().getItemId();
                    HashSet<FileAreaUpdate> toRecord = new HashSet<FileAreaUpdate>();
                    toRecord.add(update);
                    if (!itemsSeen.containsKey(parentId)) {
                        itemsToLocate.put(parentId, (IVersionableHandle)update.getSourceParent());
                        locateUpdates.put(parentId, toRecord);
                        itemsSeen.put(parentId, null);
                        continue;
                    }
                    this.recordUpdateAgainstLocate(parentId, toRecord, itemsSeen, locateUpdates);
                    continue;
                }
                if (!update.isChangeType(1) && !update.isChangeType(4)) continue;
                this.determineWhatToLocate(itemsSeen, itemsToLocate, locateUpdates, update);
            }
            HashMap sharesForComponent = (HashMap)shares.get(configuration.component().getItemId());
            if (sharesForComponent == null || sharesForComponent.isEmpty() || itemsToLocate.isEmpty()) continue;
            IComponent component = (IComponent)this.repository.itemManager().fetchCompleteItem((IItemHandle)configuration.component(), 0, null);
            ArrayList<IVersionableHandle> toLocate = new ArrayList<IVersionableHandle>(itemsToLocate.values());
            List report = configuration.locateAncestors(toLocate, (IProgressMonitor)progress.newChild(1));
            int i = 0;
            for (IAncestorReport parentage : report) {
                for (INameItemPair pair : parentage.getNameItemPairs()) {
                    IPath sharePath = (IPath)sharesForComponent.get(pair.getItem().getItemId());
                    if (sharePath == null) continue;
                    this.recordInconsistentShare(configuration.component(), sharePath.segment(0));
                    this.reportFailedUpdates(component, toLocate.get(i), locateUpdates);
                }
                ++i;
            }
        }
    }

    private void determineWhatToLocate(HashMap<UUID, UUID> itemsSeen, HashMap<UUID, IVersionableHandle> itemsToLocate, HashMap<UUID, HashSet<FileAreaUpdate>> locateUpdates, FileAreaUpdate update) {
        HashSet<FileAreaUpdate> toRecord;
        UUID itemId = update.item().getItemId();
        UUID parentId = update.getDestinationParent().getItemId();
        itemsSeen.put(itemId, parentId);
        if (itemsToLocate.containsKey(itemId)) {
            itemsToLocate.remove(itemId);
            toRecord = locateUpdates.remove(itemId);
        } else {
            toRecord = new HashSet<FileAreaUpdate>();
        }
        toRecord.add(update);
        if (!itemsSeen.containsKey(parentId)) {
            itemsToLocate.put(parentId, (IVersionableHandle)update.getDestinationParent());
            locateUpdates.put(parentId, toRecord);
            itemsSeen.put(parentId, null);
        } else {
            this.recordUpdateAgainstLocate(parentId, toRecord, itemsSeen, locateUpdates);
        }
    }

    private void recordUpdateAgainstLocate(UUID itemId, HashSet<FileAreaUpdate> toRecord, HashMap<UUID, UUID> itemsSeen, HashMap<UUID, HashSet<FileAreaUpdate>> locateUpdates) {
        int paranoiaCount = 0;
        while (paranoiaCount < 2000) {
            UUID parent = itemsSeen.get(itemId);
            if (parent == null) {
                HashSet<FileAreaUpdate> updatesRecorded = locateUpdates.get(itemId);
                if (updatesRecorded == null) {
                    locateUpdates.put(itemId, toRecord);
                    break;
                }
                updatesRecorded.addAll(toRecord);
                break;
            }
            itemId = parent;
            ++paranoiaCount;
        }
    }

    private void reportFailedUpdates(IComponent component, IVersionableHandle versionableHandle, HashMap<UUID, HashSet<FileAreaUpdate>> locateUpdates) {
        HashSet<FileAreaUpdate> updatesToReport = locateUpdates.get(versionableHandle.getItemId());
        if (updatesToReport != null) {
            for (FileAreaUpdate update : updatesToReport) {
                if (update.isChangeType(4)) {
                    this.collectStatus(new FileSystemStatus(NLS.bind((String)Messages.UpdateMutator_25, (Object)update.getName(), (Object)component.getName())));
                    continue;
                }
                if (update.isChangeType(1) && update.item() instanceof IFileItemHandle) {
                    this.collectStatus(new FileSystemStatus(NLS.bind((String)Messages.UpdateMutator_26, (Object)update.getName(), (Object)component.getName())));
                    continue;
                }
                if (update.isChangeType(1) && update.item() instanceof IFolderHandle) {
                    this.collectStatus(new FileSystemStatus(NLS.bind((String)Messages.UpdateMutator_27, (Object)update.getName(), (Object)component.getName())));
                    continue;
                }
                if (!update.isChangeType(8)) continue;
                this.collectStatus(new FileSystemStatus(NLS.bind((String)Messages.UpdateMutator_28, (Object)update.getOldName(), (Object)component.getName())));
            }
        }
    }

    private IStatus[] getDownloadFailures(ArrayList<DeferredDownloadInformation> deferredDownloadInfo) {
        ArrayList<Status> errors = new ArrayList<Status>();
        for (DeferredDownloadInformation deferredUpdateInformation : deferredDownloadInfo) {
            if (deferredUpdateInformation == null || deferredUpdateInformation.getFailure() == null) continue;
            Throwable rootCause = deferredUpdateInformation.getFailure().getCause();
            int paranoiaCount = 0;
            while (rootCause instanceof TeamRepositoryException && paranoiaCount < 50) {
                Throwable cause = ((TeamRepositoryException)rootCause).getCause();
                if (cause == null) break;
                rootCause = cause;
                ++paranoiaCount;
            }
            Status status = rootCause instanceof UnsupportedEncodingException || rootCause instanceof UnsupportedCharsetException ? new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.UpdateMutator_21, (Object)deferredUpdateInformation.getShareable().getLocalFullPath(), (Object)deferredUpdateInformation.getContent().getCharacterEncoding()), (Throwable)deferredUpdateInformation.getFailure()) : (rootCause instanceof CharacterCodingException ? new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.UpdateMutator_23, (Object)deferredUpdateInformation.getShareable().getLocalFullPath(), (Object)deferredUpdateInformation.getContent().getCharacterEncoding()), (Throwable)deferredUpdateInformation.getFailure()) : new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.UpdateMutator_22, (Object)deferredUpdateInformation.getShareable().getLocalFullPath()), (Throwable)deferredUpdateInformation.getFailure()));
            errors.add(status);
        }
        return errors.toArray(new IStatus[errors.size()]);
    }

    protected abstract void updateMetaData(DeferredDownloadInformation var1, IProgressMonitor var2) throws FileSystemClientException, TeamRepositoryException;

    private IComponent getFullComponent(FileAreaUpdate update, IComponent currentComponent) throws TeamRepositoryException {
        if (!update.component().sameItemId((IItemHandle)currentComponent)) {
            currentComponent = (IComponent)this.repository.itemManager().fetchCompleteItem((IItemHandle)update.component(), 0, null);
        }
        return currentComponent;
    }

    private void updateConfigStates(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        this.newShares.removeAll(this.inconsistentShares);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.newShares.size() + this.inconsistentShares.size() + this.componentStatesAfter.size()));
        for (ShareReference newShare : this.newShares) {
            IComponentStateSummary summary = this.componentStatesAfter.get(newShare.component.getItemId());
            this.getCopyFileArea().setConfigurationState(this.connectionHandle, newShare.component, (IPath)new Path(newShare.sharePath), summary.getConfigurationTime(), (IProgressMonitor)subMonitor.newChild(1));
        }
        for (IComponentStateSummary stateAfter : this.componentStatesAfter.values()) {
            IComponentStateSummary stateBefore = this.componentStatesBefore.get(stateAfter.getComponent().getItemId());
            if (stateBefore == null) continue;
            this.getCopyFileArea().setConfigurationState(this.connectionHandle, stateAfter.getComponent(), stateBefore.getConfigurationTime(), stateAfter.getConfigurationTime(), (IProgressMonitor)subMonitor.newChild(1));
        }
        for (ShareReference inconsistentShare : this.inconsistentShares) {
            this.getCopyFileArea().setUnknownConfigurationState(this.connectionHandle, inconsistentShare.component, new Path(inconsistentShare.sharePath), (IProgressMonitor)subMonitor.newChild(1));
        }
    }

    protected ISyncTime getBeforeConfigState(IComponentHandle component) {
        return this.componentStatesBefore.get(component.getItemId()).getConfigurationTime();
    }

    protected void updateMetaDataAfterMove(IComponent component, IComponentHandle previousComponent, IVersionableHandle itemState, boolean moveUpdate, Shareable sourceShareable, Shareable targetShareable, boolean isShareRoot, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CopyFileAreaStore cfa = this.getCopyFileArea();
        FileItemInfo itemInfo = cfa.getItemInfo(sourceShareable.getLocalFullPath());
        if (isShareRoot) {
            if (!sourceShareable.getLocalFullPath().equals((Object)targetShareable.getLocalFullPath())) {
                cfa.moveSharingInfo(sourceShareable.getLocalFullPath(), targetShareable.getLocalFullPath(), (IProgressMonitor)progress.newChild(75));
            }
            if (!component.sameItemId((IItemHandle)previousComponent)) {
                SharingDescriptor descriptor = (SharingDescriptor)targetShareable.getShare().getSharingDescriptor();
                ISyncTime previousSyncState = this.getBeforeConfigState(previousComponent);
                ISyncTime componentSyncState = this.getBeforeConfigState((IComponentHandle)component);
                if (!descriptor.getConfigurationState().equals(previousSyncState)) {
                    this.recordInconsistentShare((IComponentHandle)component, targetShareable.getLocalFullPath().segment(0));
                    cfa.setSharingInfo(targetShareable, new SharingDescriptor(descriptor.getRepositoryUri(), descriptor.getRepositoryId(), this.connection, (IComponentHandle)component, component.getName(), descriptor.getRootFolder()), (IProgressMonitor)progress.newChild(25));
                } else if (componentSyncState == null) {
                    this.newShares.add(new ShareReference((IComponentHandle)component, targetShareable.getLocalFullPath().segment(0)));
                    cfa.setSharingInfo(targetShareable, new SharingDescriptor(descriptor.getRepositoryUri(), descriptor.getRepositoryId(), this.connection, (IComponentHandle)component, component.getName(), descriptor.getRootFolder()), (IProgressMonitor)progress.newChild(25));
                } else {
                    cfa.setSharingInfo(targetShareable, new SharingDescriptor(descriptor.getRepositoryUri(), descriptor.getRepositoryId(), this.connection, (IComponentHandle)component, component.getName(), descriptor.getRootFolder(), componentSyncState), (IProgressMonitor)progress.newChild(25));
                }
            }
        } else if (itemInfo != null) {
            cfa.moveTreeInfo(sourceShareable, targetShareable, moveUpdate, (IProgressMonitor)progress.newChild(90));
            SharingDescriptor sourceDescriptor = (SharingDescriptor)sourceShareable.getShare().getSharingDescriptor();
            if (!sourceDescriptor.getConfigurationState().equals(this.getBeforeConfigState(sourceDescriptor.getComponent()))) {
                this.recordInconsistentShare((IComponentHandle)component, targetShareable.getLocalFullPath().segment(0));
            }
        }
        if (moveUpdate && itemState instanceof IFileItemHandle) {
            InverseFileItemInfo oldInfo = cfa.getItemInfo(itemState, (IComponentHandle)component, this.connectionHandle);
            FileItemInfo info = new FileItemInfo(itemState, oldInfo.getLastModification(), oldInfo.getParent(), oldInfo.getName(), oldInfo.getHash(), oldInfo.getContentLength(), oldInfo.getOriginalLineDelimiter(), oldInfo.getLineDelimiter(), oldInfo.getOriginalContentType(), oldInfo.getContentType(), oldInfo.getStoredContentId(), oldInfo.getStoredDeltaPredecessor(), oldInfo.getStoredSize(), oldInfo.getStoredEncoding(), oldInfo.getStoredChecksum(), oldInfo.getStoredNumLineDelimiters(), oldInfo.isExecutable(), oldInfo.isOriginalExecutable());
            this.getCopyFileArea().setItemInfo(targetShareable, info, null);
        }
    }

    public final void setSkipStoreContent(Set<UUID> toIgnore) {
        this.versionablesToSkip = toIgnore;
    }

    protected final boolean isSkipping() {
        return this.versionablesToSkip.size() > 0;
    }

    protected final boolean skipUpdate(Shareable shareable) {
        Assert.isNotNull((Object)shareable);
        if (shareable.getRemote() == null) {
            return false;
        }
        return this.skipUpdate(shareable.getRemote().getItemId());
    }

    protected final boolean skipUpdate(UUID itemId) {
        return this.versionablesToSkip.contains(itemId);
    }

    private void failedUpdate(FileAreaUpdate update) {
        this.failedUpdate(update, update.component());
    }

    protected final void failedUpdate(FileAreaUpdate update, IComponentHandle component) {
        List<FileAreaUpdate> failedUpdatesForComponent = this.failedUpdates.get(component.getItemId());
        if (failedUpdatesForComponent == null) {
            failedUpdatesForComponent = new ArrayList<FileAreaUpdate>();
            this.failedUpdates.put(component.getItemId(), failedUpdatesForComponent);
        }
        failedUpdatesForComponent.add(update);
    }

    private boolean isShareParent(IComponent component, IFolderHandle parent) {
        HashSet<UUID> shareParentsForComponent = this.shareParents.get(component.getItemId());
        if (shareParentsForComponent != null) {
            return shareParentsForComponent.contains(parent.getItemId());
        }
        return false;
    }

    @Override
    protected void reportErrorsAsException(IStatus[] errors) throws FileSystemClientException {
        if (errors.length == 0) {
            return;
        }
        if (this.inconsistentShares.size() > 0) {
            MultiStatus result = new MultiStatus("com.ibm.team.filesystem.client", 0, errors, NLS.bind((String)Messages.UpdateMutator_24, (Object)errors.length), null);
            throw new FileSystemClientException((IStatus)result);
        }
        super.reportErrorsAsException(errors);
    }

    private static class ShareReference {
        protected IComponentHandle component;
        protected String sharePath;

        public ShareReference(IComponentHandle component, String sharePath) {
            this.component = component;
            this.sharePath = sharePath;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.component == null ? 0 : this.component.getItemId().hashCode());
            result = 31 * result + (this.sharePath == null ? 0 : this.sharePath.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ShareReference other = (ShareReference)obj;
            if (this.component == null ? other.component != null : !this.component.sameItemId((IItemHandle)other.component)) {
                return false;
            }
            return !(this.sharePath == null ? other.sharePath != null : !this.sharePath.equals(other.sharePath));
        }
    }
}

