/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.repository.client.IContentManagerSession;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.ContentManager;
import com.ibm.team.repository.client.util.DownloadAdapter;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.Content;
import com.ibm.team.repository.common.utils.HashCode;
import com.ibm.team.repository.common.utils.HashComputingInputStream;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.ISyncTime;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.Checksum;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MergeLoadMutator
extends FileSystemOperation {
    protected IContentManagerSession contentSession = null;
    private final IPath copyFileAreaPath;
    private final IConnection connection;
    private final IContextHandle connectionHandle;
    private final LoadTree loadTree;
    private final ITeamRepository repo;
    private HashSet<IPath> loadLocations;
    private HashMap<UUID, Set<UUID>> roots;

    public MergeLoadMutator(IConnection connection, Map<ConfigurationDescriptor, Collection<IVersionableHandle>> shareRoots, LoadTree updates, IPath copyFileAreaPath, Collection<String[]> loadLocations, DilemmaHandler problemHandler) throws TeamRepositoryException {
        super(problemHandler);
        if (copyFileAreaPath == null || connection == null || loadLocations == null) {
            throw new IllegalArgumentException();
        }
        this.connection = connection;
        this.repo = connection.teamRepository();
        this.copyFileAreaPath = copyFileAreaPath;
        this.loadTree = updates;
        this.loadLocations = new HashSet();
        for (String[] stringArray : loadLocations) {
            this.loadLocations.add(PathUtils.getPath(stringArray));
        }
        this.connectionHandle = connection instanceof IWorkspaceConnection ? (IContextHandle)((IWorkspaceConnection)connection).getResolvedWorkspace().getItemHandle() : ((IBaselineConnection)connection).getBaseline();
        this.roots = new HashMap();
        for (Map.Entry entry : shareRoots.entrySet()) {
            UUID key = ((ConfigurationDescriptor)entry.getKey()).componentHandle.getItemId();
            Set<UUID> rootsInComponent = this.roots.get(key);
            if (rootsInComponent == null) {
                rootsInComponent = new HashSet<UUID>();
                this.roots.put(key, rootsInComponent);
            }
            for (IVersionableHandle root : (Collection)entry.getValue()) {
                rootsInComponent.add(root.getItemId());
            }
        }
    }

    protected void beginning() throws TeamRepositoryException, FileSystemClientException {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void execute(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        List updates = this.loadTree.getFileAreaUpdates();
        this.contentSession = this.repo.contentManager().createSession("", true, (long)updates.size(), (IProgressMonitor)progress.newChild(80));
        HashMap folders = new HashMap();
        HashMap allFolders = new HashMap();
        DeferredUpdateInformation[] pathsToUpdate = new DeferredUpdateInformation[updates.size()];
        ArrayList<FolderInformation> sharePaths = new ArrayList<FolderInformation>();
        CopyFileAreaStore copyFileAreaStore = CopyFileAreaStore.getCopyFileArea(this.getRoot());
        CancellationMonitor cMon = new CancellationMonitor((IProgressMonitor)progress);
        IComponent component = null;
        try {
            int i = -1;
            for (FileAreaUpdate fileAreaUpdate : updates) {
                this.checkCancelled(monitor);
                ++i;
                IComponentHandle componentHandle = fileAreaUpdate.getComponent();
                if (!componentHandle.sameItemId(component)) {
                    component = (IComponent)this.repo.itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, null);
                }
                if (fileAreaUpdate.getChangeType() == 1) {
                    boolean typesMatch;
                    void var18_28;
                    Shareable shareableLoaded;
                    Path path;
                    IVersionableHandle versionableState = fileAreaUpdate.afterState();
                    boolean isFolder = versionableState instanceof IFolderHandle;
                    Shareable parentShareable = null;
                    if (this.isShareRoot(componentHandle, fileAreaUpdate.getItem())) {
                        path = new Path(fileAreaUpdate.getName());
                        Shareable shareable = this.getShareable((IPath)path);
                    } else {
                        parentShareable = this.getShareable((IVersionableHandle)fileAreaUpdate.getDestinationParent(), fileAreaUpdate.component(), null);
                        IFileStorage child = parentShareable.getFileStorage().getChild(fileAreaUpdate.getName());
                        if (child != null) {
                            Shareable shareable = child.getShareable();
                        } else {
                            Object var18_31 = null;
                        }
                        path = parentShareable.getLocalFullPath();
                        HashSet contents = (HashSet)folders.get(new RelativePath((IPath)path));
                        if (contents != null) {
                            contents.add(fileAreaUpdate.getName());
                        }
                        if ((contents = (HashSet)allFolders.get(new FolderInformation((IPath)path, this.connectionHandle, componentHandle, fileAreaUpdate.getDestinationParent()))) != null) {
                            contents.add(fileAreaUpdate.getName());
                        }
                        path = path.append(fileAreaUpdate.getName());
                    }
                    if (isFolder) {
                        folders.put(new RelativePath((IPath)path), new HashSet());
                        FolderInformation folderInformation = new FolderInformation((IPath)path, this.connectionHandle, componentHandle, (IFolderHandle)versionableState);
                        if (path.segmentCount() == 1) {
                            sharePaths.add(folderInformation);
                        }
                        allFolders.put(folderInformation, new HashSet());
                    }
                    if ((shareableLoaded = this.getShareable(fileAreaUpdate.getItem(), fileAreaUpdate.component(), null)) != null) {
                        Shareable existingParent;
                        IFileStorage parentStorage = shareableLoaded.getFileStorage().getParent();
                        Shareable shareable = existingParent = parentStorage == null ? null : parentStorage.getShareable();
                        if (existingParent == null && parentShareable != null || existingParent != null && !fileAreaUpdate.parent().sameItemId((IItemHandle)existingParent.getRemote()) || !fileAreaUpdate.getName().equals(shareableLoaded.getLocalFullPath().lastSegment())) {
                            this.deleteSubtree(shareableLoaded.getLocalFullPath(), (IProgressMonitor)cMon);
                            if (path.segmentCount() == 1) {
                                shareableLoaded.unshare((IProgressMonitor)cMon);
                            } else {
                                shareableLoaded.forget((IProgressMonitor)cMon);
                            }
                        }
                    } else {
                        InverseFileItemInfo infoForDeletedItem = copyFileAreaStore.getItemInfo(fileAreaUpdate.getItem(), fileAreaUpdate.component(), this.connectionHandle);
                        if (infoForDeletedItem != null) {
                            if (infoForDeletedItem.getParent() == null) {
                                Shareable nonExistantShareable = this.getNonExistantShareable(infoForDeletedItem, fileAreaUpdate.component(), this.connectionHandle, (IProgressMonitor)cMon);
                                nonExistantShareable.forget((IProgressMonitor)cMon);
                            } else {
                                copyFileAreaStore.deleteTreeInfo(fileAreaUpdate.getItem(), fileAreaUpdate.component(), this.connectionHandle, (IProgressMonitor)cMon);
                            }
                        }
                    }
                    if (var18_28 == null || (var18_28.getState() & 8) == 0) {
                        if (isFolder) {
                            this.createFolder(fileAreaUpdate.getComponent(), (IPath)path, versionableState, (IProgressMonitor)cMon);
                            if (!this.isShareRoot((IComponentHandle)component, fileAreaUpdate.getItem())) {
                                folders.remove(new RelativePath((IPath)path));
                            }
                            this.contentSession.decrementTransferCount(1);
                            continue;
                        }
                        pathsToUpdate[i] = new DeferredUpdateInformation((IPath)path, fileAreaUpdate.isExecutable(), fileAreaUpdate.getOptionalContent());
                        this.createNewFile(fileAreaUpdate.getComponent(), path.segments(), versionableState, fileAreaUpdate.getTimestamp(), this.repo, fileAreaUpdate.getOptionalContent(), pathsToUpdate[i], (IProgressMonitor)cMon);
                        continue;
                    }
                    IVersionableHandle oldVersionable = null;
                    boolean bl = typesMatch = var18_28.getFileStorage().isFolder() == isFolder;
                    if (typesMatch) {
                        oldVersionable = var18_28.getRemote();
                    }
                    if (!typesMatch || !versionableState.sameItemId((IItemHandle)oldVersionable)) {
                        this.deleteSubtree(var18_28.getLocalFullPath(), (IProgressMonitor)cMon);
                        if (path.segmentCount() == 1) {
                            var18_28.unshare((IProgressMonitor)cMon);
                        } else {
                            var18_28.forget((IProgressMonitor)cMon);
                        }
                        if (isFolder) {
                            this.createFolder(fileAreaUpdate.getComponent(), (IPath)path, versionableState, (IProgressMonitor)cMon);
                            folders.remove(new RelativePath((IPath)path));
                            this.contentSession.decrementTransferCount(1);
                            continue;
                        }
                        pathsToUpdate[i] = new DeferredUpdateInformation((IPath)path, fileAreaUpdate.isExecutable(), fileAreaUpdate.getOptionalContent());
                        this.createNewFile(fileAreaUpdate.getComponent(), path.segments(), versionableState, fileAreaUpdate.getTimestamp(), this.repo, fileAreaUpdate.getOptionalContent(), pathsToUpdate[i], (IProgressMonitor)cMon);
                        continue;
                    }
                    if (isFolder) {
                        if (path.segmentCount() == 1) {
                            IComponent fullComponent = (IComponent)this.repo.itemManager().fetchCompleteItem((IItemHandle)componentHandle, 0, (IProgressMonitor)cMon);
                            SharingDescriptor descriptor = new SharingDescriptor(this.repo.getRepositoryURI(), this.repo.getId(), this.connection, componentHandle, fullComponent.getName(), (IFolderHandle)versionableState);
                            IShare share = var18_28.getShare();
                            if (share == null) {
                                try {
                                    SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable((Shareable)var18_28, descriptor, cMon){
                                        private final /* synthetic */ Shareable val$shareable;
                                        private final /* synthetic */ SharingDescriptor val$descriptor;
                                        private final /* synthetic */ CancellationMonitor val$cMon;
                                        {
                                            this.val$shareable = shareable;
                                            this.val$descriptor = sharingDescriptor;
                                            this.val$cMon = cancellationMonitor;
                                        }

                                        public void run() throws CoreException {
                                            this.val$shareable.share(this.val$descriptor, true, (IProgressMonitor)this.val$cMon);
                                        }
                                    });
                                }
                                catch (CoreException e) {
                                    LoggingHelper.error("com.ibm.team.filesystem.client", "Error sharing into local file area", e);
                                    throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, 200, Messages.MergeLoadMutator_2, e));
                                }
                            } else {
                                copyFileAreaStore.setSharingInfo((IShareable)var18_28, descriptor, (IProgressMonitor)cMon);
                                FileItemInfo proxy = new FileItemInfo((IFolderHandle)versionableState, null, null);
                                copyFileAreaStore.setItemInfo((IShareable)var18_28, proxy, (IProgressMonitor)cMon);
                            }
                        } else if (!versionableState.sameStateId((IItemHandle)oldVersionable)) {
                            FileItemInfo parent = copyFileAreaStore.getItemInfo(path.removeLastSegments(1));
                            FileItemInfo proxy = new FileItemInfo((IFolderHandle)versionableState, (IFolderHandle)parent.getVersionableHandle(), path.lastSegment());
                            copyFileAreaStore.setItemInfo((IShareable)var18_28, proxy, (IProgressMonitor)cMon);
                        }
                        this.contentSession.decrementTransferCount(1);
                        continue;
                    }
                    if (!versionableState.sameStateId((IItemHandle)oldVersionable) || (var18_28.getState() & 4) != 0) {
                        pathsToUpdate[i] = new DeferredUpdateInformation((IPath)path, fileAreaUpdate.isExecutable(), fileAreaUpdate.getOptionalContent(), this.loadLocations.contains(path));
                        this.modifyFile(componentHandle, versionableState, this.repo, fileAreaUpdate.getTimestamp(), pathsToUpdate[i], (IProgressMonitor)cMon);
                        continue;
                    }
                    this.contentSession.decrementTransferCount(1);
                    continue;
                }
                throw new IllegalStateException("Mutator is intended to only load new files/folders");
            }
        }
        finally {
            this.contentSession.join();
            if (progress.isCanceled()) {
                progress.subTask(Messages.MergeLoadMutator_11);
            } else if (component != null) {
                progress.subTask(NLS.bind((String)Messages.MergeLoadMutator_12, (Object)component.getName()));
            } else {
                progress.subTask(Messages.MergeLoadMutator_10);
            }
            this.updateContentLoadedMetaData(pathsToUpdate, updates, (IProgressMonitor)progress);
        }
        IStatus[] failures = this.getDownloadFailures(pathsToUpdate);
        if (failures.length > 0) {
            IStatus[] iStatusArray = this.getErrors();
            if (iStatusArray.length > 0) {
                IStatus[] allErrors = new IStatus[failures.length + iStatusArray.length];
                System.arraycopy(iStatusArray, 0, allErrors, 0, iStatusArray.length);
                System.arraycopy(failures, 0, allErrors, iStatusArray.length, failures.length);
                failures = allErrors;
            }
            RepositoryUtils.throwAppropriateException(Messages.MergeLoadMutator_4, failures);
        } else if (this.contentSession.isCanceled()) {
            throw new OperationCanceledException();
        }
        progress.setWorkRemaining(folders.size() + sharePaths.size() + allFolders.size());
        for (Map.Entry entry : folders.entrySet()) {
            IPath parentFolder = ((RelativePath)entry.getKey()).path;
            HashSet expectedContents = (HashSet)entry.getValue();
            List<IShareable> actualContents = this.getChildren(parentFolder);
            SubMonitor subProgress = progress.newChild(1);
            int n = actualContents.size() * 2;
            Iterator<IShareable> iActualContents = actualContents.iterator();
            while (iActualContents.hasNext()) {
                void var18_34;
                subProgress.setWorkRemaining((int)var18_34);
                IShareable file = iActualContents.next();
                if (!expectedContents.contains(file.getLocalFullPath().lastSegment())) {
                    if ((file.getState() & 1) == 1) {
                        copyFileAreaStore.deleteTreeInfo(file, true, (IProgressMonitor)subProgress.newChild(1));
                    }
                    if (!file.shouldBeIgnored()) {
                        if (!this.isSpecialCase(file)) {
                            this.deleteSubtree(file.getLocalFullPath(), (IProgressMonitor)subProgress.newChild(1));
                        } else {
                            LocalChangeManager.getInstance().computeChanges(file, (IProgressMonitor)subProgress.newChild(1));
                        }
                    }
                }
                var18_34 -= 2;
            }
        }
        for (Map.Entry entry : allFolders.entrySet()) {
            SubMonitor subProgress = progress.newChild(1);
            FolderInformation folder = (FolderInformation)entry.getKey();
            InverseFileItemInfo info = copyFileAreaStore.getItemInfo((IVersionableHandle)folder.folderHandle, folder.component, folder.connectionHandle);
            if (info != null) {
                HashMap<String, IVersionableHandle> children = new HashMap<String, IVersionableHandle>(info.getRemoteChildren());
                for (String string : (HashSet)entry.getValue()) {
                    children.remove(string);
                }
                subProgress.setWorkRemaining(children.size());
                for (Map.Entry entry2 : children.entrySet()) {
                    copyFileAreaStore.deleteTreeInfo((IVersionableHandle)entry2.getValue(), folder.component, folder.connectionHandle, (IProgressMonitor)subProgress.newChild(1));
                }
            }
            subProgress.done();
        }
        for (FolderInformation folderInformation : sharePaths) {
            copyFileAreaStore.setConfigurationState(folderInformation.connectionHandle, folderInformation.component, folderInformation.folderHandle, ISyncTime.FACTORY.createFrom(this.loadTree.getConfigurationState()), (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
    }

    private boolean isShareRoot(IComponentHandle component, IVersionableHandle item) {
        Set<UUID> shareRoots = this.roots.get(component.getItemId());
        return shareRoots != null && shareRoots.contains(item.getItemId());
    }

    private IStatus[] getDownloadFailures(DeferredUpdateInformation[] pathsToUpdate) {
        ArrayList<Status> errors = new ArrayList<Status>();
        DeferredUpdateInformation[] deferredUpdateInformationArray = pathsToUpdate;
        int n = pathsToUpdate.length;
        int n2 = 0;
        while (n2 < n) {
            DeferredUpdateInformation deferredUpdateInformation = deferredUpdateInformationArray[n2];
            if (deferredUpdateInformation != null && deferredUpdateInformation.getFailure() != null) {
                Throwable rootCause = deferredUpdateInformation.getFailure().getCause();
                int paranoiaCount = 0;
                while (rootCause instanceof TeamRepositoryException && paranoiaCount < 50) {
                    Throwable cause = ((TeamRepositoryException)rootCause).getCause();
                    if (cause == null) break;
                    rootCause = cause;
                    ++paranoiaCount;
                }
                Status status = rootCause instanceof UnsupportedEncodingException || rootCause instanceof UnsupportedCharsetException ? new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.MergeLoadMutator_5, (Object)deferredUpdateInformation.getPath(), (Object)deferredUpdateInformation.getContent().getCharacterEncoding()), (Throwable)deferredUpdateInformation.getFailure()) : (rootCause instanceof CharacterCodingException ? new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.MergeLoadMutator_1, (Object)deferredUpdateInformation.getPath(), (Object)deferredUpdateInformation.getContent().getCharacterEncoding()), (Throwable)deferredUpdateInformation.getFailure()) : new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.MergeLoadMutator_6, (Object)deferredUpdateInformation.getPath()), (Throwable)deferredUpdateInformation.getFailure()));
                errors.add(status);
            }
            ++n2;
        }
        return errors.toArray(new IStatus[errors.size()]);
    }

    private void updateContentLoadedMetaData(DeferredUpdateInformation[] pathsToUpdate, List<FileAreaUpdate> updates, IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)progress, (int)pathsToUpdate.length);
        subProgress.setWorkRemaining(pathsToUpdate.length);
        int i = 0;
        while (i < pathsToUpdate.length) {
            if (pathsToUpdate[i] == null || !pathsToUpdate[i].contentUpdated()) {
                subProgress.worked(1);
            } else {
                FileAreaUpdate update = updates.get(i);
                this.updateMetaInfoForPath(update.getComponent(), update.afterState(), pathsToUpdate[i], (IProgressMonitor)subProgress.newChild(1));
            }
            ++i;
        }
        subProgress.done();
    }

    protected void updateMetaInfoForPath(IComponentHandle componentHandle, IVersionableHandle fileItem, DeferredUpdateInformation updateInfo, IProgressMonitor monitor) throws FileSystemClientException {
        IFileStorage file = this.pathToIFileStorage(updateInfo.path);
        CopyFileAreaStore copyFileAreaStore = CopyFileAreaStore.getCopyFileArea(this.getRoot());
        InverseFileItemInfo oldInfo = copyFileAreaStore.getItemInfo(fileItem, componentHandle, this.connectionHandle);
        FileItemInfo parentInfo = copyFileAreaStore.getItemInfo(updateInfo.path.removeLastSegments(1));
        String[] segments = updateInfo.path.segments();
        IFolderHandle parent = null;
        String name = null;
        if (updateInfo.isUndo) {
            parent = oldInfo.getParent();
            name = oldInfo.getName();
        } else {
            parent = (IFolderHandle)parentInfo.getVersionableHandle();
            name = segments[segments.length - 1];
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Content content = (Content)updateInfo.getContent();
        FileItemInfo newInfo = new FileItemInfo(fileItem, file.getModificationStamp(), parent, name, new HashCode(updateInfo.getCheckSum()), updateInfo.getContentSize(), content.getLineDelimiter(), content.getLineDelimiter(), content.getContentType(), content.getContentType(), content.getContentId(), content.getDeltaPredecessor(), content.getContentLength(), content.getCharacterEncoding(), content.getChecksum(), content.getLineDelimiterCount(), updateInfo.isExecutable(), updateInfo.isExecutable());
        copyFileAreaStore.setItemInfo(file.getShareable(), newInfo, (IProgressMonitor)progress.newChild(50));
        file.setExecutable(updateInfo.isExecutable(), (IProgressMonitor)progress.newChild(50));
        progress.done();
    }

    protected abstract IFileStorage pathToIFileStorage(IPath var1);

    protected abstract boolean isSpecialCase(IShareable var1);

    protected abstract List<IShareable> getChildren(IPath var1) throws FileSystemClientException;

    protected abstract Shareable getShareable(IPath var1);

    private Shareable getShareable(IVersionableHandle item, IComponentHandle component, IProgressMonitor monitor) throws FileSystemClientException {
        IPath path = CopyFileAreaStore.getCopyFileArea(this.getRoot()).getLocalPathFor(item, component, this.connectionHandle, monitor);
        return path == null ? null : this.getShareable(path);
    }

    protected abstract void createNewFile(IComponentHandle var1, String[] var2, IVersionableHandle var3, Date var4, ITeamRepository var5, IContent var6, DeferredUpdateInformation var7, IProgressMonitor var8) throws FileSystemClientException, TeamRepositoryException;

    public void createFolder(IComponentHandle component, IPath path, IVersionableHandle folderItemState, IProgressMonitor mon) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        IFileStorage folder = this.createNewFolder(component, path.segments(), folderItemState, (IProgressMonitor)monitor.newChild(95));
        if (folder != null) {
            String name;
            IFolderHandle parent;
            if (path.segmentCount() == 0) {
                return;
            }
            if (path.segmentCount() == 1) {
                Shareable shareable = folder.getShareable();
                IComponent fullComponent = (IComponent)this.connection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)component, 0, (IProgressMonitor)monitor.newChild(1));
                SharingDescriptor descriptor = new SharingDescriptor(this.connection.teamRepository().getRepositoryURI(), this.connection.teamRepository().getId(), this.connection, component, fullComponent.getName(), (IFolderHandle)folderItemState);
                if (shareable.getShare() == null) {
                    shareable.share(descriptor, true, (IProgressMonitor)monitor.newChild(3));
                } else {
                    CopyFileAreaStore.getCopyFileArea(this.getRoot()).setSharingInfo(shareable, descriptor, (IProgressMonitor)monitor.newChild(3));
                }
                parent = null;
                name = null;
            } else {
                FileItemInfo parentInfo = CopyFileAreaStore.getCopyFileArea(this.getRoot()).getItemInfo(path.removeLastSegments(1));
                parent = (IFolderHandle)parentInfo.getVersionableHandle();
                name = path.lastSegment();
                monitor.worked(3);
            }
            FileItemInfo proxy = new FileItemInfo((IFolderHandle)folderItemState, parent, name);
            CopyFileAreaStore.getCopyFileArea(this.getRoot()).setItemInfo(folder.getShareable(), proxy, (IProgressMonitor)monitor.newChild(2));
        }
        monitor.done();
        this.checkCancelled((IProgressMonitor)monitor);
    }

    protected abstract IFileStorage createNewFolder(IComponentHandle var1, String[] var2, IVersionableHandle var3, IProgressMonitor var4) throws FileSystemClientException, TeamRepositoryException;

    protected abstract void deleteSubtree(IPath var1, IProgressMonitor var2) throws FileSystemClientException, TeamRepositoryException;

    protected abstract void modifyFile(IComponentHandle var1, IVersionableHandle var2, ITeamRepository var3, Date var4, DeferredUpdateInformation var5, IProgressMonitor var6) throws FileSystemClientException, TeamRepositoryException;

    protected final IConnection getConnection() {
        return this.connection;
    }

    protected final IPath getRoot() {
        return this.copyFileAreaPath;
    }

    protected void deleteIncompleteFile(IPath path) throws TeamRepositoryException {
        this.internalDeleteIncompleteFile(path);
    }

    protected final void internalDeleteIncompleteFile(IPath path) throws TeamRepositoryException {
        File file = this.getRoot().append(path).toFile();
        if (!file.exists()) {
            return;
        }
        if (!file.delete()) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.MergeLoadMutator_0, (Object)path));
        }
    }

    protected void storeFileContents(IPath path, IContent content, IVersionableHandle fileItem, InputStream in) throws TeamRepositoryException {
        this.internalStoreFileContents(path, in);
    }

    protected void internalStoreFileContents(IPath path, InputStream in) throws TeamRepositoryException {
        try {
            FileOutputStream out = new FileOutputStream(this.getRoot().append(path).toFile());
            try {
                ContentManager.read((InputStream)in, (OutputStream)out);
            }
            catch (Throwable throwable) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((OutputStream)out).close();
            }
            catch (IOException iOException) {}
        }
        catch (SocketException e) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.MergeLoadMutator_7, (Object)e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.MergeLoadMutator_8, (Object)path), (Throwable)e);
        }
    }

    protected abstract Shareable getNonExistantShareable(FileItemInfo var1, IComponentHandle var2, IContextHandle var3, IProgressMonitor var4) throws FileSystemClientException;

    @Override
    protected void reportErrorsAsException(IStatus[] errors) throws FileSystemClientException {
        if (errors.length == 0) {
            return;
        }
        MultiStatus result = new MultiStatus("com.ibm.team.filesystem.client", 0, errors, NLS.bind((String)Messages.MergeLoadMutator_9, (Object)errors.length), null);
        throw new FileSystemClientException((IStatus)result);
    }

    protected static class DeferredUpdateInformation {
        protected IPath path;
        protected IContent content;
        protected boolean isExecutable;
        protected boolean isUndo;
        private boolean contentTransferred;
        private Checksum checkSum;
        private long contentSize;
        private TeamRepositoryException failure;

        public DeferredUpdateInformation(IPath p, boolean executable, IContent c) {
            this.path = p;
            this.isExecutable = executable;
            this.content = c;
            this.isUndo = false;
            this.contentTransferred = false;
        }

        public DeferredUpdateInformation(IPath p, boolean executable, IContent c, boolean i) {
            this.path = p;
            this.isExecutable = executable;
            this.content = c;
            this.isUndo = i;
            this.contentTransferred = false;
        }

        public boolean contentUpdated() {
            return this.contentTransferred;
        }

        public boolean isExecutable() {
            return this.isExecutable;
        }

        public void setContentUpdated(Checksum checkSum, long contentSize) {
            this.contentTransferred = true;
            this.checkSum = checkSum;
            this.contentSize = contentSize;
        }

        public IPath getPath() {
            return this.path;
        }

        public IContent getContent() {
            return this.content;
        }

        public Checksum getCheckSum() {
            return this.checkSum;
        }

        public long getContentSize() {
            return this.contentSize;
        }

        public void setFailure(TeamRepositoryException failureCause) {
            this.failure = failureCause;
        }

        public TeamRepositoryException getFailure() {
            return this.failure;
        }
    }

    protected static class DownloadHandler
    extends DownloadAdapter {
        DeferredUpdateInformation deferredUpdateInformation;
        IVersionableHandle fileItem;
        MergeLoadMutator mutator;

        public DownloadHandler(DeferredUpdateInformation deferredUpdateInformation, IVersionableHandle fileItem, MergeLoadMutator mutator) {
            this.deferredUpdateInformation = deferredUpdateInformation;
            this.mutator = mutator;
        }

        public void downloadStreamAcquired(IContent content, InputStream in) throws TeamRepositoryException {
            boolean completed = false;
            try {
                HashComputingInputStream inStream = new HashComputingInputStream(in);
                this.mutator.storeFileContents(this.deferredUpdateInformation.path, content, this.fileItem, (InputStream)inStream);
                completed = true;
                this.deferredUpdateInformation.setContentUpdated(inStream.getChecksum(), inStream.getContentSize());
            }
            finally {
                if (!completed) {
                    this.mutator.deleteIncompleteFile(this.deferredUpdateInformation.path);
                }
            }
        }

        public void downloadFailed(IContent content, TeamRepositoryException e) {
            this.deferredUpdateInformation.setFailure(e);
        }
    }

    private static class FolderInformation {
        protected IPath path;
        protected IContextHandle connectionHandle;
        protected IComponentHandle component;
        protected IFolderHandle folderHandle;

        public FolderInformation(IPath path, IContextHandle connectionHandle, IComponentHandle component, IFolderHandle folderHandle) {
            this.path = path;
            this.connectionHandle = connectionHandle;
            this.component = component;
            this.folderHandle = folderHandle;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.component == null ? 0 : this.component.getItemId().hashCode());
            result = 31 * result + (this.connectionHandle == null ? 0 : this.connectionHandle.getItemId().hashCode());
            result = 31 * result + (this.folderHandle == null ? 0 : this.folderHandle.getItemId().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FolderInformation other = (FolderInformation)obj;
            if (this.component == null ? other.component != null : !this.component.sameItemId((IItemHandle)other.component)) {
                return false;
            }
            if (this.connectionHandle == null ? other.connectionHandle != null : !this.connectionHandle.sameItemId((IItemHandle)other.connectionHandle)) {
                return false;
            }
            return !(this.folderHandle == null ? other.folderHandle != null : !this.folderHandle.sameItemId((IItemHandle)other.folderHandle));
        }
    }

    private final class RelativePath {
        protected final IPath path;
        private final String[] segments;

        public RelativePath(IPath path) {
            this.path = path;
            this.segments = path.segments();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.segments);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RelativePath other = (RelativePath)obj;
            return Arrays.equals(this.segments, other.segments);
        }
    }
}

