/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.LocalFileStorage;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.ShareableFile;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.load.MergeLoadMutator;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.repository.client.IDownloadHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalFileSystemMergeLoadMutator
extends MergeLoadMutator {
    private final File root;

    public LocalFileSystemMergeLoadMutator(IConnection connection, Map<ConfigurationDescriptor, Collection<IVersionableHandle>> shareRoots, LoadTree updates, IPath fileSystemRoot, Collection<String[]> subTreeRoots, DilemmaHandler problemHandler) throws TeamRepositoryException {
        super(connection, shareRoots, updates, fileSystemRoot, subTreeRoots, problemHandler);
        this.root = fileSystemRoot.toFile();
        if (!this.root.exists() || !this.root.isDirectory()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.LocalFileSystemMergeLoadMutator_0, (Object)fileSystemRoot));
        }
    }

    @Override
    protected void createNewFile(IComponentHandle component, String[] stringPath, IVersionableHandle fileItem, Date timestamp, ITeamRepository repo, IContent content, MergeLoadMutator.DeferredUpdateInformation deferredUpdateInformation, IProgressMonitor progressReporter) throws FileSystemClientException, TeamRepositoryException {
        File file = PathUtils.getFile(this.root, stringPath);
        file.setLastModified(timestamp.getTime());
        if (file.exists()) {
            this.deleteSubtree(file);
        }
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, 367, NLS.bind((String)Messages.LocalFileSystemMergeLoadMutator_1, (Object)file.getPath()), e));
        }
        if (content != null) {
            this.contentSession.retrieveContent(content, (IDownloadHandler)new MergeLoadMutator.DownloadHandler(deferredUpdateInformation, fileItem, this));
        }
    }

    @Override
    protected IFileStorage createNewFolder(IComponentHandle component, String[] stringPath, IVersionableHandle folderItem, IProgressMonitor monitor) throws FileSystemClientException {
        File directory = PathUtils.getFile(this.root, stringPath);
        if (!directory.exists() && !directory.mkdir()) {
            throw new FileSystemClientException(new FileSystemStatus(4, 368, NLS.bind((String)Messages.LocalFileSystemMergeLoadMutator_2, (Object[])stringPath)));
        }
        if (monitor != null) {
            monitor.done();
        }
        return new LocalFileStorage(this.getRoot(), directory);
    }

    private void deleteSubtree(File file) throws FileSystemClientException {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                this.deleteSubtree(children[i]);
                ++i;
            }
        }
        file.delete();
    }

    @Override
    protected void deleteSubtree(IPath path, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        File file = PathUtils.getFile(this.root, path.segments());
        if (path.segmentCount() == 0) {
            throw new IllegalArgumentException();
        }
        if (file.exists()) {
            this.deleteSubtree(file);
        }
    }

    @Override
    protected List<IShareable> getChildren(IPath parentFolder) throws FileSystemClientException {
        File folder = PathUtils.getFile(this.root, parentFolder.segments());
        File[] files = folder.listFiles();
        if (files == null || files.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IShareable> children = new ArrayList<IShareable>();
        int i = 0;
        while (i < files.length) {
            children.add(new ShareableFile(this.getRoot(), files[i]));
            ++i;
        }
        return children;
    }

    @Override
    protected Shareable getShareable(IPath path) {
        File file = PathUtils.getFile(this.root, path.segments());
        if (file.exists()) {
            return new ShareableFile(this.getRoot(), file);
        }
        return null;
    }

    @Override
    protected boolean isSpecialCase(IShareable file) {
        return false;
    }

    @Override
    protected IFileStorage pathToIFileStorage(IPath path) {
        File file = PathUtils.getFile(this.root, path.segments());
        return new LocalFileStorage(this.getRoot(), file);
    }

    @Override
    protected void modifyFile(IComponentHandle component, IVersionableHandle fileItem, ITeamRepository repository, Date timestamp, MergeLoadMutator.DeferredUpdateInformation deferredUpdateInformation, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        this.contentSession.retrieveContent(deferredUpdateInformation.content, (IDownloadHandler)new MergeLoadMutator.DownloadHandler(deferredUpdateInformation, fileItem, this));
    }

    @Override
    protected Shareable getNonExistantShareable(FileItemInfo infoForDeletedItem, IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        IPath path = CopyFileAreaStore.getCopyFileArea(this.getRoot()).getLocalPathFor(infoForDeletedItem.getVersionableHandle(), component, connection, monitor);
        File file = PathUtils.getFile(this.root, path.segments());
        return new ShareableFile(this.getRoot(), file);
    }
}

