/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.LocalFileStorage;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.ShareableFile;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.load.DeferredDownloadInformation;
import com.ibm.team.filesystem.client.internal.load.LoadMutator;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.repository.client.IDownloadHandler;
import com.ibm.team.repository.client.internal.ContentManager;
import com.ibm.team.repository.client.util.DownloadAdapter;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.Content;
import com.ibm.team.repository.common.utils.HashCode;
import com.ibm.team.repository.common.utils.HashComputingInputStream;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalFileSystemLoadMutator
extends LoadMutator {
    private final File root;
    private final IComponentHandle component;
    private final HashSet<IPath> loadLocations;
    private HashMap<UUID, IPath> foldersCreated;
    private final HashSet<UUID> shareRoots;
    private IPath fileSystemRoot;

    public LocalFileSystemLoadMutator(IConnection connection, IComponentHandle component, Collection<IVersionableHandle> shareRoots, LoadTree loadTree, IPath fileSystemRoot, Collection<String[]> subTreeRoots, int flags, LoadDilemmaHandler loadProblemHandler) throws TeamRepositoryException {
        super(connection, loadTree, fileSystemRoot, flags, loadProblemHandler);
        this.component = component;
        this.fileSystemRoot = fileSystemRoot;
        this.root = fileSystemRoot.toFile();
        if (!this.root.exists() || !this.root.isDirectory()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.LocalFileSystemLoadMutator_0, (Object)fileSystemRoot));
        }
        this.loadLocations = new HashSet();
        for (String[] path : subTreeRoots) {
            this.loadLocations.add(PathUtils.getPath(path));
        }
        this.foldersCreated = new HashMap();
        this.shareRoots = new HashSet();
        for (IVersionableHandle shareRoot : shareRoots) {
            this.shareRoots.add(shareRoot.getItemId());
        }
    }

    @Override
    protected void deleteRootArea(IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IPath rootPath = this.getRoot();
        IConnection connection = this.getConnection();
        CopyFileAreaStore copyFileArea = CopyFileAreaStore.getCopyFileArea(rootPath);
        if (SharingManager.getInstance().isConnectionShared(this.getRoot(), this.getConnectionHandle())) {
            File[] children = rootPath.toFile().listFiles();
            int i = 0;
            while (i < children.length) {
                progress.setWorkRemaining(children.length - i);
                ISharingDescriptor sharing = copyFileArea.getSharingInfo((IPath)new Path(children[i].getName()));
                if (sharing != null && sharing.isAssociatedWithConnection(connection) && sharing.getComponent().sameItemId((IItemHandle)this.component) && (this.loadLocations.isEmpty() || this.loadLocations.contains(new Path(children[i].getName())))) {
                    this.deleteSubtree(children[i]);
                    ShareableFile shareable = new ShareableFile(rootPath, children[i]);
                    shareable.forget((IProgressMonitor)progress.newChild(1));
                }
                ++i;
            }
        } else if (this.loadLocations.isEmpty()) {
            File[] children = this.root.listFiles();
            int i = 0;
            while (i < children.length) {
                this.deleteSubtree(children[i]);
                ++i;
            }
        } else {
            for (IPath path : this.loadLocations) {
                File file = PathUtils.getFile(this.root, path.segments());
                this.deleteSubtree(file);
            }
        }
        progress.done();
    }

    private IDownloadHandler getDownloadAdapter(final DeferredDownloadInformation updateInfo, final ShareableFile shareable, IProgressMonitor monitor) {
        return new DownloadAdapter(){

            public void downloadStreamAcquired(IContent content, InputStream in) throws TeamRepositoryException {
                File file = shareable.getFile();
                try {
                    FileOutputStream out = new FileOutputStream(file);
                    boolean completed = false;
                    try {
                        HashComputingInputStream inStream = new HashComputingInputStream(in);
                        ContentManager.read((InputStream)inStream, (OutputStream)out);
                        updateInfo.setContentUpdated(shareable, inStream.getChecksum(), inStream.getContentSize());
                        completed = true;
                    }
                    catch (Throwable throwable) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (IOException iOException) {}
                        if (!completed && file.exists()) {
                            file.delete();
                        }
                        throw throwable;
                    }
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException iOException) {}
                    if (!completed && file.exists()) {
                        file.delete();
                    }
                }
                catch (IOException e) {
                    throw new TeamRepositoryException(NLS.bind((String)Messages.LocalFileSystemLoadMutator_1, (Object)file), (Throwable)e);
                }
            }

            public void downloadFailed(IContent content, TeamRepositoryException e) {
                updateInfo.setFailure(shareable, e);
            }
        };
    }

    private void deleteSubtree(File file) throws FileSystemClientException {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                this.deleteSubtree(children[i]);
                ++i;
            }
        }
        file.delete();
    }

    protected IFileStorage pathToIFileStorage(IPath path) {
        File file = PathUtils.getFile(this.root, path.segments());
        return new LocalFileStorage(this.getRoot(), file);
    }

    @Override
    protected void createNewFile(IComponent component, DeferredDownloadInformation downloadInfo, Date date, IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        IFolderHandle parent = downloadInfo.getParent();
        String name = downloadInfo.getName();
        IPath path = this.foldersCreated.get(parent.getItemId());
        if (path == null) {
            if (!component.sameItemId((IItemHandle)parent)) {
                throw new FileSystemClientException(new FileSystemStatus(4, 367, NLS.bind((String)Messages.LocalFileSystemLoadMutator_2, (Object)name, (Object)component.getName())));
            }
            path = new Path(name);
        } else {
            path = path.append(name);
        }
        File file = PathUtils.getFile(this.root, path.segments());
        file.setLastModified(date.getTime());
        if (file.exists()) {
            this.deleteSubtree(file);
        }
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, 367, NLS.bind((String)Messages.LocalFileSystemLoadMutator_3, (Object)file.getPath()), e));
        }
        if (downloadInfo.getContent() != null) {
            this.contentSession.retrieveContent(downloadInfo.getContent(), this.getDownloadAdapter(downloadInfo, new ShareableFile(this.getRoot(), file), progress));
        }
    }

    @Override
    protected IFileStorage createNewFolder(IComponent component, IFolderHandle parent, String name, IVersionableHandle folderItemState, IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        IPath path = this.foldersCreated.get(parent.getItemId());
        if (path == null) {
            if (!this.isShareRoot(component, folderItemState)) {
                throw new FileSystemClientException(new FileSystemStatus(4, 368, NLS.bind((String)Messages.LocalFileSystemLoadMutator_4, (Object)name, (Object)component.getName())));
            }
            path = new Path(name);
        } else {
            path = path.append(name);
        }
        File directory = PathUtils.getFile(this.root, path.segments());
        if (directory.exists()) {
            this.deleteSubtree(directory);
            if (path.segmentCount() == 1) {
                ShareableFile shareable = new ShareableFile(this.getRoot(), directory);
                shareable.forget(progress);
            }
        }
        if (!directory.mkdir()) {
            throw new FileSystemClientException(new FileSystemStatus(4, 368, NLS.bind((String)Messages.LocalFileSystemLoadMutator_5, (Object)path.toString())));
        }
        this.foldersCreated.put(folderItemState.getItemId(), path);
        return new LocalFileStorage(this.getRoot(), directory);
    }

    private boolean isShareRoot(IComponent component, IVersionableHandle item) {
        return this.shareRoots.contains(item.getItemId());
    }

    @Override
    protected void updateMetaData(DeferredDownloadInformation updateInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Shareable shareable = updateInfo.getShareable();
        if (shareable instanceof ShareableFile) {
            File file = ((ShareableFile)shareable).getFile();
            if (this.isMaintainShareable()) {
                Content content = (Content)updateInfo.getContent();
                LineDelimiter lineDelimiter = content.getLineDelimiter();
                String contentType = content.getContentType();
                FileItemInfo info = new FileItemInfo((IVersionableHandle)updateInfo.getFileItem(), file.lastModified(), updateInfo.getParent(), updateInfo.getName(), new HashCode(updateInfo.getChecksum()), updateInfo.getContentSize(), lineDelimiter, lineDelimiter, contentType, contentType, content.getContentId(), content.getDeltaPredecessor(), content.getContentLength(), content.getCharacterEncoding(), content.getChecksum(), content.getLineDelimiterCount(), updateInfo.isExecutable(), updateInfo.isExecutable());
                try {
                    CopyFileAreaStore.getCopyFileArea(this.getRoot()).setItemInfo(updateInfo.getShareable(), info, (IProgressMonitor)progress.newChild(50));
                }
                catch (FileSystemClientException e) {
                    throw new TeamRepositoryException(NLS.bind((String)Messages.LocalFileSystemLoadMutator_6, (Object)updateInfo.getShareable().getLocalFullPath()), (Throwable)((Object)e));
                }
            }
            ((ShareableFile)shareable).getFileStorage().setExecutable(updateInfo.isExecutable(), (IProgressMonitor)progress.newChild(50));
            progress.done();
        }
    }
}

