/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IFolderHandle;
import java.util.zip.Checksum;

public class DeferredDownloadInformation {
    private FileAreaUpdate update;
    private Checksum checksum;
    private long contentSize;
    private boolean isComplete;
    private Shareable shareable;
    private TeamRepositoryException failure;

    public DeferredDownloadInformation(FileAreaUpdate update) {
        if (!(update.getItem() instanceof IFileItemHandle)) {
            throw new IllegalArgumentException("Trying to download something that is not a file");
        }
        this.update = update;
        this.isComplete = false;
        this.failure = null;
    }

    public boolean isExecutable() {
        return this.update.isExecutable();
    }

    public IFolderHandle getParent() {
        return this.update.getDestinationParent();
    }

    public IFileItemHandle getFileItem() {
        return (IFileItemHandle)this.update.afterState();
    }

    public String getName() {
        return this.update.getName();
    }

    public IContent getContent() {
        return this.update.getOptionalContent();
    }

    public void setContentUpdated(Shareable shareable, Checksum checksum, long contentSize) {
        this.shareable = shareable;
        this.isComplete = true;
        this.checksum = checksum;
        this.contentSize = contentSize;
    }

    public boolean contentUpdated() {
        return this.isComplete;
    }

    public Shareable getShareable() {
        return this.shareable;
    }

    public long getContentSize() {
        return this.contentSize;
    }

    public Checksum getChecksum() {
        return this.checksum;
    }

    public void setFailure(Shareable shareable, TeamRepositoryException e) {
        this.shareable = shareable;
        this.failure = e;
    }

    public TeamRepositoryException getFailure() {
        return this.failure;
    }
}

