/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.ignore;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreReason;
import com.ibm.team.filesystem.client.internal.utils.ILRUCache;
import com.ibm.team.filesystem.client.internal.utils.LRUCache;
import com.ibm.team.filesystem.client.internal.utils.SynchronizedLRUCache;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IgnoreManager
implements IIgnoreManager {
    private final Object providersLock = new Object();
    HashMap<String, IIgnoreProvider> providers = new HashMap();
    protected EventSource eventSource = new EventSource();
    ILRUCache<IPath, Boolean> cache = new SynchronizedLRUCache<IPath, Boolean>(new LRUCache(400));
    private static final IgnoreManager instance;

    static {
        IgnoreManager man;
        instance = man = new IgnoreManager("default", new DefaultIgnoreProvider());
    }

    public static IIgnoreManager getInstance() {
        return instance;
    }

    private IgnoreManager() {
    }

    public IgnoreManager(String name, DefaultIgnoreProvider provider) {
        this();
        try {
            this.addIgnoreProvider(name, provider, null);
        }
        catch (FileSystemClientException e) {
            LoggingHelper.log(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIgnoreProvider(String name, IIgnoreProvider provider, IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress);
        Object object = this.providersLock;
        synchronized (object) {
            if (this.providers.containsKey(name)) {
                throw new IllegalStateException(NLS.bind((String)Messages.IgnoreManager_0, (Object)name));
            }
            this.providers = (HashMap)this.providers.clone();
            this.providers.put(name, provider);
            provider.setIgnoreManager(this, this.eventSource, (IProgressMonitor)monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIgnoreProvider(String name) throws NoSuchElementException {
        Object object = this.providersLock;
        synchronized (object) {
            HashMap newProviders = (HashMap)this.providers.clone();
            IIgnoreProvider removed = (IIgnoreProvider)newProviders.remove(name);
            if (removed == null) {
                throw new NoSuchElementException();
            }
            this.providers = newProviders;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, IIgnoreProvider> getProviders() {
        Object object = this.providersLock;
        synchronized (object) {
            return this.providers;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IIgnoreManager.IIgnoreReason findIgnoreReasons(IShareable shareable, IProgressMonitor progress) {
        if (!this.shouldBeIgnored(shareable)) {
            return null;
        }
        myProviders = this.getProviders();
        fullPath = shareable.getLocalFullPath();
        monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(fullPath.segmentCount() * myProviders.size()));
        testers = new IIgnoreProvider.IIgnoreTester[myProviders.size()];
        sm = SharingManager.getInstance();
        shareRoot = shareable.getRoot();
        try {
            i = 0;
            for (IIgnoreProvider provider : myProviders.values()) {
                testers[i++] = provider.getTester();
            }
            walker = new Path("/");
            segments = fullPath.segments();
            allRules = new ArrayList<IIgnoreProvider.IIgnoreRule>();
            i = 0;
            while (i < segments.length) {
                walker = walker.append(segments[i]);
                var16_16 = testers;
                var15_15 = testers.length;
                var14_14 = 0;
                while (var14_14 < var15_15) {
                    tester = var16_16[var14_14];
                    rules = tester.findIgnoreReasons(shareable, (IPath)walker);
                    Assert.isNotNull((Object)rules);
                    allRules.addAll(rules);
                    ++var14_14;
                }
                if (allRules.size() > 0) {
                    inheritsFrom = null;
                    if (i < segments.length - 1) {
                        inheritsFrom = sm.findShareable(shareRoot, (IPath)walker, true);
                    }
                    var19_18 = new IgnoreReason(shareable, allRules, inheritsFrom);
                    return var19_18;
                }
                ++i;
            }
        }
        finally {
            var23_19 = testers;
            var22_22 = testers.length;
            var21_25 = 0;
            ** while (var21_25 < var22_22)
        }
lbl-1000:
        // 1 sources

        {
            tester = var23_19[var21_25];
            if (tester != null) {
                try {
                    tester.done();
                }
                catch (Exception e) {
                    LoggingHelper.error("com.ibm.team.filesystem.client", Messages.IgnoreManager_2, e);
                }
            }
            ++var21_25;
            continue;
        }
lbl54:
        // 1 sources

        monitor.done();
        return var19_18;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean shouldBeIgnored(IShareable shareable) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 23[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void addGenericListener(Object category, IListener listener) {
        this.eventSource.addGenericListener(category, listener);
    }

    @Override
    public void addGenericListener(Object[] categories, IListener listener) {
        Object[] objectArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            Object category = objectArray[n2];
            this.addGenericListener(category, listener);
            ++n2;
        }
    }

    public void purgeGenericListener(IListener listener) {
        this.eventSource.purgeGenericListener(listener);
    }

    @Override
    public void removeGenericListener(Object[] categories, IListener listener) {
        Object[] objectArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            Object category = objectArray[n2];
            this.eventSource.removeGenericListener(category, listener);
            ++n2;
        }
    }

    public void removeGenericListener(Object category, IListener listener) {
        this.eventSource.removeGenericListener(category, listener);
    }

    public void waitForEventsToDrain() {
        while (this.eventSource.internalIsBusy()) {
            try {
                Thread.sleep(4L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IIgnoreProvider getIgnoreProvider(String name) {
        Object object = this.providersLock;
        synchronized (object) {
            if (!this.providers.containsKey(name)) {
                throw new IllegalStateException(NLS.bind((String)Messages.IgnoreManager_5, (Object)name));
            }
            return this.providers.get(name);
        }
    }

    @Override
    public boolean hasUndeliveredEvents() {
        return this.eventSource.internalIsBusy();
    }

    @Override
    public IIgnoreManager createCopy(Collection<? extends IIgnoreManager.ICopyParameter> list, IProgressMonitor progress) {
        final IgnoreManager copy = new IgnoreManager();
        copy.eventSource = new EventSource();
        copy.cache = new SynchronizedLRUCache<IPath, Boolean>(new LRUCache());
        copy.providers = new HashMap();
        ArrayList<IIgnoreManager.ICopyParameter> paramWithIgnoreManager = new ArrayList<IIgnoreManager.ICopyParameter>();
        paramWithIgnoreManager.addAll(list);
        paramWithIgnoreManager.add(new IIgnoreManager.IIgnoreManagerCopyParameter(){

            public IIgnoreManager getNewIgnoreManager() {
                return copy;
            }

            public EventSource getEventQueue() {
                return copy.eventSource;
            }
        });
        Set<Map.Entry<String, IIgnoreProvider>> providers = this.getProviders().entrySet();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)providers.size());
        for (Map.Entry<String, IIgnoreProvider> entry : providers) {
            IIgnoreProvider provider = entry.getValue().createCopy(paramWithIgnoreManager, (IProgressMonitor)monitor.newChild(1));
            copy.providers.put(entry.getKey(), provider);
        }
        return copy;
    }

    @Override
    public IIgnoreManager createCopy(IProgressMonitor progress) {
        return this.createCopy(Collections.EMPTY_LIST, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deallocate() {
        Object object = this.providersLock;
        synchronized (object) {
            for (IIgnoreProvider provider : this.providers.values()) {
                provider.deallocate(this);
            }
            this.providers.clear();
        }
    }
}

