/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.ignore;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.GlobalIgnoreRule;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnorePattern;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRule;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRuleComparator;
import com.ibm.team.filesystem.client.internal.ignore.JazzIgnoreFile;
import com.ibm.team.filesystem.client.internal.ignore.LocalIgnoreRule;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IgnoreFileLoader {
    static final byte[] PREAMBLE = "### Jazz Ignore ".getBytes();
    public static final String PT_IGNORE_FORMAT = "ignoreFileFormat";
    private IIgnoreFileLoader latestLoader = null;
    private Map<Integer, IIgnoreFileLoader> loaders = new HashMap<Integer, IIgnoreFileLoader>();
    private static IgnoreFileLoader instance;

    public static synchronized IgnoreFileLoader getInstance() {
        if (instance == null) {
            IConfigurationElement[] configs;
            instance = new IgnoreFileLoader();
            int maxVersion = -1;
            IConfigurationElement[] iConfigurationElementArray = configs = RegistryFactory.getRegistry().getConfigurationElementsFor("com.ibm.team.filesystem.client", PT_IGNORE_FORMAT);
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement config = iConfigurationElementArray[n2];
                try {
                    IIgnoreFileLoader loader = (IIgnoreFileLoader)config.createExecutableExtension("class");
                    if (IgnoreFileLoader.instance.loaders.containsKey(loader.getVersion())) {
                        LoggingHelper.error("com.ibm.team.filesystem.client", "Duplicate ignore providers for version " + loader.getVersion(), null);
                    } else {
                        IgnoreFileLoader.instance.loaders.put(loader.getVersion(), loader);
                        maxVersion = Math.max(loader.getVersion(), maxVersion);
                    }
                }
                catch (CoreException e) {
                    LoggingHelper.log(e);
                }
                ++n2;
            }
            if (maxVersion > -1) {
                IgnoreFileLoader.instance.latestLoader = IgnoreFileLoader.instance.loaders.get(maxVersion);
            }
        }
        return instance;
    }

    public byte[] getIgnorePreamble(int version) {
        byte[] versionBytes = Integer.toString(version).getBytes();
        byte[] toReturn = new byte[PREAMBLE.length + versionBytes.length + 1];
        System.arraycopy(PREAMBLE, 0, toReturn, 0, PREAMBLE.length);
        System.arraycopy(versionBytes, 0, toReturn, PREAMBLE.length, versionBytes.length);
        toReturn[toReturn.length - 1] = 10;
        return toReturn;
    }

    public JazzIgnoreFile load(DefaultIgnoreProvider provider, IShareable content, boolean create, IProgressMonitor progress) throws FileSystemClientException, FileInaccessibleException {
        return this.load(provider.getFilesystem(), provider, content, create, progress);
    }

    public JazzIgnoreFile load(DefaultIgnoreProvider.IFilesystemAbstraction filesystem, DefaultIgnoreProvider provider, IShareable content, boolean create, IProgressMonitor progress) throws FileSystemClientException, FileInaccessibleException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)1);
        JazzIgnoreFile file = null;
        file = this.load(filesystem, provider, content, (IProgressMonitor)monitor);
        if (file == null) {
            if (this.isGlobal(content.getLocalFullPath())) {
                return this.createGlobalIgnoreFile(provider, content);
            }
            if (create) {
                file = new JazzIgnoreFile(provider, content, new TreeSet<IgnoreRule>(IgnoreRuleComparator.INSTANCE), -1L, -2L);
            }
        }
        monitor.done();
        return file;
    }

    public JazzIgnoreFile createGlobalIgnoreFile(DefaultIgnoreProvider provider, IShareable content) {
        TreeSet<IgnoreRule> rules = new TreeSet<IgnoreRule>(IgnoreRuleComparator.INSTANCE);
        rules.add(new LocalIgnoreRule(content, provider, JazzIgnoreFile.DEFAULT_PROP_IGNORE_LOCAL[0], false, false));
        rules.add(new GlobalIgnoreRule(content, provider, JazzIgnoreFile.DEFAULT_PROP_IGNORE_GLOBAL[0], false, false));
        return new JazzIgnoreFile(provider, content, rules, -1L, -2L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JazzIgnoreFile load(DefaultIgnoreProvider.IFilesystemAbstraction filesystem, DefaultIgnoreProvider provider, IShareable content, IProgressMonitor progress) throws FileSystemClientException, FileInaccessibleException {
        JazzIgnoreFile jazzIgnoreFile;
        IgnoreFileMetadata metadata;
        IIgnoreFileLoader loader;
        InputStream in;
        block23: {
            in = null;
            loader = null;
            metadata = null;
            in = filesystem.read(content);
            if (in == null) {
                if (filesystem.exists(content)) {
                    throw new FileInaccessibleException();
                }
                return null;
            }
            try {
                try {
                    metadata = this.consumeVersionPreamble(in);
                    Map<Integer, IIgnoreFileLoader> map = this.loaders;
                    synchronized (map) {
                        loader = this.loaders.get(metadata.version);
                    }
                }
                catch (IgnoreFileVersionException ignoreFileVersionException) {
                    metadata = new IgnoreFileMetadata();
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    break block23;
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        if (loader == null && (loader = this.latestLoader) == null) {
            return new JazzIgnoreFile(provider, content, new TreeSet<IgnoreRule>(IgnoreRuleComparator.INSTANCE), -1L, -2L);
        }
        try {
            in = filesystem.read(content);
            jazzIgnoreFile = loader.load(metadata.version, metadata.encoding, filesystem, in, provider, content);
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
        return jazzIgnoreFile;
    }

    private boolean isGlobal(IPath path) {
        return path.segmentCount() == 2;
    }

    private IgnoreFileMetadata consumeVersionPreamble(InputStream toConsume) throws IgnoreFileVersionException, FileSystemClientException {
        IgnoreFileMetadata metadata = new IgnoreFileMetadata();
        metadata.version = -1;
        metadata.encoding = "UTF-8";
        try {
            int c;
            int r;
            int i = 0;
            while ((r = toConsume.read()) != -1 && i < PREAMBLE.length) {
                if (r == PREAMBLE[i++]) continue;
                throw new IgnoreFileVersionException(NLS.bind((String)Messages.IgnoreFileLoader_6, (Object)i));
            }
            while ((c = toConsume.read()) != -1 && Character.isDigit(c)) {
                metadata.version = metadata.version * 10 + (c - 48);
            }
            if (c == -1) {
                throw new IgnoreFileVersionException(Messages.IgnoreFileLoader_7);
            }
            if (c == 13 || c == 10) {
                return metadata;
            }
            throw new IgnoreFileVersionException(Messages.IgnoreFileLoader_8);
        }
        catch (IOException iOException) {
            throw new FileSystemClientException(new FileSystemStatus(Messages.IgnoreFileLoader_9));
        }
    }

    public JazzIgnoreFile createNew(IShareable file, DefaultIgnoreProvider provider, SortedSet<IgnoreRule> rules) throws FileSystemClientException {
        if (this.latestLoader == null) {
            return null;
        }
        return this.latestLoader.store(provider.getFilesystem(), provider, file, rules);
    }

    public byte[] asBytes(IPath path, SortedSet<IgnoreRule> rules) throws FileSystemClientException {
        if (this.latestLoader == null) {
            throw new IllegalStateException();
        }
        return this.latestLoader.asBytes(path, rules);
    }

    public Collection<IgnorePattern> getDefaultIgnorePatterns(IPath path) {
        if (this.latestLoader == null) {
            throw new IllegalStateException();
        }
        return this.latestLoader.getDefaultIgnorePatterns(path);
    }

    public static class FileInaccessibleException
    extends Exception {
        private static final long serialVersionUID = 5048576172792150059L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IIgnoreFileLoader {
        public JazzIgnoreFile load(int var1, String var2, DefaultIgnoreProvider.IFilesystemAbstraction var3, InputStream var4, IIgnoreProvider var5, IShareable var6) throws FileSystemClientException;

        public JazzIgnoreFile store(DefaultIgnoreProvider.IFilesystemAbstraction var1, DefaultIgnoreProvider var2, IShareable var3, SortedSet<IgnoreRule> var4) throws FileSystemClientException;

        public int getVersion();

        public byte[] asBytes(IPath var1, SortedSet<IgnoreRule> var2) throws FileSystemClientException;

        public Collection<IgnorePattern> getDefaultIgnorePatterns(IPath var1);
    }

    private static class IgnoreFileMetadata {
        Integer version = -1;
        String encoding = "UTF-8";

        private IgnoreFileMetadata() {
        }
    }

    public static class IgnoreFileVersionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        IgnoreFileVersionException(String msg) {
            super(msg);
        }
    }
}

