/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.ignore;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ICopyFileAreaEvent;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IShareableVisitor;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.ignore.GlobalIgnoreEvent;
import com.ibm.team.filesystem.client.internal.ignore.GlobalIgnoreRule;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreEvent;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreEvent;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreFileLoader;
import com.ibm.team.filesystem.client.internal.ignore.IgnorePattern;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRule;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRuleComparator;
import com.ibm.team.filesystem.client.internal.ignore.JazzIgnoreFile;
import com.ibm.team.filesystem.client.internal.ignore.LocalIgnoreEvent;
import com.ibm.team.filesystem.client.internal.ignore.LocalIgnoreRule;
import com.ibm.team.filesystem.client.internal.operations.IgnoreFileAgeDBHM;
import com.ibm.team.filesystem.client.internal.utils.LRUCache;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIgnoreProvider
extends IgnoreProvider
implements IIgnoreProvider.IIgnoreTester,
ICopyFileAreaListener {
    public static final String EVENT_EXTERNAL_CHANGE = "external_change";
    private static final List CATEGORY_EXTERNAL_CHANGE = Collections.singletonList("external_change");
    public static final double FILE_CACHE_RATIO = 1.2;
    private static final int FILE_CACHE_MIN = 10;
    private static final int FILE_CACHE_NO_DEFAULT_CFA = 300;
    private final LRUCache<IPath, JazzIgnoreFile> files;
    private int shareCount;
    private IgnoreFileAgeDBHM fileAges = new IgnoreFileAgeDBHM();
    private boolean shouldInvalidateCache = false;
    private final IFilesystemAbstraction filesystem;
    public static final String IGNORE_FILE_NAME = ".jazzignore";
    Set<IShareable> modifiedFiles = new HashSet<IShareable>();

    private IShareable getParentFor(IShareable shareable) {
        return ((Shareable)shareable).getParent();
    }

    public static DefaultIgnoreProvider getDefault() {
        return (DefaultIgnoreProvider)SharingManager.getInstance().getIgnoreManager().getIgnoreProvider("default");
    }

    public DefaultIgnoreProvider() {
        this(new PassThroughFilesystemAbstraction());
    }

    public DefaultIgnoreProvider(IFilesystemAbstraction fs) {
        this.filesystem = fs;
        SharingManager sm = SharingManager.getInstance();
        IPath defaultRoot = sm.getDefaultCFARoot();
        this.shareCount = 300;
        if (defaultRoot != null) {
            try {
                this.shareCount = sm.allShares(defaultRoot).length;
            }
            catch (FileSystemClientException fileSystemClientException) {
                this.shareCount = 0;
            }
            sm.addListener(defaultRoot, this);
        }
        this.files = new LRUCache(DefaultIgnoreProvider.computeFileCacheSize(this.shareCount));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void change(ICopyFileAreaEvent[] events) {
        int sizeChange = 0;
        LinkedList<IPath> removed = null;
        ICopyFileAreaEvent[] iCopyFileAreaEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            ICopyFileAreaEvent event = iCopyFileAreaEventArray[n2];
            switch (event.getReason()) {
                case 1: {
                    ++sizeChange;
                    break;
                }
                case 2: {
                    if (removed == null) {
                        removed = new LinkedList<IPath>();
                    }
                    removed.add(event.getPath());
                    --sizeChange;
                }
            }
            ++n2;
        }
        if (sizeChange == 0) {
            return;
        }
        LRUCache<IPath, JazzIgnoreFile> lRUCache = this.files;
        synchronized (lRUCache) {
            this.shareCount += sizeChange;
            int desiredCacheSize = DefaultIgnoreProvider.computeFileCacheSize(this.shareCount);
            this.files.setSpaceLimit(desiredCacheSize);
            if (removed != null) {
                for (IPath removedSharePath : removed) {
                    Iterator<IPath> keys = this.files.keys();
                    while (keys.hasNext()) {
                        IPath key = keys.next();
                        if (!removedSharePath.isPrefixOf(key)) continue;
                        keys.remove();
                    }
                }
                this.shouldInvalidateCache = true;
            }
        }
    }

    private static int computeFileCacheSize(int shareCount) {
        return (int)Math.max(10.0, (double)shareCount * 1.2);
    }

    @Override
    public List<IIgnoreProvider.IIgnoreRule> findIgnoreReasons(IShareable toIgnore, IPath path) {
        List<IIgnoreProvider.IIgnoreRule> reasons;
        if (path.segmentCount() < 2) {
            return Collections.EMPTY_LIST;
        }
        IPath parentPath = path.removeLastSegments(1);
        ArrayList<IIgnoreProvider.IIgnoreRule> rules = new ArrayList<IIgnoreProvider.IIgnoreRule>();
        JazzIgnoreFile globalFile = null;
        try {
            globalFile = this.getGlobalIgnoreFile(toIgnore);
        }
        catch (FileSystemClientException e) {
            LoggingHelper.log(e.getStatus());
        }
        if (globalFile != null && (reasons = globalFile.findIgnoreReasons(path)) != null) {
            rules.addAll(reasons);
        }
        JazzIgnoreFile localFile = null;
        try {
            localFile = this.getIgnoreFileForFolder(toIgnore, parentPath, false);
        }
        catch (FileSystemClientException e) {
            LoggingHelper.log(e.getStatus());
        }
        if (localFile == globalFile || localFile == null) {
            return rules;
        }
        reasons = localFile.findIgnoreReasons(path);
        if (reasons != null) {
            rules.addAll(reasons);
        }
        return rules;
    }

    public IgnoreRule getIgnoreRuleFor(IShareable shareable, boolean isGlobal) {
        IPath path = shareable.getLocalFullPath();
        String lastSegment = path.lastSegment();
        if (isGlobal) {
            return new GlobalIgnoreRule(this.getGlobalIgnoreShareable(shareable), this, lastSegment, false, false);
        }
        return new LocalIgnoreRule(this.getIgnoreShareableForFolder(shareable, path.removeLastSegments(1)), this, lastSegment, false, false);
    }

    public List<IgnoreRule> getIgnoreSuffixRulesFor(List<IShareable> shareables, boolean isGlobal) {
        HashMap<IShareable, HashSet<String>> pathToSuffixMap = new HashMap<IShareable, HashSet<String>>();
        for (IShareable shareable : shareables) {
            IPath path = shareable.getLocalFullPath();
            String extension = path.getFileExtension();
            extension = extension == null || extension.length() == 0 ? path.lastSegment() : "*." + extension;
            IShareable root = null;
            root = isGlobal ? this.getShareableForPath(shareable, this.getGlobalIgnoreRoot(shareable), false) : this.getShareableForPath(shareable, shareable.getLocalFullPath().removeLastSegments(1), true);
            HashSet<String> suffixSet = (HashSet<String>)pathToSuffixMap.get(root);
            if (suffixSet == null) {
                suffixSet = new HashSet<String>();
                pathToSuffixMap.put(root, suffixSet);
            }
            suffixSet.add(extension);
        }
        ArrayList<IgnoreRule> rules = new ArrayList<IgnoreRule>(pathToSuffixMap.size());
        for (Map.Entry entry : pathToSuffixMap.entrySet()) {
            for (String pattern : (HashSet)entry.getValue()) {
                IgnoreRule rule = null;
                IShareable shareable = (IShareable)entry.getKey();
                rule = isGlobal ? new GlobalIgnoreRule(this.getGlobalIgnoreShareable(shareable), this, pattern, false, false) : new LocalIgnoreRule(this.getIgnoreShareableForFolder(shareable, shareable.getLocalFullPath()), this, pattern, false, false);
                rules.add(rule);
            }
        }
        return rules;
    }

    public List<IgnoreRule> getIgnoreRulesFor(String pattern, List<IShareable> shareables, boolean isGlobal) {
        HashSet<IShareable> roots = new HashSet<IShareable>();
        if (isGlobal) {
            for (IShareable shareable : shareables) {
                roots.add(this.getShareableForPath(shareable, this.getGlobalIgnoreRoot(shareable), true));
            }
        } else {
            for (IShareable shareable : shareables) {
                roots.add(this.getParentFor(shareable));
            }
        }
        ArrayList<IgnoreRule> rules = new ArrayList<IgnoreRule>(roots.size());
        for (IShareable root : roots) {
            IgnoreRule rule = null;
            rule = isGlobal ? new GlobalIgnoreRule(this.getGlobalIgnoreShareable(root), this, pattern, false, false) : new LocalIgnoreRule(this.getIgnoreShareableForFolder(root, root.getLocalFullPath()), this, pattern, false, false);
            rules.add(rule);
        }
        return rules;
    }

    public IIgnoreProvider.IIgnoreRule ignore(IShareable shareable, IProgressMonitor progress) throws FileSystemClientException {
        IShare share = shareable.getShare();
        if (share == null) {
            throw new FileSystemClientException((IStatus)new Status(4, "com.ibm.team.filesystem.client", String.valueOf(Messages.DefaultIgnoreProvider_3) + shareable.getLocalFullPath().toString()));
        }
        IShareable parent = this.getParentFor(shareable);
        if (parent == null) {
            throw new FileSystemClientException((IStatus)new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.DefaultIgnoreProvider_4, (Object)shareable.getLocalFullPath().toString())));
        }
        if (!this.canIgnore(shareable)) {
            throw new FileSystemClientException((IStatus)new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.DefaultIgnoreProvider_5, (Object)shareable.getLocalFullPath().toString())));
        }
        IgnoreRule rule = this.getIgnoreRuleFor(shareable, false);
        this.addIgnoreRule(rule, progress);
        return rule;
    }

    public void unignore(IShareable shareable, IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress);
        try {
            IIgnoreManager.IIgnoreReason reason = this.getIgnoreManager().findIgnoreReasons(shareable, progress);
            if (reason == null) {
                throw new FileSystemClientException((IStatus)new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.DefaultIgnoreProvider_6, (Object)shareable.getLocalFullPath())));
            }
            if (reason.inherited()) {
                throw new FileSystemClientException((IStatus)new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.DefaultIgnoreProvider_7, (Object)shareable.getLocalFullPath())));
            }
            monitor.setWorkRemaining(reason.getRules().size());
            for (IIgnoreProvider.IIgnoreRule externalRule : reason.getRules()) {
                this.removeIgnoreRule((IgnoreRule)externalRule, (IProgressMonitor)monitor.newChild(1));
            }
        }
        finally {
            monitor.done();
        }
    }

    public boolean canUnignore(IShareable shareable) throws FileSystemClientException {
        IIgnoreManager.IIgnoreReason reason = this.getIgnoreManager().findIgnoreReasons(shareable, null);
        if (reason == null) {
            return false;
        }
        for (IIgnoreProvider.IIgnoreRule rule : reason.getRules()) {
            if (rule.getProvider() == this) continue;
            return false;
        }
        Assert.isTrue((reason.getRules().size() > 0 ? 1 : 0) != 0);
        return true;
    }

    public boolean canIgnore(IShareable shareable) throws FileSystemClientException {
        if (shareable.getShare() == null) {
            return false;
        }
        IPath path = shareable.getLocalFullPath();
        if (path.segmentCount() <= 1) {
            return false;
        }
        return !this.getIgnoreManager().shouldBeIgnored(shareable);
    }

    public void accept(Collection<IShareable> roots, final IIgnoreVisitor visitor, IFilesystemAbstraction fs, IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)roots.size());
        final MultiStatus multi = new MultiStatus("com.ibm.team.filesystem.client", 4, Messages.DefaultIgnoreProvider_8, null);
        final IFilesystemAbstraction filesystem = fs == null ? this.filesystem : fs;
        for (IShareable root : roots) {
            final boolean[] visitedGlobalIgnoreFile = new boolean[1];
            root.accept(new IShareableVisitor(){

                public boolean visit(IShareable shareable, IProgressMonitor monitor) {
                    if (DefaultIgnoreProvider.IGNORE_FILE_NAME.equals(shareable.getLocalFullPath().lastSegment())) {
                        JazzIgnoreFile file;
                        try {
                            file = IgnoreFileLoader.getInstance().load(filesystem, DefaultIgnoreProvider.this, shareable, false, monitor);
                        }
                        catch (FileSystemClientException e) {
                            multi.add(e.getStatus());
                            return true;
                        }
                        catch (IgnoreFileLoader.FileInaccessibleException fileInaccessibleException) {
                            return true;
                        }
                        if (file == null) {
                            return true;
                        }
                        if (file.isGlobal()) {
                            visitedGlobalIgnoreFile[0] = true;
                        }
                        visitor.visit(file.getRules());
                    }
                    return true;
                }
            }, Integer.MAX_VALUE, true, false, (IProgressMonitor)monitor);
            if (visitedGlobalIgnoreFile[0]) continue;
            visitor.visit(this.getGlobalIgnoreFile(root).getRules());
        }
        if (multi.getChildren().length > 0) {
            throw new FileSystemClientException((IStatus)multi);
        }
    }

    private void removeRule(IIgnoreProvider.IIgnoreRule passedRule, IProgressMonitor progress) throws FileSystemClientException {
        if (!(passedRule instanceof IgnoreRule)) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.DefaultIgnoreProvider_9, (Object)passedRule.getClass().getSimpleName()));
        }
        IgnoreRule rule = (IgnoreRule)passedRule;
        IShareable parent = rule.getRootShareable();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)3);
        JazzIgnoreFile file = this.getIgnoreFileForFolder(parent, parent.getLocalFullPath(), false);
        if (file == null) {
            return;
        }
        ISchedulingRule sr = this.findSchedulingRuleFor(rule.getFile());
        try {
            Job.getJobManager().beginRule(sr, (IProgressMonitor)monitor.newChild(1));
            this.startModifyingFile(rule.getFile());
            try {
                JazzIgnoreFile newFile = file.removeRules((Collection<IgnoreRule>)Collections.singleton(rule), (IProgressMonitor)monitor.newChild(1));
                this.updateCacheFor(parent.getLocalFullPath(), newFile);
            }
            finally {
                this.stopModifyingFile(rule.getFile(), monitor.newChild(1));
            }
        }
        finally {
            Job.getJobManager().endRule(sr);
        }
        monitor.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldInvalidateCache(IShareable shareable) {
        LRUCache<IPath, JazzIgnoreFile> lRUCache = this.files;
        synchronized (lRUCache) {
            boolean result = this.shouldInvalidateCache;
            this.shouldInvalidateCache = false;
            return result;
        }
    }

    @Override
    public IIgnoreProvider.IIgnoreTester getTester() {
        return this;
    }

    @Override
    public boolean shouldBeIgnored(IShareable shareable, IPath path) {
        List<IIgnoreProvider.IIgnoreRule> reasons;
        if (path.segmentCount() < 2) {
            return false;
        }
        IPath parentPath = path.removeLastSegments(1);
        JazzIgnoreFile globalFile = null;
        try {
            globalFile = this.getGlobalIgnoreFile(shareable);
        }
        catch (FileSystemClientException fileSystemClientException) {}
        if (globalFile != null && (reasons = globalFile.findIgnoreReasons(path)) != null && reasons.size() > 0) {
            return true;
        }
        JazzIgnoreFile file = null;
        try {
            file = this.getIgnoreFileForFolder(shareable, parentPath, false);
        }
        catch (FileSystemClientException fileSystemClientException) {}
        if (file == null) {
            return false;
        }
        reasons = file.findIgnoreReasons(path);
        return reasons != null && reasons.size() > 0;
    }

    public IFilesystemAbstraction getFilesystem() {
        return this.filesystem;
    }

    private IPath getGlobalIgnoreRoot(IShareable shareable) {
        return shareable.getLocalFullPath().uptoSegment(1);
    }

    private JazzIgnoreFile getGlobalIgnoreFile(IShareable shareable) throws FileSystemClientException {
        JazzIgnoreFile file = this.getIgnoreFileForFolder(shareable, this.getGlobalIgnoreRoot(shareable), false);
        if (file == null) {
            file = IgnoreFileLoader.getInstance().createGlobalIgnoreFile(this, shareable);
        }
        return file;
    }

    private IShareable getGlobalIgnoreShareable(IShareable shareable) {
        IPath rootPath = this.getGlobalIgnoreRoot(shareable).append(IGNORE_FILE_NAME);
        return SharingManager.getInstance().findShareable(shareable.getRoot(), rootPath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JazzIgnoreFile getIgnoreFileForFolder(IShareable shareable, IPath folderPath, boolean create) throws FileSystemClientException {
        JazzIgnoreFile file;
        LRUCache<IPath, JazzIgnoreFile> lRUCache = this.files;
        synchronized (lRUCache) {
            if (this.files.containsKey(folderPath)) {
                file = this.files.get(folderPath);
                if (file != null) {
                    return file;
                }
                if (!create) {
                    return null;
                }
            }
        }
        IShareable ignoreFile = this.getIgnoreShareableForFolder(shareable, folderPath);
        try {
            file = IgnoreFileLoader.getInstance().load(this, ignoreFile, create, null);
        }
        catch (IgnoreFileLoader.FileInaccessibleException fileInaccessibleException) {
            LRUCache<IPath, JazzIgnoreFile> lRUCache2 = this.files;
            synchronized (lRUCache2) {
                return this.files.get(folderPath);
            }
        }
        LRUCache<IPath, JazzIgnoreFile> lRUCache3 = this.files;
        synchronized (lRUCache3) {
            this.files.put(folderPath, file);
            if (file == null) {
                this.fileAges.remove(folderPath);
            } else {
                long lastModified = this.filesystem.lastModified(shareable);
                long size = this.filesystem.size(shareable, null);
                this.fileAges.put(folderPath, lastModified, size);
            }
            return file;
        }
    }

    private IShareable getIgnoreShareableForFolder(IShareable shareable, IPath folderPath) {
        return SharingManager.getInstance().findShareable(shareable.getRoot(), folderPath.append(IGNORE_FILE_NAME), false);
    }

    private IShareable getShareableForPath(IShareable peer, IPath shareablePath, boolean isFolder) {
        return this.getShareableForPath(peer.getRoot(), shareablePath, isFolder);
    }

    private IShareable getShareableForPath(IPath shareRoot, IPath shareablePath, boolean isFolder) {
        return SharingManager.getInstance().findShareable(shareRoot, shareablePath, isFolder);
    }

    @Override
    public void done() {
    }

    public IStatus ignoreFilesChanged(List<IShareable> ignoreFiles, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(ignoreFiles.size() * 3));
        MultiStatus multi = new MultiStatus("com.ibm.team.filesystem.client", -1, Messages.DefaultIgnoreProvider_10, null);
        for (IShareable shareable : ignoreFiles) {
            IgnoreEvent event;
            try {
                ISchedulingRule rule = SharingManager.getInstance().getExternalSchedulingRule(shareable);
                try {
                    Job.getJobManager().beginRule(rule, (IProgressMonitor)monitor.newChild(1));
                    event = this.ignoreFileChanged(shareable, (IProgressMonitor)monitor.newChild(1));
                }
                finally {
                    Job.getJobManager().endRule(rule);
                }
            }
            catch (FileSystemClientException e) {
                multi.add(e.getStatus());
                continue;
            }
            if (event != null) {
                try {
                    this.queueEvent(((Shareable)shareable).getParent(), event, (IProgressMonitor)monitor.newChild(1));
                }
                catch (FileSystemClientException e) {
                    multi.add((IStatus)new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.DefaultIgnoreProvider_11, (Object)shareable.getLocalFullPath()), (Throwable)((Object)e)));
                }
                continue;
            }
            monitor.newChild(1);
        }
        monitor.done();
        if (multi.getChildren().length > 0) {
            return multi;
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IgnoreEvent ignoreFileChanged(IShareable shareable, IProgressMonitor progress) throws FileSystemClientException {
        SortedSet<IgnoreRule> rules;
        String type;
        JazzIgnoreFile currentFile;
        IShareable parent;
        block31: {
            IPath parentPath;
            block28: {
                LRUCache<IPath, JazzIgnoreFile> lRUCache;
                block29: {
                    block30: {
                        JazzIgnoreFile cachedFile;
                        boolean containsKey;
                        Assert.isTrue((boolean)shareable.getLocalFullPath().lastSegment().equals(IGNORE_FILE_NAME));
                        Set<IShareable> set = this.modifiedFiles;
                        synchronized (set) {
                            if (this.modifiedFiles.contains(shareable)) {
                                return null;
                            }
                        }
                        long lastModified = this.filesystem.lastModified(shareable);
                        long size = this.filesystem.size(shareable, progress);
                        IPath path = shareable.getLocalFullPath().removeLastSegments(1);
                        LRUCache<IPath, JazzIgnoreFile> lRUCache2 = this.files;
                        synchronized (lRUCache2) {
                            if (!this.fileAges.shouldReload(path, lastModified, size)) {
                                return null;
                            }
                        }
                        IShare share = shareable.getShare();
                        if (share == null) {
                            return null;
                        }
                        parent = this.getParentFor(shareable);
                        if (parent != null && parent.shouldBeIgnored()) {
                            return null;
                        }
                        parent = this.getParentFor(shareable);
                        parentPath = parent.getLocalFullPath();
                        boolean exists = ((Shareable)shareable).getFileStorage().exists();
                        LRUCache<IPath, JazzIgnoreFile> lRUCache3 = this.files;
                        synchronized (lRUCache3) {
                            containsKey = this.files.containsKey(parentPath);
                            cachedFile = this.files.get(parentPath);
                            this.shouldInvalidateCache = true;
                        }
                        currentFile = null;
                        type = null;
                        if (!containsKey) break block28;
                        if (!exists) break block29;
                        if (cachedFile != null) break block30;
                        lRUCache = this.files;
                        synchronized (lRUCache) {
                            this.files.removeKey(parentPath);
                        }
                        currentFile = this.getIgnoreFileForFolder(shareable, parentPath, false);
                        if (currentFile == null) {
                            lRUCache = this.files;
                            synchronized (lRUCache) {
                                this.files.removeKey(parentPath);
                                this.fileAges.remove(parentPath);
                            }
                            type = "unignore";
                            break block31;
                        } else {
                            type = "ignore";
                        }
                        break block31;
                    }
                    type = "unknown";
                    lRUCache = this.files;
                    synchronized (lRUCache) {
                        this.files.removeKey(parentPath);
                    }
                    currentFile = this.getIgnoreFileForFolder(shareable, parentPath, false);
                    break block31;
                }
                type = "unignore";
                lRUCache = this.files;
                synchronized (lRUCache) {
                    this.files.removeKey(parentPath);
                    this.fileAges.remove(parentPath);
                }
            }
            type = "unknown";
            currentFile = this.getIgnoreFileForFolder(shareable, parentPath, false);
        }
        SortedSet<IgnoreRule> sortedSet = rules = currentFile == null ? null : currentFile.getRules();
        if (this.getGlobalIgnoreFile(shareable).equals(shareable)) {
            return new GlobalIgnoreEvent(this.getIgnoreManager(), shareable, parent, type, (List<Object>)CATEGORY_EXTERNAL_CHANGE, rules);
        }
        return new LocalIgnoreEvent(this.getIgnoreManager(), shareable, parent, type, (List<Object>)CATEGORY_EXTERNAL_CHANGE, rules);
    }

    private void verifyRule(IIgnoreProvider.IIgnoreRule rule) {
        if (rule == null) {
            throw new IllegalArgumentException(Messages.DefaultIgnoreProvider_12);
        }
        if (rule.getProvider() != this) {
            throw new IllegalArgumentException(Messages.DefaultIgnoreProvider_13);
        }
        if (!(rule instanceof IgnoreRule)) {
            throw new IllegalArgumentException(Messages.DefaultIgnoreProvider_14);
        }
    }

    private void verifyRules(Collection<? extends IIgnoreProvider.IIgnoreRule> rules) {
        for (IIgnoreProvider.IIgnoreRule iIgnoreRule : rules) {
            this.verifyRule(iIgnoreRule);
        }
    }

    public void addIgnoreRule(IIgnoreProvider.IIgnoreRule externalRule, IProgressMonitor progress) throws FileSystemClientException {
        this.addIgnoreRules((Collection<? extends IIgnoreProvider.IIgnoreRule>)Collections.singleton(externalRule), progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCacheFor(IPath parentPath, JazzIgnoreFile file) {
        LRUCache<IPath, JazzIgnoreFile> lRUCache = this.files;
        synchronized (lRUCache) {
            this.files.put(parentPath, file);
            if (file == null) {
                this.fileAges.remove(parentPath);
            } else {
                this.fileAges.put(parentPath, file.getLastModified(), file.getSize());
            }
        }
    }

    private ISchedulingRule findSchedulingRuleFor(IShareable shareable) {
        IShare share = shareable.getShare();
        if (share == null) {
            return null;
        }
        return SharingManager.getInstance().getTrackingRule(share.getAnchor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIgnoreRules(Collection<? extends IIgnoreProvider.IIgnoreRule> allRules, IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(allRules.size() * 4));
        monitor.setTaskName(Messages.DefaultIgnoreProvider_15);
        this.verifyRules(allRules);
        for (Map.Entry<JazzIgnoreFile, Collection<IgnoreRule>> entry : this.groupRulesByOwner(allRules).entrySet()) {
            IgnoreEvent event;
            Collection<IgnoreRule> rules;
            JazzIgnoreFile file = entry.getKey();
            Collection<IgnoreRule> added = file.computeComplement(rules = entry.getValue());
            if (added.isEmpty()) continue;
            IShareable shareable = file.getFile();
            ISchedulingRule rule = this.findSchedulingRuleFor(shareable);
            try {
                Job.getJobManager().beginRule(rule, (IProgressMonitor)monitor.newChild(1));
                this.startModifyingFile(shareable);
                try {
                    JazzIgnoreFile newFile = file.addRules(added, (IProgressMonitor)monitor.newChild(1));
                    this.updateCacheFor(file.getRootShareable().getLocalFullPath(), newFile);
                    LRUCache<IPath, JazzIgnoreFile> lRUCache = this.files;
                    synchronized (lRUCache) {
                        this.shouldInvalidateCache = true;
                    }
                }
                finally {
                    this.stopModifyingFile(shareable, monitor.newChild(1));
                }
            }
            finally {
                Job.getJobManager().endRule(rule);
            }
            ArrayList<IgnoreRule> globalRules = new ArrayList<IgnoreRule>(rules.size());
            ArrayList<IgnoreRule> localRules = new ArrayList<IgnoreRule>(rules.size());
            this.splitRulesByScope(added, globalRules, localRules);
            if (globalRules.size() > 0) {
                event = new GlobalIgnoreEvent(this.getIgnoreManager(), file.getFile(), file.getRootShareable(), "ignore", (List<Object>)Collections.EMPTY_LIST, globalRules);
                this.queueEvent(file.getRootShareable(), event, (IProgressMonitor)monitor.newChild(1));
            }
            if (localRules.size() <= 0) continue;
            event = new LocalIgnoreEvent(this.getIgnoreManager(), file.getFile(), file.getRootShareable(), "ignore", (List<Object>)Collections.EMPTY_LIST, rules);
            this.queueEvent(file.getRootShareable(), event, (IProgressMonitor)monitor.newChild(1));
        }
    }

    private Map<JazzIgnoreFile, Collection<IgnoreRule>> groupRulesByOwner(Collection<? extends IIgnoreProvider.IIgnoreRule> rules) throws FileSystemClientException {
        HashMap<JazzIgnoreFile, Collection<IgnoreRule>> grouping = new HashMap<JazzIgnoreFile, Collection<IgnoreRule>>();
        for (IIgnoreProvider.IIgnoreRule iIgnoreRule : rules) {
            IgnoreRule rule = (IgnoreRule)iIgnoreRule;
            IShareable rootShareable = rule.getRootShareable();
            JazzIgnoreFile owner = this.getIgnoreFileForFolder(rootShareable, rootShareable.getLocalFullPath(), true);
            Collection<IgnoreRule> associatedWithFile = grouping.get(owner);
            if (associatedWithFile == null) {
                associatedWithFile = new LinkedList<IgnoreRule>();
                grouping.put(owner, associatedWithFile);
            }
            associatedWithFile.add(rule);
        }
        return grouping;
    }

    private void splitRulesByScope(Collection<IgnoreRule> allRules, Collection<IgnoreRule> global, Collection<IgnoreRule> local) {
        for (IgnoreRule rule : allRules) {
            if (rule.isGlobal()) {
                global.add(rule);
                continue;
            }
            local.add(rule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends IIgnoreProvider.IIgnoreRule> void removeIgnoreRule(T externalRule, IProgressMonitor progress) throws FileSystemClientException {
        this.verifyRule(externalRule);
        IgnoreRule rule = (IgnoreRule)externalRule;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)4);
        this.removeRule(rule, (IProgressMonitor)monitor.newChild(1));
        LRUCache<IPath, JazzIgnoreFile> lRUCache = this.files;
        synchronized (lRUCache) {
            this.shouldInvalidateCache = true;
        }
        IgnoreEvent event = null;
        event = rule.isGlobal() ? new GlobalIgnoreEvent(this.getIgnoreManager(), rule.getFile(), rule.getRootShareable(), "unignore", (List<Object>)Collections.EMPTY_LIST, (Collection<? extends IIgnoreProvider.IIgnoreRule>)Collections.singletonList(rule)) : new LocalIgnoreEvent(this.getIgnoreManager(), rule.getFile(), rule.getRootShareable(), "unignore", (List<Object>)Collections.EMPTY_LIST, (Collection<? extends IIgnoreProvider.IIgnoreRule>)Collections.singletonList(rule));
        this.queueEvent(rule.getRootShareable(), event, (IProgressMonitor)monitor.newChild(3));
        monitor.done();
    }

    public void removeIgnoreRules(List<? extends IIgnoreProvider.IIgnoreRule> externalRules, IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)externalRules.size());
        for (IIgnoreProvider.IIgnoreRule iIgnoreRule : externalRules) {
            this.removeIgnoreRule(iIgnoreRule, (IProgressMonitor)monitor.newChild(1));
        }
        monitor.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startModifyingFile(IShareable file) {
        Set<IShareable> set = this.modifiedFiles;
        synchronized (set) {
            if (!this.modifiedFiles.add(file)) {
                throw new RuntimeException(NLS.bind((String)Messages.DefaultIgnoreProvider_16, (Object)file));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopModifyingFile(IShareable file, SubMonitor monitor) {
        Set<IShareable> set = this.modifiedFiles;
        synchronized (set) {
            if (!this.modifiedFiles.remove(file)) {
                throw new RuntimeException(NLS.bind((String)Messages.DefaultIgnoreProvider_17, (Object)file));
            }
        }
        this.ignoreFilesChanged(Collections.singletonList(file), (IProgressMonitor)monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearFileCache() {
        LRUCache<IPath, JazzIgnoreFile> lRUCache = this.files;
        synchronized (lRUCache) {
            this.files.flush();
            this.fileAges.clear();
            this.shouldInvalidateCache = true;
        }
    }

    @Override
    protected IgnoreProvider createCopyInternal(Collection<IIgnoreManager.ICopyParameter> params, IIgnoreManager ignoreManager, IProgressMonitor progress) {
        IFilesystemAbstraction abs = null;
        for (IIgnoreManager.ICopyParameter param : params) {
            IDefaultIgnoreProviderCopyReason myReason;
            IFilesystemAbstraction preferred;
            if (!(param instanceof IDefaultIgnoreProviderCopyReason) || (preferred = (myReason = (IDefaultIgnoreProviderCopyReason)param).useFilesystemAbstraction(this.filesystem)) == null) continue;
            assert (abs == null) : "IFilesystemAbstraction set twice. Original: " + abs + " new: " + preferred;
            abs = preferred;
        }
        if (abs == null) {
            abs = (IFilesystemAbstraction)this.filesystem.clone();
        }
        return new DefaultIgnoreProvider(abs);
    }

    @Override
    protected void syncChangeTrackerForEvent(IShareable ignoreRoot, IIgnoreEvent event, SubMonitor monitor) throws FileSystemClientException {
        monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        Share share = (Share)ignoreRoot.getShare();
        if (share == null) {
            return;
        }
        Collection<IShareable> changed = event.getChanged((IProgressMonitor)monitor);
        if (changed == null) {
            if (ignoreRoot == null) {
                throw new IllegalArgumentException(Messages.DefaultIgnoreProvider_18);
            }
            share.refreshChanges(ignoreRoot, (IProgressMonitor)monitor.newChild(1));
            return;
        }
        Assert.isNotNull(changed);
        monitor.setWorkRemaining(changed.size());
        for (IShareable shareable : changed) {
            SubMonitor subMonitor = monitor.newChild(1);
            share.refreshChanges(shareable, (IProgressMonitor)subMonitor);
            subMonitor.done();
        }
    }

    protected void queueEvent(IShareable ignoreRoot, IIgnoreEvent event, IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress);
        this.syncChangeTrackerForEvent(ignoreRoot, event, monitor);
        monitor.done();
        super.queueEvent(event);
    }

    public byte[] getIgnoreFileContents(IPath path, Collection<String> globalPatterns, Collection<String> localPatterns) throws FileSystemClientException {
        boolean isGlobal;
        boolean bl = isGlobal = path.segmentCount() == 1;
        if (!isGlobal && globalPatterns != null) {
            throw new IllegalArgumentException(Messages.DefaultIgnoreProvider_19);
        }
        TreeSet<IgnoreRule> rules = new TreeSet<IgnoreRule>(IgnoreRuleComparator.INSTANCE);
        if (globalPatterns != null) {
            for (String pattern : globalPatterns) {
                rules.add(new GlobalIgnoreRule(null, this, pattern, false, false));
            }
        }
        if (localPatterns != null) {
            for (String pattern : localPatterns) {
                rules.add(new LocalIgnoreRule(null, this, pattern, false, false));
            }
        }
        return IgnoreFileLoader.getInstance().asBytes(path.append(IGNORE_FILE_NAME), rules);
    }

    public Collection<IgnorePattern> getDefaultIgnorePatterns(IPath path) {
        if (path.segmentCount() < 1) {
            throw new IllegalArgumentException();
        }
        return IgnoreFileLoader.getInstance().getDefaultIgnorePatterns(path.append(IGNORE_FILE_NAME));
    }

    @Override
    public void deallocate(IIgnoreManager ignoreManager) {
        super.deallocate(ignoreManager);
        if (SharingManager.getInstance().getDefaultCFARoot() != null) {
            SharingManager.getInstance().removeListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFileCacheSize() {
        LRUCache<IPath, JazzIgnoreFile> lRUCache = this.files;
        synchronized (lRUCache) {
            return this.files.getSpaceLimit();
        }
    }

    public static interface IDefaultIgnoreProviderCopyReason
    extends IIgnoreManager.ICopyParameter {
        public IFilesystemAbstraction useFilesystemAbstraction(IFilesystemAbstraction var1);
    }

    public static interface IFilesystemAbstraction
    extends Cloneable {
        public static final long NULL_MOD = -1L;
        public static final long NULL_SIZE = -2L;

        public boolean exists(IShareable var1);

        public InputStream read(IShareable var1) throws FileSystemClientException;

        public void write(IShareable var1, InputStream var2) throws FileSystemClientException;

        public long lastModified(IShareable var1);

        public long size(IShareable var1, IProgressMonitor var2) throws FileSystemClientException;

        public Object clone();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IIgnoreVisitor {
        public void visit(Collection<IgnoreRule> var1);
    }

    public static class PassThroughFilesystemAbstraction
    implements IFilesystemAbstraction {
        public boolean exists(IShareable file) {
            return ((Shareable)file).getFileStorage().exists();
        }

        public InputStream read(final IShareable file) throws FileSystemClientException {
            final InputStream[] stream = new InputStream[1];
            try {
                SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                    public void run() throws CoreException {
                        stream[0] = ((Shareable)file).getFileStorage().getContents(true);
                    }
                });
            }
            catch (CoreException coreException) {
                return null;
            }
            return stream[0];
        }

        public void write(IShareable file, InputStream in) throws FileSystemClientException {
            IFileStorage store = ((Shareable)file).getFileStorage();
            if (store.exists()) {
                store.setContents(in, null);
            } else {
                store.create(in, null);
            }
        }

        public long lastModified(IShareable file) {
            return ((Shareable)file).getFileStorage().getModificationStamp();
        }

        public long size(IShareable file, IProgressMonitor monitor) throws FileSystemClientException {
            try {
                SharingManager.getInstance().disableChangeMonitoring();
                long l = ((Shareable)file).getFileStorage().getSize(monitor);
                return l;
            }
            finally {
                SharingManager.getInstance().enableChangeMonitoring();
            }
        }

        public Object clone() {
            return new PassThroughFilesystemAbstraction();
        }
    }
}

