/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ICopyFileAreaEvent;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.copyfileareas.IFlushOperation;
import com.ibm.team.filesystem.client.internal.copyfileareas.ILockParticipant;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;

public class BatchingLock {
    private static final boolean DEBUG = System.getProperty("filesystem.debug.batchingLock", "false").equals("true");
    static final ISchedulingRule NULL_SCHEDULING_RULE = new ISchedulingRule(){

        public boolean contains(ISchedulingRule rule) {
            return false;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return false;
        }
    };
    static final ISchedulingRule AVOID_NOTIFICATION_RULE = new ISchedulingRule(){

        public boolean contains(ISchedulingRule rule) {
            return false;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return false;
        }
    };
    private Map infos = new LinkedHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ThreadInfo getThreadInfo() {
        Thread thisThread = Thread.currentThread();
        Map map = this.infos;
        synchronized (map) {
            ThreadInfo info = (ThreadInfo)this.infos.get(thisThread);
            return info;
        }
    }

    private ISchedulingRule getRuleForResoure(ISchedulingRule resourceRule) {
        return resourceRule == null ? NULL_SCHEDULING_RULE : resourceRule;
    }

    public boolean isLocked(ISchedulingRule resourceRule) {
        ISchedulingRule rule = this.getRuleForResoure(resourceRule);
        if (rule == AVOID_NOTIFICATION_RULE || rule == NULL_SCHEDULING_RULE) {
            return false;
        }
        ThreadInfo info = this.getThreadInfo();
        if (info == null) {
            return false;
        }
        return info.ruleConflicts(rule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ISchedulingRule acquire(ISchedulingRule resourceRule, IFlushOperation operation, ILockParticipant participant, boolean doWait, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 1);
        info = this.getThreadInfo();
        added = false;
        thisThread = Thread.currentThread();
        if (info == null) {
            info = this.createThreadInfo(operation);
            var9_9 = this.infos;
            // MONITORENTER : var9_9
            this.infos.put(thisThread, info);
            // MONITOREXIT : var9_9
            added = true;
            if (BatchingLock.DEBUG) {
                System.out.println("[" + thisThread.getName() + "] acquired batching lock on " + resourceRule);
            }
        }
        conflictingThreadName = null;
        blockingMonitor = monitor instanceof IProgressMonitorWithBlocking != false ? (IProgressMonitorWithBlocking)monitor : null;
        checkedThread = true;
        acquired = false;
        try {
            resourceRule = participant.locking(resourceRule);
            rule = this.getRuleForResoure(resourceRule);
            while (true) {
                block47: {
                    block48: {
                        block45: {
                            block46: {
                                if (monitor.isCanceled()) {
                                    throw new OperationCanceledException();
                                }
                                if (rule == BatchingLock.AVOID_NOTIFICATION_RULE || rule == BatchingLock.NULL_SCHEDULING_RULE) ** GOTO lbl43
                                if (!checkedThread) {
                                    ThreadCheck.checkLongOpsAllowed();
                                    checkedThread = true;
                                }
                                conflictingInfo = null;
                                conflictingThread = null;
                                var16_17 = this.infos;
                                // MONITORENTER : var16_17
                                iter = this.infos.entrySet().iterator();
                                if (true) ** GOTO lbl68
lbl43:
                                // 1 sources

                                result = info.pushRule(rule);
                                acquired = true;
                                var21_22 = result;
                                if (!acquired && added) {
                                    var22_25 = this.infos;
                                    // MONITORENTER : var22_25
                                    this.infos.remove(Thread.currentThread());
                                    // MONITOREXIT : var22_25
                                }
                                if (conflictingThreadName != null) {
                                    blockingMonitor.clearBlocked();
                                }
                                monitor.done();
                                return var21_22;
                                do {
                                    e = iter.next();
                                    otherInfo = (ThreadInfo)e.getValue();
                                    if (e.getKey() == thisThread || !otherInfo.ruleConflicts(rule)) continue;
                                    conflictingInfo = otherInfo;
                                    conflictingThread = (Thread)e.getKey();
                                    break;
lbl68:
                                    // 2 sources

                                } while (iter.hasNext());
                                if (conflictingInfo != null) break block45;
                                result = info.pushRule(rule);
                                acquired = true;
                                var21_21 = result;
                                // MONITOREXIT : var16_17
                                if (acquired || !added) break block46;
                                var22_23 = this.infos;
                                // MONITORENTER : var22_23
                                this.infos.remove(Thread.currentThread());
                                // MONITOREXIT : var22_23
                            }
                            if (conflictingThreadName != null) {
                                blockingMonitor.clearBlocked();
                            }
                            monitor.done();
                            return var21_21;
                        }
                        // MONITOREXIT : var16_17
                        waited = false;
                        var17_18 = ThreadInfo.access$0(conflictingInfo);
                        // MONITORENTER : var17_18
                        if (!conflictingInfo.ruleConflicts(rule)) ** GOTO lbl141
                        if (doWait) break block47;
                        // MONITOREXIT : var17_18
                        if (acquired || !added) break block48;
                        var22_24 = this.infos;
                        this.infos.remove(Thread.currentThread());
                        // MONITOREXIT : var22_24
                    }
                    if (conflictingThreadName != null) {
                        blockingMonitor.clearBlocked();
                    }
                    monitor.done();
                    return null;
                }
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (blockingMonitor != null && !(name = ThreadInfo.access$1(conflictingInfo) != null ? ThreadInfo.access$1(conflictingInfo).getName() : conflictingThread.getName()).equals(conflictingThreadName)) {
                    msg = NLS.bind((String)Messages.BatchingLock_0, (Object[])new Object[]{name});
                    if (conflictingThreadName != null) {
                        conflictingThreadName = null;
                        blockingMonitor.clearBlocked();
                    }
                    blockingMonitor.setBlocked((IStatus)new Status(1, "com.ibm.team.filesystem.client", 1, msg, null));
                    conflictingThreadName = name;
                }
                participant.waiting();
                waited = true;
                try {
                    ThreadInfo.access$0(conflictingInfo).wait(500L);
                }
                catch (InterruptedException v6) {}
lbl141:
                // 3 sources

                if (!waited) continue;
                resourceRule = participant.locking(resourceRule);
                rule = this.getRuleForResoure(resourceRule);
                continue;
                break;
            }
        }
        catch (Throwable var20_27) {
            if (!acquired && added) {
                var22_26 = this.infos;
                // MONITORENTER : var22_26
                this.infos.remove(Thread.currentThread());
                // MONITOREXIT : var22_26
            }
            if (conflictingThreadName != null) {
                blockingMonitor.clearBlocked();
            }
            monitor.done();
            throw var20_27;
        }
    }

    protected ThreadInfo createThreadInfo(IFlushOperation operation) {
        return new ThreadInfo(operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(ISchedulingRule rule, IProgressMonitor monitor) throws FileSystemClientException {
        ThreadInfo info = this.getThreadInfo();
        Assert.isNotNull((Object)info, (String)"Unmatched acquire/release.");
        Assert.isTrue((boolean)info.isNested(), (String)"Unmatched acquire/release.");
        info.popRule(rule, monitor);
        if (!info.isNested()) {
            Thread thisThread = Thread.currentThread();
            if (DEBUG) {
                System.out.println("[" + thisThread.getName() + "] released batching lock");
            }
            Map map = this.infos;
            synchronized (map) {
                this.infos.remove(thisThread);
            }
        }
    }

    public void addChange(ICopyFileAreaEvent change) {
        ThreadInfo info = this.getThreadInfo();
        Assert.isNotNull((Object)info, (String)"Folder changed outside of resource lock");
        info.addChange(change);
    }

    public void flush(IProgressMonitor monitor) throws FileSystemClientException {
        ThreadInfo info = this.getThreadInfo();
        Assert.isNotNull((Object)info, (String)"Flush requested outside of resource lock");
        info.flush(monitor);
    }

    public class ThreadInfo {
        private List changes = new ArrayList();
        private IFlushOperation operation;
        private Job job;
        private List rules = new ArrayList();

        public ThreadInfo(IFlushOperation operation) {
            this.operation = operation;
        }

        public ISchedulingRule pushRule(ISchedulingRule rule) {
            if (rule != NULL_SCHEDULING_RULE && rule != AVOID_NOTIFICATION_RULE) {
                this.addAndCheckRule(rule);
            } else {
                this.addRule(rule);
            }
            return rule;
        }

        public void popRule(ISchedulingRule rule, IProgressMonitor monitor) throws FileSystemClientException {
            try {
                if (this.isFlushRequired()) {
                    this.flush(monitor);
                }
            }
            finally {
                ISchedulingRule stackedRule = this.removeRule();
                if (rule == null) {
                    rule = NULL_SCHEDULING_RULE;
                }
                if (!stackedRule.equals(rule)) {
                    Assert.isTrue((boolean)false, (String)("end for resource '" + rule + "' does not match stacked rule '" + stackedRule + "'"));
                }
            }
        }

        public boolean isNested() {
            return !this.rules.isEmpty();
        }

        public void addChange(ICopyFileAreaEvent change) {
            this.changes.add(change);
        }

        public boolean isEmpty() {
            return this.changes.isEmpty();
        }

        public ICopyFileAreaEvent[] getEvents() {
            return this.changes.toArray(new ICopyFileAreaEvent[this.changes.size()]);
        }

        public void flush(IProgressMonitor monitor) throws FileSystemClientException {
            try {
                try {
                    if (this.operation != null) {
                        this.operation.flush(this, monitor);
                    }
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
                catch (Error e) {
                    this.handleAbortedFlush(e);
                    throw e;
                }
                catch (RuntimeException e) {
                    this.handleAbortedFlush(e);
                    throw e;
                }
            }
            finally {
                this.changes.clear();
            }
        }

        private boolean isFlushRequired() {
            return this.rules.size() == 1 || this.remainingRulesAreNull();
        }

        private boolean remainingRulesAreNull() {
            int i = 0;
            while (i < this.rules.size() - 1) {
                ISchedulingRule rule = (ISchedulingRule)this.rules.get(i);
                if (rule != NULL_SCHEDULING_RULE) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private void handleAbortedFlush(Throwable t) {
            LoggingHelper.error("com.ibm.team.filesystem.client", "Flush aborted", t);
        }

        private void addAndCheckRule(ISchedulingRule resource) {
            ISchedulingRule baseRule = null;
            for (ISchedulingRule rule : this.rules) {
                if (rule == NULL_SCHEDULING_RULE || rule == AVOID_NOTIFICATION_RULE) continue;
                if (rule.contains(resource)) break;
                baseRule = rule;
                break;
            }
            if (baseRule != null) {
                throw new IllegalStateException("The rule " + resource + " is not contained in base rule " + baseRule);
            }
            this.addRule(resource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addRule(ISchedulingRule resource) {
            List list = this.rules;
            synchronized (list) {
                this.rules.add(resource);
                this.job = Job.getJobManager().currentJob();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ISchedulingRule removeRule() {
            List list = this.rules;
            synchronized (list) {
                this.rules.notifyAll();
                this.job = Job.getJobManager().currentJob();
                return (ISchedulingRule)this.rules.remove(this.rules.size() - 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean ruleConflicts(ISchedulingRule resource) {
            List list = this.rules;
            synchronized (list) {
                for (ISchedulingRule rule : this.rules) {
                    if (rule == NULL_SCHEDULING_RULE || rule == AVOID_NOTIFICATION_RULE) continue;
                    if (rule.getClass() == MultiRule.class) {
                        return rule.isConflicting(resource);
                    }
                    return resource.isConflicting(rule);
                }
                return false;
            }
        }

        static /* synthetic */ List access$0(ThreadInfo threadInfo) {
            return threadInfo.rules;
        }

        static /* synthetic */ Job access$1(ThreadInfo threadInfo) {
            return threadInfo.job;
        }
    }
}

