/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IShareableVisitor;
import com.ibm.team.filesystem.client.internal.IVisitor;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreManager;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.scm.common.IVersionableHandle;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public abstract class Shareable
implements IShareable {
    public IShare getShare() {
        return SharingManager.getInstance().getShare(this);
    }

    public int getState() {
        return SharingManager.getInstance().getState(this);
    }

    public boolean isLocallyModified() {
        return (this.getState() & 4) != 0;
    }

    public final IShare share(ISharingDescriptor descriptor, boolean overwrite, IProgressMonitor monitor) throws FileSystemClientException {
        return this.share(descriptor, overwrite, true, monitor);
    }

    public IShare share(ISharingDescriptor descriptor, boolean overwrite, boolean loadChanges, IProgressMonitor monitor) throws FileSystemClientException {
        return SharingManager.getInstance().share(this, descriptor, overwrite, loadChanges, monitor);
    }

    public IVersionableHandle getRemote() {
        FileItemInfo info = SharingManager.getInstance().getItemInfo(this);
        return info != null && info.getVersionableHandle().hasStateId() && info.isFolder() == this.getFileStorage().isFolder() ? info.getVersionableHandle() : null;
    }

    public IVersionableHandle getVersionable() {
        FileItemInfo info = SharingManager.getInstance().getItemInfo(this);
        return info != null && info.isFolder() == this.getFileStorage().isFolder() ? info.getVersionableHandle() : null;
    }

    public void accept(IShareableVisitor visitor, int depth, boolean includeLocal, boolean mutable, IProgressMonitor monitor) throws FileSystemClientException {
        this.accept(visitor, depth, includeLocal, mutable ? this.getRule() : null, monitor);
    }

    public void accept(final IShareableVisitor visitor, final int depth, final boolean includeLocal, ISchedulingRule rule, IProgressMonitor monitor) throws FileSystemClientException {
        IShare share = this.getShare();
        if (share == null) {
            if (monitor != null) {
                monitor.beginTask("", 1);
                monitor.done();
            }
            return;
        }
        final FileSystemClientException[] visitorException = new FileSystemClientException[1];
        IVisitor metadataVisitor = new IVisitor(){

            public boolean visit(IPath path, FileItemInfo fileItem, IProgressMonitor monitor) {
                SubMonitor progress;
                IVersionableHandle versionableHandle = fileItem.getVersionableHandle();
                boolean remote = versionableHandle.hasStateId();
                if (!includeLocal) {
                    if (!remote) {
                        return false;
                    }
                    Shareable shareable = Shareable.this.getShareableFor(path, fileItem.isFolder());
                    return visitor.visit(shareable, monitor);
                }
                final Shareable shareable = Shareable.this.getShareableFor(path, fileItem.isFolder());
                boolean visitChildren = visitor.visit(shareable, (IProgressMonitor)(progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100)).newChild(50));
                if (!visitChildren) {
                    return false;
                }
                if (!fileItem.isFolder()) {
                    return false;
                }
                try {
                    shareable.visit(new IShareableVisitor(){

                        public boolean visit(IShareable shareableToVisit, IProgressMonitor monitor) {
                            if (shareable.equals(shareableToVisit)) {
                                return true;
                            }
                            if (shareableToVisit.getVersionable() == null) {
                                boolean result = visitor.visit(shareableToVisit, monitor);
                                return result;
                            }
                            return false;
                        }
                    }, depth, (IProgressMonitor)progress.newChild(50));
                    progress.done();
                }
                catch (FileSystemClientException e) {
                    visitorException[0] = e;
                }
                return true;
            }
        };
        CopyFileAreaStore.getCopyFileArea(this.getRoot()).accept(metadataVisitor, this, rule, depth, monitor);
        if (visitorException[0] != null) {
            throw visitorException[0];
        }
    }

    public abstract IFileStorage getFileStorage();

    public void forget(IProgressMonitor monitor) throws FileSystemClientException {
        SharingManager.getInstance().forget(this, monitor);
    }

    public void unshare(IProgressMonitor monitor) throws FileSystemClientException {
        Share share = SharingManager.getInstance().getShare(this);
        if (share == null) {
            return;
        }
        if (!share.getPath().equals((Object)this.getLocalFullPath())) {
            throw new IllegalStateException("Only the root of the share can be unshared");
        }
        SharingManager.getInstance().forget(this, monitor);
    }

    public abstract Shareable getShareableFor(IPath var1, boolean var2);

    public abstract void visit(IShareableVisitor var1, int var2, IProgressMonitor var3) throws FileSystemClientException;

    public Shareable getParent() {
        IPath parentPath = this.getLocalFullPath().removeLastSegments(1);
        if (parentPath.isRoot()) {
            return null;
        }
        return this.getShareableFor(parentPath, true);
    }

    public boolean shouldBeIgnored() {
        return IgnoreManager.getInstance().shouldBeIgnored(this);
    }

    public boolean shouldBeIgnoredLocally() {
        return false;
    }

    public abstract boolean isLocal();

    public ILocalChange getChange() {
        return SharingManager.getInstance().getChange(this);
    }

    public ISchedulingRule getRule() {
        return SharingManager.getSchedulingRule(this);
    }

    public void manage(IProgressMonitor monitor) throws FileSystemClientException {
    }

    public boolean isManaged(IProgressMonitor monitor) {
        return false;
    }

    public LineDelimiter getLineDelimiter() {
        FileItemInfo info = SharingManager.getInstance().getItemInfo(this);
        if (info != null) {
            return info.getLineDelimiter();
        }
        return LineDelimiter.LINE_DELIMITER_NONE;
    }

    public String getContentType() {
        FileItemInfo info = SharingManager.getInstance().getItemInfo(this);
        if (info != null) {
            return info.getContentType();
        }
        return null;
    }

    public LineDelimiter getOriginalLineDelimiter() {
        FileItemInfo info = SharingManager.getInstance().getItemInfo(this);
        if (info != null) {
            return info.getOriginalLineDelimiter();
        }
        return LineDelimiter.LINE_DELIMITER_NONE;
    }

    public String getOriginalContentType() {
        FileItemInfo info = SharingManager.getInstance().getItemInfo(this);
        if (info != null) {
            return info.getOriginalContentType();
        }
        return null;
    }

    public boolean isExecutable() {
        return this.getFileStorage().isExecutable();
    }
}

