/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.ShareableFile;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.localchanges.IVersionableTree;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.ScmPackage;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.ecore.EClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Share
implements IShare,
IVersionableTree {
    private ISharingDescriptor descriptor;
    private final IPath root;
    private IPath anchor;

    public Share(ISharingDescriptor descriptor, IPath root, CopyFileAreaStore cfa) {
        Assert.isNotNull((Object)descriptor, (String)"Sharing Descriptor is null");
        this.descriptor = descriptor;
        this.root = root;
        this.anchor = cfa.getRoot();
        this.getTracker();
    }

    @Override
    public IPath getPath() {
        if (this.descriptor == null) {
            throw new IllegalStateException("Not shared anymore");
        }
        return this.root;
    }

    @Override
    public ISharingDescriptor getSharingDescriptor() {
        if (this.descriptor == null) {
            throw new IllegalStateException("Not shared anymore");
        }
        return this.descriptor;
    }

    void invalidate() {
        this.descriptor = null;
    }

    @Override
    public IPath getAnchor() {
        return this.anchor;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Share)) {
            return false;
        }
        Share another = (Share)obj;
        return this.anchor.equals((Object)another.anchor) && this.root.equals((Object)another.root) && this.descriptor.equals(another.descriptor);
    }

    public int hashCode() {
        return this.anchor.hashCode() ^ this.root.hashCode() ^ this.descriptor.hashCode();
    }

    public CopyFileAreaStore getCopyFileArea() {
        return CopyFileAreaStore.getCopyFileArea(this.anchor);
    }

    @Override
    public LocalChangeTracker getTracker() {
        return LocalChangeManager.getInstance().getTracker(this, this.descriptor.getConnectionHandle(), this.descriptor.getComponent(), this.getAnchor(), SharingManager.getInstance().getTrackingRule(this.getAnchor()));
    }

    @Override
    public IShareable getShareable(IPath relativePath, boolean folder) {
        return new ShareableFile(this.anchor, this.anchor.append(relativePath).toFile());
    }

    @Override
    public IVersionableHandle createVersionable(IPath path, IItemType itemType, IProgressMonitor monitor) {
        block5: {
            try {
                if (this.isVersionable(itemType)) break block5;
                LoggingHelper.error("com.ibm.team.filesystem.client", "Could not create versionable for " + path + " " + itemType.getNamespaceURI() + " " + itemType.getName(), null);
                return null;
            }
            catch (FileSystemClientException e) {
                LoggingHelper.error("com.ibm.team.filesystem.client", "Could not create versionable for " + path, (Throwable)((Object)e));
                return null;
            }
        }
        IVersionable created = (IVersionable)itemType.createItem();
        boolean folder = itemType == IFolder.ITEM_TYPE;
        IShareable shareable = this.getShareable(path, folder);
        IVersionableHandle handle = (IVersionableHandle)itemType.createItemHandle(created.getItemId(), null);
        if (folder) {
            this.getCopyFileArea().setItemInfo(shareable, new FileItemInfo((IFolderHandle)handle, null, null), monitor);
        } else {
            this.getCopyFileArea().setItemInfo(shareable, new FileItemInfo(handle, -1L, null, null, null, -1L, null, null, null, null, null, null, -1L, null, -1L, -1L, false, false), monitor);
        }
        return handle;
    }

    private boolean isVersionable(IItemType itemType) {
        EClass eClass = (EClass)itemType.getAdapter(EClass.class);
        if (eClass == null) {
            return false;
        }
        return ScmPackage.eINSTANCE.getVersionable().isSuperTypeOf(eClass);
    }

    @Override
    public void restoreVersionable(IPath path, IVersionableHandle item, IProgressMonitor monitor) {
        try {
            IShareable shareable = this.getShareable(path, item instanceof IFolderHandle);
            CopyFileAreaStore cfa = this.getCopyFileArea();
            InverseFileItemInfo oldInfo = cfa.getItemInfo(item, this.descriptor.getComponent(), this.descriptor.getConnectionHandle());
            Assert.isTrue((oldInfo != null ? 1 : 0) != 0);
            Assert.isTrue((oldInfo.getParent() != null ? 1 : 0) != 0);
            cfa.setItemInfo(shareable, new FileItemInfo(oldInfo.getVersionableHandle(), -1L, oldInfo.getParent(), oldInfo.getName(), oldInfo.getHash(), oldInfo.getContentLength(), oldInfo.getOriginalLineDelimiter(), oldInfo.getLineDelimiter(), oldInfo.getOriginalContentType(), oldInfo.getContentType(), oldInfo.getStoredContentId(), oldInfo.getStoredDeltaPredecessor(), oldInfo.getStoredSize(), oldInfo.getStoredEncoding(), oldInfo.getStoredChecksum(), oldInfo.getStoredNumLineDelimiters(), oldInfo.isOriginalExecutable(), oldInfo.isOriginalExecutable()), monitor);
        }
        catch (FileSystemClientException e) {
            LoggingHelper.error("com.ibm.team.filesystem.client", "Could not restore versionable for " + path, (Throwable)((Object)e));
        }
    }

    @Override
    public IVersionableHandle getVersionableHandle(IPath path) {
        FileItemInfo itemInfo = this.getCopyFileArea().getItemInfo(path);
        return itemInfo == null ? null : itemInfo.getVersionableHandle();
    }

    @Override
    public IVersionableHandle getDeletedVersionable(IFolderHandle parent, String name, IProgressMonitor monitor) {
        return this.getCopyFileArea().getDeletedItem(parent, name, this.descriptor.getComponent(), this.descriptor.getConnectionHandle(), monitor);
    }

    @Override
    public boolean isLocked() {
        return this.getCopyFileArea().isLocked(this.descriptor.getComponent(), this.descriptor.getConnectionHandle());
    }

    @Override
    public ISchedulingRule lock(IProgressMonitor monitor) {
        return this.getCopyFileArea().lock(this.descriptor.getComponent(), this.descriptor.getConnectionHandle(), monitor);
    }

    @Override
    public void unlock(ISchedulingRule rule, IProgressMonitor monitor) throws FileSystemClientException {
        this.getCopyFileArea().release(rule, monitor);
    }

    @Override
    public List<IVersionableTree.IChangeType> getChangedItems() {
        try {
            return SharingManager.getInstance().getChangeTracker(this.getCopyFileArea()).getLocalChanges(this.descriptor.getComponent(), this.descriptor.getConnectionHandle());
        }
        catch (FileSystemClientException e) {
            LoggingHelper.error("com.ibm.team.filesystem.client", "Failed to retrieve changed item infos", (Throwable)((Object)e));
            return Collections.EMPTY_LIST;
        }
    }

    @Override
    public void trackFileChange(IVersionableHandle file, IPath path) {
        try {
            SharingManager.getInstance().getChangeTracker(this.getCopyFileArea()).setContentChanged(file, path, this.descriptor.getComponent(), this.descriptor.getConnectionHandle());
        }
        catch (FileSystemClientException e) {
            LoggingHelper.error("com.ibm.team.filesystem.client", "Failed to set file as modified", (Throwable)((Object)e));
        }
    }

    public void refreshChanges(IShareable root, IProgressMonitor monitor) throws FileSystemClientException {
        LocalChangeManager.getInstance().refreshChanges(this, root, monitor);
    }

    @Override
    public void syncChanges() {
        this.getTracker().syncChanges();
    }

    public String toString() {
        return this.root + " @ " + this.getAnchor();
    }
}

