/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class RestoreVersionableOperation {
    private RestoreVersionableOperation() {
    }

    public static void restoreFile(IShareable file, InputStream in, IVersionableHandle handle, IProgressMonitor monitor) throws FileSystemClientException, IOException {
        if (in == null) {
            throw new NullPointerException();
        }
        try {
            Shareable shareable;
            IFileStorage storage;
            IFileStorage parent;
            if (file == null) {
                throw new NullPointerException();
            }
            if (handle == null) {
                throw new NullPointerException();
            }
            if (handle.getItemId() == null) {
                throw new NullPointerException();
            }
            if (handle instanceof IFolderHandle) {
                throw new IllegalArgumentException("Cannot give a file a versionable of type folder");
            }
            if (handle.hasStateId() || handle.hasFullState()) {
                handle = (IVersionableHandle)handle.getItemType().createItemHandle(handle.getItemId(), null);
            }
            if ((parent = (storage = (shareable = (Shareable)file).getFileStorage()).getParent()) == null) {
                throw new IllegalArgumentException("Cannot restore file at " + shareable.getLocalFullPath() + " outside of share");
            }
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            LockData lock = RestoreVersionableOperation.lockTree(parent, (IProgressMonitor)progress.newChild(5));
            if (lock == null) {
                throw new IllegalArgumentException(shareable.getLocalFullPath() + " is not in a shared location");
            }
            try {
                FileItemInfo info;
                if (storage.exists()) {
                    throw new IllegalArgumentException(shareable.getLocalFullPath() + " already exists");
                }
                if (!parent.exists()) {
                    throw new IllegalArgumentException("Parent folder " + parent.getFullPath() + " does not exist");
                }
                if (!parent.isFolder()) {
                    throw new IllegalArgumentException("Parent " + parent.getFullPath() + " is not a folder");
                }
                IShare share = shareable.getShare();
                if (share.getPath().equals((Object)shareable.getLocalFullPath())) {
                    throw new IllegalArgumentException("Cannot restore file at share root");
                }
                ISharingDescriptor desc = share.getSharingDescriptor();
                CopyFileAreaStore cfa = CopyFileAreaStore.getCopyFileArea(shareable.getRoot());
                if (cfa.isShareRoot((IFolderHandle)IFolder.ITEM_TYPE.createItemHandle(handle.getItemId(), null), desc.getComponent(), desc.getConnectionHandle())) {
                    throw new IllegalArgumentException(handle.getItemId() + " already exists");
                }
                InverseFileItemInfo existing = cfa.getItemInfo(handle, desc.getComponent(), desc.getConnectionHandle());
                if (existing != null) {
                    if (existing.getLocalName() != null) {
                        throw new IllegalArgumentException(handle.getItemId() + " already exists");
                    }
                    if (existing.getVersionableHandle().getItemType() != handle.getItemType()) {
                        throw new IllegalArgumentException("Type mismatch, existing: " + existing.getVersionableHandle().getItemType().getName() + ", restoring: " + handle.getItemType().getName());
                    }
                    info = new FileItemInfo(existing.getVersionableHandle(), existing.getLastModification(), existing.getParent(), existing.getName(), existing.getHash(), existing.getContentLength(), existing.getOriginalLineDelimiter(), existing.getLineDelimiter(), existing.getOriginalContentType(), existing.getContentType(), existing.getStoredContentId(), existing.getStoredDeltaPredecessor(), existing.getStoredSize(), existing.getStoredEncoding(), existing.getStoredChecksum(), existing.getStoredNumLineDelimiters(), existing.isOriginalExecutable(), existing.isOriginalExecutable());
                } else {
                    info = new FileItemInfo(handle, -1L, null, null, null, -1L, null, null, null, null, null, null, -1L, null, -1L, -1L, false, false);
                }
                SharingManager.getInstance().disableChangeMonitoring();
                try {
                    storage.create(in, (IProgressMonitor)progress.newChild(60));
                }
                finally {
                    SharingManager.getInstance().enableChangeMonitoring();
                }
                cfa.setItemInfo(shareable, info, (IProgressMonitor)progress.newChild(30));
            }
            finally {
                RestoreVersionableOperation.unlockTree(lock, (IProgressMonitor)progress.newChild(5));
            }
            in.close();
            in = null;
        }
        catch (Throwable throwable) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void restoreFolder(IShareable folder, IFolderHandle handle, IProgressMonitor monitor) throws FileSystemClientException {
        Shareable shareable;
        IFileStorage storage;
        IFileStorage parent;
        if (folder == null) {
            throw new NullPointerException();
        }
        if (handle == null || handle.getItemId() == null) {
            throw new NullPointerException();
        }
        if (handle.hasStateId() || handle.hasFullState()) {
            handle = (IFolderHandle)handle.getItemType().createItemHandle(handle.getItemId(), null);
        }
        if ((parent = (storage = (shareable = (Shareable)folder).getFileStorage()).getParent()) == null) {
            throw new IllegalArgumentException("Cannot restore file at " + shareable.getLocalFullPath() + " outside of share");
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        LockData lock = RestoreVersionableOperation.lockTree(storage, (IProgressMonitor)progress.newChild(5));
        if (lock == null) {
            throw new IllegalArgumentException(shareable.getLocalFullPath() + " is not in a shared location");
        }
        try {
            FileItemInfo info;
            if (storage.exists()) {
                throw new IllegalArgumentException(shareable.getLocalFullPath() + " already exists");
            }
            if (!parent.exists()) {
                throw new IllegalArgumentException("Parent folder " + parent.getFullPath() + " does not exist");
            }
            if (!parent.isFolder()) {
                throw new IllegalArgumentException("Parent " + parent.getFullPath() + " is not a folder");
            }
            IShare share = shareable.getShare();
            if (share.getPath().equals((Object)shareable.getLocalFullPath())) {
                throw new IllegalArgumentException("Cannot restore folder at share root");
            }
            ISharingDescriptor desc = share.getSharingDescriptor();
            CopyFileAreaStore cfa = CopyFileAreaStore.getCopyFileArea(shareable.getRoot());
            if (cfa.isShareRoot(handle, desc.getComponent(), desc.getConnectionHandle())) {
                throw new IllegalArgumentException(handle.getItemId() + " already exists");
            }
            InverseFileItemInfo existing = cfa.getItemInfo((IVersionableHandle)handle, desc.getComponent(), desc.getConnectionHandle());
            if (existing != null) {
                if (existing.getLocalName() != null) {
                    throw new IllegalArgumentException(handle.getItemId() + " already exists");
                }
                if (existing.getVersionableHandle().getItemType() != handle.getItemType()) {
                    throw new IllegalArgumentException("Type mismatch, existing: " + existing.getVersionableHandle().getItemType().getName() + ", restoring: " + handle.getItemType().getName());
                }
                info = new FileItemInfo(existing.getVersionableHandle(), existing.getLastModification(), existing.getParent(), existing.getName(), existing.getHash(), existing.getContentLength(), existing.getOriginalLineDelimiter(), existing.getLineDelimiter(), existing.getOriginalContentType(), existing.getContentType(), existing.getStoredContentId(), existing.getStoredDeltaPredecessor(), existing.getStoredSize(), existing.getStoredEncoding(), existing.getStoredChecksum(), existing.getStoredNumLineDelimiters(), false, false);
            } else {
                info = new FileItemInfo(handle, null, null);
            }
            SharingManager.getInstance().disableChangeMonitoring();
            try {
                storage.create((IProgressMonitor)progress.newChild(30));
            }
            finally {
                SharingManager.getInstance().enableChangeMonitoring();
            }
            cfa.setItemInfo(shareable, info, (IProgressMonitor)progress.newChild(60));
        }
        finally {
            RestoreVersionableOperation.unlockTree(lock, (IProgressMonitor)progress.newChild(5));
        }
    }

    private static LockData lockTree(IFileStorage storage, IProgressMonitor monitor) throws FileSystemClientException {
        ISchedulingRule rule = storage.getRule(IFileStorage.RuleKind.CREATE);
        boolean success = false;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            Job.getJobManager().beginRule(rule, (IProgressMonitor)progress.newChild(50));
            CopyFileAreaStore cfa = CopyFileAreaStore.getCopyFileArea(storage.getShareable().getRoot());
            ISchedulingRule cfaRule = cfa.lock(storage.getShareable(), (IProgressMonitor)progress.newChild(50));
            if (cfaRule == null) {
                return null;
            }
            LockData result = new LockData(rule, cfaRule, cfa.getRoot());
            success = true;
            LockData lockData = result;
            return lockData;
        }
        finally {
            if (!success) {
                Job.getJobManager().endRule(rule);
            }
        }
    }

    private static void unlockTree(LockData data, IProgressMonitor monitor) throws FileSystemClientException {
        try {
            CopyFileAreaStore cfa = CopyFileAreaStore.getCopyFileArea(data.cfaPath);
            cfa.release(data.cfaRule, monitor);
        }
        finally {
            Job.getJobManager().endRule(data.fsRule);
        }
    }

    private static class LockData {
        public final ISchedulingRule cfaRule;
        public final ISchedulingRule fsRule;
        public final IPath cfaPath;

        public LockData(ISchedulingRule fsRule, ISchedulingRule cfaRule, IPath cfaPath) {
            this.cfaRule = cfaRule;
            this.fsRule = fsRule;
            this.cfaPath = cfaPath;
        }
    }
}

