/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.ReadWriteLock;
import com.ibm.team.filesystem.client.internal.Store;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LockableMap<K, V> {
    protected Store<K, V> entries;
    private Map<K, V> entriesProxy;
    private IPath path;
    private ReadWriteLock mapLock = new ReadWriteLock();

    public LockableMap(IPath path, File f) {
        this.path = path;
        this.init(f);
    }

    protected void init(File f) {
        if (f.exists()) {
            this.initEntries();
        }
        this.entriesProxy = new Map<K, V>(){

            @Override
            public synchronized void clear() {
                if (LockableMap.this.entries != null) {
                    LockableMap.this.entries.clear();
                }
            }

            @Override
            public synchronized boolean containsKey(Object key) {
                if (LockableMap.this.entries != null) {
                    return LockableMap.this.entries.containsKey(key);
                }
                return false;
            }

            @Override
            public synchronized boolean containsValue(Object value) {
                if (LockableMap.this.entries != null) {
                    return LockableMap.this.entries.containsValue(value);
                }
                return false;
            }

            @Override
            public synchronized Set<Map.Entry<K, V>> entrySet() {
                if (LockableMap.this.entries != null) {
                    return LockableMap.this.entries.entrySet();
                }
                return Collections.emptySet();
            }

            @Override
            public synchronized V get(Object key) {
                if (LockableMap.this.entries != null) {
                    return LockableMap.this.entries.get(key);
                }
                return null;
            }

            @Override
            public synchronized boolean isEmpty() {
                if (LockableMap.this.entries != null) {
                    LockableMap.this.entries.isEmpty();
                }
                return true;
            }

            @Override
            public synchronized Set<K> keySet() {
                if (LockableMap.this.entries != null) {
                    return LockableMap.this.entries.keySet();
                }
                return Collections.emptySet();
            }

            @Override
            public synchronized V put(K key, V value) {
                if (LockableMap.this.entries == null) {
                    LockableMap.this.initEntries();
                }
                return LockableMap.this.entries.put(key, value);
            }

            @Override
            public synchronized void putAll(Map<? extends K, ? extends V> t) {
                if (LockableMap.this.entries == null) {
                    LockableMap.this.initEntries();
                }
                LockableMap.this.entries.putAll(t);
            }

            @Override
            public synchronized V remove(Object key) {
                if (LockableMap.this.entries != null) {
                    return LockableMap.this.entries.remove(key);
                }
                return null;
            }

            @Override
            public synchronized int size() {
                if (LockableMap.this.entries != null) {
                    return LockableMap.this.entries.size();
                }
                return 0;
            }

            @Override
            public synchronized Collection<V> values() {
                if (LockableMap.this.entries != null) {
                    return LockableMap.this.entries.values();
                }
                return Collections.emptyList();
            }
        };
    }

    protected abstract void initEntries();

    public Map<K, V> entries() {
        return this.entriesProxy;
    }

    public void acquire(boolean exclusive) {
        if (exclusive) {
            this.mapLock.acquireWrite();
        } else {
            this.mapLock.acquireRead();
        }
    }

    public boolean release() throws FileSystemClientException {
        return this.mapLock.release();
    }

    public IPath getPath() {
        return this.path;
    }

    public void close() throws IOException {
        if (this.entries != null) {
            this.entries.close();
        }
    }
}

