/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileStorage;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.ShareableFile;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;

public class LocalFileStorage
extends FileStorage
implements IFileStorage {
    protected static final Method canExecute;
    protected static final Method setExecutable;
    private final File file;
    private final IPath root;
    private final IPath fullPath;

    static {
        Method m = null;
        try {
            m = File.class.getMethod("canExecute", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        canExecute = m;
        m = null;
        try {
            m = File.class.getMethod("setExecutable", Boolean.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        setExecutable = m;
    }

    public LocalFileStorage(IPath root, File file) {
        this.file = file;
        this.root = root;
        String stringPath = file.getPath();
        try {
            stringPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            LoggingHelper.error("com.ibm.team.filesystem.client", NLS.bind((String)Messages.LocalFileStorage_0, (Object[])new Object[]{stringPath}), e);
        }
        this.fullPath = new Path(stringPath).removeFirstSegments(root.segmentCount()).setDevice(null).makeAbsolute();
    }

    public File getFile() {
        return this.file;
    }

    public IPath getRoot() {
        return this.root;
    }

    public boolean isFolder() {
        return this.file.isDirectory();
    }

    public long getModificationStamp() {
        long result = this.file.lastModified();
        if (result == 0L) {
            return this.file.exists() ? 0 : -1;
        }
        return result;
    }

    public long getLocalTimeStamp() {
        return this.file.lastModified();
    }

    public boolean isModified(long newTimeStamp) {
        FileItemInfo currentInfo = SharingManager.getInstance().getItemInfo(new ShareableFile(this.root, this.file));
        return currentInfo == null || currentInfo.getLastModification() != newTimeStamp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getSize(IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        try {
            if (this.file.isDirectory()) {
                return -1L;
            }
            long size = this.file.length();
            if (size == 0L && !this.file.exists()) {
                return -1L;
            }
            long l = size;
            return l;
        }
        finally {
            progress.done();
        }
    }

    public IFileStorage getParent() {
        if (this.fullPath.segmentCount() <= 1) {
            return null;
        }
        return new LocalFileStorage(this.root, this.file.getParentFile());
    }

    public IFileStorage getChild(String name) {
        File childFile = new File(this.file, name);
        if (childFile.exists()) {
            return new LocalFileStorage(this.root, childFile);
        }
        return null;
    }

    public IFileStorage[] getChildren() throws FileSystemClientException {
        File[] listing = this.file.listFiles();
        if (listing == null) {
            return null;
        }
        IFileStorage[] children = new IFileStorage[listing.length];
        int i = 0;
        while (i < listing.length) {
            children[i] = new LocalFileStorage(this.root, listing[i]);
            ++i;
        }
        return children;
    }

    public IVersionableHandle getRemote() {
        return new ShareableFile(this.root, this.file).getRemote();
    }

    public InputStream getContents(boolean force) throws FileSystemClientException {
        return this.getContents();
    }

    public InputStream getContents() throws FileSystemClientException {
        if (this.file.isDirectory()) {
            return null;
        }
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, 203, Messages.LocalFileStorage_1, e));
        }
    }

    public void create(InputStream in, IProgressMonitor monitor) throws FileSystemClientException {
        this.setContents(in, monitor);
    }

    public void create(IProgressMonitor progress) throws FileSystemClientException {
        if (!this.file.mkdir()) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.LocalFileStorage_2, (Object[])new Object[]{this.fullPath}), null));
        }
    }

    public void setContents(InputStream in, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        try {
            if (this.isFolder()) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        throw new FileSystemClientException(FileSystemStatus.getStatusFor(e));
                    }
                }
                throw new FileSystemClientException(new FileSystemStatus(Messages.LocalFileStorage_3));
            }
            boolean success = false;
            try {
                try {
                    FileOutputStream out = new FileOutputStream(this.file);
                    try {
                        if (in != null) {
                            byte[] buf = new byte[8192];
                            int size = in.read(buf);
                            while (size != -1) {
                                ((OutputStream)out).write(buf, 0, size);
                                size = in.read(buf);
                            }
                        }
                        success = true;
                    }
                    finally {
                        block27: {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (IOException e) {
                                if (!success) break block27;
                                success = false;
                                throw e;
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor(e));
                }
            }
            finally {
                block28: {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            if (!success) break block28;
                            throw new FileSystemClientException(FileSystemStatus.getStatusFor(e));
                        }
                    }
                }
            }
        }
        finally {
            progress.done();
        }
    }

    public IPath getFullPath() {
        return this.fullPath;
    }

    public String getName() {
        return this.file.getName();
    }

    public boolean isReadOnly() {
        return !this.file.canWrite();
    }

    public Shareable getShareable() {
        return new ShareableFile(this.root, this.file);
    }

    public boolean isExecutable() {
        if (!this.supportsExecBit()) {
            return super.isExecutable();
        }
        try {
            return (Boolean)canExecute.invoke((Object)this.file, new Object[0]);
        }
        catch (IllegalAccessException e) {
            LoggingHelper.log(FileSystemStatus.getStatusFor(e));
        }
        catch (InvocationTargetException e) {
            LoggingHelper.log(FileSystemStatus.getStatusFor(e.getTargetException()));
        }
        return false;
    }

    public boolean setExecutable(boolean exec, IProgressMonitor monitor) {
        if (!this.supportsExecBit()) {
            return super.setExecutable(exec, monitor);
        }
        try {
            return (Boolean)setExecutable.invoke((Object)this.file, exec);
        }
        catch (IllegalAccessException e) {
            LoggingHelper.log(FileSystemStatus.getStatusFor(e));
        }
        catch (InvocationTargetException e) {
            LoggingHelper.log(FileSystemStatus.getStatusFor(e.getTargetException()));
        }
        return false;
    }

    public boolean supportsExecBit() {
        return setExecutable != null && canExecute != null && super.supportsExecBit();
    }

    public boolean exists() {
        return this.file.exists();
    }

    public void move(IFileStorage destination, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        try {
            LocalFileStorage dest = (LocalFileStorage)destination;
            if (!dest.root.equals((Object)this.root)) {
                throw new IllegalArgumentException();
            }
            if (!this.file.renameTo(dest.file)) {
                throw new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalFileStorage_4, (Object[])new Object[]{this.file, dest.file})));
            }
        }
        finally {
            progress.done();
        }
    }

    public void delete(IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            if (this.exists()) {
                LocalFileStorage.deepDelete(this.file, (IProgressMonitor)progress.newChild(100));
            }
        }
        finally {
            progress.done();
        }
    }

    private static void deepDelete(File f, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)0);
        if (f.isDirectory()) {
            File[] children = f.listFiles();
            if (children == null) {
                throw new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalFileStorage_5, (Object[])new Object[]{f})));
            }
            progress.setWorkRemaining(children.length);
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                LocalFileStorage.deepDelete(child, (IProgressMonitor)progress.newChild(1));
                ++n2;
            }
        }
        if (!f.delete()) {
            throw new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalFileStorage_6, (Object[])new Object[]{f})));
        }
    }

    public boolean contains(ISchedulingRule rule) {
        if (this == rule) {
            return true;
        }
        if (rule instanceof MultiRule) {
            MultiRule multi = (MultiRule)rule;
            ISchedulingRule[] children = multi.getChildren();
            int i = 0;
            while (i < children.length) {
                if (!this.contains(children[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (!(rule instanceof IFileStorage)) {
            return false;
        }
        return this.fullPath.isPrefixOf(((IFileStorage)rule).getFullPath());
    }

    public boolean isConflicting(ISchedulingRule rule) {
        if (!(rule instanceof IFileStorage)) {
            return false;
        }
        IPath otherPath = ((IFileStorage)rule).getFullPath();
        return this.fullPath.isPrefixOf(otherPath) || otherPath.isPrefixOf(this.fullPath);
    }

    public String toString() {
        return this.fullPath.toString();
    }

    public void refreshCachedSubTree(IProgressMonitor monitor) throws FileSystemClientException {
    }

    public ISchedulingRule getRule(IFileStorage.RuleKind kind) {
        switch (kind) {
            case CREATE: {
                return this.getParent() == null ? this : this.getParent();
            }
            case DELETE: {
                return this.getParent() == null ? this : this.getParent();
            }
            case MODIFY: {
                return this;
            }
            case REFRESH: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown rule " + (Object)((Object)kind));
    }
}

