/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IFileSystemView;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.operations.LocalFileSystemLoadOperation;
import com.ibm.team.filesystem.client.internal.operations.LocalFileSystemUpdateOperation;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.common.IWorkspaceCompareReport;
import com.ibm.team.filesystem.common.internal.dto.FilesystemDTOFactory;
import com.ibm.team.filesystem.common.internal.dto.LogicalConflictReport;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.WorkspaceComparisonFlags;
import com.ibm.team.scm.common.dto.ISynchronizationInfo;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemView
implements IFileSystemView {
    private final IConnection connection;
    private final boolean isWorkspaceConnection;
    private final FileSystemServiceProxy fileSystemService;

    public FileSystemView(FileSystemServiceProxy fileSystemServiceProxy, IConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        if (connection instanceof IWorkspaceConnection) {
            this.isWorkspaceConnection = true;
        } else {
            this.isWorkspaceConnection = false;
            if (!(connection instanceof IBaselineConnection)) {
                throw new IllegalArgumentException();
            }
        }
        this.connection = connection;
        this.fileSystemService = fileSystemServiceProxy;
    }

    @Override
    public IConnection connection() {
        return this.connection;
    }

    @Override
    public void updateLocalFileSystem(File localRoot, IUpdateReport updateReport, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        this.updateLocalFileSystem(localRoot, updateReport, null, monitor);
    }

    public void updateLocalFileSystem(File localRoot, IUpdateReport updateReport, ISynchronizationInfo synchronizationInfo, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        ThreadCheck.checkLongOpsAllowed();
        if (localRoot == null || !localRoot.exists()) {
            throw new IllegalArgumentException();
        }
        if (updateReport == null) {
            throw new IllegalArgumentException();
        }
        if (!this.isWorkspaceConnection) {
            throw new TeamRepositoryException((Object)this.connection().teamRepository(), Messages.FileSystemView_0);
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            LocalFileSystemUpdateOperation op = new LocalFileSystemUpdateOperation((IWorkspaceConnection)this.connection(), Collections.singletonList(updateReport), (IPath)new Path(localRoot.getCanonicalPath()), 3, UpdateDilemmaHandler.getDefault());
            op.setSynchronizationInfo(synchronizationInfo);
            op.run(monitor);
        }
        catch (IOException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, 207, Messages.FileSystemView_1, e));
        }
    }

    @Override
    public List getBlame(IComponentHandle component, IFileItemHandle fileItemHandle, IChangeSetHandle changeSetHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fileSystemService.getBlame(this.connection, component, fileItemHandle, changeSetHandle, null, monitor);
    }

    @Override
    public ILogicalConflictReport interpretConflicts(IPath copyFileAreaRoot, Collection itemUpdateReports, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!this.isWorkspaceConnection) {
            throw new TeamRepositoryException((Object)this.connection().teamRepository(), Messages.FileSystemView_2);
        }
        if (copyFileAreaRoot == null) {
            throw new IllegalArgumentException();
        }
        if (itemUpdateReports.isEmpty()) {
            LogicalConflictReport result = FilesystemDTOFactory.eINSTANCE.createLogicalConflictReport();
            return result;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        return this.fileSystemService.interpretConflicts((IWorkspaceConnection)this.connection, itemUpdateReports, null, (IProgressMonitor)progress.newChild(99));
    }

    @Override
    public void loadLocalFileSystem(File localRoot, Collection<IComponentHandle> components, int options, LoadDilemmaHandler problemHandler, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        this.loadLocalFileSystem(localRoot, components, options, problemHandler, null, monitor);
    }

    public void loadLocalFileSystem(File localRoot, Collection<IComponentHandle> components, int options, LoadDilemmaHandler problemHandler, ISynchronizationInfo synchronizationInfo, IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        ThreadCheck.checkLongOpsAllowed();
        if (localRoot == null) {
            throw new IllegalArgumentException();
        }
        if (components == null) {
            throw new IllegalArgumentException();
        }
        if (problemHandler == null) {
            throw new IllegalArgumentException();
        }
        if (options != 0 && options != 1 && options != 2) {
            throw new IllegalArgumentException();
        }
        for (IComponentHandle object : components) {
            if (object instanceof IComponentHandle) continue;
            throw new IllegalArgumentException();
        }
        if (!localRoot.exists() || !localRoot.isDirectory()) {
            throw new IllegalArgumentException(Messages.FileSystemView_3);
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(100 + components.size() * 10));
        try {
            LocalFileSystemLoadOperation op = new LocalFileSystemLoadOperation((IPath)new Path(localRoot.getCanonicalPath()), this.getLoadOperationFlags(options), problemHandler);
            if (this.isWorkspaceConnection) {
                IWorkspaceConnection workspaceConnection = (IWorkspaceConnection)this.connection;
                for (IComponentHandle component : components) {
                    IConfiguration configuration = workspaceConnection.configuration(component);
                    ArrayList<IFolderHandle> foldersToLoad = this.getFoldersToLoad(configuration, monitor.newChild(10));
                    op.requestLoad(workspaceConnection, component, foldersToLoad);
                }
            } else {
                IConfiguration configuration = ((IBaselineConnection)this.connection).configuration();
                ArrayList<IFolderHandle> foldersToLoad = this.getFoldersToLoad(configuration, monitor.newChild(10));
                op.requestLoad((IBaselineConnection)this.connection, foldersToLoad);
            }
            op.setSychronizationInfo(synchronizationInfo);
            op.run((IProgressMonitor)monitor.newChild(90));
        }
        catch (IOException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, 207, Messages.FileSystemView_4, e));
        }
    }

    private ArrayList<IFolderHandle> getFoldersToLoad(IConfiguration configuration, SubMonitor monitor) throws TeamRepositoryException {
        Map children = configuration.childEntriesForRoot((IProgressMonitor)monitor);
        ArrayList<IFolderHandle> foldersToLoad = new ArrayList<IFolderHandle>(children.size());
        for (IVersionableHandle child : children.values()) {
            if (!(child instanceof IFolderHandle)) continue;
            foldersToLoad.add((IFolderHandle)child);
        }
        return foldersToLoad;
    }

    private int getLoadOperationFlags(int options) {
        int operationFlags = 0;
        if ((options & 1) == 1) {
            operationFlags = 1;
        } else if ((options & 2) == 2) {
            operationFlags = 2;
        }
        return operationFlags;
    }

    @Override
    public List interpretChanges(IPath copyFileAreaRoot, List changeSets, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        return this.fileSystemService.interpretChanges(this.connection, changeSets, null, (IProgressMonitor)monitor.newChild(99));
    }

    @Override
    public ILogicalConflictReport conflictReport(IPath copyFileAreaRoot, IProgressMonitor progress) throws TeamRepositoryException {
        if (!this.isWorkspaceConnection) {
            throw new TeamRepositoryException((Object)this.connection().teamRepository(), Messages.FileSystemView_5);
        }
        if (copyFileAreaRoot == null) {
            throw new IllegalArgumentException();
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IUpdateReport rawConflictReport = ((IWorkspaceConnection)this.connection).conflictReport();
        if (rawConflictReport.conflicts().isEmpty()) {
            LogicalConflictReport result = FilesystemDTOFactory.eINSTANCE.createLogicalConflictReport();
            result.setConflictReport(rawConflictReport);
            return result;
        }
        return this.fileSystemService.conflictReport((IWorkspaceConnection)this.connection, null, (IProgressMonitor)monitor.newChild(99));
    }

    @Override
    public IWorkspaceCompareReport compareAsWorkspaces(IWorkspaceConnection other, int compareFlags, IPath copyFileAreaRoot, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!this.isWorkspaceConnection) {
            throw new TeamRepositoryException((Object)this.connection().teamRepository(), Messages.FileSystemView_5);
        }
        if (other == null) {
            throw new IllegalArgumentException();
        }
        if (!WorkspaceComparisonFlags.isValid((int)compareFlags)) {
            throw new IllegalArgumentException();
        }
        if (copyFileAreaRoot == null) {
            throw new IllegalArgumentException();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        return this.fileSystemService.compareAsWorkspaces((IWorkspaceConnection)this.connection, other, compareFlags, (IProgressMonitor)progress.newChild(99));
    }
}

