/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.utils.HashCode;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import org.eclipse.core.runtime.Assert;

public class FileItemInfo {
    public static final long NULL_STAMP = -1L;
    public static final long NULL_CHECKSUM = -1L;
    public static final long NULL_DELIMITER_COUNT = -1L;
    private final IVersionableHandle handle;
    private final long lastModification;
    private final IFolderHandle parent;
    private final String name;
    public static final int NULL_SIZE = -1;
    private final long contentLength;
    private final HashCode hash;
    private final LineDelimiter lineDelimiter;
    private final LineDelimiter originalLineDelimiter;
    private final String contentType;
    private final String originalContentType;
    private final UUID deltaPredecessor;
    private final UUID contentId;
    private final long sizeInRepo;
    private final String encoding;
    private final long checksum;
    private final long numLineDelimiters;
    private final boolean originalExecutable;
    private final boolean executable;

    public FileItemInfo(IVersionableHandle handle, long lastModification, IFolderHandle parent, String name, HashCode hash, long size, LineDelimiter originalLineDelimiter, LineDelimiter lineDelimiter, String originalContentType, String contentType, UUID contentId, UUID contentDeltaPredecessor, long contentSizeInRepo, String originalEncoding, long checksumInRepo, long lineDelimiterCountInRepo, boolean executable, boolean originalExecutable) {
        this.validateFileItemInfo(handle, parent, name);
        if (handle instanceof IFolderHandle) {
            if (originalContentType != null || contentType != null) {
                throw new IllegalArgumentException();
            }
            if (originalLineDelimiter != null || lineDelimiter != null) {
                throw new IllegalArgumentException();
            }
            executable = false;
            originalExecutable = false;
        } else {
            if (contentType == null && originalContentType != null) {
                throw new IllegalArgumentException();
            }
            if (lineDelimiter == null && originalLineDelimiter != null) {
                throw new IllegalArgumentException();
            }
        }
        if (handle.hasStateId() && !(handle instanceof IFolderHandle)) {
            if (hash == null) {
                throw new IllegalArgumentException();
            }
            if (size == -1L) {
                throw new IllegalArgumentException();
            }
        } else {
            if (!handle.hasStateId() && lastModification != -1L) {
                throw new IllegalArgumentException();
            }
            if (size != -1L) {
                throw new IllegalArgumentException();
            }
            if (originalLineDelimiter != null) {
                throw new IllegalArgumentException();
            }
            if (originalContentType != null) {
                throw new IllegalArgumentException();
            }
            if (contentId != null) {
                throw new IllegalArgumentException();
            }
            if (contentDeltaPredecessor != null) {
                throw new IllegalArgumentException();
            }
            if (contentSizeInRepo != -1L) {
                throw new IllegalArgumentException();
            }
            if (originalEncoding != null) {
                throw new IllegalArgumentException();
            }
            if (checksumInRepo != -1L) {
                throw new IllegalArgumentException();
            }
            if (lineDelimiterCountInRepo != -1L) {
                throw new IllegalArgumentException();
            }
        }
        if (contentId == null) {
            Assert.isTrue((contentDeltaPredecessor == null ? 1 : 0) != 0);
            Assert.isTrue((contentSizeInRepo == -1L ? 1 : 0) != 0);
            Assert.isTrue((originalEncoding == null ? 1 : 0) != 0);
            Assert.isTrue((checksumInRepo == -1L ? 1 : 0) != 0);
            Assert.isTrue((lineDelimiterCountInRepo == -1L ? 1 : 0) != 0);
        } else {
            Assert.isTrue((boolean)handle.hasStateId());
            Assert.isTrue((!(handle instanceof IFolderHandle) ? 1 : 0) != 0);
            Assert.isTrue((originalLineDelimiter != null ? 1 : 0) != 0);
            Assert.isTrue((contentSizeInRepo != -1L ? 1 : 0) != 0);
            Assert.isTrue((originalContentType != null ? 1 : 0) != 0);
            Assert.isTrue((checksumInRepo != -1L ? 1 : 0) != 0);
        }
        this.handle = handle;
        this.parent = parent;
        this.name = name;
        this.lastModification = lastModification;
        this.hash = hash;
        this.contentLength = size;
        this.lineDelimiter = lineDelimiter;
        this.originalLineDelimiter = originalLineDelimiter;
        this.originalContentType = originalContentType;
        this.contentType = contentType;
        this.contentId = contentId;
        this.deltaPredecessor = contentDeltaPredecessor;
        this.sizeInRepo = contentSizeInRepo;
        this.encoding = originalEncoding;
        this.checksum = checksumInRepo;
        this.numLineDelimiters = lineDelimiterCountInRepo;
        this.executable = executable;
        this.originalExecutable = originalExecutable;
    }

    public FileItemInfo(IFolderHandle handle, IFolderHandle parent, String name) {
        this.validateFileItemInfo((IVersionableHandle)handle, parent, name);
        this.handle = handle;
        this.parent = parent;
        this.name = name;
        this.lastModification = -1L;
        this.contentLength = -1L;
        this.originalLineDelimiter = null;
        this.lineDelimiter = null;
        this.hash = null;
        this.originalContentType = null;
        this.contentType = null;
        this.contentId = null;
        this.deltaPredecessor = null;
        this.sizeInRepo = -1L;
        this.encoding = null;
        this.checksum = -1L;
        this.numLineDelimiters = -1L;
        this.originalExecutable = false;
        this.executable = false;
    }

    private void validateFileItemInfo(IVersionableHandle handle, IFolderHandle parent, String name) {
        Assert.isNotNull((Object)handle);
        Assert.isTrue((!handle.hasFullState() ? 1 : 0) != 0);
        Assert.isTrue((parent == null || !parent.hasFullState() ? 1 : 0) != 0);
        Assert.isTrue((parent == null == (name == null) ? 1 : 0) != 0);
        Assert.isTrue((parent == null || handle.hasStateId() ? 1 : 0) != 0);
        Assert.isTrue((parent != null || !handle.hasStateId() || handle instanceof IFolderHandle ? 1 : 0) != 0);
    }

    public IVersionableHandle getVersionableHandle() {
        return this.handle;
    }

    public boolean isFolder() {
        return this.handle instanceof IFolderHandle;
    }

    public long getLastModification() {
        return this.lastModification;
    }

    public IFolderHandle getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public HashCode getHash() {
        return this.hash;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public LineDelimiter getOriginalLineDelimiter() {
        return this.originalLineDelimiter;
    }

    public LineDelimiter getLineDelimiter() {
        return this.lineDelimiter;
    }

    public String getOriginalContentType() {
        return this.originalContentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public UUID getStoredDeltaPredecessor() {
        return this.deltaPredecessor;
    }

    public UUID getStoredContentId() {
        return this.contentId;
    }

    public long getStoredSize() {
        return this.sizeInRepo;
    }

    public String getStoredEncoding() {
        return this.encoding;
    }

    public long getStoredChecksum() {
        return this.checksum;
    }

    public long getStoredNumLineDelimiters() {
        return this.numLineDelimiters;
    }

    public boolean isExecutable() {
        return this.executable;
    }

    public boolean isOriginalExecutable() {
        return this.originalExecutable;
    }
}

