/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.FileContentInputStreamProvider;
import com.ibm.team.filesystem.client.internal.MimeTypeUtil;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.common.changemodel.VersionablePathSegment;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.Date;

public class ClientFileStateFactory {
    public static FileState create(ITeamRepository repo, IVersionable item) {
        if (item == null) {
            return FileState.getDeletedState();
        }
        if (item instanceof IFileItem) {
            IFileItem fileItem = (IFileItem)item;
            return ClientFileStateFactory.getFileState(repo, fileItem);
        }
        if (item instanceof IFolder) {
            return FileState.createFolderState((VersionablePathSegment)VersionablePathSegment.pathFor((IVersionable)item), (Date)item.modified(), (boolean)false, (StateId)StateId.forItem((IItem)item));
        }
        return FileState.getDeletedState().withPath(VersionablePathSegment.pathFor((IVersionable)item));
    }

    private static FileState getFileState(ITeamRepository repo, IFileItem item) {
        IContent content = item.getContent();
        String mimeType = content.getContentType();
        LineDelimiter delimiter = content.getLineDelimiter();
        boolean isText = MimeTypeUtil.isText(mimeType);
        FileContentInputStreamProvider inputStreamProvider = new FileContentInputStreamProvider(repo, content);
        return FileState.create((VersionablePathSegment)VersionablePathSegment.pathFor((IVersionable)item), (Date)item.getFileTimestamp(), (IInputStreamProvider)inputStreamProvider, (boolean)item.isExecutable(), (String)mimeType, (LineDelimiter)delimiter, (boolean)isText, (String)content.getCharacterEncoding(), (boolean)false, (StateId)StateId.forItem((IItem)item));
    }
}

