/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.restproxy.notification;

import com.ibm.team.filesystem.client.restproxy.HttpClientWrapper;
import com.ibm.team.filesystem.client.restproxy.IClientNotificationChannel;
import com.ibm.team.filesystem.client.restproxy.INotificationListener;
import com.ibm.team.filesystem.client.restproxy.notification.KeyInUseException;
import com.ibm.team.filesystem.client.restproxy.notification.Notification;
import com.ibm.team.filesystem.client.restproxy.notification.NotificationJob;
import com.ibm.team.filesystem.client.restproxy.notification.NotificationMarshaller;
import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.transport.IParameterWrapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientNotificationChannel
implements NotificationMarshaller.ITypeFinder,
IClientNotificationChannel {
    private static final Log log = LogFactory.getLog((String)ClientNotificationChannel.class.getName());
    private static final String AUTO_PREFIX = "auto." + System.currentTimeMillis() + ".";
    long keyCounter = 0L;
    public static String KEY_ALL = "all";
    private final Map<String, Set<INotificationListener>> listeners = new HashMap<String, Set<INotificationListener>>();
    private final Map<String, Class<?>> types = new HashMap();
    private final String baseUri;
    private final String key;
    private final HttpClientWrapper client;
    private final Object jobLock = new Object();
    protected NotificationJob job;

    public ClientNotificationChannel(String baseUri, String secretKey, HttpClientWrapper client) {
        this.baseUri = baseUri;
        this.key = secretKey;
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String addListener(String key, INotificationListener l, boolean keyMustBeUnique) throws KeyInUseException {
        if (keyMustBeUnique && key != null && key.equals(KEY_ALL)) {
            throw new IllegalArgumentException("KEY_ALL cannot be unique");
        }
        Map<String, Set<INotificationListener>> map = this.listeners;
        synchronized (map) {
            if (key == null) {
                key = this.generateUniqueKey();
            }
            Set<INotificationListener> list = this.listeners.get(key);
            if (keyMustBeUnique && list != null) {
                throw new KeyInUseException();
            }
            if (list == null) {
                list = new HashSet<INotificationListener>();
                this.listeners.put(key, list);
            }
            list.add(l);
            this.connect();
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() {
        String uri = String.valueOf(this.baseUri) + "notification/";
        Object object = this.jobLock;
        synchronized (object) {
            if (this.job == null) {
                this.job = new NotificationJob("ClientNotificationChannel: " + this.baseUri, this.key, this, uri);
            }
            this.job.connect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateUniqueKey() {
        Map<String, Set<INotificationListener>> map = this.listeners;
        synchronized (map) {
            String key;
            while (this.listeners.containsKey(key = String.valueOf(AUTO_PREFIX) + this.keyCounter++)) {
            }
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addType(String typeName, Class<? extends IParameterWrapper> toInstantiate) {
        Map<String, Class<?>> map = this.types;
        synchronized (map) {
            if (this.types.containsKey(typeName)) {
                Class<?> other = this.types.get(typeName);
                if (!other.equals(toInstantiate)) {
                    throw new IllegalStateException("Type name already registered to " + this.types.get(typeName).getCanonicalName());
                }
                return;
            }
            this.types.put(typeName, toInstantiate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeType(String typeName, Class<? extends IParameterWrapper> toRemove) {
        Map<String, Class<?>> map = this.types;
        synchronized (map) {
            Class<?> oldType = this.types.get(typeName);
            if (oldType == null) {
                throw new IllegalStateException("Type named \"" + typeName + "\" not registered");
            }
            if (!oldType.equals(toRemove)) {
                throw new IllegalStateException("Type mismatch on removal. Have " + oldType.getCanonicalName() + ", but told to remove " + toRemove);
            }
            this.types.remove(typeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(String key, INotificationListener l) {
        Map<String, Set<INotificationListener>> map = this.listeners;
        synchronized (map) {
            Set<INotificationListener> list = this.listeners.get(key);
            list.remove(l);
            if (list.isEmpty()) {
                this.listeners.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect() {
        Object object = this.listeners;
        synchronized (object) {
            if (!this.listeners.isEmpty()) {
                throw new IllegalStateException("Cannot disconnect notification channel while listeners are present");
            }
        }
        object = this.jobLock;
        synchronized (object) {
            if (this.job == null) {
                return;
            }
            this.job.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notificationReceived(Notification notification) throws IOException {
        Map<String, Set<INotificationListener>> map = this.listeners;
        synchronized (map) {
            this.inform(KEY_ALL, notification);
            this.inform(notification.key, notification);
        }
    }

    private void inform(String key, Notification notification) {
        Set<INotificationListener> list = this.listeners.get(key);
        if (list == null) {
            return;
        }
        for (INotificationListener listener : list) {
            try {
                listener.notificationReceived(key, notification);
            }
            catch (Throwable e) {
                log.error((Object)("Exception thrown while running listener for " + key), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> findTypeFor(String s) {
        Map<String, Class<?>> map = this.types;
        synchronized (map) {
            return this.types.get(s);
        }
    }

    public HttpClientWrapper getClient() {
        return this.client;
    }
}

