/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.daemon;

import com.ibm.team.filesystem.client.daemon.events.ILightweightEventListener;
import com.ibm.team.filesystem.client.daemon.events.LightweightEventSource;
import com.ibm.team.filesystem.client.internal.http.HttpContext;
import com.ibm.team.filesystem.client.internal.http.HttpHandler;
import com.ibm.team.filesystem.client.internal.http.HttpRequest;
import com.ibm.team.filesystem.client.internal.http.HttpResponse;
import com.ibm.team.filesystem.client.internal.http.HttpServer;
import com.ibm.team.filesystem.client.internal.http.constants.HttpMethod;
import com.ibm.team.filesystem.client.internal.http.constants.ResponseCode;
import com.ibm.team.filesystem.client.restproxy.notification.IServerNotificationChannel;
import com.ibm.team.filesystem.client.restproxy.notification.NotificationEvent;
import com.ibm.team.filesystem.client.restproxy.notification.NotificationQueuedEvent;
import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.transport.IParameterWrapper;
import com.ibm.team.repository.common.utils.UnsynchronizedByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.FileLock;
import java.security.SecureRandom;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.RegistryFactory;

public class FSDaemon {
    private static final Log log = LogFactory.getLog((String)FSDaemon.class.getName());
    private static final String LOCK_PATH = ".metadata" + File.separator + ".jazzlock";
    private static final String LOCATION_PATH = ".metadata" + File.separator + ".jazzwhere";
    private static final int KEY_SIZE = 16;
    protected File cfaPath;
    protected RandomAccessFile lockRAF;
    protected FileLock lock;
    protected volatile HttpServer server;
    protected ILockFile location = null;
    protected volatile IServerNotificationChannel notifier;
    private final IServerNotificationChannel notifierWrapper = new IServerNotificationChannel(){
        LightweightEventSource<NotificationEvent> eventManager = new LightweightEventSource();

        @Override
        public void manage(HttpRequest rq, HttpResponse resp) throws IOException {
            IServerNotificationChannel notifier = FSDaemon.this.notifier;
            if (notifier == null) {
                resp.setCode(ResponseCode.NOT_FOUND.getCode(), ResponseCode.NOT_FOUND.getDefaultText());
                return;
            }
            notifier.manage(rq, resp);
        }

        @Override
        public void queueNotification(String key, String type, IParameterWrapper notification) {
            IServerNotificationChannel notifier = FSDaemon.this.notifier;
            if (notifier == null) {
                return;
            }
            this.eventManager.fireEvent(new NotificationQueuedEvent(notifier, type));
            notifier.queueNotification(key, type, notification);
        }

        @Override
        public void addListener(ILightweightEventListener<NotificationEvent> l) {
            this.eventManager.addListener(l);
        }

        @Override
        public void removeListener(ILightweightEventListener<NotificationEvent> l) {
            this.eventManager.removeListener(l);
        }

        @Override
        public FSDaemon getFSDaemon() {
            return FSDaemon.this;
        }
    };
    protected static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public FSDaemon(File cfaPath) {
        this.cfaPath = cfaPath;
    }

    public int start() {
        return this.start(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int start(ILifecycleListener lifecycleListener) {
        try {
            if (!this.acquireLock()) {
                return 1;
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return 1;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        {
            HttpServer srv;
            this.server = srv = new HttpServer();
            srv.bind(new InetSocketAddress(InetAddress.getByName(null), 0));
            int port = srv.getLocalPort();
            byte[] key = new byte[16];
            this.writeLocation(port, key);
            this.location = new LockFile(FSDaemon.generateKeyString(key), port);
            if (!this.loadHandlers()) {
                return 1;
            }
            if (lifecycleListener != null) {
                lifecycleListener.initialized(this);
            }
            srv.run(this.location.getKey());
            return 0;
        }
    }

    private void writeLocation(int port, byte[] key) throws IOException {
        UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(12);
        DataOutputStream dout = new DataOutputStream((OutputStream)out);
        dout.writeInt(port);
        SecureRandom rnd = new SecureRandom();
        rnd.nextBytes(key);
        dout.write(key);
        dout.flush();
        File locationPath = FSDaemon.generateLocationFile(this.cfaPath);
        FileOutputStream locationFile = new FileOutputStream(locationPath);
        try {
            locationFile.write(out.getBuffer(), 0, out.size());
        }
        finally {
            try {
                locationFile.close();
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected boolean loadHandlers() {
        IConfigurationElement[] configs = RegistryFactory.getRegistry().getConfigurationElementsFor("com.ibm.team.filesystem.client.daemon", "httphandler");
        HttpServer srv = this.server;
        try {
            IConfigurationElement[] iConfigurationElementArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement config = iConfigurationElementArray[n2];
                HttpHandler handler = (HttpHandler)config.createExecutableExtension("class");
                IConfigurationElement[] methods = config.getChildren("method");
                ArrayList<HttpContext> contexts = new ArrayList<HttpContext>(methods.length);
                IConfigurationElement[] iConfigurationElementArray2 = config.getChildren("method");
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement methodConfig = iConfigurationElementArray2[n4];
                    String path = methodConfig.getAttribute("path");
                    HttpMethod method = HttpMethod.valueOf(methodConfig.getAttribute("type"));
                    HttpContext ctx = new HttpContext(method, path, handler);
                    srv.addContext(ctx);
                    contexts.add(ctx);
                    ++n4;
                }
                handler.registered(this, srv, contexts);
                ++n2;
            }
        }
        catch (CoreException e) {
            log.error((Object)"Failed to load handlers", (Throwable)e);
            return false;
        }
        return true;
    }

    protected void cleanUp() {
        HttpServer srv;
        if (this.lock != null) {
            this.lock = null;
        }
        if ((srv = this.server) != null) {
            try {
                srv.cleanUp();
                this.server = null;
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        File locationFile = FSDaemon.generateLocationFile(this.cfaPath);
        locationFile.delete();
        if (this.lockRAF != null) {
            try {
                this.lockRAF.close();
                this.lockRAF = null;
            }
            catch (IOException e) {
                log.error((Object)"Failed to close lock file", (Throwable)e);
            }
        }
    }

    protected boolean acquireLock() {
        File lockPath = new File(this.cfaPath, LOCK_PATH);
        if (lockPath.exists()) {
            if (!lockPath.isFile()) {
                log.error((Object)(lockPath + " is not a file"));
                return false;
            }
        } else {
            File lockParent = lockPath.getParentFile();
            if (lockParent.exists()) {
                if (!lockParent.isDirectory()) {
                    log.error((Object)(lockParent + " is not a directory"));
                    return false;
                }
            } else if (!lockParent.mkdirs()) {
                log.error((Object)("Failed to create " + lockParent));
                return false;
            }
            try {
                if (!lockPath.createNewFile()) {
                    log.error((Object)("Failed to create " + lockPath));
                    return false;
                }
            }
            catch (IOException e) {
                log.error((Object)("Failed to create " + lockPath + ": " + e.getMessage()), (Throwable)e);
                return false;
            }
        }
        try {
            this.lockRAF = new RandomAccessFile(lockPath, "rw");
        }
        catch (IOException e) {
            log.error((Object)("Failed to open " + lockPath + ": " + e.getMessage()), (Throwable)e);
            return false;
        }
        try {
            this.lock = this.lockRAF.getChannel().tryLock(0L, 1L, false);
        }
        catch (IOException e) {
            log.error((Object)("Failed to acquire lock on " + lockPath + ": " + e.getMessage()), (Throwable)e);
            return false;
        }
        if (this.lock == null) {
            log.error((Object)("Failed to acquire lock on " + this.cfaPath));
            return false;
        }
        return true;
    }

    public void stop() {
        HttpServer srv = this.server;
        if (srv != null) {
            try {
                srv.shutdown();
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setNotificationChannel(IServerNotificationChannel notifier) {
        this.notifier = notifier;
    }

    public IServerNotificationChannel getNotificationChannel() {
        return this.notifierWrapper;
    }

    public int getPort() {
        return this.server.getLocalPort();
    }

    public String getKey() {
        if (this.location != null) {
            return this.location.getKey();
        }
        return null;
    }

    public static ILockFile readLock(File cfaRoot) throws IOException, InterruptedException {
        File lockPath = new File(cfaRoot, LOCK_PATH);
        File parent = lockPath.getParentFile();
        if (!parent.exists()) {
            return null;
        }
        RandomAccessFile lockFile = new RandomAccessFile(lockPath, "rw");
        FileLock lock = null;
        try {
            try {
                lock = lockFile.getChannel().tryLock(0L, 1L, false);
            }
            finally {
                if (lock != null) {
                    lock.release();
                }
            }
        }
        finally {
            try {
                lockFile.close();
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (lock != null) {
            return null;
        }
        File locationPath = FSDaemon.generateLocationFile(cfaRoot);
        int i = 0;
        while (locationPath.length() < 20L) {
            Thread.sleep(100L);
            if (i++ < 50) continue;
            throw new IOException("Location file is too small after waiting: " + locationPath.getAbsolutePath());
        }
        DataInputStream dis = new DataInputStream(new FileInputStream(locationPath));
        int port = dis.readInt();
        byte[] keyBytes = new byte[16];
        dis.readFully(keyBytes);
        String keyString = FSDaemon.generateKeyString(keyBytes);
        return new LockFile(keyString, port);
    }

    private static final File generateLocationFile(File cfaPath) {
        return new File(cfaPath, LOCATION_PATH);
    }

    private static final String generateKeyString(byte[] key) {
        StringBuilder keyStr = new StringBuilder(key.length * 2);
        byte[] byArray = key;
        int n = key.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            keyStr.append(digits[b >>> 4 & 0xF]);
            keyStr.append(digits[b & 0xF]);
            ++n2;
        }
        return keyStr.toString();
    }

    public ILockFile getLockFile() {
        return this.location;
    }

    public HttpServer getHttpServer() {
        return this.server;
    }

    public static interface ILifecycleListener {
        public void initialized(FSDaemon var1);

        public void shutdown(FSDaemon var1);
    }

    public static interface ILockFile {
        public int getPort();

        public String getKey();
    }

    private static class LockFile
    implements ILockFile {
        final String key;
        final int port;

        private LockFile(String k, int p) {
            this.key = k;
            this.port = p;
        }

        public String getKey() {
            return this.key;
        }

        public int getPort() {
            return this.port;
        }
    }
}

