/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.ui.internal.itemview;

import com.ibm.team.feed.core.ChannelEvent;
import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.IChannelListener;
import com.ibm.team.feed.core.INewsListener;
import com.ibm.team.feed.core.NewsEvent;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.feed.ui.internal.FeedUIPlugin;
import com.ibm.team.jface.GenericAggregationBin;
import com.ibm.team.jface.itemview.ItemViewer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;

public class ItemViewerContentProvider
implements IStructuredContentProvider {
    private HashMap fGenericAggBins;
    private final Map fNewsListener = new HashMap();
    private final List fChannelListener = new ArrayList();
    private Object fInput;

    public void dispose() {
        this.unregister();
    }

    public Object[] getElements(Object inputElement) {
        if (this.fGenericAggBins != null) {
            this.fGenericAggBins.clear();
        }
        if (this.fInput instanceof Channel[]) {
            ArrayList elements = new ArrayList();
            Channel[] channels = (Channel[])this.fInput;
            int i = 0;
            while (i < channels.length) {
                Channel channel = channels[i];
                elements.addAll(Arrays.asList(channel.getItems()));
                ++i;
            }
            return this.aggregateEvents(elements.toArray(new NewsItem[elements.size()]));
        }
        if (this.fInput instanceof Object[]) {
            return (Object[])this.fInput;
        }
        return new Object[0];
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.unregister();
        this.fInput = newInput;
        this.register(viewer);
    }

    private void register(final Viewer viewer) {
        if (this.fInput instanceof Channel[]) {
            final Channel[] channels = (Channel[])this.fInput;
            int i = 0;
            while (i < channels.length) {
                INewsListener newsListener = new INewsListener(){

                    public void newsReceived(NewsEvent event) {
                        ItemViewerContentProvider.this.refreshViewer(viewer);
                    }

                    public void newsRemoved(NewsEvent event) {
                        ItemViewerContentProvider.this.refreshViewer(viewer);
                    }

                    public void newsStateChanged(NewsEvent event) {
                        NewsItem[] items;
                        HashSet<String> toUpdate = new HashSet<String>();
                        NewsItem[] newsItemArray = items = event.getChangedNews();
                        int n = items.length;
                        int n2 = 0;
                        while (n2 < n) {
                            NewsItem item = newsItemArray[n2];
                            Object object = ((GenericAggregationBin)ItemViewerContentProvider.this.fGenericAggBins.get(item.getLink())).getMostRecent();
                            if (object != null) {
                                toUpdate.add(String.valueOf(object.hashCode()));
                            }
                            ++n2;
                        }
                        ((ItemViewer)viewer).update(toUpdate.toArray());
                    }
                };
                this.fNewsListener.put(channels[i], newsListener);
                FeedManager.getDefault().addNewsListener(channels[i], newsListener);
                IChannelListener channelListener = new IChannelListener(){

                    public void channelEdited(ChannelEvent event) {
                        boolean affectsViewer = false;
                        int j = 0;
                        while (j < channels.length) {
                            if (channels[j].equals((Object)event.getChannel())) {
                                affectsViewer = true;
                                break;
                            }
                            ++j;
                        }
                        if (affectsViewer) {
                            ItemViewerContentProvider.this.refreshViewer(viewer);
                        }
                    }

                    public void channelStatusChanged(ChannelEvent event) {
                    }
                };
                this.fChannelListener.add(channelListener);
                FeedManager.getDefault().addChannelListener(channelListener);
                ++i;
            }
        }
    }

    private void addNewsToBin(NewsItem item) {
        String key = item.getLink();
        if (item != null && this.fGenericAggBins.containsKey(key)) {
            GenericAggregationBin bin = (GenericAggregationBin)this.fGenericAggBins.get(key);
            bin.add((Object)item);
        } else {
            GenericAggregationBin bin = new GenericAggregationBin();
            bin.add((Object)item);
            this.fGenericAggBins.put(key, bin);
        }
    }

    private GenericAggregationBin[] aggregateEvents(NewsItem[] items) {
        if (this.fGenericAggBins == null) {
            this.fGenericAggBins = new HashMap();
        }
        int i = 0;
        while (i < items.length) {
            NewsItem item = items[i];
            if (item != null) {
                this.addNewsToBin(item);
            }
            ++i;
        }
        return this.fGenericAggBins.values().toArray(new GenericAggregationBin[this.fGenericAggBins.size()]);
    }

    private void refreshViewer(final Viewer viewer) {
        Control control = viewer.getControl();
        if (control != null && !control.isDisposed()) {
            control.getDisplay().syncExec(new Runnable(){

                public void run() {
                    SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

                        public void run() throws Exception {
                            viewer.refresh();
                        }

                        public void handleException(Throwable exception) {
                            if (exception instanceof Exception) {
                                FeedUIPlugin.getDefault().log(exception.getMessage(), (Exception)exception);
                            }
                        }
                    });
                }
            });
        }
    }

    private void unregister() {
        if (this.fInput == null) {
            return;
        }
        if (this.fInput instanceof Channel[]) {
            Set keys = this.fNewsListener.keySet();
            for (Channel channel : keys) {
                INewsListener newsListener = (INewsListener)this.fNewsListener.get(channel);
                FeedManager.getDefault().removeNewsListener(channel, newsListener);
            }
            for (IChannelListener channelListener : this.fChannelListener) {
                FeedManager.getDefault().removeChannelListener(channelListener);
            }
            this.fChannelListener.clear();
            this.fNewsListener.clear();
        }
    }
}

