/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.ui.internal.itemview;

import com.ibm.team.feed.core.ChannelEvent;
import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.IChannelListener;
import com.ibm.team.feed.core.INewsListener;
import com.ibm.team.feed.core.NewsEvent;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.foundation.rcp.core.IDateProvider;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.jface.itemview.MarkupItemView;
import com.ibm.team.jface.timeline.Range;
import com.ibm.team.jface.timeline.TimelineContentProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.Viewer;

public class DefaultTimelineContentProvider
extends TimelineContentProvider {
    private final Map fNewsListener = new HashMap();
    private final List fChannelListener = new ArrayList();
    private Object fInput;

    public int getElementCount(Object inputElement, Range range) {
        int count;
        block4: {
            block3: {
                count = 0;
                if (!(this.fInput instanceof Channel[])) break block3;
                Channel[] channels = (Channel[])this.fInput;
                int i = 0;
                while (i < channels.length) {
                    Channel channel = channels[i];
                    count += this.getAggregatedElementCount(channel, range);
                    ++i;
                }
                break block4;
            }
            if (!(this.fInput instanceof Object[])) break block4;
            Object[] elements = (Object[])this.fInput;
            int i = 0;
            while (i < elements.length) {
                Date d = this.getDate(elements[i]);
                if (d != null && range.contains(d.getTime())) {
                    ++count;
                }
                ++i;
            }
        }
        return count;
    }

    private int getAggregatedElementCount(Channel channel, Range range) {
        int count = 0;
        HashMap<String, NewsItem> linkToItem = new HashMap<String, NewsItem>();
        NewsItem[] items = channel.getItems();
        int i = 0;
        while (i < items.length) {
            NewsItem item = items[i];
            String key = item.getLink();
            Date d = item.getPublishDate();
            if (linkToItem.containsKey(key)) {
                NewsItem existing = (NewsItem)linkToItem.get(key);
                if (d != null && d.after(existing.getPublishDate())) {
                    linkToItem.put(key, item);
                }
            } else {
                linkToItem.put(key, item);
            }
            ++i;
        }
        Collection collection = linkToItem.values();
        for (NewsItem item : collection) {
            if (!range.contains(item.getPublishDate().getTime())) continue;
            ++count;
        }
        return count;
    }

    public Date getDate(Object element) {
        IAdaptable adaptable;
        Object provider;
        if (element instanceof IDateProvider) {
            return ((IDateProvider)element).getDate();
        }
        if (element instanceof IAdaptable && (provider = (adaptable = (IAdaptable)element).getAdapter(IDateProvider.class)) != null) {
            return ((IDateProvider)provider).getDate();
        }
        IDateProvider dateProvider = MarkupItemView.getDateProvider((Object)element);
        if (dateProvider != null) {
            return dateProvider.getDate();
        }
        if (element instanceof Date) {
            return (Date)element;
        }
        return null;
    }

    public void dispose() {
        this.unregister();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.unregister();
        this.fInput = newInput;
        this.register(viewer);
    }

    private void register(final Viewer viewer) {
        if (this.fInput instanceof Channel[]) {
            final Channel[] channels = (Channel[])this.fInput;
            int i = 0;
            while (i < channels.length) {
                INewsListener newsListener = new INewsListener(){

                    public void newsReceived(NewsEvent event) {
                        DefaultTimelineContentProvider.this.refreshViewer(viewer);
                    }

                    public void newsRemoved(NewsEvent event) {
                        DefaultTimelineContentProvider.this.refreshViewer(viewer);
                    }

                    public void newsStateChanged(NewsEvent event) {
                        DefaultTimelineContentProvider.this.refreshViewer(viewer);
                    }
                };
                this.fNewsListener.put(channels[i], newsListener);
                FeedManager.getDefault().addNewsListener(channels[i], newsListener);
                IChannelListener channelListener = new IChannelListener(){

                    public void channelEdited(ChannelEvent event) {
                        boolean affectsViewer = false;
                        int j = 0;
                        while (j < channels.length) {
                            if (channels[j].equals((Object)event.getChannel())) {
                                affectsViewer = true;
                                break;
                            }
                            ++j;
                        }
                        if (affectsViewer) {
                            DefaultTimelineContentProvider.this.refreshViewer(viewer);
                        }
                    }

                    public void channelStatusChanged(ChannelEvent event) {
                        boolean affectsViewer = false;
                        int j = 0;
                        while (j < channels.length) {
                            if (channels[j].equals((Object)event.getChannel())) {
                                affectsViewer = true;
                                break;
                            }
                            ++j;
                        }
                        if (affectsViewer) {
                            DefaultTimelineContentProvider.this.refreshViewer(viewer);
                        }
                    }
                };
                this.fChannelListener.add(channelListener);
                FeedManager.getDefault().addChannelListener(channelListener);
                ++i;
            }
        }
    }

    private void refreshViewer(final Viewer viewer) {
        FoundationUIJob job = new FoundationUIJob(""){

            public IStatus runProtectedInUI(IProgressMonitor monitor) {
                viewer.refresh();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private void unregister() {
        if (this.fInput == null) {
            return;
        }
        if (this.fInput instanceof Channel[]) {
            Set keys = this.fNewsListener.keySet();
            for (Channel channel : keys) {
                INewsListener newsListener = (INewsListener)this.fNewsListener.get(channel);
                FeedManager.getDefault().removeNewsListener(channel, newsListener);
            }
            for (IChannelListener channelListener : this.fChannelListener) {
                FeedManager.getDefault().removeChannelListener(channelListener);
            }
            this.fChannelListener.clear();
            this.fNewsListener.clear();
        }
    }
}

