/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.ui.internal.dashboard;

import com.ibm.team.feed.core.ChannelEvent;
import com.ibm.team.feed.core.ClientFeedUtils;
import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.IChannelListener;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.feed.ui.internal.OpenNewsAction;
import com.ibm.team.feed.ui.internal.dashboard.Messages;
import com.ibm.team.feed.ui.internal.dashboard.NewsFilter;
import com.ibm.team.jface.GenericAggregationBin;
import com.ibm.team.jface.dashboard.ISectionSite;
import com.ibm.team.jface.tooltip.INavigatorContent;
import com.ibm.team.jface.tooltip.NavigatorContentAdapter;
import com.ibm.team.jface.tooltip.SlideoutSupport;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.repository.common.util.NLS;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class NewsTableViewer
extends TableViewer {
    private static final String BUILD_CATEGORY = "com.ibm.team.build.category.BuildResultChanged";
    private IChannelListener fChannelListener;
    private ISectionSite fSectionSite;
    private TooltipSupport fTooltipSupport;
    private SlideoutSupport fSlideoutSupport;
    private static final int BASE_WIDTH = 190;
    private static final float SIDE_RATIO = 0.4f;

    public NewsTableViewer(ISectionSite sectionSite, Table table, final int iconWidth) {
        super(table);
        this.fSectionSite = sectionSite;
        this.fSlideoutSupport = new SlideoutSupport((Control)this.getTable(), (ISelectionProvider)this, sectionSite.getName(), true){

            protected INavigatorContent convertSelectionToNavigatorContent(ISelection selection) {
                if (NewsTableViewer.this.getTable().getSelection().length != 1) {
                    return null;
                }
                Object data = NewsTableViewer.this.getTable().getSelection()[0].getData();
                if (data instanceof GenericAggregationBin) {
                    GenericAggregationBin bin = (GenericAggregationBin)data;
                    List items = bin.getItems();
                    Collections.sort(items, new Comparator<NewsItem>(){

                        @Override
                        public int compare(NewsItem o1, NewsItem o2) {
                            return o1.getPublishDate().compareTo(o2.getPublishDate());
                        }
                    });
                    NewsItem firstUnreadItem = null;
                    NewsItem current = (NewsItem)bin.getMostRecent();
                    int unreadCount = 0;
                    for (NewsItem newsItem : items) {
                        if (newsItem.isIsRead()) continue;
                        ++unreadCount;
                        if (firstUnreadItem != null) continue;
                        firstUnreadItem = newsItem;
                    }
                    if (firstUnreadItem != null && !NewsTableViewer.BUILD_CATEGORY.equals(current.getCategory())) {
                        current = firstUnreadItem;
                    }
                    return new NavigatorContentAdapter(items, (Object)current, unreadCount);
                }
                return null;
            }

            protected void openRequested(Object element) {
                if (element instanceof GenericAggregationBin) {
                    element = ((GenericAggregationBin)element).getMostRecent();
                }
                if (element instanceof NewsItem) {
                    new OpenNewsAction(NewsTableViewer.this.fSectionSite, (NewsItem)element).run();
                }
            }
        };
        this.fTooltipSupport = new TooltipSupport((Control)this.getTable(), false, false){
            private boolean fShowRelation;

            protected Object mapElement(int x, int y) {
                TableItem hoveredItem = NewsTableViewer.this.getTable().getItem(new Point(x, y));
                if (hoveredItem == null) {
                    return null;
                }
                Rectangle bounds = hoveredItem.getImageBounds(0);
                if (bounds.isEmpty()) {
                    bounds.width = iconWidth;
                    bounds.height = 16;
                }
                this.fShowRelation = x - bounds.x > 16 && x - bounds.x < 32;
                this.setUseBrowser(false);
                Object data = hoveredItem.getData();
                if (data instanceof GenericAggregationBin) {
                    GenericAggregationBin bin = (GenericAggregationBin)data;
                    Object mostRecent = bin.getMostRecent();
                    return mostRecent;
                }
                return data;
            }

            protected String getMarkup(Object element, boolean isFocus) {
                if (!(element instanceof NewsItem)) {
                    return Messages.getString("NewsTableViewer.UNKNOWN_ITEM");
                }
                NewsItem newsItem = (NewsItem)element;
                if (this.fShowRelation) {
                    String relation = ClientFeedUtils.getInstance().getRelation(newsItem);
                    return NLS.bind((String)Messages.getString("NewsTableViewer.SUBJECT_RELATION"), (Object[])new Object[]{relation != null ? relation : "unknown"});
                }
                return newsItem.getTitle();
            }
        };
        this.fTooltipSupport.setPreferredHoverSize(new Point(190, 76));
        this.initChannelListener();
    }

    public Object[] getFilteredChildren(Object parent) {
        return super.getFilteredChildren(parent);
    }

    public TooltipSupport getTooltipSupport() {
        return this.fTooltipSupport;
    }

    public SlideoutSupport getSlideoutSupport() {
        return this.fSlideoutSupport;
    }

    public void dispose() {
        FeedManager.getDefault().removeChannelListener(this.fChannelListener);
    }

    public void remove(Object element) {
        IStructuredSelection structuredSelection;
        int selectionIndex = -1;
        Table table2 = this.getTable();
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && structuredSelection.getFirstElement() == element) {
            selectionIndex = table2.getSelectionIndex();
        }
        super.remove(element);
        if (selectionIndex >= 0 && selectionIndex < table2.getItemCount()) {
            this.setSelection((ISelection)new StructuredSelection(table2.getItem(selectionIndex).getData()));
        } else if (selectionIndex == table2.getItemCount() && table2.getItemCount() > 0) {
            this.setSelection((ISelection)new StructuredSelection(table2.getItem(selectionIndex - 1).getData()));
        }
    }

    protected Object[] getSortedChildren(Object parent) {
        Object[] result = super.getSortedChildren(parent);
        int i = 0;
        while (i < this.getFilters().length) {
            NewsFilter newsFilter;
            ViewerFilter filter = this.getFilters()[i];
            if (filter instanceof NewsFilter && (newsFilter = (NewsFilter)filter).isFilterByNumber() && result.length > 5) {
                Object[] cutResult = new Object[5];
                System.arraycopy(result, 0, cutResult, 0, 5);
                return cutResult;
            }
            ++i;
        }
        return result;
    }

    private void initChannelListener() {
        this.fChannelListener = new IChannelListener(){

            public void channelEdited(ChannelEvent event) {
                if (event.redraw) {
                    NewsTableViewer.this.refreshAsynced();
                }
            }

            public void channelStatusChanged(ChannelEvent event) {
            }
        };
        FeedManager.getDefault().addChannelListener(this.fChannelListener);
    }

    private void refreshAsynced() {
        if (!this.getTable().getDisplay().isDisposed()) {
            this.getTable().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!NewsTableViewer.this.getTable().isDisposed()) {
                        NewsTableViewer.this.refresh();
                        NewsTableViewer.this.getTable().redraw();
                    }
                }
            });
        }
    }
}

