/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.ui;

import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.TempChannel;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.ui.internal.FeedUIPlugin;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIUtils;
import com.ibm.team.jface.itemview.MarkupItemViewInput;
import java.net.URL;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class FeedUI {
    public static void openRecentItemView(IWorkbenchPage page, URL feedUrl, String title, String status) {
        Channel[] channels = new Channel[1];
        String inputId = "recent:" + feedUrl.toString();
        MarkupItemViewInput input = new MarkupItemViewInput((Object)channels, title, inputId, true);
        IEditorPart editor = page.findEditor((IEditorInput)input);
        if (editor == null) {
            TempChannel channel = FeedManager.getDefault().addTempChannel(feedUrl, title);
            channels[0] = channel;
            input.setTitle(title);
            input.setDisposeTempChannelsOnClose(true);
            input.setStatusLabel(status);
            FeedUI.openItemView(page, input);
        } else {
            page.activate((IWorkbenchPart)editor);
        }
    }

    public static void openItemView(IWorkbenchPage page, MarkupItemViewInput input) {
        String editorId = "com.ibm.team.jface.MarkupItemView";
        if (page == null) {
            page = FoundationUIUtils.getActivePage();
        }
        if (page != null) {
            IEditorPart editor = page.findEditor((IEditorInput)input);
            if (editor != null && !editor.isDirty() && editor instanceof IReusableEditor) {
                ((IReusableEditor)editor).setInput((IEditorInput)input);
                try {
                    page.openEditor((IEditorInput)input, editor.getSite().getId());
                }
                catch (PartInitException e) {
                    FeedUIPlugin.getDefault().log("can't open markup item view", (Exception)((Object)e));
                }
            } else {
                try {
                    page.openEditor((IEditorInput)input, editorId);
                }
                catch (PartInitException e) {
                    FeedUIPlugin.getDefault().log("can't open markup item view", (Exception)((Object)e));
                }
            }
        }
    }
}

