/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.dashboard.internal.rcp.ui.editor;

import com.ibm.team.dashboard.internal.rcp.ui.editor.AbstractDashboardAspectEditor;
import com.ibm.team.dashboard.internal.rcp.ui.editor.DashboardImages;
import com.ibm.team.dashboard.internal.rcp.ui.editor.Messages;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.repository.client.ILicenseClient;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.internal.misc.StatusUtil;

public class DashboardTemplatesAspectEditor
extends AbstractDashboardAspectEditor {
    private TreeViewer viewer;
    private int newPageCount = 0;
    Action ACTION_ADD_COLUMN = new Action(){

        public void run() {
            AbstractDashboardAspectEditor.DashboardElement element = DashboardTemplatesAspectEditor.this.getCurrentElement();
            if (element instanceof PageElement) {
                PageElement page = (PageElement)element;
                ColumnElement newColumn = new ColumnElement(DashboardTemplatesAspectEditor.this.model, (AbstractDashboardAspectEditor.DashboardElement)page, null);
                page.addChild(newColumn);
                DashboardTemplatesAspectEditor.this.getTreeViewer().refresh((Object)page);
                DashboardTemplatesAspectEditor.this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)newColumn));
                DashboardTemplatesAspectEditor.this.setDirty();
            }
        }

        public String getText() {
            return Messages.actionAddColumn;
        }

        public ImageDescriptor getImageDescriptor() {
            return DashboardImages.DESC_COLUMN_OBJ;
        }
    };
    Action ACTION_CREATE_TEMPLATE = new Action(){

        public void run() {
            AbstractDashboardAspectEditor.DashboardElement element = DashboardTemplatesAspectEditor.this.getCurrentElement();
            if (element instanceof TemplateElement) {
                TemplateElement template = (TemplateElement)element;
                ((TemplateElement)element).exists = true;
                IDetailsPage page = DashboardTemplatesAspectEditor.this.block.getCurrentPage();
                if (page instanceof TemplateDetailsPart) {
                    TemplateDetailsPart part = (TemplateDetailsPart)page;
                    if (part.title != null) {
                        part.title.text.setText(template.getDefaultTitle());
                    }
                    template.validatePages();
                    part.updatePage(template);
                }
                DashboardTemplatesAspectEditor.this.setDirty();
            }
        }

        public String getText() {
            return Messages.actionCreateTemplate;
        }
    };
    Action ACTION_DELETE_TEMPLATE = new Action(){

        public void run() {
            AbstractDashboardAspectEditor.DashboardElement element = DashboardTemplatesAspectEditor.this.getCurrentElement();
            if (element instanceof TemplateElement) {
                TemplateElement template = (TemplateElement)element;
                template.exists = false;
                template.resetTitle();
                template.children = new ArrayList();
                IDetailsPage page = DashboardTemplatesAspectEditor.this.block.getCurrentPage();
                if (page instanceof TemplateDetailsPart) {
                    ((TemplateDetailsPart)page).updatePage(element);
                }
                DashboardTemplatesAspectEditor.this.getTreeViewer().refresh((Object)template);
                DashboardTemplatesAspectEditor.this.setDirty();
            }
        }

        public String getText() {
            return Messages.actionDeleteTemplate;
        }
    };
    Action ACTION_ADD_PAGE = new Action(){

        public void run() {
            AbstractDashboardAspectEditor.DashboardElement element = DashboardTemplatesAspectEditor.this.getCurrentElement();
            if (element instanceof TemplateElement) {
                TemplateElement template = (TemplateElement)element;
                AbstractDashboardAspectEditor.DashboardModel dashboardModel = DashboardTemplatesAspectEditor.this.model;
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.defaultPageTitle));
                DashboardTemplatesAspectEditor dashboardTemplatesAspectEditor = DashboardTemplatesAspectEditor.this;
                int n = dashboardTemplatesAspectEditor.newPageCount + 1;
                dashboardTemplatesAspectEditor.newPageCount = n;
                PageElement newPage = new PageElement(dashboardModel, (AbstractDashboardAspectEditor.DashboardElement)template, stringBuilder.append(n).toString());
                template.addChild(newPage);
                DashboardTemplatesAspectEditor.this.getTreeViewer().refresh((Object)template);
                DashboardTemplatesAspectEditor.this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)newPage));
                DashboardTemplatesAspectEditor.this.setDirty();
            }
        }

        public String getText() {
            return Messages.actionAddPage;
        }

        public ImageDescriptor getImageDescriptor() {
            return DashboardImages.DESC_PAGE_OBJ;
        }
    };
    Action ACTION_MOVE_UP = new Action(){

        public void run() {
            AbstractDashboardAspectEditor.DashboardElement element = DashboardTemplatesAspectEditor.this.getCurrentElement();
            if (element != null && element.getParent() != null && element.getParent().children.size() > 1) {
                AbstractDashboardAspectEditor.DashboardElement parent = element.getParent();
                ArrayList children = parent.children;
                Object[] expanded = DashboardTemplatesAspectEditor.this.getTreeViewer().getExpandedElements();
                int index = children.indexOf(element);
                if (index != 0) {
                    children.set(index, (AbstractDashboardAspectEditor.DashboardElement)children.get(index - 1));
                    children.set(index - 1, element);
                }
                DashboardTemplatesAspectEditor.this.getTreeViewer().getTree().setRedraw(false);
                DashboardTemplatesAspectEditor.this.getTreeViewer().refresh((Object)parent);
                DashboardTemplatesAspectEditor.this.getTreeViewer().setExpandedElements(expanded);
                DashboardTemplatesAspectEditor.this.getTreeViewer().getTree().setRedraw(true);
                DashboardTemplatesAspectEditor.this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)element));
                DashboardTemplatesAspectEditor.this.setDirty();
            }
        }

        public String getText() {
            return Messages.moveUpActionLabel;
        }

        public ImageDescriptor getImageDescriptor() {
            return DashboardImages.DESC_MOVE_UP;
        }
    };
    Action ACTION_MOVE_DOWN = new Action(){

        public void run() {
            AbstractDashboardAspectEditor.DashboardElement element = DashboardTemplatesAspectEditor.this.getCurrentElement();
            if (element != null && element.getParent() != null && element.getParent().children.size() > 1) {
                AbstractDashboardAspectEditor.DashboardElement parent = element.getParent();
                ArrayList children = parent.children;
                Object[] expanded = DashboardTemplatesAspectEditor.this.getTreeViewer().getExpandedElements();
                int index = children.indexOf(element);
                if (index != children.size() - 1) {
                    children.set(index, (AbstractDashboardAspectEditor.DashboardElement)children.get(index + 1));
                    children.set(index + 1, element);
                }
                DashboardTemplatesAspectEditor.this.getTreeViewer().getTree().setRedraw(false);
                DashboardTemplatesAspectEditor.this.getTreeViewer().refresh((Object)parent);
                DashboardTemplatesAspectEditor.this.getTreeViewer().setExpandedElements(expanded);
                DashboardTemplatesAspectEditor.this.getTreeViewer().getTree().setRedraw(true);
                DashboardTemplatesAspectEditor.this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)element));
                DashboardTemplatesAspectEditor.this.setDirty();
            }
        }

        public String getText() {
            return Messages.moveDownActionLabel;
        }

        public ImageDescriptor getImageDescriptor() {
            return DashboardImages.DESC_MOVE_DOWN;
        }
    };
    private Section section;
    private boolean viewContributor;
    private boolean viewTeam;
    private boolean viewProject;
    private boolean addTab;
    private boolean licenseCheckDone;
    private Hyperlink addMemento;

    protected int getDescriptionHeight() {
        return this.section.getDescriptionControl().getBounds().height;
    }

    protected void createMasterSection(final IManagedForm mform, Composite parent) {
        FormToolkit toolkit = mform.getToolkit();
        this.section = toolkit.createSection(parent, 4224);
        this.section.setDescription(Messages.templateMasterSectionDescription);
        Composite sectionArea = toolkit.createComposite((Composite)this.section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        sectionArea.setLayout((Layout)layout);
        toolkit.paintBordersFor(sectionArea);
        Tree tree = toolkit.createTree(sectionArea, 0);
        GridData gd = new GridData(1808);
        tree.setLayoutData((Object)gd);
        this.viewer = new TreeViewer(tree);
        this.viewer.setContentProvider((IContentProvider)new AbstractDashboardAspectEditor.DashboardContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TemplatesLabelProvider());
        MenuManager popupMenuManager = new MenuManager();
        popupMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mng) {
                DashboardTemplatesAspectEditor.this.fillContextMenu(mng);
            }
        });
        popupMenuManager.setRemoveAllWhenShown(true);
        tree.setMenu(popupMenuManager.createContextMenu((Control)tree));
        Composite buttonArea = toolkit.createComposite(sectionArea);
        gd = new GridData(1040);
        buttonArea.setLayoutData((Object)gd);
        buttonArea.setLayout((Layout)new GridLayout());
        final Button moveUp = toolkit.createButton(buttonArea, Messages.moveUpButtonLabel, 8);
        moveUp.setLayoutData((Object)new GridData(768));
        moveUp.setEnabled(false);
        moveUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardTemplatesAspectEditor.this.ACTION_MOVE_UP.run();
            }
        });
        final Button moveDown = toolkit.createButton(buttonArea, Messages.moveDownButtonLabel, 8);
        moveDown.setLayoutData((Object)new GridData(768));
        moveDown.setEnabled(false);
        moveDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardTemplatesAspectEditor.this.ACTION_MOVE_DOWN.run();
            }
        });
        this.section.setClient((Control)sectionArea);
        final SectionPart spart = new SectionPart(this.section){

            public void refresh() {
                DashboardTemplatesAspectEditor.this.viewer.refresh();
                super.refresh();
            }
        };
        mform.addPart((IFormPart)spart);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                mform.fireSelectionChanged((IFormPart)spart, event.getSelection());
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.size() == 1) {
                    AbstractDashboardAspectEditor.DashboardElement element = (AbstractDashboardAspectEditor.DashboardElement)selection.getFirstElement();
                    moveUp.setEnabled(element.getParent() != null && element.getParent().children.indexOf(element) != 0);
                    moveDown.setEnabled(element.getParent() != null && element.getParent().children.indexOf(element) != element.getParent().children.size() - 1);
                } else {
                    moveUp.setEnabled(false);
                    moveDown.setEnabled(false);
                }
            }
        });
        this.viewer.setInput((Object)this.model);
    }

    private void fillContextMenu(IMenuManager mng) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        AbstractDashboardAspectEditor.DashboardElement element = (AbstractDashboardAspectEditor.DashboardElement)selection.getFirstElement();
        boolean canRemove = false;
        if (element instanceof TemplateElement) {
            TemplateElement template = (TemplateElement)element;
            if (template.exists) {
                mng.add((IAction)this.ACTION_ADD_PAGE);
                mng.add((IContributionItem)new Separator());
                mng.add((IAction)this.ACTION_DELETE_TEMPLATE);
            } else {
                mng.add((IAction)this.ACTION_CREATE_TEMPLATE);
            }
        } else if (element instanceof PageElement) {
            PageElement page = (PageElement)element;
            if (page.canAddColumn()) {
                mng.add((IAction)this.ACTION_ADD_COLUMN);
            }
            if (page.canRemove()) {
                this.ACTION_REMOVE.setExpectedClass(PageElement.class);
                canRemove = true;
            }
        } else if (element instanceof ColumnElement) {
            ColumnElement column = (ColumnElement)element;
            mng.add((IAction)this.ACTION_ADD_VIEWLET);
            if (column.canRemove()) {
                this.ACTION_REMOVE.setExpectedClass(ColumnElement.class);
                canRemove = true;
            }
        } else if (element instanceof AbstractDashboardAspectEditor.ViewletElement) {
            AbstractDashboardAspectEditor.ViewletElement viewlet = (AbstractDashboardAspectEditor.ViewletElement)element;
            if (viewlet.canAddMemento()) {
                mng.add((IAction)this.ACTION_ADD_MEMENTO);
            }
            this.ACTION_REMOVE.setExpectedClass(AbstractDashboardAspectEditor.ViewletElement.class);
            canRemove = true;
        } else if (element instanceof AbstractDashboardAspectEditor.MementoElement) {
            mng.add((IAction)this.ACTION_ADD_MEMENTO_PROPERTY);
            mng.add((IContributionItem)new Separator());
            this.ACTION_REMOVE.setExpectedClass(AbstractDashboardAspectEditor.MementoElement.class);
            canRemove = true;
        } else if (element instanceof AbstractDashboardAspectEditor.MementoValueElement) {
            this.ACTION_REMOVE.setExpectedClass(AbstractDashboardAspectEditor.MementoValueElement.class);
            canRemove = true;
        } else if (element instanceof AbstractDashboardAspectEditor.MementoPropertyElement) {
            AbstractDashboardAspectEditor.MementoPropertyElement property = (AbstractDashboardAspectEditor.MementoPropertyElement)element;
            boolean canAddMemento = property.canAddMemento();
            boolean canAddProperty = property.canAddProperty();
            boolean canAddValue = property.canAddValue();
            if (canAddProperty) {
                mng.add((IAction)this.ACTION_ADD_MEMENTO_PROPERTY);
            }
            if (canAddMemento) {
                mng.add((IAction)this.ACTION_ADD_MEMENTO);
            }
            if (canAddValue) {
                mng.add((IAction)this.ACTION_ADD_MEMENTO_PROPERTY_VALUE);
            }
            if (canAddMemento || canAddValue || canAddProperty) {
                mng.add((IContributionItem)new Separator());
            }
            this.ACTION_REMOVE.setExpectedClass(AbstractDashboardAspectEditor.MementoPropertyElement.class);
            canRemove = true;
        }
        if (!(element instanceof TemplateElement) && element.getParent() != null) {
            boolean canMoveDown;
            ArrayList children = element.getParent().children;
            boolean canMoveUp = children.indexOf(element) != 0;
            boolean bl = canMoveDown = children.indexOf(element) != children.size() - 1;
            if ((canMoveUp || canMoveDown) && !mng.isEmpty()) {
                mng.add((IContributionItem)new Separator());
            }
            if (canMoveUp) {
                mng.add((IAction)this.ACTION_MOVE_UP);
            }
            if (canMoveDown) {
                mng.add((IAction)this.ACTION_MOVE_DOWN);
            }
        }
        if (canRemove) {
            if (!mng.isEmpty()) {
                mng.add((IContributionItem)new Separator());
            }
            mng.add((IAction)this.ACTION_REMOVE);
        }
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        super.createControl(parent, toolkit);
        final Display display = parent.getDisplay();
        Job loadingJob = new Job(Messages.DashboardTemplatesAspectEditor_licenseCheckJob){

            protected IStatus run(IProgressMonitor monitor) {
                ITeamRepository teamRepository = (ITeamRepository)DashboardTemplatesAspectEditor.this.getAspect().getProcessContainerWorkingCopy().getUnderlyingProcessItem().getOrigin();
                ILicenseClient context = (ILicenseClient)teamRepository.getClientLibrary(ILicenseClient.class);
                ArrayList<String> list = new ArrayList<String>();
                list.add("com.ibm.team.dashboard.viewDashboard");
                list.add("com.ibm.team.dashboard.viewPersonalDashboard");
                list.add("com.ibm.team.dashboard.viewProfileDashboard");
                list.add("com.ibm.team.dashboard.viewTeamDashboard");
                list.add("com.ibm.team.dashboard.viewProjectDashboard");
                list.add("com.ibm.team.dashboard.addTab");
                try {
                    String[] result = context.checkLicenses(list, monitor);
                    DashboardTemplatesAspectEditor.this.viewContributor = result[0] == null || result[1] == null || result[2] == null;
                    DashboardTemplatesAspectEditor.this.viewTeam = result[0] == null || result[3] == null;
                    DashboardTemplatesAspectEditor.this.viewProject = result[0] == null || result[4] == null;
                    DashboardTemplatesAspectEditor.this.addTab = result[0] == null || result[5] == null;
                    DashboardTemplatesAspectEditor.this.licenseCheckDone = true;
                }
                catch (TeamRepositoryException e) {
                    return StatusUtil.newStatus((String)Messages.DashboardTemplatesAspectEditor_licenseCheckError, (Throwable)e);
                }
                if (!display.isDisposed()) {
                    display.asyncExec(new Runnable(){

                        public void run() {
                            TreeViewer v = DashboardTemplatesAspectEditor.this.getTreeViewer();
                            if (v != null && v.getTree() != null && !v.getTree().isDisposed()) {
                                IDetailsPage page;
                                if (DashboardTemplatesAspectEditor.this.getCurrentElement() != null && (page = (this).DashboardTemplatesAspectEditor.this.block.getCurrentPage()) instanceof AbstractDashboardAspectEditor.DashboardDetailsPart) {
                                    ((AbstractDashboardAspectEditor.DashboardDetailsPart)page).updateMessage(DashboardTemplatesAspectEditor.this.getCurrentElement());
                                }
                                v.refresh();
                            }
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        loadingJob.schedule();
    }

    protected AbstractDashboardAspectEditor.DashboardModel createModel() {
        return new TemplatesModel();
    }

    protected void addViewletDetailsFields(AbstractDashboardAspectEditor.ViewletDetailsPart detailsPart, FormToolkit toolkit, Composite parent, int span) {
        String type = this.getCurrentTemplateType();
        if (type.equals("contributor")) {
            detailsPart.createElementEntry(toolkit, parent, AbstractDashboardAspectEditor.ViewletElementDef.ATT_PROFILE, span);
        }
    }

    protected void addViewletDetailsLinks(AbstractDashboardAspectEditor.ViewletDetailsPart detailsPart, final FormToolkit toolkit, Composite parent, int span) {
        this.addMemento = toolkit.createHyperlink(parent, Messages.viewletDetailsAddMementoLink, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = span + 1;
        this.addMemento.setLayoutData((Object)gd);
        this.addMemento.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                DashboardTemplatesAspectEditor.this.ACTION_ADD_MEMENTO.run();
            }
        });
        this.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ssel = (IStructuredSelection)event.getSelection();
                AbstractDashboardAspectEditor.DashboardElement el = null;
                if (ssel.size() == 1) {
                    el = (AbstractDashboardAspectEditor.DashboardElement)ssel.getFirstElement();
                }
                if (el instanceof AbstractDashboardAspectEditor.ViewletElement) {
                    DashboardTemplatesAspectEditor.this.updateViewletDetailsLinks(el, toolkit);
                }
            }
        });
        this.updateViewletDetailsLinks(this.getCurrentElement(), toolkit);
    }

    private void updateViewletDetailsLinks(AbstractDashboardAspectEditor.DashboardElement el, FormToolkit toolkit) {
        if (el != null && el instanceof AbstractDashboardAspectEditor.ViewletElement) {
            this.addMemento.setEnabled(((AbstractDashboardAspectEditor.ViewletElement)el).canAddMemento());
            this.addMemento.setForeground(this.addMemento.isEnabled() ? toolkit.getHyperlinkGroup().getForeground() : toolkit.getColors().getColor("DISABLED_LINK_COLOR"));
        }
    }

    protected void registerPages(DetailsPart part) {
        part.setPageProvider((IDetailsPageProvider)new TemplatesPageProvider());
    }

    protected TreeViewer getTreeViewer() {
        return this.viewer;
    }

    protected boolean isTemplate() {
        return true;
    }

    protected String getCurrentTemplateType() {
        AbstractDashboardAspectEditor.DashboardElement element = this.getCurrentElement();
        while (element != null && !(element instanceof TemplateElement)) {
            element = element.getParent();
        }
        if (element instanceof TemplateElement) {
            return (String)((TemplateElement)element).getAttribute((String)"type").value;
        }
        return null;
    }

    class ColumnDetailsPart
    extends AbstractDashboardAspectEditor.DashboardDetailsPart {
        Hyperlink addViewlet;

        ColumnDetailsPart() {
        }

        public void createContents(Composite parent) {
            FormToolkit toolkit = this.getManagedForm().getToolkit();
            GridLayout layout = new GridLayout();
            layout.marginTop = DashboardTemplatesAspectEditor.this.getDescriptionHeight();
            parent.setLayout((Layout)layout);
            int span = 1;
            layout.numColumns = span + 1;
            this.addMessage(parent, toolkit, span, layout);
            this.addViewlet = toolkit.createHyperlink(parent, Messages.columnDetailsAddViewletLink, 0);
            GridData gd = new GridData();
            gd.horizontalSpan = span + 1;
            this.addViewlet.setLayoutData((Object)gd);
            this.addViewlet.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    ((ColumnDetailsPart)ColumnDetailsPart.this).DashboardTemplatesAspectEditor.this.ACTION_ADD_VIEWLET.run();
                }
            });
            toolkit.paintBordersFor(parent);
        }

        protected void messageUpdated(boolean hasMessage) {
            ((GridData)this.addViewlet.getLayoutData()).verticalIndent = hasMessage ? 10 : 0;
        }
    }

    class ColumnElement
    extends AbstractDashboardAspectEditor.DashboardElement {
        public static final String COLUMN = "column";

        public ColumnElement(AbstractDashboardAspectEditor.DashboardModel model, AbstractDashboardAspectEditor.DashboardElement parent, ModelElement me) {
            super(model, parent, me);
            if (me != null) {
                this.load();
            }
        }

        private void load() {
            List children = this.me.getChildElements();
            int i = 0;
            while (i < children.size()) {
                ModelElement child = (ModelElement)children.get(i);
                if (child.getName().equals("viewlet")) {
                    AbstractDashboardAspectEditor.ViewletElement ve = (AbstractDashboardAspectEditor)DashboardTemplatesAspectEditor.this.new AbstractDashboardAspectEditor.ViewletElement(this.model, (AbstractDashboardAspectEditor.DashboardElement)this, child, false);
                    this.addChild(ve);
                }
                ++i;
            }
        }

        public String getKey() {
            return COLUMN;
        }

        public boolean canRemove() {
            return this.getParent() != null && this.getParent().getChildren().length > 1;
        }
    }

    class PageDetailsPart
    extends AbstractDashboardAspectEditor.DashboardDetailsPart {
        Hyperlink addColumn;
        Label noLicense;
        AbstractDashboardAspectEditor.StringPropertyEntry title;

        PageDetailsPart() {
        }

        public void createContents(Composite parent) {
            FormToolkit toolkit = this.getManagedForm().getToolkit();
            GridLayout layout = new GridLayout();
            layout.marginTop = DashboardTemplatesAspectEditor.this.getDescriptionHeight();
            parent.setLayout((Layout)layout);
            int span = 1;
            layout.numColumns = span + 1;
            this.addMessage(parent, toolkit, span, layout);
            this.title = (AbstractDashboardAspectEditor.StringPropertyEntry)this.createElementEntry(toolkit, parent, PageElementDef.ATT_TITLE, span, true, false);
            GridData gd = new GridData();
            gd.horizontalSpan = span + 1;
            this.addColumn = toolkit.createHyperlink(parent, Messages.templateDetailsAddColumnLink, 0);
            this.addColumn.setLayoutData((Object)gd);
            this.addColumn.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    ((PageDetailsPart)PageDetailsPart.this).DashboardTemplatesAspectEditor.this.ACTION_ADD_COLUMN.run();
                }
            });
            toolkit.paintBordersFor(parent);
        }

        public void selectionChanged(IFormPart part, ISelection selection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            AbstractDashboardAspectEditor.DashboardElement el = null;
            if (ssel.size() == 1) {
                el = (AbstractDashboardAspectEditor.DashboardElement)ssel.getFirstElement();
            }
            this.updatePage(el);
            super.selectionChanged(part, selection);
        }

        private void updatePage(AbstractDashboardAspectEditor.DashboardElement el) {
            if (el instanceof PageElement) {
                PageElement page = (PageElement)el;
                this.addColumn.setEnabled(page.canAddColumn());
                FormToolkit toolkit = this.getManagedForm().getToolkit();
                this.addColumn.setForeground(this.addColumn.isEnabled() ? toolkit.getHyperlinkGroup().getForeground() : toolkit.getColors().getColor("DISABLED_LINK_COLOR"));
            }
        }

        protected void messageUpdated(boolean hasMessage) {
            ((GridData)this.title.text.getLayoutData()).verticalIndent = hasMessage ? 10 : 0;
            ((GridData)this.title.label.getLayoutData()).verticalIndent = hasMessage ? 10 : 0;
        }
    }

    class PageElement
    extends AbstractDashboardAspectEditor.DashboardElement {
        static final String PAGE = "page";

        public PageElement(AbstractDashboardAspectEditor.DashboardModel model, AbstractDashboardAspectEditor.DashboardElement parent, ModelElement me) {
            super(model, parent, me);
            this.reserveAttribute(TemplateElementDef.ATT_TITLE);
            if (me != null) {
                this.load();
            }
            this.validateColumns();
        }

        public PageElement(AbstractDashboardAspectEditor.DashboardModel model, AbstractDashboardAspectEditor.DashboardElement parent, String title) {
            this(model, parent, (ModelElement)null);
            this.putAttribute("title", title);
        }

        private void validateColumns() {
            if (this.getChildren() != null && this.getChildren().length == 0) {
                ColumnElement ce = new ColumnElement(this.model, (AbstractDashboardAspectEditor.DashboardElement)this, null);
                this.addChild(ce);
                if (DashboardTemplatesAspectEditor.this.getTreeViewer() != null) {
                    DashboardTemplatesAspectEditor.this.getTreeViewer().expandToLevel((Object)ce, 0);
                }
            }
        }

        private void load() {
            this.putAttribute("title", this.me.getAttribute("title"));
            List children = this.me.getChildElements();
            int i = 0;
            while (i < children.size()) {
                ModelElement child = (ModelElement)children.get(i);
                if (child.getName().equals("column")) {
                    ColumnElement ce = new ColumnElement(this.model, (AbstractDashboardAspectEditor.DashboardElement)this, child);
                    this.addChild(ce);
                }
                ++i;
            }
        }

        public String getKey() {
            return PAGE;
        }

        public boolean canAddColumn() {
            return this.getChildren().length < 3;
        }

        public boolean canRemove() {
            return this.getParent() != null && this.getParent().getChildren().length > 1;
        }

        public boolean isValid() {
            return !DashboardTemplatesAspectEditor.this.licenseCheckDone || DashboardTemplatesAspectEditor.this.addTab || this.getParent() != null && this.getParent().getChildren().length > 0 && this.getParent().getChildren()[0] == this;
        }
    }

    static class PageElementDef {
        static final String TITLE = "title";
        static final AbstractDashboardAspectEditor.DashboardAttributeDef ATT_TITLE = new AbstractDashboardAspectEditor.DashboardAttributeDef(0, "title", Messages.pageTitleLabel, Messages.pageTitleTooltip);

        PageElementDef() {
        }
    }

    class TemplateDetailsPart
    extends AbstractDashboardAspectEditor.DashboardDetailsPart {
        static final int INDEX_DOES_EXIST = 0;
        static final int INDEX_DOES_NOT_EXIST = 1;
        AbstractDashboardAspectEditor.StringPropertyEntry title;
        StackLayout stackLayout;
        Composite root;
        Composite stack;
        Composite[] pages = new Composite[2];

        TemplateDetailsPart() {
        }

        public void createContents(Composite parent) {
            FormToolkit toolkit = this.getManagedForm().getToolkit();
            this.root = parent;
            GridLayout layout = new GridLayout();
            layout.marginTop = DashboardTemplatesAspectEditor.this.getDescriptionHeight();
            parent.setLayout((Layout)layout);
            int span = 1;
            this.addMessage(parent, toolkit, span, layout);
            this.stack = toolkit.createComposite(parent);
            this.stack.setLayoutData((Object)new GridData(1, 1, true, true));
            this.stackLayout = new StackLayout();
            this.stack.setLayout((Layout)this.stackLayout);
            this.pages[0] = toolkit.createComposite(this.stack);
            this.pages[1] = toolkit.createComposite(this.stack);
            layout = new GridLayout();
            this.pages[0].setLayout((Layout)layout);
            layout.numColumns = span + 1;
            this.createElementEntry(toolkit, this.pages[0], TemplateElementDef.ATT_TYPE, span);
            this.title = (AbstractDashboardAspectEditor.StringPropertyEntry)this.createElementEntry(toolkit, this.pages[0], TemplateElementDef.ATT_TITLE, span, true, false);
            Hyperlink addPage = toolkit.createHyperlink(this.pages[0], Messages.templateDetailsAddPageLink, 0);
            GridData gd = new GridData();
            gd.horizontalSpan = span + 1;
            addPage.setLayoutData((Object)gd);
            addPage.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    ((TemplateDetailsPart)TemplateDetailsPart.this).DashboardTemplatesAspectEditor.this.ACTION_ADD_PAGE.run();
                }
            });
            layout = new GridLayout();
            this.pages[1].setLayout((Layout)layout);
            layout.numColumns = span + 1;
            this.createElementEntry(toolkit, this.pages[1], TemplateElementDef.ATT_TYPE, span);
            Label label = toolkit.createLabel(this.pages[1], Messages.templateDetailsNoTemplate);
            gd = new GridData();
            gd.horizontalSpan = span + 1;
            label.setLayoutData((Object)gd);
            Hyperlink create = toolkit.createHyperlink(this.pages[1], Messages.templateDetailsCreateLink, 0);
            gd = new GridData();
            gd.horizontalSpan = span + 1;
            create.setLayoutData((Object)gd);
            create.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    ((TemplateDetailsPart)TemplateDetailsPart.this).DashboardTemplatesAspectEditor.this.ACTION_CREATE_TEMPLATE.run();
                }
            });
            toolkit.paintBordersFor(parent);
            toolkit.paintBordersFor(this.pages[1]);
            toolkit.paintBordersFor(this.pages[0]);
            this.updatePage(DashboardTemplatesAspectEditor.this.getCurrentElement());
        }

        public void selectionChanged(IFormPart part, ISelection selection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            AbstractDashboardAspectEditor.DashboardElement el = null;
            if (ssel.size() == 1) {
                el = (AbstractDashboardAspectEditor.DashboardElement)ssel.getFirstElement();
            }
            this.updatePage(el);
            super.selectionChanged(part, selection);
        }

        private void updatePage(AbstractDashboardAspectEditor.DashboardElement element) {
            this.stackLayout.topControl = element instanceof TemplateElement && ((TemplateElement)element).exists ? this.pages[0] : this.pages[1];
            this.stack.layout();
        }

        protected void messageUpdated(boolean hasMessage) {
            ((GridData)this.stack.getLayoutData()).verticalIndent = hasMessage ? 10 : 0;
        }
    }

    class TemplateElement
    extends AbstractDashboardAspectEditor.DashboardElement {
        static final String TEMPLATE = "dashboard-template";
        boolean exists;

        public TemplateElement(AbstractDashboardAspectEditor.DashboardModel model, AbstractDashboardAspectEditor.DashboardElement parent, ModelElement me) {
            super(model, parent, me);
            this.exists = true;
            this.init();
        }

        public TemplateElement(AbstractDashboardAspectEditor.DashboardModel model, AbstractDashboardAspectEditor.DashboardElement parent, ModelElement me, String type, boolean exists) {
            super(model, parent, me);
            this.exists = true;
            this.exists = exists;
            this.init();
            this.putAttribute("type", type);
            if (exists) {
                this.putAttribute("title", this.getDefaultTitle());
            } else {
                this.resetTitle();
            }
        }

        private void init() {
            this.reserveAttribute(TemplateElementDef.ATT_TYPE);
            this.reserveAttribute(TemplateElementDef.ATT_TITLE);
            if (this.me != null) {
                this.load();
            }
            if (this.exists) {
                this.validatePages();
            }
        }

        private void validatePages() {
            if (this.getChildren() != null && this.getChildren().length == 0) {
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.defaultPageTitle));
                DashboardTemplatesAspectEditor dashboardTemplatesAspectEditor = DashboardTemplatesAspectEditor.this;
                int n = dashboardTemplatesAspectEditor.newPageCount + 1;
                dashboardTemplatesAspectEditor.newPageCount = n;
                PageElement newPage = new PageElement(this.model, (AbstractDashboardAspectEditor.DashboardElement)this, stringBuilder.append(n).toString());
                this.addChild(newPage);
                if (DashboardTemplatesAspectEditor.this.getTreeViewer() != null) {
                    DashboardTemplatesAspectEditor.this.getTreeViewer().expandToLevel((Object)newPage, 1);
                }
            }
        }

        private void load() {
            this.putAttribute("type", this.me.getAttribute("type"));
            this.putAttribute("title", this.me.getAttribute("title"));
            List children = this.me.getChildElements();
            int i = 0;
            while (i < children.size()) {
                ModelElement child = (ModelElement)children.get(i);
                if (child.getName().equals("page")) {
                    PageElement pe = new PageElement(this.model, (AbstractDashboardAspectEditor.DashboardElement)this, child);
                    this.addChild(pe);
                }
                ++i;
            }
        }

        public void resetTitle() {
            this.putAttribute("title", "");
        }

        public String getKey() {
            return TEMPLATE;
        }

        public void save(IMemento memento) {
            if (this.exists) {
                super.save(memento);
            }
        }

        public String getDefaultTitle() {
            return "${scope}";
        }

        public boolean isValid() {
            return !DashboardTemplatesAspectEditor.this.licenseCheckDone || this.getAttribute((String)"type").value.equals("contributor") && DashboardTemplatesAspectEditor.this.viewContributor || this.getAttribute((String)"type").value.equals("team") && DashboardTemplatesAspectEditor.this.viewTeam || this.getAttribute((String)"type").value.equals("project") && DashboardTemplatesAspectEditor.this.viewProject;
        }
    }

    static class TemplateElementDef {
        static final String TYPE = "type";
        static final String TITLE = "title";
        static final String TYPE_CONTRIBUTOR = "contributor";
        static final String TYPE_PROJECT = "project";
        static final String TYPE_TEAM = "team";
        static final String KEY_CONTRIBUTOR = "contributorType";
        static final String KEY_OTHER = "otherType";
        static final AbstractDashboardAspectEditor.DashboardAttributeDef ATT_TYPE = new AbstractDashboardAspectEditor.DashboardAttributeDef(0, "type", Messages.templateTypeLabel, Messages.templateTypeTooltip, false);
        static final AbstractDashboardAspectEditor.DashboardAttributeDef ATT_TITLE = new AbstractDashboardAspectEditor.DashboardAttributeDef(0, "title", Messages.templateTitleLabel, Messages.templateTitleTooltip);

        TemplateElementDef() {
        }
    }

    class TemplatesLabelProvider
    extends AbstractDashboardAspectEditor.DashboardLabelProvider {
        TemplatesLabelProvider() {
        }

        public String getText(Object obj) {
            AbstractDashboardAspectEditor.DashboardAttribute ta;
            if (obj instanceof TemplateElement) {
                TemplateElement te = (TemplateElement)obj;
                ta = te.getAttribute("title");
                AbstractDashboardAspectEditor.DashboardAttribute typea = te.getAttribute("type");
                String text = null;
                if (ta != null && ta.value != null) {
                    text = ta.value.toString();
                }
                if (typea != null) {
                    String type = typea.value.toString();
                    String label = type.equals("contributor") ? Messages.labelContributor : (type.equals("team") ? Messages.labelTeam : Messages.labelProject);
                    text = text != null ? String.valueOf(text) + " (" + label + ")" : label;
                }
                if (text != null) {
                    return text;
                }
            }
            if (obj instanceof PageElement) {
                PageElement pe = (PageElement)obj;
                ta = pe.getAttribute("title");
                if (ta != null && ta.value != null) {
                    return String.valueOf(ta.value.toString()) + " (" + Messages.labelPage + ")";
                }
                return "(" + Messages.labelPage + ")";
            }
            if (obj instanceof ColumnElement) {
                return "(" + Messages.labelColumn + ")";
            }
            return super.getText(obj);
        }

        public Image getImage(Object obj) {
            if (obj instanceof AbstractDashboardAspectEditor.MementoElement) {
                return DashboardImages.getImage(DashboardImages.DESC_MEMENTO_OBJ);
            }
            if (obj instanceof AbstractDashboardAspectEditor.MementoPropertyElement) {
                return DashboardImages.getImage(DashboardImages.DESC_MEMENTO_PROPERTY_OBJ);
            }
            if (obj instanceof AbstractDashboardAspectEditor.MementoValueElement) {
                return DashboardImages.getImage(DashboardImages.DESC_MEMENTO_VALUE_OBJ);
            }
            if (obj instanceof TemplateElement) {
                return DashboardImages.getImage(DashboardImages.DESC_DASHBOARD_OBJ);
            }
            if (obj instanceof PageElement) {
                return DashboardImages.getImage(DashboardImages.DESC_PAGE_OBJ);
            }
            if (obj instanceof ColumnElement) {
                return DashboardImages.getImage(DashboardImages.DESC_COLUMN_OBJ);
            }
            return super.getImage(obj);
        }
    }

    class TemplatesModel
    extends AbstractDashboardAspectEditor.DashboardModel {
        Hashtable templates;

        TemplatesModel() {
        }

        AbstractDashboardAspectEditor.DashboardElement[] getElements() {
            AbstractDashboardAspectEditor.DashboardElement[] elements = this.templates.values().toArray(new AbstractDashboardAspectEditor.DashboardElement[this.templates.size()]);
            ArrayList<TemplateElement> filtered = new ArrayList<TemplateElement>();
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof TemplateElement) {
                    TemplateElement te = (TemplateElement)elements[i];
                    if (te.getAttribute((String)"type").value.equals("contributor") || te.getAttribute((String)"type").value.equals("team") || te.getAttribute((String)"type").value.equals("project")) {
                        filtered.add(te);
                    }
                }
                ++i;
            }
            return filtered.toArray(new AbstractDashboardAspectEditor.DashboardElement[filtered.size()]);
        }

        protected void init(ModelElement root) {
            this.templates = new Hashtable();
            if (root != null) {
                List cme = root.getChildElements();
                int i = 0;
                while (i < cme.size()) {
                    String type;
                    ModelElement me = (ModelElement)cme.get(i);
                    if (me.getName().equals("dashboard-template") && !this.templates.containsKey(type = me.getAttribute("type")) && (type.equals("contributor") || type.equals("project") || type.equals("team"))) {
                        TemplateElement te = new TemplateElement((AbstractDashboardAspectEditor.DashboardModel)this, null, me);
                        this.templates.put(type, te);
                    }
                    ++i;
                }
            }
            this.validateTemplates();
        }

        private void validateTemplates() {
            TemplateElement te;
            if (!this.templates.containsKey("project")) {
                te = new TemplateElement(this, null, null, "project", false);
                this.templates.put("project", te);
            }
            if (!this.templates.containsKey("team")) {
                te = new TemplateElement(this, null, null, "team", false);
                this.templates.put("team", te);
            }
            if (!this.templates.containsKey("contributor")) {
                te = new TemplateElement(this, null, null, "contributor", false);
                this.templates.put("contributor", te);
            }
        }

        public void save(IMemento memento) {
            super.save(memento);
            Iterator i = this.templates.keySet().iterator();
            while (i.hasNext()) {
                TemplateElement element = (TemplateElement)this.templates.get(i.next());
                element.save(memento);
            }
        }

        protected String getConfigurationDataId() {
            return "com.ibm.team.dashboard.configuration.templates";
        }

        protected String getConfigurationDataNamespace() {
            return "http://com.ibm.team.dashboard/templates";
        }
    }

    class TemplatesPageProvider
    extends AbstractDashboardAspectEditor.ViewletPageProvider {
        TemplatesPageProvider() {
        }

        public IDetailsPage getPage(Object key) {
            if (key.equals(TemplateElement.class)) {
                return new TemplateDetailsPart();
            }
            if (key.equals(PageElement.class)) {
                return new PageDetailsPart();
            }
            if (key.equals(ColumnElement.class)) {
                return new ColumnDetailsPart();
            }
            if (key.equals("contributorType") || key.equals("otherType")) {
                return new AbstractDashboardAspectEditor.ViewletDetailsPart();
            }
            return super.getPage(key);
        }

        public Object getPageKey(Object object) {
            if (object instanceof TemplateElement) {
                return TemplateElement.class;
            }
            if (object instanceof PageElement) {
                return PageElement.class;
            }
            if (object instanceof ColumnElement) {
                return ColumnElement.class;
            }
            if (object instanceof AbstractDashboardAspectEditor.ViewletElement) {
                String type = DashboardTemplatesAspectEditor.this.getCurrentTemplateType();
                return type != null && type.equals("contributor") ? "contributorType" : "otherType";
            }
            return super.getPageKey(object);
        }
    }
}

