/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.workitems;

import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.internal.ui.workitems.Messages;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkingCopyListener;
import com.ibm.team.workitem.client.WorkItemOperation;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.WorkingCopyEvent;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.ui.QueriesUI;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.WorkItemUIOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class WorkItemHelper {
    public static final String WORK_ITEMS_VIEW_ID = "com.ibm.magnolia.workItemExplorer";
    public static final String WORK_ITEM_EDITOR_ID = "com.ibm.magnolia.workItemEditor";
    protected static WorkItemHelper fInstance = new WorkItemHelper();

    public static WorkItemHelper getInstance() {
        return fInstance;
    }

    protected WorkItemHelper() {
    }

    public void createAndLinkWorkItem(Shell shell, String summary, String description, IBuildResultHandle buildResultHandle, IProjectAreaHandle projectAreaHandle) {
        ITeamRepository teamRepository = (ITeamRepository)projectAreaHandle.getOrigin();
        if (teamRepository.loggedIn()) {
            WorkItemUIOperation operation = this.getCreateWorkItemOperation(summary, description, buildResultHandle);
            this.createWorkItem(shell, projectAreaHandle, operation);
        }
    }

    protected void createWorkItem(Shell shell, IProjectAreaHandle projectAreaHandle, WorkItemUIOperation operation) {
        WorkItemUI.createWorkItem((Shell)shell, (IProjectAreaHandle)projectAreaHandle, (WorkItemOperation)operation);
    }

    public void showRelatedWorkItems(String summary, String description, IBuildResultHandle buildResultHandle, IProjectAreaHandle projectAreaHandle, IWorkbenchWindow workbenchWindow) {
        ITeamRepository teamRepository = (ITeamRepository)projectAreaHandle.getOrigin();
        if (teamRepository.loggedIn()) {
            QueriesUI.showRelatedWorkItems((IWorkbenchWindow)workbenchWindow, (IProjectAreaHandle)projectAreaHandle, (String)"", (String)summary, (String)description);
        }
    }

    private WorkItemUIOperation getCreateWorkItemOperation(final String summary, final String description, final IBuildResultHandle buildResultHandle) {
        return new WorkItemUIOperation(Messages.WorkItemHelper_JOB_LABEL_CREATING_WORK_ITEM, IWorkItem.FULL_PROFILE){

            protected void execute(WorkItemWorkingCopy workingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
                workingCopy.addWorkingCopyListener(WorkItemHelper.this.getWorkingCopyListener(buildResultHandle));
                IWorkItem workItem = workingCopy.getWorkItem();
                workItem.setHTMLSummary(XMLString.createFromPlainText((String)summary));
                workItem.setHTMLDescription(XMLString.createFromPlainText((String)description));
            }

            protected void commit(WorkItemWorkingCopy[] workingCopies, IProgressMonitor monitor) throws TeamRepositoryException {
            }
        };
    }

    protected IWorkingCopyListener getWorkingCopyListener(final IBuildResultHandle buildResultHandle) {
        return new IWorkingCopyListener(){

            public void workingCopyEvent(WorkingCopyEvent event) {
                WorkItemWorkingCopy workingCopy = event.getSource();
                if (event.getType().equals("saved")) {
                    WorkItemHelper.this.handleWorkItemSaved((IWorkItemHandle)workingCopy.getWorkItem(), buildResultHandle);
                    workingCopy.removeWorkingCopyListener((IWorkingCopyListener)this);
                } else if (event.getType().equals("aboutToBeDisposed")) {
                    workingCopy.removeWorkingCopyListener((IWorkingCopyListener)this);
                }
            }
        };
    }

    protected void handleWorkItemSaved(final IWorkItemHandle workItemHandle, final IBuildResultHandle buildResultHandle) {
        TeamBuildJob job = new TeamBuildJob(Messages.WorkItemHelper_JOB_LABEL_LINKING, true){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                ITeamRepository repository = (ITeamRepository)buildResultHandle.getOrigin();
                WorkItemHelper.this.linkReportedWorkItem(repository, buildResultHandle, workItemHandle, monitor);
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                WorkItemHelper.this.handleJobDone(status);
            }
        };
        job.schedule();
    }

    protected void linkReportedWorkItem(ITeamRepository repository, IBuildResultHandle buildResultHandle, IWorkItemHandle workItemHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        com.ibm.team.build.internal.client.workitem.WorkItemHelper.linkReportedWorkItem((ITeamRepository)repository, (IBuildResultHandle)buildResultHandle, (IWorkItemHandle)workItemHandle, (IProgressMonitor)monitor);
    }

    protected void handleJobDone(IStatus status) {
    }
}

