/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.wizards.builddefinition;

import com.ibm.team.build.common.builddefinition.BuildConfigurationRegistry;
import com.ibm.team.build.common.builddefinition.IBuildDefinitionTemplate;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.internal.common.builddefinition.BuildDefinitionTemplateExtension;
import com.ibm.team.build.internal.ui.wizards.builddefinition.ConfigurationPage;
import com.ibm.team.build.internal.ui.wizards.builddefinition.Messages;
import com.ibm.team.build.internal.ui.wizards.builddefinition.WizardContext;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildTemplateSelectionPage
extends WizardPage {
    protected final WizardContext fWizardContext;
    protected Text fBuildDefinitionIdText;
    protected Text fBuildDescriptionText;
    protected TableViewer fTableViewer;
    protected Composite fTemplateDescriptionComposite;
    protected Label fTemplateDescriptionLabel;
    private boolean fFirstShowing = true;

    public BuildTemplateSelectionPage(WizardContext context) {
        super(BuildTemplateSelectionPage.class.getName());
        this.fWizardContext = context;
        this.setTitle(Messages.BuildDefinitionSelectionPage_GENERAL_INFO_TITLE);
        this.setDescription(Messages.BuildDefinitionSelectionPage_GENERAL_INFO_DESC);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite container = this.createPageContent(parent);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
    }

    private Composite createPageContent(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        page.setLayout((Layout)gridLayout);
        page.setLayoutData((Object)new GridData(1808));
        Label idLabel = new Label(page, 0);
        idLabel.setText(Messages.BuildTemplateSelectionPage_LABEL_BUILD_ID);
        this.fBuildDefinitionIdText = new Text(page, 2048);
        this.fBuildDefinitionIdText.setLayoutData((Object)new GridData(768));
        this.fBuildDefinitionIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BuildTemplateSelectionPage.this.handleNameTextModified();
            }
        });
        Label descriptionLabel = new Label(page, 0);
        descriptionLabel.setText(Messages.BuildTemplateSelectionPage_LABEL_BUILD_DESCRIPTION);
        this.fBuildDescriptionText = new Text(page, 2048);
        GridData gridData = new GridData(768);
        this.fBuildDescriptionText.setLayoutData((Object)gridData);
        this.fBuildDescriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BuildTemplateSelectionPage.this.handleDescriptionTextModified();
            }
        });
        this.createBuildTypeSelectionTable(page);
        return page;
    }

    private void createBuildTypeSelectionTable(Composite parent) {
        Label label = new Label(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label = new Label(parent, 64);
        label.setText(Messages.BuildTemplateSelectionPage_LABEL_AVAILABLE_TEMPLATES);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.fTableViewer = new TableViewer(parent, 2820);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.fTableViewer.getTable().setLayoutData((Object)gridData);
        this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IBuildDefinitionTemplate)element).getName();
            }
        });
        this.fTableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return super.getComparator().compare(((IBuildDefinitionTemplate)e1).getName(), ((IBuildDefinitionTemplate)e2).getName());
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BuildTemplateSelectionPage.this.handleSelectionChanged();
            }
        });
        this.fTableViewer.addDoubleClickListener(this.getDoubleClickListener());
        this.fTemplateDescriptionComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.fTemplateDescriptionComposite);
        GridLayoutFactory.fillDefaults().applyTo(this.fTemplateDescriptionComposite);
        Label descriptionTitle = new Label(this.fTemplateDescriptionComposite, 0);
        descriptionTitle.setText(Messages.BuildTemplateSelectionPage_TEMPLATE_DESCRIPTION_LABEL);
        descriptionTitle.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fTemplateDescriptionLabel = new Label(this.fTemplateDescriptionComposite, 64);
        GridDataFactory.fillDefaults().indent(10, 0).grab(true, false).applyTo((Control)this.fTemplateDescriptionLabel);
    }

    protected IDoubleClickListener getDoubleClickListener() {
        return new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                BuildTemplateSelectionPage.this.handleDoubleClick();
            }
        };
    }

    private void handleDoubleClick() {
        IWizardPage nextPage;
        if (this.validate() && (nextPage = this.getNextPage()) != null) {
            this.getContainer().showPage(nextPage);
        }
    }

    private void handleSelectionChanged() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        if (selection.size() > 0) {
            BuildDefinitionTemplateExtension template = (BuildDefinitionTemplateExtension)selection.getFirstElement();
            this.fWizardContext.setBuildTemplate((IBuildDefinitionTemplate)template);
            String description = template.getDescription();
            if (description == null || description.length() == 0) {
                description = Messages.BuildTemplateSelectionPage_NO_DESCRIPTION;
            }
            this.fTemplateDescriptionLabel.setText(description);
            this.fTemplateDescriptionComposite.getParent().layout(true);
        }
        this.validate();
    }

    private void handleNameTextModified() {
        this.validate();
        this.fWizardContext.getBuildDefinition().setId(this.fBuildDefinitionIdText.getText());
    }

    private void handleDescriptionTextModified() {
        this.validate();
        this.fWizardContext.getBuildDefinition().setDescription(this.fBuildDescriptionText.getText());
    }

    protected boolean validate() {
        if (this.fBuildDefinitionIdText.getText().length() < 1) {
            this.setErrorMessage(Messages.BuildTemplateSelectionPage_ERROR_NAME_MISSING);
            this.setPageComplete(false);
            this.getContainer().updateButtons();
            return false;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
        this.getContainer().updateButtons();
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.fFirstShowing) {
                List<IBuildDefinitionTemplate> templates = this.getValidTemplates();
                if (!templates.isEmpty()) {
                    this.fTableViewer.setInput(templates);
                    IBuildDefinitionTemplate template = (IBuildDefinitionTemplate)this.fTableViewer.getElementAt(0);
                    this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)template));
                    this.fWizardContext.setBuildTemplate(template);
                    this.fFirstShowing = false;
                    String buildName = this.fWizardContext.getSuggestedBuildName();
                    this.fBuildDefinitionIdText.setText(buildName);
                    this.fBuildDefinitionIdText.setFocus();
                    this.fBuildDefinitionIdText.selectAll();
                    this.fWizardContext.getBuildDefinition().setId(buildName);
                }
                PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.ibm.team.build.ui.wizard_templateselection");
            }
            this.validate();
        }
    }

    protected List<IBuildDefinitionTemplate> getValidTemplates() {
        IBuildDefinitionTemplate[] templates;
        ArrayList<IBuildDefinitionTemplate> validTemplates = new ArrayList<IBuildDefinitionTemplate>();
        IBuildDefinitionTemplate[] iBuildDefinitionTemplateArray = templates = BuildConfigurationRegistry.getInstance().getBuildDefinitionTemplates();
        int n = templates.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildDefinitionTemplate template = iBuildDefinitionTemplateArray[n2];
            if (this.isValidTemplate(template)) {
                validTemplates.add(template);
            }
            ++n2;
        }
        return validTemplates;
    }

    private boolean isValidTemplate(IBuildDefinitionTemplate template) {
        String[] stringArray = template.getConfigurationElementIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String elementId = stringArray[n2];
            IBuildConfigurationElement element = BuildConfigurationRegistry.getInstance().getBuildConfigurationElement(elementId);
            if (element == null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.ibm.team.build.ui.wizard_templateselection");
    }

    public IWizardPage getNextPage() {
        ConfigurationPage nextPage = null;
        if (this.fWizardContext.getPreBuildElementIds().size() > 0) {
            nextPage = this.fWizardContext.getWizard().getPreBuildConfigPage();
        } else if (this.fWizardContext.getPostBuildElementIds().size() > 0) {
            nextPage = this.fWizardContext.getWizard().getPostBuildConfigPage();
        } else if (this.fWizardContext.getUnspecifiedBuildElementIds().size() > 0) {
            nextPage = this.fWizardContext.getWizard().getAdditionalConfigPage();
        }
        return nextPage;
    }
}

