/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.views.query;

import com.ibm.team.build.client.iterator.IBuildResultRecordIterator;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.internal.ui.query.BuildQuery;
import com.ibm.team.build.internal.ui.query.BuildQueryResult;
import com.ibm.team.build.internal.ui.views.query.BuildQueryView;
import com.ibm.team.build.internal.ui.views.query.BuildQueryViewInput;
import com.ibm.team.build.internal.ui.views.query.BuildUIQueryMessages;
import com.ibm.team.repository.common.util.NLS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public abstract class RunBuildQueryAction
extends Action {
    protected final BuildQueryView fBuildQueryView;

    public RunBuildQueryAction(BuildQueryView buildQueryView) {
        ValidationHelper.validateNotNull((String)"buildQueryView", (Object)((Object)buildQueryView));
        this.fBuildQueryView = buildQueryView;
    }

    protected BuildQueryView getBuildQueryView() {
        return this.fBuildQueryView;
    }

    public abstract BuildQuery getBuildQuery();

    public void run() {
        if (!this.fBuildQueryView.startRunBuildQueryAction(this)) {
            return;
        }
        BuildQuery query = this.getBuildQuery();
        if (query == null) {
            this.fBuildQueryView.finishRunBuildQueryAction();
            return;
        }
        this.fBuildQueryView.addBuildQueryViewHistoryEntry(query);
        BuildQueryJob queryJob = this.createBuildQueryJob(query);
        IWorkbenchSiteProgressService progressService = this.fBuildQueryView.getProgressService();
        if (progressService != null) {
            progressService.schedule((Job)queryJob);
        } else {
            queryJob.schedule();
        }
    }

    protected BuildQueryJob createBuildQueryJob(BuildQuery buildQuery) {
        return new BuildQueryJob(buildQuery);
    }

    protected void setBuildQueryViewInput(BuildQueryViewInput input) {
        this.fBuildQueryView.setInput(input);
    }

    protected void runQuery(BuildQuery buildQuery, IProgressMonitor monitor) throws Exception {
        long startTime = System.currentTimeMillis();
        IBuildResultRecordIterator iter = buildQuery.doIterativeQuery(monitor);
        BuildQueryResult queryResult = new BuildQueryResult(buildQuery.getTeamRepository(), buildQuery);
        BuildQueryViewInput queryViewInput = new BuildQueryViewInput(queryResult);
        this.setBuildQueryViewInput(queryViewInput);
        int recordsToGet = 5;
        int recordsToGetIncrement = 5;
        int querySize = iter.size();
        int i = 0;
        if (querySize > 0) {
            while (iter.hasNext() && !monitor.isCanceled() && !this.fBuildQueryView.isBuildQueryActionCanceled()) {
                IBuildResultRecord[] records = iter.next(recordsToGet, monitor);
                int j = 0;
                while (j < records.length) {
                    buildQuery.getRowFactory().createBuildQueryRow(queryResult, records[j]);
                    ++j;
                }
                i += records.length;
                if (recordsToGetIncrement < 15) {
                    recordsToGet += recordsToGetIncrement;
                    recordsToGetIncrement += 5;
                }
                String label = NLS.bind((String)BuildUIQueryMessages.RunBuildQueryAction_RETRIEVING_BUILDS_X_OF_X, (Object[])new Object[]{BuildUIQueryMessages.BuildQueryView_QueryJobName_RetrievingBuilds, i, querySize});
                this.fBuildQueryView.updateBuildQueryViewLabelAndRowCount(label, i);
            }
        }
        queryResult.initQueryDurationMillis(System.currentTimeMillis() - startTime);
        this.fBuildQueryView.updateBuildQueryViewLabelAndRowCount(queryViewInput.getFinishedDescription(), i);
    }

    protected void queryFinished(BuildQuery buildQuery, IStatus status) {
        this.fBuildQueryView.finishRunBuildQueryAction();
        if (status.getSeverity() == 4) {
            String errorMessage = status.getMessage();
            String errorInputDescription = NLS.bind((String)BuildUIQueryMessages.BuildQueryView_query_error, (Object[])new Object[]{buildQuery.getDescription(), errorMessage});
            this.setBuildQueryViewInput(new BuildQueryViewInput(errorInputDescription));
        }
    }

    public class BuildQueryJob
    extends TeamBuildJob {
        private final BuildQuery fBuildQuery;

        protected BuildQueryJob(BuildQuery buildQuery) {
            super(BuildUIQueryMessages.BuildQueryView_QueryJobName_RetrievingBuilds, true, buildQuery.getTeamRepository());
            this.fBuildQuery = buildQuery;
        }

        protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
            String description = BuildUIQueryMessages.BuildQueryView_QueryJobName_RetrievingBuilds;
            RunBuildQueryAction.this.setBuildQueryViewInput(new BuildQueryViewInput(description));
            RunBuildQueryAction.this.runQuery(this.fBuildQuery, monitor);
            return Status.OK_STATUS;
        }

        protected void jobFinished(IStatus status) {
            RunBuildQueryAction.this.queryFinished(this.fBuildQuery, status);
        }
    }
}

