/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.views.query;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.ui.BuildDefinitionLabelProvider;
import com.ibm.team.build.internal.ui.BuildUIMessages;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.dialogs.definitions.BuildDefinitionSelectionDialog;
import com.ibm.team.build.internal.ui.helper.BuildDefinitionHandleHelper;
import com.ibm.team.build.internal.ui.views.query.BuildUIQueryMessages;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyBuildsMenuConfigurationDialog
extends TrayDialog {
    protected static final String SORT_DEFINITIONS_PREFERENCE_KEY = "MyBuildsMenuConfigurationDialog.sort.definitions";
    protected List<BuildDefinitionHandleHelper> fBuildDefinitions;
    private boolean fShowRepositories;
    private TableViewer fTableViewer;
    protected Label fMessageLabel;
    protected Button fAddButton;
    protected Button fRemoveButton;
    protected Button fUpButton;
    protected Button fDownButton;
    protected Button fSortButton;

    public MyBuildsMenuConfigurationDialog(List<BuildDefinitionHandleHelper> buildDefinitions, boolean showRepositories, Shell parentShell) {
        super(parentShell);
        this.fBuildDefinitions = buildDefinitions;
        this.fShowRepositories = showRepositories;
        this.setShellStyle(this.getShellStyle() | 0x10);
        BuildUIPlugin.getDefault().getPreferenceStore().setDefault(SORT_DEFINITIONS_PREFERENCE_KEY, false);
    }

    public List<BuildDefinitionHandleHelper> getBuildDefinitions() {
        return this.fBuildDefinitions;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(BuildUIQueryMessages.MyBuildsMenuConfiguration_DIALOG_TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogComposite = (Composite)super.createDialogArea(parent);
        this.fMessageLabel = new Label(dialogComposite, 0);
        this.fMessageLabel.setText(BuildUIQueryMessages.MyBuildsMenuConfiguration_DIALOG_MESSAGE);
        Composite bodyComposite = new Composite(dialogComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(bodyComposite);
        this.fTableViewer = new TableViewer(bodyComposite);
        this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new BuildDefinitionLabelProvider(this.fShowRepositories));
        this.fTableViewer.setInput(this.fBuildDefinitions);
        this.fTableViewer.addSelectionChangedListener(this.getSelectionChangedListener());
        Composite buttonComposite = new Composite(bodyComposite, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        this.fAddButton = new Button(buttonComposite, 0);
        this.fAddButton.setText(BuildUIQueryMessages.MyBuildsMenuConfiguration_ADD_DEFINITION_BUTTON_LABEL);
        this.fAddButton.addSelectionListener(this.getAddListener());
        this.fRemoveButton = new Button(buttonComposite, 0);
        this.fRemoveButton.setText(BuildUIMessages.REMOVE_BUTTON_LABEL);
        this.fRemoveButton.addSelectionListener(this.getRemoveListener());
        this.fUpButton = new Button(buttonComposite, 0);
        this.fUpButton.setText(BuildUIQueryMessages.MyBuildsMenuConfiguration_UP_BUTTON_LABEL);
        this.fUpButton.addSelectionListener(this.getUpButtonSelectionListener());
        this.fDownButton = new Button(buttonComposite, 0);
        this.fDownButton.setText(BuildUIQueryMessages.MyBuildsMenuConfiguration_DOWN_BUTTON_LABEL);
        this.fDownButton.addSelectionListener(this.getDownButtonSelectionListener());
        this.fSortButton = new Button(bodyComposite, 32);
        this.fSortButton.setText(BuildUIQueryMessages.MyBuildsMenuConfiguration_SORT_CHECKBOX_LABEL);
        this.fSortButton.setSelection(BuildUIPlugin.getDefault().getPreferenceStore().getBoolean(SORT_DEFINITIONS_PREFERENCE_KEY));
        this.fSortButton.addSelectionListener(this.getSortButtonSelectionListener());
        GridDataFactory.swtDefaults().grab(true, false).align(4, 1).applyTo((Control)this.fMessageLabel);
        GridDataFactory.fillDefaults().grab(false, true).indent(0, 5).applyTo((Control)bodyComposite);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).hint(200, 300).applyTo((Control)this.fTableViewer.getTable());
        GridDataFactory.fillDefaults().applyTo((Control)buttonComposite);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)this.fAddButton);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)this.fRemoveButton);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)this.fUpButton);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)this.fDownButton);
        GridDataFactory.swtDefaults().applyTo((Control)this.fSortButton);
        this.updateButtonEnablement();
        this.updateSorting();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialogComposite, "com.ibm.team.build.ui.dialog_configuremybuilds");
        return dialogComposite;
    }

    private void move(int offset) {
        List<BuildDefinitionHandleHelper> toBeMoved = this.getCurrentSelection();
        if (offset > 0) {
            Collections.reverse(toBeMoved);
        }
        for (BuildDefinitionHandleHelper query : toBeMoved) {
            int index = this.fBuildDefinitions.indexOf(query);
            int newIndex = index + offset;
            if (newIndex <= -1 || newIndex >= this.fBuildDefinitions.size()) continue;
            this.fBuildDefinitions.remove(index);
            this.fBuildDefinitions.add(newIndex, query);
        }
        this.fTableViewer.refresh();
        this.updateButtonEnablement();
        this.setFocusOnOkButton();
    }

    protected SelectionListener getUpButtonSelectionListener() {
        return this.getMoveButtonSelectionListener(-1);
    }

    protected SelectionListener getDownButtonSelectionListener() {
        return this.getMoveButtonSelectionListener(1);
    }

    private SelectionListener getMoveButtonSelectionListener(final int offset) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MyBuildsMenuConfigurationDialog.this.move(offset);
            }
        };
    }

    protected SelectionListener getSortButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MyBuildsMenuConfigurationDialog.this.updateSorting();
                MyBuildsMenuConfigurationDialog.this.updateButtonEnablement();
                MyBuildsMenuConfigurationDialog.this.setFocusOnOkButton();
            }
        };
    }

    protected void updateSorting() {
        if (this.fSortButton.getSelection()) {
            Collections.sort(this.fBuildDefinitions, new Comparator<BuildDefinitionHandleHelper>(){

                @Override
                public int compare(BuildDefinitionHandleHelper o1, BuildDefinitionHandleHelper o2) {
                    return o1.getBuildDefinitionId().compareTo(o2.getBuildDefinitionId());
                }
            });
            this.fTableViewer.refresh();
        }
    }

    protected void setFocusOnOkButton() {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setFocus();
        }
    }

    protected SelectionListener getAddListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] results = MyBuildsMenuConfigurationDialog.this.promptUserToAddDefinitions();
                if (results != null) {
                    int i = 0;
                    while (i < results.length) {
                        IBuildDefinition definition = (IBuildDefinition)results[i];
                        BuildDefinitionHandleHelper helper = new BuildDefinitionHandleHelper(definition.getId(), (IBuildDefinitionHandle)definition);
                        MyBuildsMenuConfigurationDialog.this.fBuildDefinitions.add(helper);
                        ++i;
                    }
                    MyBuildsMenuConfigurationDialog.this.updateSorting();
                    MyBuildsMenuConfigurationDialog.this.setFocusOnOkButton();
                    MyBuildsMenuConfigurationDialog.this.fTableViewer.refresh();
                }
            }
        };
    }

    protected Object[] promptUserToAddDefinitions() {
        String title = BuildUIQueryMessages.BuildQueryView_BUILD_DEFINITION_PREFERENCE_DIALOG_TITLE;
        String message = BuildUIQueryMessages.BuildQueryView_BUILD_DEFINITION_PREFERENCE_DIALOG_MESSAGE;
        BuildDefinitionSelectionDialog dialog = new BuildDefinitionSelectionDialog(null, title, message, true, this.fShowRepositories);
        if (dialog.open() == 0) {
            return dialog.getResult();
        }
        return null;
    }

    protected List<BuildDefinitionHandleHelper> getCurrentSelection() {
        return ((IStructuredSelection)this.fTableViewer.getSelection()).toList();
    }

    protected void updateButtonEnablement() {
        List<BuildDefinitionHandleHelper> selectionList = this.getCurrentSelection();
        BuildDefinitionHandleHelper[] selection = selectionList.toArray(new BuildDefinitionHandleHelper[selectionList.size()]);
        this.fRemoveButton.setEnabled(selection.length > 0);
        this.fUpButton.setEnabled(!this.fSortButton.getSelection() && selection.length > 0 && this.fBuildDefinitions.indexOf(selection[0]) > 0);
        this.fDownButton.setEnabled(!this.fSortButton.getSelection() && selection.length > 0 && this.fBuildDefinitions.indexOf(selection[selection.length - 1]) < this.fBuildDefinitions.size() - 1);
    }

    protected SelectionListener getRemoveListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (BuildDefinitionHandleHelper helper : MyBuildsMenuConfigurationDialog.this.getCurrentSelection()) {
                    MyBuildsMenuConfigurationDialog.this.fBuildDefinitions.remove(helper);
                }
                MyBuildsMenuConfigurationDialog.this.setFocusOnOkButton();
                MyBuildsMenuConfigurationDialog.this.fTableViewer.refresh();
            }
        };
    }

    protected ISelectionChangedListener getSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MyBuildsMenuConfigurationDialog.this.updateButtonEnablement();
            }
        };
    }

    protected void okPressed() {
        BuildUIPlugin.getDefault().getPreferenceStore().setValue(SORT_DEFINITIONS_PREFERENCE_KEY, this.fSortButton.getSelection());
        BuildUIPlugin.getDefault().savePluginPreferences();
        super.okPressed();
    }
}

