/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.views.query;

import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.build.internal.ui.helper.BuildStateTextHelper;
import com.ibm.team.build.internal.ui.query.BuildQueryRow;
import com.ibm.team.build.internal.ui.tooltips.support.ColumnAwareTooltipSupport;
import com.ibm.team.build.internal.ui.views.query.BuildUIQueryMessages;
import com.ibm.team.build.ui.BuildUI;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.ui.internal.utils.WorkbenchUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class BuildsViewTooltipSupport
extends ColumnAwareTooltipSupport {
    private Table fTable;

    public BuildsViewTooltipSupport(Table table) {
        super((Control)table, true, true);
        this.fTable = table;
    }

    protected Object getTooltipObjectForColumn(int columnPosition, Object data) {
        if (data != null && data instanceof BuildQueryRow) {
            return ((BuildQueryRow)data).getBuildResultRecord();
        }
        return null;
    }

    protected void openRequested(Object element) {
        IBuildResultRecord record = (IBuildResultRecord)element;
        IBuildResult result = record.getBuildResult();
        if (result.getState() == BuildState.NOT_STARTED || result.getState() == BuildState.CANCELED) {
            this.showCantOpenMessage(result);
            return;
        }
        BuildUI.getDefault().open((IBuildResultHandle)result, (ITeamRepository)result.getOrigin(), WorkbenchUtil.getPage((Shell)this.fTable.getShell()));
    }

    protected void showCantOpenMessage(IBuildResult result) {
        MessageDialog.openInformation((Shell)this.fTable.getShell(), (String)BuildUIQueryMessages.BuildsViewTooltipSupport_DIALOG_TITLE, (String)NLS.bind((String)BuildUIQueryMessages.BuildsViewTooltipSupport_CANNOT_OPEN_MESSAGE, (Object)BuildStateTextHelper.getText(result.getState())));
    }
}

