/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.views.query;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.query.BuildQuery;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildQueryViewHistory {
    private final ArrayList<BuildQuery> fQueryQueue = new ArrayList();
    private final int fMaxEntryCount;

    public BuildQueryViewHistory() {
        this(8);
    }

    public BuildQueryViewHistory(int maxEntryCount) {
        this.fMaxEntryCount = maxEntryCount;
    }

    public int getMaxEntryCount() {
        return this.fMaxEntryCount;
    }

    public List<BuildQuery> getEntries() {
        return new ArrayList<BuildQuery>(this.fQueryQueue);
    }

    public BuildQuery getMostRecent() {
        if (this.fQueryQueue.isEmpty()) {
            return null;
        }
        return this.fQueryQueue.get(0);
    }

    public void addEntry(BuildQuery query) {
        ValidationHelper.validateNotNull((String)"query", (Object)query);
        this.remove(query.getName());
        this.fQueryQueue.add(0, query);
        if (this.fQueryQueue.size() > this.fMaxEntryCount) {
            this.fQueryQueue.remove(this.fMaxEntryCount);
        }
    }

    private void remove(String queryName) {
        int i = 0;
        while (i < this.fQueryQueue.size()) {
            BuildQuery query = this.fQueryQueue.get(i);
            if (queryName.equals(query.getName())) {
                this.fQueryQueue.remove(i);
                break;
            }
            ++i;
        }
    }
}

