/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.views.query;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.views.query.BuildQueryColumn;
import com.ibm.team.build.internal.ui.views.query.BuildQueryColumnRegistry;
import com.ibm.team.build.internal.ui.views.query.BuildQueryDisplayPreferences;
import com.ibm.team.build.internal.ui.views.query.BuildQueryView;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.widgets.TableColumn;

public class BuildQueryViewColumnListener
extends ControlAdapter {
    private final BuildQueryView fBuildQueryView;
    private boolean fIsEnabled = false;

    public BuildQueryViewColumnListener(BuildQueryView buildQueryView) {
        ValidationHelper.validateNotNull((String)"buildQueryView", (Object)((Object)buildQueryView));
        this.fBuildQueryView = buildQueryView;
    }

    public boolean isEnabled() {
        return this.fIsEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.fIsEnabled = isEnabled;
    }

    public void controlMoved(ControlEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        BuildQueryDisplayPreferences preferences = this.getPreferences();
        if (preferences == null) {
            return;
        }
        TableColumn tableColumn = this.getTableColumn(e);
        preferences.setBuildQueryColumnOrder(tableColumn.getParent(), this.getColumnRegistry());
    }

    public void controlResized(ControlEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        BuildQueryDisplayPreferences preferences = this.getPreferences();
        if (preferences == null) {
            return;
        }
        TableColumn tableColumn = this.getTableColumn(e);
        BuildQueryColumn buildQueryColumn = (BuildQueryColumn)tableColumn.getData();
        preferences.setBuildQueryColumnWidth(buildQueryColumn.getClass(), tableColumn.getWidth());
    }

    protected TableColumn getTableColumn(ControlEvent controlEvent) {
        return (TableColumn)controlEvent.widget;
    }

    protected BuildQueryDisplayPreferences getPreferences() {
        return this.fBuildQueryView.getPreferences();
    }

    protected BuildQueryColumnRegistry getColumnRegistry() {
        return this.fBuildQueryView.getColumnRegistry();
    }
}

