/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.views.query;

import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.views.query.BuildQueryColumn;
import com.ibm.team.build.internal.ui.views.query.BuildQueryColumnRegistry;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildQueryDisplayPreferences {
    private final String fKey;
    private static final String fBuildQueryDisplayPreferenceNamePrefix = "BuildQueryDisplayPreferences";
    private static final String fPreferenceNameSeparator = "/";
    private static final String fPreferenceValueSeparatorForBuildQueryColumnOrder = ",";
    private static final Pattern fPreferenceValuePatternForBuildQueryColumnOrder = Pattern.compile(",");
    private final String fPreferenceNameForBuildQueryColumnOrder;
    private final String fPreferenceNamePrefixForBuildQueryColumnWidth;
    private final String fPreferenceNamePrefixForBuildQueryColumnVisible;
    private final String fPreferenceNamePrefixForBuildStatusFiltered;
    private final String fPreferenceNamePrefixForBuildStateFiltered;

    public BuildQueryDisplayPreferences(String key) {
        ValidationHelper.validateNotNull((String)"key", (Object)key);
        this.fKey = key;
        this.fPreferenceNameForBuildQueryColumnOrder = this.constructPreferenceNameConstant("BuildQueryColumnOrder", false);
        this.fPreferenceNamePrefixForBuildQueryColumnWidth = this.constructPreferenceNameConstant("BuildQueryColumnWidth", true);
        this.fPreferenceNamePrefixForBuildQueryColumnVisible = this.constructPreferenceNameConstant("BuildQueryColumnVisible", true);
        this.fPreferenceNamePrefixForBuildStatusFiltered = this.constructPreferenceNameConstant("BuildStatusFiltered", true);
        this.fPreferenceNamePrefixForBuildStateFiltered = this.constructPreferenceNameConstant("BuildStateFiltered", true);
        List<Class<? extends BuildQueryColumn>> allBuildQueryColumnTypes = BuildQueryColumnRegistry.getAllBuildQueryColumnTypes();
        List<Class<? extends BuildQueryColumn>> defaultHiddenBuildQueryColumnTypes = BuildQueryColumnRegistry.getDefaultHiddenBuildQueryColumnTypes();
        for (Class<? extends BuildQueryColumn> buildQueryColumnType : allBuildQueryColumnTypes) {
            String preferenceName = this.getPreferenceNameForBuildQueryColumnVisibility(buildQueryColumnType);
            boolean isHidden = defaultHiddenBuildQueryColumnTypes.contains(buildQueryColumnType);
            this.getPreferenceStore().setDefault(preferenceName, !isHidden);
        }
    }

    private String constructPreferenceNameConstant(String id, boolean isPrefix) {
        String preferenceName = "BuildQueryDisplayPreferences/" + this.fKey + fPreferenceNameSeparator + id;
        if (isPrefix) {
            preferenceName = String.valueOf(preferenceName) + fPreferenceNameSeparator;
        }
        return preferenceName;
    }

    public String getKey() {
        return this.fKey;
    }

    protected IPreferenceStore getPreferenceStore() {
        return BuildUIPlugin.getDefault().getPreferenceStore();
    }

    public List<Class<? extends BuildQueryColumn>> getBuildQueryColumnOrder() {
        String[] buildQueryColumnTypeNames;
        ArrayList<Class<? extends BuildQueryColumn>> buildQueryColumnOrder = new ArrayList<Class<? extends BuildQueryColumn>>();
        String encodedBuildQueryColumnOrder = this.getPreferenceStore().getString(this.fPreferenceNameForBuildQueryColumnOrder);
        String[] stringArray = buildQueryColumnTypeNames = fPreferenceValuePatternForBuildQueryColumnOrder.split(encodedBuildQueryColumnOrder);
        int n = buildQueryColumnTypeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String buildQueryColumnTypeName = stringArray[n2];
            Class<? extends BuildQueryColumn> buildQueryColumnType = BuildQueryColumnRegistry.getBuildQueryColumnType(buildQueryColumnTypeName);
            if (buildQueryColumnType != null) {
                buildQueryColumnOrder.add(buildQueryColumnType);
            }
            ++n2;
        }
        List<Class<? extends BuildQueryColumn>> allBuildQueryColumnTypes = BuildQueryColumnRegistry.getAllBuildQueryColumnTypes();
        for (Class<? extends BuildQueryColumn> buildQueryColumnType : allBuildQueryColumnTypes) {
            if (buildQueryColumnOrder.contains(buildQueryColumnType)) continue;
            buildQueryColumnOrder.add(buildQueryColumnType);
        }
        return buildQueryColumnOrder;
    }

    /*
     * WARNING - void declaration
     */
    public void setBuildQueryColumnOrder(Table buildQueryTable, BuildQueryColumnRegistry buildQueryColumnRegistry) {
        void var5_8;
        ValidationHelper.validateNotNull((String)"buildQueryTable", (Object)buildQueryTable);
        ValidationHelper.validateNotNull((String)"buildQueryColumnRegistry", (Object)buildQueryColumnRegistry);
        ArrayList buildQueryColumnOrder = new ArrayList();
        int[] nArray = buildQueryTable.getColumnOrder();
        int n = nArray.length;
        boolean n2 = false;
        while (var5_8 < n) {
            int columnPosition = nArray[var5_8];
            TableColumn tableColumn = buildQueryTable.getColumn(columnPosition);
            BuildQueryColumn buildQueryColumn = (BuildQueryColumn)tableColumn.getData();
            buildQueryColumnOrder.add(buildQueryColumn.getClass());
            ++var5_8;
        }
        for (BuildQueryColumn buildQueryColumn : buildQueryColumnRegistry.getBuildQueryColumns()) {
            if (buildQueryColumn.isVisible()) continue;
            buildQueryColumnOrder.add(buildQueryColumn.getClass());
        }
        StringBuilder encodedBuildQueryColumnOrder = new StringBuilder();
        for (Class clazz : buildQueryColumnOrder) {
            if (encodedBuildQueryColumnOrder.length() != 0) {
                encodedBuildQueryColumnOrder.append(fPreferenceValueSeparatorForBuildQueryColumnOrder);
            }
            encodedBuildQueryColumnOrder.append(clazz.getSimpleName());
        }
        this.getPreferenceStore().setValue(this.fPreferenceNameForBuildQueryColumnOrder, encodedBuildQueryColumnOrder.toString());
    }

    public int getBuildQueryColumnWidth(Class<? extends BuildQueryColumn> buildQueryColumnType) {
        ValidationHelper.validateNotNull((String)"buildQueryColumnType", buildQueryColumnType);
        String preferenceName = this.getPreferenceNameForBuildQueryColumnWidth(buildQueryColumnType);
        return this.getPreferenceStore().getInt(preferenceName);
    }

    private String getPreferenceNameForBuildQueryColumnWidth(Class<? extends BuildQueryColumn> buildQueryColumnType) {
        return String.valueOf(this.fPreferenceNamePrefixForBuildQueryColumnWidth) + buildQueryColumnType.getSimpleName();
    }

    public void setBuildQueryColumnWidth(Class<? extends BuildQueryColumn> buildQueryColumnType, int width) {
        ValidationHelper.validateNotNull((String)"buildQueryColumnType", buildQueryColumnType);
        String preferenceName = this.getPreferenceNameForBuildQueryColumnWidth(buildQueryColumnType);
        this.getPreferenceStore().setValue(preferenceName, width);
    }

    public boolean isBuildQueryColumnVisible(Class<? extends BuildQueryColumn> buildQueryColumnType) {
        ValidationHelper.validateNotNull((String)"buildQueryColumnType", buildQueryColumnType);
        String preferenceName = this.getPreferenceNameForBuildQueryColumnVisibility(buildQueryColumnType);
        return this.getPreferenceStore().getBoolean(preferenceName);
    }

    private String getPreferenceNameForBuildQueryColumnVisibility(Class<? extends BuildQueryColumn> buildQueryColumnType) {
        return String.valueOf(this.fPreferenceNamePrefixForBuildQueryColumnVisible) + buildQueryColumnType.getSimpleName();
    }

    public void setBuildQueryColumnVisible(Class<? extends BuildQueryColumn> buildQueryColumnType, boolean isVisible) {
        ValidationHelper.validateNotNull((String)"buildQueryColumnType", buildQueryColumnType);
        String preferenceName = this.getPreferenceNameForBuildQueryColumnVisibility(buildQueryColumnType);
        this.getPreferenceStore().setValue(preferenceName, isVisible);
    }

    public boolean isBuildStatusFiltered(BuildStatus buildStatus) {
        ValidationHelper.validateNotNull((String)"buildStatus", (Object)buildStatus);
        String preferenceName = this.getPreferenceNameForBuildStatusFiltered(buildStatus);
        return this.getPreferenceStore().getBoolean(preferenceName);
    }

    private String getPreferenceNameForBuildStatusFiltered(BuildStatus buildStatus) {
        return String.valueOf(this.fPreferenceNamePrefixForBuildStatusFiltered) + buildStatus.name();
    }

    public void setBuildStatusFiltered(BuildStatus buildStatus, boolean isFiltered) {
        ValidationHelper.validateNotNull((String)"buildStatus", (Object)buildStatus);
        String preferenceName = this.getPreferenceNameForBuildStatusFiltered(buildStatus);
        this.getPreferenceStore().setValue(preferenceName, isFiltered);
    }

    public EnumSet<BuildStatus> getBuildStatusFilters() {
        EnumSet<BuildStatus> buildStatusFilters = EnumSet.noneOf(BuildStatus.class);
        BuildStatus[] buildStatusArray = BuildStatus.values();
        int n = buildStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            BuildStatus buildStatus = buildStatusArray[n2];
            if (this.isBuildStatusFiltered(buildStatus)) {
                buildStatusFilters.add(buildStatus);
            }
            ++n2;
        }
        return buildStatusFilters;
    }

    public void setBuildStatusFilters(EnumSet<BuildStatus> buildStatusFilters) {
        ValidationHelper.validateNotNull((String)"buildStatusFilters", buildStatusFilters);
        BuildStatus[] buildStatusArray = BuildStatus.values();
        int n = buildStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            BuildStatus buildStatus = buildStatusArray[n2];
            this.setBuildStatusFiltered(buildStatus, buildStatusFilters.contains(buildStatus));
            ++n2;
        }
    }

    public boolean isBuildStateFiltered(BuildState buildState) {
        ValidationHelper.validateNotNull((String)"buildState", (Object)buildState);
        String preferenceName = this.getPreferenceNameForBuildStateFiltered(buildState);
        return this.getPreferenceStore().getBoolean(preferenceName);
    }

    private String getPreferenceNameForBuildStateFiltered(BuildState buildState) {
        return String.valueOf(this.fPreferenceNamePrefixForBuildStateFiltered) + buildState.name();
    }

    public void setBuildStateFiltered(BuildState buildState, boolean isFiltered) {
        ValidationHelper.validateNotNull((String)"buildState", (Object)buildState);
        String preferenceName = this.getPreferenceNameForBuildStateFiltered(buildState);
        this.getPreferenceStore().setValue(preferenceName, isFiltered);
    }

    public EnumSet<BuildState> getBuildStateFilters() {
        EnumSet<BuildState> buildStateFilters = EnumSet.noneOf(BuildState.class);
        BuildState[] buildStateArray = BuildState.values();
        int n = buildStateArray.length;
        int n2 = 0;
        while (n2 < n) {
            BuildState buildState = buildStateArray[n2];
            if (this.isBuildStateFiltered(buildState)) {
                buildStateFilters.add(buildState);
            }
            ++n2;
        }
        return buildStateFilters;
    }

    public void setBuildStateFilters(EnumSet<BuildState> buildStateFilters) {
        ValidationHelper.validateNotNull((String)"buildStateFilters", buildStateFilters);
        BuildState[] buildStateArray = BuildState.values();
        int n = buildStateArray.length;
        int n2 = 0;
        while (n2 < n) {
            BuildState buildState = buildStateArray[n2];
            this.setBuildStateFiltered(buildState, buildStateFilters.contains(buildState));
            ++n2;
        }
    }
}

