/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.views.query;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.views.query.BuildQueryColumn;
import com.ibm.team.build.internal.ui.views.query.BuildQueryView;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildQueryColumnRegistry {
    private static ArrayList<Class<? extends BuildQueryColumn>> fBuildQueryColumnTypes;
    private static ArrayList<Class<? extends BuildQueryColumn>> fDefaultHiddenBuildQueryColumnTypes;
    private static HashMap<String, Class<? extends BuildQueryColumn>> fBuildQueryColumnTypeBySimpleName;
    private final BuildQueryView fBuildQueryView;
    private final HashMap<Class<? extends BuildQueryColumn>, BuildQueryColumn> fBuildQueryColumns = new HashMap();
    private final TreeMap<String, BuildQueryColumn> fSortedBuildQueryColumns = new TreeMap(Collator.getInstance());

    public static Class<? extends BuildQueryColumn> getBuildQueryColumnType(String buildQueryColumnSimpleName) {
        if (fBuildQueryColumnTypeBySimpleName == null) {
            fBuildQueryColumnTypeBySimpleName = new HashMap();
            for (Class<? extends BuildQueryColumn> buildQueryColumnType : BuildQueryColumnRegistry.getAllBuildQueryColumnTypes()) {
                fBuildQueryColumnTypeBySimpleName.put(buildQueryColumnType.getSimpleName(), buildQueryColumnType);
            }
        }
        return fBuildQueryColumnTypeBySimpleName.get(buildQueryColumnSimpleName);
    }

    public static List<Class<? extends BuildQueryColumn>> getAllBuildQueryColumnTypes() {
        if (fBuildQueryColumnTypes == null) {
            fBuildQueryColumnTypes = new ArrayList();
            fBuildQueryColumnTypes.add(BuildQueryColumn.Status.class);
            fBuildQueryColumnTypes.add(BuildQueryColumn.State.class);
            fBuildQueryColumnTypes.add(BuildQueryColumn.BuildDefinition.class);
            fBuildQueryColumnTypes.add(BuildQueryColumn.Label.class);
            fBuildQueryColumnTypes.add(BuildQueryColumn.Progress.class);
            fBuildQueryColumnTypes.add(BuildQueryColumn.EstimatedCompletionTime.class);
            fBuildQueryColumnTypes.add(BuildQueryColumn.StartTime.class);
            fBuildQueryColumnTypes.add(BuildQueryColumn.TimeTaken.class);
            fBuildQueryColumnTypes.add(BuildQueryColumn.Tags.class);
            fBuildQueryColumnTypes.addAll(BuildQueryColumnRegistry.getDefaultHiddenBuildQueryColumnTypes());
        }
        return new ArrayList<Class<? extends BuildQueryColumn>>(fBuildQueryColumnTypes);
    }

    public static List<Class<? extends BuildQueryColumn>> getDefaultHiddenBuildQueryColumnTypes() {
        if (fDefaultHiddenBuildQueryColumnTypes == null) {
            fDefaultHiddenBuildQueryColumnTypes = new ArrayList();
            fDefaultHiddenBuildQueryColumnTypes.add(BuildQueryColumn.BuildEngineId.class);
            fDefaultHiddenBuildQueryColumnTypes.add(BuildQueryColumn.CompletionTime.class);
            fDefaultHiddenBuildQueryColumnTypes.add(BuildQueryColumn.Requestor.class);
            fDefaultHiddenBuildQueryColumnTypes.add(BuildQueryColumn.TimeInQueue.class);
        }
        return fDefaultHiddenBuildQueryColumnTypes;
    }

    public BuildQueryColumnRegistry(BuildQueryView buildQueryView) {
        ValidationHelper.validateNotNull((String)"buildQueryView", (Object)((Object)buildQueryView));
        this.fBuildQueryView = buildQueryView;
        this.init(BuildQueryColumnRegistry.getAllBuildQueryColumnTypes());
    }

    private void init(List<Class<? extends BuildQueryColumn>> buildQueryColumnTypes) {
        try {
            for (Class<? extends BuildQueryColumn> buildQueryColumnType : buildQueryColumnTypes) {
                BuildQueryColumn buildQueryColumn = buildQueryColumnType.newInstance();
                buildQueryColumn.initBuildQueryView(this.fBuildQueryView);
                this.fBuildQueryColumns.put(buildQueryColumn.getClass(), buildQueryColumn);
                this.fSortedBuildQueryColumns.put(buildQueryColumn.getColumnLabel(), buildQueryColumn);
            }
        }
        catch (Exception exception) {
            BuildUIPlugin.log(exception);
        }
    }

    public List<BuildQueryColumn> getBuildQueryColumns() {
        return new ArrayList<BuildQueryColumn>(this.fSortedBuildQueryColumns.values());
    }

    public BuildQueryColumn getBuildQueryColumn(Class<? extends BuildQueryColumn> buildQueryColumnType) {
        return this.fBuildQueryColumns.get(buildQueryColumnType);
    }
}

