/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.views.query;

import com.ibm.team.build.client.iterator.IBuildResultRecordIterator;
import com.ibm.team.build.internal.ui.domain.ConnectedProjectAreaRegistryHelper;
import com.ibm.team.build.internal.ui.query.BuildQuery;
import com.ibm.team.build.internal.ui.query.BuildQueryColumnKind;
import com.ibm.team.build.internal.ui.views.query.AdaptableBuildQueryRow;
import com.ibm.team.build.internal.ui.views.query.BuildUIQueryMessages;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class BuildQueryBySelectedTeamAreas
extends BuildQuery {
    private IProjectAreaHandle fProjectAreaHandle;

    public BuildQueryBySelectedTeamAreas(String name, IProjectAreaHandle projectAreaHandle, ITeamRepository teamRepository) {
        super(name, null, AdaptableBuildQueryRow.Factory, teamRepository);
        this.fProjectAreaHandle = projectAreaHandle;
    }

    protected IBuildResultRecordIterator getIterativeQuery(String[] buildResultProperties, IProgressMonitor monitor) throws TeamRepositoryException {
        List selectedTeams = this.getSelectedTeamAreas();
        if (!selectedTeams.isEmpty()) {
            ITeamAreaHandle[] teamAreaHandles = selectedTeams.toArray(new ITeamAreaHandle[selectedTeams.size()]);
            return this.getRecordClient().getBuildResultRecords(teamAreaHandles, null, buildResultProperties, monitor);
        }
        ITeamAreaHandle[] teamAreaHandles = new ITeamAreaHandle[]{(ITeamAreaHandle)ITeamArea.ITEM_TYPE.createItem()};
        return this.getRecordClient().getBuildResultRecords(teamAreaHandles, null, buildResultProperties, monitor);
    }

    public BuildQueryColumnKind[] getDefaultSortColumns() {
        return new BuildQueryColumnKind[]{BuildQueryColumnKind.StartTime, BuildQueryColumnKind.StartTime};
    }

    public String getDescription() {
        String description = null;
        List selectedTeamAreas = this.getSelectedTeamAreas();
        String projectAreaName = this.getProjectAreaName();
        IProjectArea projectArea = this.getSharedProjectAreaIfKnown();
        if (projectArea != null) {
            int totalTeamAreaCount = projectArea.getTeamAreas().size();
            description = MessageFormat.format(BuildUIQueryMessages.BuildQueryBySelectedTeamAreas_QUERY_DESCRIPTION_KNOWN_TOTAL, selectedTeamAreas.size(), totalTeamAreaCount, projectAreaName);
        } else {
            description = selectedTeamAreas.size() == 1 ? NLS.bind((String)BuildUIQueryMessages.BuildQueryBySelectedTeamAreas_QUERY_DESCRIPTION_SINGULAR_UNKNOWN_TOTAL, (Object)selectedTeamAreas.size(), (Object)projectAreaName) : NLS.bind((String)BuildUIQueryMessages.BuildQueryBySelectedTeamAreas_QUERY_DESCRIPTION_PLURAL_UNKNOWN_TOTAL, (Object)selectedTeamAreas.size(), (Object)projectAreaName);
        }
        return description;
    }

    protected List getSelectedTeamAreas() {
        return ConnectedProjectAreaRegistry.getDefault().getSelectedTeamAreas(this.fProjectAreaHandle);
    }

    protected String getProjectAreaName() {
        return ConnectedProjectAreaRegistryHelper.getProjectAreaName(this.fProjectAreaHandle);
    }

    protected IProjectArea getSharedProjectAreaIfKnown() {
        return (IProjectArea)this.getTeamRepository().itemManager().getSharedItemIfKnown((IItemHandle)this.fProjectAreaHandle);
    }
}

