/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.tooltips.jobs;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIMessages;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.repository.client.ITeamRepository;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public abstract class OpenEditorJob
extends UIJob {
    private final ITeamRepository fTeamRepository;
    private final IWorkbenchPage fWorkbenchPage;

    protected OpenEditorJob(String jobName, ITeamRepository teamRepository, IWorkbenchPage workbenchPage) {
        super(jobName);
        ValidationHelper.validateNotNull((String)"teamRepository", (Object)teamRepository);
        this.fTeamRepository = teamRepository;
        this.fWorkbenchPage = workbenchPage;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page == null) {
            return new Status(4, BuildUIPlugin.getUniqueIdentifier(), 4, BuildUIMessages.BuildUISupport_OPEN_BUILD_RESULT_EDITOR_EXCEPTION_MESSAGE, null);
        }
        try {
            IEditorInput editorInput = this.getEditorInput();
            String editorId = this.getEditorId();
            page.openEditor(editorInput, editorId);
            return Status.OK_STATUS;
        }
        catch (PartInitException exception) {
            this.setName(BuildUIMessages.BuildUISupport_OPEN_BUILD_RESULT_EDITOR_JOB_TITLE_ON_ERROR);
            return new Status(4, BuildUIPlugin.getUniqueIdentifier(), 4, BuildUIMessages.BuildUISupport_OPEN_BUILD_RESULT_EDITOR_EXCEPTION_MESSAGE, (Throwable)exception);
        }
    }

    protected IWorkbenchPage getWorkbenchPage() {
        if (this.fWorkbenchPage != null) {
            return this.fWorkbenchPage;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    protected abstract IEditorInput getEditorInput();

    protected abstract String getEditorId();

    public ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }
}

