/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.tooltips.generators;

import com.ibm.team.build.client.iterator.IBuildResultRecordIterator;
import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultPruningPolicy;
import com.ibm.team.build.common.model.IBuildSchedule;
import com.ibm.team.build.internal.client.ITeamBuildRecordClient;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.build.internal.ui.editors.builddefinition.ScheduleConfigurationEditor;
import com.ibm.team.build.internal.ui.helper.BuildResultTextHelper;
import com.ibm.team.build.internal.ui.helper.TimeFormatHelper;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJobHelper;
import com.ibm.team.build.internal.ui.query.BuildQueryByDefinition;
import com.ibm.team.build.internal.ui.query.BuildQueryRow;
import com.ibm.team.build.internal.ui.tooltips.BuildQueryHyperlinkHandler;
import com.ibm.team.build.internal.ui.tooltips.generators.AbstractBuildHTMLGenerator;
import com.ibm.team.build.internal.ui.tooltips.generators.DescendingBuildResultRecordComparator;
import com.ibm.team.build.internal.ui.tooltips.generators.TooltipsGeneratorsMessages;
import com.ibm.team.jface.preview.HTMLGenerator;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.net.URI;
import java.util.Arrays;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class BuildDefinitionHTMLGenerator
extends AbstractBuildHTMLGenerator {
    private IBuildDefinition fBuildDefinition;

    public BuildDefinitionHTMLGenerator(IBuildDefinition definition) {
        this.fBuildDefinition = definition;
    }

    protected void createFocusControl(HTMLGenerator.Composite parent, IProgressMonitor monitor) {
        HTMLGenerator.Section outermostSection = new HTMLGenerator.Section((HTMLGenerator)this, parent, this.getFocusTitleControl(monitor));
        outermostSection.setCSSClass("outermost");
        parent = outermostSection;
        this.createBuildsSection(parent, monitor);
        IBuildConfigurationElement element = this.fBuildDefinition.getConfigurationElement("com.ibm.team.build.schedule");
        if (element != null) {
            this.createScheduleSection(parent);
        }
        if ((element = this.fBuildDefinition.getConfigurationElement("com.ibm.team.build.general")) != null) {
            this.createPruningSection(parent);
        }
        if ((element = this.fBuildDefinition.getConfigurationElement("com.ibm.team.build.properties")) != null) {
            this.createPropertiesSection(parent);
        }
    }

    protected HTMLGenerator.Control getFocusTitleControl(IProgressMonitor monitor) {
        AbstractBuildHTMLGenerator.CustomTable titleTable = this.createLayoutTable(null, 3);
        titleTable.setBorderCSSClass("padded-right");
        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)titleTable, this.fBuildDefinition.getId()).setCSSClass("bold");
        ITeamRepository repository = this.getTeamRepository((IItemHandle)this.fBuildDefinition);
        if (repository != null) {
            this.createShowBuildsLink(titleTable, repository, monitor);
            HTMLGenerator.Link link = this.createItemLink(titleTable, (IItemHandle)this.fBuildDefinition, repository, monitor);
            new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)link, TooltipsGeneratorsMessages.BuildDefinitionHTMLGenerator_OPEN_DEFINITION_LINK_LABEL);
        } else {
            this.createEmptyCell(titleTable);
            this.createEmptyCell(titleTable);
        }
        return titleTable;
    }

    private void createShowBuildsLink(HTMLGenerator.Composite composite, ITeamRepository repository, IProgressMonitor monitor) {
        BuildQueryByDefinition query = new BuildQueryByDefinition(this.fBuildDefinition.getId(), null, new BuildQueryRow.Factory(), (IBuildDefinitionHandle)this.fBuildDefinition, repository);
        URI uri = new BuildQueryHyperlinkHandler().createHyperlink(query, (IProgressMonitor)this.createSubMonitor(monitor, 1)).getURI();
        HTMLGenerator.Link link = new HTMLGenerator.Link((HTMLGenerator)this, composite, uri.toString());
        new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)link, TooltipsGeneratorsMessages.BuildDefinitionHTMLGenerator_SHOW_BUILD_LINK_LABEL);
    }

    protected void createHoverControl(HTMLGenerator.Composite composite, IProgressMonitor monitor) {
        new HTMLGenerator.Label((HTMLGenerator)this, composite, this.fBuildDefinition.getId()).setCSSClass("bold");
        new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
        new HTMLGenerator.Label((HTMLGenerator)this, composite, this.fBuildDefinition.getDescription());
        ITeamRepository repository = this.getTeamRepository((IItemHandle)this.fBuildDefinition);
        if (repository != null) {
            try {
                BuildResultRecordsResult builds = this.getResultRecords(BuildState.IN_PROGRESS, repository, monitor);
                new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
                String message = builds.getSize() == 1 ? TooltipsGeneratorsMessages.BuildDefinitionHTMLGenerator_1_IN_PROGRESS_BUILD : NLS.bind((String)TooltipsGeneratorsMessages.BuildDefinitionHTMLGenerator_IN_PROGRESS_BUILD, (Object)builds.getSize());
                new HTMLGenerator.Label((HTMLGenerator)this, composite, message);
                if (builds.getSize() > 0) {
                    this.createInProgressBuildsList(composite, builds.getRecords());
                }
            }
            catch (TeamRepositoryException exception) {
                new HTMLGenerator.Label((HTMLGenerator)this, composite, TooltipsGeneratorsMessages.BuildDefinitionHTMLGenerator_ERROR_MESSAGE);
                new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
                new HTMLGenerator.Label((HTMLGenerator)this, composite, TeamBuildJobHelper.getStatusMessage(exception));
            }
        }
    }

    private void createInProgressBuildsList(HTMLGenerator.Composite composite, IBuildResultRecord[] builds) {
        Arrays.sort(builds, new DescendingBuildResultRecordComparator());
        HTMLGenerator.BulletList list = new HTMLGenerator.BulletList((HTMLGenerator)this, composite);
        int i = 0;
        while (i < builds.length) {
            new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)list, BuildResultTextHelper.getLabel(builds[i].getBuildResult()));
            ++i;
        }
    }

    protected void createPruningSection(HTMLGenerator.Composite composite) {
        HTMLGenerator.Section section = new HTMLGenerator.Section((HTMLGenerator)this, composite, (HTMLGenerator.Control)new HTMLGenerator.Label((HTMLGenerator)this, TooltipsGeneratorsMessages.BuildDefinitionEditor_PRUNING_POLICY_TITLE));
        section.setCSSClass("left");
        IBuildResultPruningPolicy policy = this.fBuildDefinition.getBuildResultPruningPolicy();
        if (!policy.isEnabled()) {
            new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)section, TooltipsGeneratorsMessages.BuildDefinitionHTMLGenerator_PRUNING_DISABLED);
        } else {
            new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)section, NLS.bind((String)TooltipsGeneratorsMessages.BuildDefinitionHTMLGenerator_PRUNING_SUCCESSFUL_BUILDS, (Object)String.valueOf(policy.getSuccessfulResultsToKeep())));
            new HTMLGenerator.LineBreak((HTMLGenerator)this, (HTMLGenerator.Composite)section);
            new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)section, NLS.bind((String)TooltipsGeneratorsMessages.BuildDefinitionHTMLGenerator_PRUNING_FAILED_BUILDS, (Object)String.valueOf(policy.getFailedResultsToKeep())));
            new HTMLGenerator.LineBreak((HTMLGenerator)this, (HTMLGenerator.Composite)section);
        }
    }

    protected void createScheduleSection(HTMLGenerator.Composite composite) {
        HTMLGenerator.Section section = new HTMLGenerator.Section((HTMLGenerator)this, composite, (HTMLGenerator.Control)new HTMLGenerator.Label((HTMLGenerator)this, TooltipsGeneratorsMessages.BuildDefinitionEditor_SECTION_TITLE_SCHEDULE));
        section.setCSSClass("left");
        IBuildSchedule schedule = this.fBuildDefinition.getBuildSchedule();
        if (schedule == null || !schedule.isScheduleEnabled()) {
            new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)section, TooltipsGeneratorsMessages.BuildDefinitionHTMLGenerator_SCHEDULIING_DISABLED);
        } else {
            int buildInterval = schedule.getBuildInterval();
            if (buildInterval > 0) {
                new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)section, NLS.bind((String)TooltipsGeneratorsMessages.BuildDefinitionHTMLGenerator_SCHEDULED_CONTINUOUSLY, (Object)String.valueOf(buildInterval)));
            } else {
                int hour = TimeFormatHelper.get12HourFrom24HourFormat(schedule.getBuildHourLocalTime());
                String amPm = TimeFormatHelper.getAmPmFrom24HourFormat(schedule.getBuildHourLocalTime());
                String minute = String.format("%02d", schedule.getBuildMinute());
                new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)section, NLS.bind((String)TooltipsGeneratorsMessages.BuildDefinitionHTMLGenerator_SCHEDULED_TIME, (Object[])new Object[]{String.valueOf(hour), minute, amPm}));
            }
            new HTMLGenerator.LineBreak((HTMLGenerator)this, (HTMLGenerator.Composite)section);
            new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)section, TooltipsGeneratorsMessages.BuildDefinitionHTMLGenerator_BUILD_DAYS);
            new HTMLGenerator.LineBreak((HTMLGenerator)this, (HTMLGenerator.Composite)section);
            if (schedule.isBuildOnMonday()) {
                new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)section, ScheduleConfigurationEditor.MONDAY);
                new HTMLGenerator.LineBreak((HTMLGenerator)this, (HTMLGenerator.Composite)section);
            }
            if (schedule.isBuildOnTuesday()) {
                new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)section, ScheduleConfigurationEditor.TUESDAY);
                new HTMLGenerator.LineBreak((HTMLGenerator)this, (HTMLGenerator.Composite)section);
            }
            if (schedule.isBuildOnWednesday()) {
                new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)section, ScheduleConfigurationEditor.WEDNESDAY);
                new HTMLGenerator.LineBreak((HTMLGenerator)this, (HTMLGenerator.Composite)section);
            }
            if (schedule.isBuildOnThursday()) {
                new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)section, ScheduleConfigurationEditor.THURSDAY);
                new HTMLGenerator.LineBreak((HTMLGenerator)this, (HTMLGenerator.Composite)section);
            }
            if (schedule.isBuildOnFriday()) {
                new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)section, ScheduleConfigurationEditor.FRIDAY);
                new HTMLGenerator.LineBreak((HTMLGenerator)this, (HTMLGenerator.Composite)section);
            }
            if (schedule.isBuildOnSaturday()) {
                new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)section, ScheduleConfigurationEditor.SATURDAY);
                new HTMLGenerator.LineBreak((HTMLGenerator)this, (HTMLGenerator.Composite)section);
            }
            if (schedule.isBuildOnSunday()) {
                new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)section, ScheduleConfigurationEditor.SUNDAY);
                new HTMLGenerator.LineBreak((HTMLGenerator)this, (HTMLGenerator.Composite)section);
            }
        }
    }

    protected void createBuildsSection(HTMLGenerator.Composite composite, IProgressMonitor monitor) {
        ITeamRepository teamRepository = this.getTeamRepository((IItemHandle)this.fBuildDefinition);
        if (teamRepository != null) {
            try {
                BuildResultRecordsResult resultRecords = this.getResultRecords(null, teamRepository, monitor);
                Arrays.sort(resultRecords.getRecords(), new DescendingBuildResultRecordComparator());
                super.createBuildsSection(composite, resultRecords.getRecords(), resultRecords.getSize(), teamRepository, monitor);
            }
            catch (TeamRepositoryException exception) {
                new HTMLGenerator.Label((HTMLGenerator)this, composite, TooltipsGeneratorsMessages.BuildDefinitionHTMLGenerator_ERROR_MESSAGE);
                new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
                new HTMLGenerator.Label((HTMLGenerator)this, composite, TeamBuildJobHelper.getStatusMessage(exception));
            }
        }
    }

    protected BuildResultRecordsResult getResultRecords(BuildState buildState, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        LinkedList<IBuildResultRecord> resultRecords = new LinkedList<IBuildResultRecord>();
        ITeamBuildRecordClient client = (ITeamBuildRecordClient)teamRepository.getClientLibrary(ITeamBuildRecordClient.class);
        BuildState[] buildStates = null;
        if (buildState != null) {
            buildStates = new BuildState[]{buildState};
        }
        IBuildResultRecordIterator resultIter = client.getBuildResultRecords(new IBuildDefinitionHandle[]{this.fBuildDefinition}, buildStates, IBuildResult.PROPERTIES_VIEW_ITEM, (IProgressMonitor)this.createSubMonitor(monitor, 1));
        while (resultIter.hasNext() && resultRecords.size() < 10) {
            IBuildResultRecord[] records;
            IBuildResultRecord[] iBuildResultRecordArray = records = resultIter.next(10, (IProgressMonitor)this.createSubMonitor(monitor, 1));
            int n = records.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildResultRecord buildResultRecord = iBuildResultRecordArray[n2];
                resultRecords.add(buildResultRecord);
                ++n2;
            }
        }
        return new BuildResultRecordsResult(resultRecords.toArray(new IBuildResultRecord[resultRecords.size()]), resultIter.size());
    }

    protected void createPropertiesSection(HTMLGenerator.Composite composite) {
        HTMLGenerator.Section section = new HTMLGenerator.Section((HTMLGenerator)this, composite, (HTMLGenerator.Control)new HTMLGenerator.Label((HTMLGenerator)this, TooltipsGeneratorsMessages.BuildDefinitionHTMLGenerator_PROPERTIES_SECTION_HEADER));
        section.setCSSClass("left");
        AbstractBuildHTMLGenerator.CustomTable table = new AbstractBuildHTMLGenerator.CustomTable((HTMLGenerator.Composite)section, 3);
        table.setCSSClass("properties");
        table.setBorderCSSClass("all");
        for (IBuildProperty currentProperty : this.fBuildDefinition.getProperties()) {
            if (!currentProperty.isGenericEditAllowed()) continue;
            new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, currentProperty.getName());
            new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, currentProperty.getValue());
            new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)table, currentProperty.getDescription());
        }
    }

    protected static class BuildResultRecordsResult {
        private int fTotalNumRecords = 0;
        private IBuildResultRecord[] fRecords;

        public BuildResultRecordsResult(IBuildResultRecord[] buildResultRecords, int totalNumRecords) {
            this.fRecords = buildResultRecords;
            this.fTotalNumRecords = totalNumRecords;
        }

        public int getSize() {
            return this.fTotalNumRecords;
        }

        public IBuildResultRecord[] getRecords() {
            return this.fRecords;
        }
    }
}

