/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.teamcentral;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.domain.BuildDefinitionQueryNode;
import com.ibm.team.build.internal.ui.listeners.AbstractBuildDefinitionChangeListener;
import com.ibm.team.build.internal.ui.teamcentral.BuildSectionContentProvider;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.StructuredViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildSectionItemChangeListener
extends AbstractBuildDefinitionChangeListener {
    private BuildSectionContentProvider fContentProvider;

    public BuildSectionItemChangeListener(BuildSectionContentProvider buildSectionContentProvider, List<BuildDefinitionQueryNode> nodes) throws IllegalArgumentException {
        ValidationHelper.validateNotNull((String)"nodes", nodes);
        this.fContentProvider = buildSectionContentProvider;
        for (BuildDefinitionQueryNode buildDefinitionQueryNode : nodes) {
            this.getItemIdToNodesMap().put(buildDefinitionQueryNode.getBuildDefinition().getItemId().getUuidValue(), buildDefinitionQueryNode);
        }
    }

    @Override
    protected Object getParent() {
        return null;
    }

    @Override
    protected IProjectAreaHandle getProjectAreaHandle() {
        return null;
    }

    @Override
    protected boolean shouldShowDefinition(IBuildDefinition definition, IProgressMonitor monitor) {
        Object originObject = definition.getOrigin();
        if (!(originObject instanceof ITeamRepository)) {
            return false;
        }
        try {
            ITeamRepository repository = (ITeamRepository)originObject;
            IContributor user = repository.loggedInContributor();
            IProcessItemService processService = (IProcessItemService)repository.getClientLibrary(IProcessItemService.class);
            List teamsForUser = processService.findTeamAreas(user, null, (Collection)Collections.singletonList(ITeamArea.ITEM_ID_PROPERTY), monitor);
            ITeamAreaHandle teamAreaHandle = definition.getTeamArea();
            return teamsForUser.contains(teamAreaHandle);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            return false;
        }
    }

    @Override
    protected void addNodesToViewer(Object parent, Object[] nodes) {
        this.fContentProvider.addNodes(nodes);
    }

    @Override
    public StructuredViewer getViewer() {
        return this.fContentProvider.getTableViewer();
    }

    @Override
    protected void removeNodesFromViewer(Object parent, Object[] nodes) {
        this.fContentProvider.removeNodes(nodes);
    }
}

