/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.teamcentral;

import com.ibm.team.build.internal.ui.teamcentral.BuildSectionMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BuildSectionConfigureRefreshDialog
extends Dialog {
    private Composite fComposite;
    private Text fRefreshIntervalText;
    private int fRefreshIntervalMinutes;

    protected BuildSectionConfigureRefreshDialog(Shell parentShell, int defaultRefreshIntevalMinutes) {
        super(parentShell);
        this.fRefreshIntervalMinutes = defaultRefreshIntevalMinutes;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        parent.getShell().setText(BuildSectionMessages.BuildSectionConfigureRefreshDialog_CONFIGURE_REFRESH_DIALOG_TITLE);
        this.fComposite = new Composite(parent, 0);
        this.fComposite.setLayout((Layout)new GridLayout(1, false));
        this.createRefreshIntervalComposite(this.fComposite);
        this.fComposite.layout();
        return this.fComposite;
    }

    private void createRefreshIntervalComposite(Composite parent) {
        Composite refreshIntervalComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        refreshIntervalComposite.setLayout((Layout)layout);
        new Label(refreshIntervalComposite, 0).setText(BuildSectionMessages.BuildSectionConfigureRefreshDialog_CONFIGURE_REFRESH_DIALOG_TEXT_1);
        this.fRefreshIntervalText = new Text(refreshIntervalComposite, 2048);
        this.fRefreshIntervalText.setText(Integer.toString(this.fRefreshIntervalMinutes));
        this.fRefreshIntervalText.addListener(25, this.createIntegerInputListener());
        GridData textGridData = new GridData();
        textGridData.widthHint = 40;
        this.fRefreshIntervalText.setLayoutData((Object)textGridData);
        new Label(refreshIntervalComposite, 0).setText(BuildSectionMessages.BuildSectionConfigureRefreshDialog_CONFIGURE_REFRESH_DIALOG_TEXT_2);
        this.fRefreshIntervalText.selectAll();
    }

    protected Listener createIntegerInputListener() {
        return new Listener(){

            public void handleEvent(Event e) {
                char[] chars = e.text.toCharArray();
                int i = 0;
                while (i < chars.length) {
                    if (!Character.isDigit(chars[i])) {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        };
    }

    protected void okPressed() {
        this.fRefreshIntervalMinutes = Integer.parseInt(this.getRefreshIntervalText().getText());
        super.okPressed();
    }

    protected Text getRefreshIntervalText() {
        return this.fRefreshIntervalText;
    }

    public int getRefreshIntervalMinutes() {
        return this.fRefreshIntervalMinutes;
    }
}

