/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.teamcentral;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.dialogs.definitions.BuildDefinitionSelectionDialog;
import com.ibm.team.build.internal.ui.domain.BuildDefinitionQueryNode;
import com.ibm.team.build.internal.ui.domain.BuildDomainActionHelper;
import com.ibm.team.build.internal.ui.domain.BuildDomainLabelProvider;
import com.ibm.team.build.internal.ui.domain.BuildDomainQueryNode;
import com.ibm.team.build.internal.ui.helper.BuildDefinitionHandleHelper;
import com.ibm.team.build.internal.ui.helper.BuildUIPreferencesHelper;
import com.ibm.team.build.internal.ui.teamcentral.BuildSectionConfigureRefreshDialog;
import com.ibm.team.build.internal.ui.teamcentral.BuildSectionContentProvider;
import com.ibm.team.build.internal.ui.teamcentral.BuildSectionMessages;
import com.ibm.team.build.internal.ui.teamcentral.BuildSectionTooltipSupport;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.NoScrollbarsTable;
import com.ibm.team.jface.dashboard.ISection;
import com.ibm.team.jface.dashboard.ISectionListener;
import com.ibm.team.jface.dashboard.ISectionSite;
import com.ibm.team.jface.dashboard.Section;
import com.ibm.team.jface.dashboard.SectionLabel;
import com.ibm.team.jface.tooltip.TooltipSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildSection
extends Section
implements ISection,
ISectionListener {
    public static final String DEFINITIONS_PREFERENCE_STORE_KEY = "team.central.build.section.build.definitions";
    public static final String DEFINITIONS_CUSTOMIZED_KEY = "team.central.build.section.is.customized";
    public static final String REFRESH_INTERVAL_MINUTES_PREFERENCE_KEY = "team.central.build.section.refresh.interval.minutes";
    private static final int REFRESH_INTERVAL_MINUTES_DEFAULT = 0;
    public static final Object SHOW_USERS_TEAM_BUILDS_INPUT = new Object();
    private Composite fContainer;
    private boolean isMac = this.isMac();
    private TableViewer fTableViewer;
    private NoScrollbarsTable fCustomScrollTable;
    private SectionLabel fTeaserLabel;
    private boolean fIsExpanded;
    private List<BuildDefinitionHandleHelper> fBuildsToDisplay;
    private boolean isBuildsToDisplayCustomized;
    protected Thread fRefreshThread;
    protected int fRefreshIntervalMinutes;
    private boolean fIsDisposed;
    private BuildSectionContentProvider fContentProvider;

    public BuildSection() {
        BuildUIPlugin.getDefault().getPreferenceStore().setDefault(REFRESH_INTERVAL_MINUTES_PREFERENCE_KEY, 0);
        this.fRefreshIntervalMinutes = BuildUIPlugin.getDefault().getPreferenceStore().getInt(REFRESH_INTERVAL_MINUTES_PREFERENCE_KEY);
    }

    protected boolean isMac() {
        return "carbon".equals(SWT.getPlatform());
    }

    public void createContent(Composite parent) {
        this.fContainer = parent;
        if (this.isMac) {
            Table buildTable = new Table(this.fContainer, 98306);
            this.fTableViewer = new TableViewer(buildTable);
        } else {
            this.fCustomScrollTable = new NoScrollbarsTable(this.fContainer, 32770);
            this.fCustomScrollTable.getTable().setBackground(this.fContainer.getBackground());
            this.fTableViewer = new TableViewer(this.fCustomScrollTable.getTable());
        }
        this.createTooltipSupport();
        this.fContentProvider = new BuildSectionContentProvider(this);
        this.fTableViewer.setContentProvider((IContentProvider)this.fContentProvider);
        BuildDomainLabelProvider labelProvider = new BuildDomainLabelProvider();
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.fTableViewer.setComparator(new ViewerComparator());
        this.fTableViewer.setInput(this.getInput());
        this.getSectionSite().addSelectionProvider((ISelectionProvider)this.fTableViewer);
        this.fTableViewer.addDoubleClickListener(this.createOpenNodeListener());
        this.createContextMenu((ContentViewer)this.fTableViewer);
        this.createRefreshThread();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fContainer, "com.ibm.team.build.ui.teamcentral");
    }

    private void createRefreshThread() {
        this.fRefreshThread = new Thread(){

            public void run() {
                long sinceLastRefresh = 0L;
                while (!BuildSection.this.fIsDisposed) {
                    try {
                        if (BuildSection.this.getRefreshIntervalMilliseconds() > 0L && sinceLastRefresh >= BuildSection.this.getRefreshIntervalMilliseconds()) {
                            Display.getDefault().asyncExec(new Runnable(){

                                public void run() {
                                    if (!BuildSection.this.fIsDisposed) {
                                        BuildSection.this.internalRefreshContent(false);
                                    }
                                }
                            });
                            sinceLastRefresh = 0L;
                        }
                        Thread.sleep(BuildSection.this.getRefreshThreadSleepTimeMilliseconds());
                        sinceLastRefresh += BuildSection.this.getRefreshThreadSleepTimeMilliseconds();
                    }
                    catch (InterruptedException interruptedException) {
                        BuildSection.this.handleInterruptedException();
                    }
                }
            }
        };
        this.fRefreshThread.start();
    }

    protected void handleInterruptedException() {
    }

    protected long getRefreshThreadSleepTimeMilliseconds() {
        return 60000L;
    }

    protected int getRefreshIntervalMinutes() {
        return this.fRefreshIntervalMinutes;
    }

    protected long getRefreshIntervalMilliseconds() {
        return this.getRefreshIntervalMinutes() * 60 * 1000;
    }

    private Object getInput() {
        if (!this.isSectionCustomized()) {
            return SHOW_USERS_TEAM_BUILDS_INPUT;
        }
        ArrayList<IBuildDefinitionHandle> definitionHandles = new ArrayList<IBuildDefinitionHandle>();
        for (BuildDefinitionHandleHelper buildDefinitionHandleHelper : this.fBuildsToDisplay) {
            definitionHandles.add(buildDefinitionHandleHelper.getBuildDefinitionHandle());
        }
        return definitionHandles;
    }

    protected boolean isSectionCustomized() {
        return this.isBuildsToDisplayCustomized;
    }

    protected TooltipSupport createTooltipSupport() {
        return new BuildSectionTooltipSupport(this.getSectionSite().getViewSite(), (Control)this.fTableViewer.getTable());
    }

    public void dispose() {
        this.fIsDisposed = true;
        if (this.fRefreshThread != null) {
            this.fRefreshThread.interrupt();
        }
        if (this.getSectionSite() != null) {
            this.getSectionSite().removeSectionListener((ISectionListener)this);
        }
    }

    private void createContextMenu(ContentViewer viewer) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(this.createMenuListener(viewer));
        viewer.getControl().setMenu(menuMgr.createContextMenu(viewer.getControl()));
        this.getSectionSite().getViewSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
    }

    protected IMenuListener createMenuListener(final ContentViewer viewer) {
        return new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                BuildSection.this.contextMenuAboutToShow(manager, viewer);
            }
        };
    }

    protected void contextMenuAboutToShow(IMenuManager menuMgr, ContentViewer viewer) {
        ISelection selection = viewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            menuMgr.add((IContributionItem)new GroupMarker("jazz.open.group"));
            BuildDomainActionHelper actionHelper = this.createMenuHelper(menuMgr, (IStructuredSelection)selection);
            actionHelper.contributeActions();
        }
        menuMgr.add((IContributionItem)new Separator());
        if (!selection.isEmpty()) {
            menuMgr.add(this.createRemoveBuildAction());
        }
        menuMgr.add((IContributionItem)new Separator("additions"));
    }

    protected IAction createRemoveBuildAction() {
        return new Action(BuildSectionMessages.BuildSection_REMOVE_BUILD_ACTION_NAME){

            public void run() {
                IStructuredSelection structuredSelection = BuildSection.this.getTableSelection();
                BuildSection.this.removeBuildsFromBuildsToDisplay(structuredSelection.toList());
                ((BuildSectionContentProvider)BuildSection.this.getTableViewer().getContentProvider()).removeNodes(structuredSelection.toArray());
            }
        };
    }

    protected BuildDomainActionHelper createMenuHelper(IMenuManager menuMgr, IStructuredSelection selection) {
        return new BuildDomainActionHelper(menuMgr, selection, (IWorkbenchPartSite)this.getSectionSite().getViewSite());
    }

    protected IDoubleClickListener createOpenNodeListener() {
        return new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection structured = (IStructuredSelection)selection;
                Object element = structured.getFirstElement();
                if (element instanceof BuildDomainQueryNode) {
                    BuildDomainQueryNode node = (BuildDomainQueryNode)element;
                    node.open((IWorkbenchSite)BuildSection.this.getSectionSite().getViewSite());
                }
            }
        };
    }

    public void createTeaser(Composite parent) {
        GridLayout grid = new GridLayout(1, false);
        grid.marginHeight = 0;
        grid.marginWidth = 1;
        grid.horizontalSpacing = 1;
        grid.marginTop = 1;
        parent.setLayout((Layout)grid);
        this.fTeaserLabel = new SectionLabel(parent, 131072);
        this.fTeaserLabel.setBackground(parent.getBackground());
        this.fTeaserLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, true));
        LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.fTeaserLabel);
        this.fTeaserLabel.setForeground(JazzResources.getColor((ResourceManager)resourceManager, (RGB)new RGB(255, 0, 0)));
        Font font = JFaceResources.getDefaultFont();
        FontData[] fontData = font.getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setHeight(fontData[i].getHeight() - 1);
            ++i;
        }
        this.fTeaserLabel.setFont(JazzResources.getFont((ResourceManager)resourceManager, (FontDescriptor)FontDescriptor.createFrom((FontData[])fontData), (Font)font));
        Menu buildMenu = this.getSectionSite().getSectionMenu();
        this.initializeSectionMenu(buildMenu);
    }

    protected SelectionListener createRefreshSettingsListener(final Shell parent) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildSectionConfigureRefreshDialog dialog = BuildSection.this.createConfigureRefreshDialog(parent);
                if (dialog.open() == 0) {
                    BuildSection.this.fRefreshIntervalMinutes = dialog.getRefreshIntervalMinutes();
                    BuildUIPlugin.getDefault().getPreferenceStore().setValue(BuildSection.REFRESH_INTERVAL_MINUTES_PREFERENCE_KEY, BuildSection.this.fRefreshIntervalMinutes);
                    BuildUIPlugin.getDefault().savePluginPreferences();
                    BuildSection.this.internalRefreshContent(true);
                }
            }
        };
    }

    protected SelectionListener createAddBuildsListener(final Shell shell) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBuildDefinition[] addedBuilds = BuildSection.this.openBuildDefinitionSelectionDialog(shell);
                if (addedBuilds == null) {
                    return;
                }
                if (!BuildSection.this.isSectionCustomized()) {
                    List<BuildDefinitionQueryNode> nodes = ((BuildSectionContentProvider)BuildSection.this.getTableViewer().getContentProvider()).getBuildDefinitionQueryNodes();
                    BuildSection.this.fBuildsToDisplay = BuildSection.this.getDefinitions(addedBuilds, nodes);
                    BuildSection.this.isBuildsToDisplayCustomized = true;
                } else {
                    IBuildDefinition[] iBuildDefinitionArray = addedBuilds;
                    int n = addedBuilds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IBuildDefinition buildDefinition = iBuildDefinitionArray[n2];
                        if (BuildSection.this.findBuildDefinitionHelper((IBuildDefinitionHandle)buildDefinition, BuildSection.this.fBuildsToDisplay) == null) {
                            BuildDefinitionHandleHelper helper = new BuildDefinitionHandleHelper(buildDefinition.getId(), (IBuildDefinitionHandle)buildDefinition);
                            BuildSection.this.fBuildsToDisplay.add(helper);
                        }
                        ++n2;
                    }
                }
                BuildSection.this.storePreferences(BuildSection.this.fBuildsToDisplay);
                BuildSection.this.internalRefreshContent(true);
            }
        };
    }

    protected BuildDefinitionHandleHelper findBuildDefinitionHelper(IBuildDefinitionHandle buildDefinitionHandle, List<BuildDefinitionHandleHelper> helpers) {
        for (BuildDefinitionHandleHelper helper : helpers) {
            if (!helper.getBuildDefinitionHandle().getItemId().equals((Object)buildDefinitionHandle.getItemId())) continue;
            return helper;
        }
        return null;
    }

    private List<BuildDefinitionHandleHelper> getDefinitions(IBuildDefinition[] addedBuilds, List<BuildDefinitionQueryNode> nodes) {
        ArrayList<BuildDefinitionHandleHelper> helpers = new ArrayList<BuildDefinitionHandleHelper>();
        for (BuildDefinitionQueryNode buildDefinitionQueryNode : nodes) {
            helpers.add(new BuildDefinitionHandleHelper(buildDefinitionQueryNode.getBuildDefinitionId(), (IBuildDefinitionHandle)buildDefinitionQueryNode.getBuildDefinition()));
        }
        IBuildDefinition[] iBuildDefinitionArray = addedBuilds;
        int n = addedBuilds.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildDefinition definition = iBuildDefinitionArray[n2];
            if (this.findBuildDefinitionHelper((IBuildDefinitionHandle)definition, helpers) == null) {
                helpers.add(new BuildDefinitionHandleHelper(definition.getId(), (IBuildDefinitionHandle)definition));
            }
            ++n2;
        }
        return helpers;
    }

    private void initializeSectionMenu(Menu sectionMenu) {
        MenuItem refreshMenuItem = new MenuItem(sectionMenu, 0);
        refreshMenuItem.setText(BuildSectionMessages.BuildEventSection2_REFRESH_MENU_ITEM_TEXT);
        refreshMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildSection.this.internalRefreshContent(true);
            }
        });
        new MenuItem(sectionMenu, 2);
        MenuItem refreshSettingsMenuItem = new MenuItem(sectionMenu, 0);
        refreshSettingsMenuItem.setText(BuildSectionMessages.BuildSection_UPDATE_REFRESH_ACTION_NAME);
        refreshSettingsMenuItem.addSelectionListener(this.createRefreshSettingsListener(sectionMenu.getShell()));
        MenuItem addBuildsMenuItem = new MenuItem(sectionMenu, 0);
        addBuildsMenuItem.setText(BuildSectionMessages.BuildSection_ADD_BUILDS_ACTION_TEXT);
        addBuildsMenuItem.addSelectionListener(this.createAddBuildsListener(sectionMenu.getShell()));
    }

    public Point getDefaultContentSize() {
        if (this.fTableViewer != null) {
            return new Point(-1, this.fTableViewer.getTable().getItemHeight() * 5 + (this.isMac ? this.fTableViewer.getTable().getHorizontalBar().getSize().y : 0));
        }
        return new Point(-1, -1);
    }

    public Point getMinimalContentSize() {
        if (this.fTableViewer != null) {
            return new Point(-1, this.fTableViewer.getTable().getItemHeight() * 2 + (this.isMac ? this.fTableViewer.getTable().getHorizontalBar().getSize().y : 0));
        }
        return new Point(-1, -1);
    }

    public Point getPreferredContentSize(int wHint, int hHint) {
        if (this.fTableViewer != null) {
            return new Point(wHint, this.fTableViewer.getTable().getItemCount() * this.fTableViewer.getTable().getItemHeight() + (this.isMac ? this.fTableViewer.getTable().getHorizontalBar().getSize().y : 0));
        }
        return new Point(wHint, hHint);
    }

    public void init(ISectionSite sectionSite, IMemento memento) {
        super.init(sectionSite, memento);
        this.getSectionSite().addSectionListener((ISectionListener)this);
        this.fBuildsToDisplay = this.getBuildsToDisplay();
        this.isBuildsToDisplayCustomized = this.retrieveIsCustomized();
    }

    protected List<BuildDefinitionHandleHelper> getBuildsToDisplay() {
        List<BuildDefinitionHandleHelper> builds = this.getBuildsFromPreferenceHelper();
        Iterator<BuildDefinitionHandleHelper> iterator = builds.iterator();
        while (iterator.hasNext()) {
            BuildDefinitionHandleHelper buildDefinitionHandleHelper = iterator.next();
            if (buildDefinitionHandleHelper.getBuildDefinitionHandle().getOrigin() != null) continue;
            iterator.remove();
        }
        return builds;
    }

    protected List<BuildDefinitionHandleHelper> getBuildsFromPreferenceHelper() {
        return BuildUIPreferencesHelper.getBuildDefinitionPreferences(DEFINITIONS_PREFERENCE_STORE_KEY);
    }

    public void setFocus() {
        if (this.fIsExpanded) {
            if (this.isMac && ((Table)this.fTableViewer.getControl()).getSelectionCount() > 0) {
                this.fTableViewer.getControl().setFocus();
            } else if (this.fCustomScrollTable.getTable().getSelectionCount() > 0) {
                this.fCustomScrollTable.getTable().setFocus();
            }
        }
    }

    public void refreshContent() {
        this.internalRefreshContent(false);
    }

    protected void internalRefreshContent(boolean isUserInitiated) {
        if (this.getTableViewer() == null || this.getTeaserLabel() == null) {
            return;
        }
        this.setRefreshUserInitiatedFlag(isUserInitiated);
        this.setTableInput(this.getInput());
    }

    protected void setRefreshUserInitiatedFlag(boolean isUserInitiated) {
        this.fContentProvider.setFetchJobFlag(isUserInitiated);
    }

    public void updateTeaser(int numberOfFailingBuilds) {
        if (this.fTeaserLabel == null || this.fTeaserLabel.isDisposed()) {
            return;
        }
        String teaserMessage = this.getTeaserMessage(numberOfFailingBuilds);
        this.fTeaserLabel.getDisplay().asyncExec(this.createUpdateTeaserRunnable(teaserMessage));
    }

    protected Runnable createUpdateTeaserRunnable(final String teaserMessage) {
        return new Runnable(){

            public void run() {
                if (!BuildSection.this.fTeaserLabel.isDisposed()) {
                    if (teaserMessage != null) {
                        BuildSection.this.fTeaserLabel.setText(teaserMessage);
                    }
                    BuildSection.this.getSectionSite().layoutTeaser();
                }
            }
        };
    }

    protected String getTeaserMessage(int numberOfFailingBuilds) {
        String teaserMessage = "";
        if (numberOfFailingBuilds > 0) {
            teaserMessage = NLS.bind((String)BuildSectionMessages.BuildEventSection2_HEADER_TEXT, (Object)numberOfFailingBuilds);
        }
        return teaserMessage;
    }

    public void sectionCollapsed() {
        this.fIsExpanded = false;
    }

    public void sectionExpanded() {
        this.fIsExpanded = true;
    }

    public void sectionMaximized(boolean isContentClipped) {
    }

    public void sectionOpened() {
    }

    public void sectionResized() {
    }

    public TableViewer getTableViewer() {
        return this.fTableViewer;
    }

    public boolean isExpanded() {
        return this.fIsExpanded;
    }

    public SectionLabel getTeaserLabel() {
        return this.fTeaserLabel;
    }

    protected BuildSectionConfigureRefreshDialog createConfigureRefreshDialog(Shell parent) {
        return new BuildSectionConfigureRefreshDialog(parent, this.fRefreshIntervalMinutes);
    }

    protected IBuildDefinition[] openBuildDefinitionSelectionDialog(Shell shell) {
        BuildDefinitionSelectionDialog dialog = new BuildDefinitionSelectionDialog(shell, true);
        dialog.setBlockOnOpen(true);
        dialog.open();
        Object[] addedBuilds = dialog.getResult();
        if (addedBuilds == null) {
            return null;
        }
        ArrayList<IBuildDefinition> allDefinitions = new ArrayList<IBuildDefinition>();
        Object[] objectArray = addedBuilds;
        int n = addedBuilds.length;
        int n2 = 0;
        while (n2 < n) {
            Object buildObject = objectArray[n2];
            IBuildDefinition definition = (IBuildDefinition)buildObject;
            allDefinitions.add(definition);
            ++n2;
        }
        return allDefinitions.toArray(new IBuildDefinition[allDefinitions.size()]);
    }

    protected IStructuredSelection getTableSelection() {
        return (IStructuredSelection)this.getTableViewer().getSelection();
    }

    protected void setTableInput(Object input) {
        this.getTableViewer().setInput(input);
    }

    protected void storePreferences(List<BuildDefinitionHandleHelper> buildsToDisplay) {
        BuildUIPlugin.getDefault().getPreferenceStore().setValue(DEFINITIONS_CUSTOMIZED_KEY, true);
        BuildUIPreferencesHelper.storeBuildDefinitionPreferences(buildsToDisplay.toArray(new BuildDefinitionHandleHelper[buildsToDisplay.size()]), DEFINITIONS_PREFERENCE_STORE_KEY);
    }

    private boolean retrieveIsCustomized() {
        return BuildUIPlugin.getDefault().getPreferenceStore().getBoolean(DEFINITIONS_CUSTOMIZED_KEY);
    }

    protected void setSectionCustomized(boolean isBuildsToDisplayCustomized) {
        this.isBuildsToDisplayCustomized = isBuildsToDisplayCustomized;
    }

    public void setBuildsToDisplay(List<BuildDefinitionHandleHelper> buildsToDisplay) {
        this.fBuildsToDisplay = buildsToDisplay;
    }

    private void removeBuildsFromBuildsToDisplay(List<BuildDefinitionQueryNode> selectedBuildQueryNodes) {
        if (!this.isSectionCustomized()) {
            ArrayList<BuildDefinitionHandleHelper> temp = new ArrayList<BuildDefinitionHandleHelper>();
            List<BuildDefinitionQueryNode> nodesBeingDisplayed = ((BuildSectionContentProvider)this.getTableViewer().getContentProvider()).getBuildDefinitionQueryNodes();
            for (BuildDefinitionQueryNode node : selectedBuildQueryNodes) {
                nodesBeingDisplayed.remove(node);
            }
            for (BuildDefinitionQueryNode node : nodesBeingDisplayed) {
                BuildDefinitionHandleHelper helper = new BuildDefinitionHandleHelper(node.getBuildDefinitionId(), (IBuildDefinitionHandle)node.getBuildDefinition());
                temp.add(helper);
            }
            this.fBuildsToDisplay = temp;
        } else {
            for (BuildDefinitionQueryNode node : selectedBuildQueryNodes) {
                BuildDefinitionHandleHelper helper = this.findBuildDefinitionHelper((IBuildDefinitionHandle)node.getBuildDefinition(), this.fBuildsToDisplay);
                if (helper == null) continue;
                this.fBuildsToDisplay.remove(helper);
            }
        }
        this.isBuildsToDisplayCustomized = true;
        this.storePreferences(this.fBuildsToDisplay);
    }
}

