/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.tags;

import com.ibm.team.build.internal.ui.dialogs.tags.BuildUICategoryDialogMessages;
import com.ibm.team.build.internal.ui.tags.TagContentProposalProvider;
import com.ibm.team.build.internal.ui.tags.TagsTextContentAdapter;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

public class TagsField {
    private Text fText;
    private TagContentProposalProvider fTagProvider;
    private ControlDecoration fDecoration;
    private ContentProposalAdapter fProposalListener;

    public TagsField(Text text, TagContentProposalProvider proposalProvider) {
        this.fText = text;
        this.fTagProvider = proposalProvider;
        this.init();
    }

    private void init() {
        this.setupContentAssist();
        this.setupDecoration();
    }

    private void setupDecoration() {
        this.fDecoration = new ControlDecoration((Control)this.fText, 16512);
        this.fDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
        this.fDecoration.setDescriptionText(BuildUICategoryDialogMessages.PromptForTagDialog_HOVER_TEXT);
        this.fDecoration.hide();
        this.fText.addFocusListener(this.getTextFocusListener(this.fDecoration));
    }

    protected FocusListener getTextFocusListener(final ControlDecoration decoration) {
        return new FocusListener(){

            public void focusGained(FocusEvent e) {
                decoration.show();
            }

            public void focusLost(FocusEvent e) {
                decoration.hide();
            }
        };
    }

    private void setupContentAssist() {
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        TriggerSequence[] activeBindings = bindingService.getActiveBindingsFor("org.eclipse.ui.edit.text.contentAssist.proposals");
        KeyStroke keyStroke = activeBindings.length != 0 && activeBindings[0].getTriggers().length > 0 && activeBindings[0].getTriggers()[0] instanceof KeyStroke ? (KeyStroke)activeBindings[0].getTriggers()[0] : KeyStroke.getInstance((int)SWT.MOD1, (int)32);
        TagsTextContentAdapter tagsContentAdapter = new TagsTextContentAdapter(this.fText);
        this.fProposalListener = new ContentProposalAdapter((Control)this.fText, (IControlContentAdapter)tagsContentAdapter, (IContentProposalProvider)this.fTagProvider, keyStroke, new char[]{'*'});
        this.fProposalListener.setProposalAcceptanceStyle(3);
        this.fProposalListener.setPropagateKeys(true);
        this.fProposalListener.addContentProposalListener((IContentProposalListener)tagsContentAdapter);
    }

    public void dispose() {
        this.fTagProvider.dispose();
    }

    protected ControlDecoration getDecoration() {
        return this.fDecoration;
    }

    protected ContentProposalAdapter getProposalListener() {
        return this.fProposalListener;
    }

    public Text getText() {
        return this.fText;
    }
}

