/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.tags;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.common.helper.TagsHelper;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.dialogs.tags.BuildUICategoryDialogMessages;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.internal.ui.tags.TagContentProposal;
import com.ibm.team.foundation.common.util.WildcardMatcher;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagContentProposalProvider
implements IContentProposalProvider {
    private HashSet<String> fAllTags;
    private Job fFetchingJob;
    private ITeamRepository fTeamRepository;
    private IBuildDefinitionHandle[] fBuildDefinitionHandles;
    private IProjectAreaHandle fProjectAreaHandle;
    private boolean fIsLimitedByProjectArea;

    public TagContentProposalProvider(ITeamRepository teamRepository, IBuildDefinitionHandle[] buildDefinitionHandles) {
        ValidationHelper.validateNotNull((String)"teamRepository", (Object)teamRepository);
        ValidationHelper.validateNotNull((String)"buildDefinitionHandles", (Object[])buildDefinitionHandles);
        ValidationHelper.validateNotEmpty((String)"buildDefinitionHandles", (Object[])buildDefinitionHandles);
        ValidationHelper.validateNotNullElements((String)"buildDefinitionHandles", (Object[])buildDefinitionHandles);
        this.initialize(teamRepository, buildDefinitionHandles, false);
    }

    public TagContentProposalProvider(ITeamRepository teamRepository, IProjectAreaHandle projectAreaHandle) {
        ValidationHelper.validateNotNull((String)"projectAreaHandle", (Object)projectAreaHandle);
        this.fProjectAreaHandle = projectAreaHandle;
        this.initialize(teamRepository, null, true);
    }

    private void initialize(ITeamRepository teamRepository, IBuildDefinitionHandle[] buildDefinitionHandles, boolean isLimitedByProjectArea) {
        this.fTeamRepository = teamRepository;
        this.fBuildDefinitionHandles = buildDefinitionHandles;
        this.fIsLimitedByProjectArea = isLimitedByProjectArea;
        this.fFetchingJob = this.getFetchTagsJob();
        this.fFetchingJob.schedule();
    }

    protected FetchAllTagsJob getFetchTagsJob() {
        return new FetchAllTagsJob();
    }

    public void addTags(String[] tags) {
        if (this.fAllTags == null) {
            this.fAllTags = new HashSet();
        }
        String[] stringArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            this.fAllTags.add(tag);
            ++n2;
        }
    }

    public String[] getNewTags(String tags) {
        if (this.fAllTags != null) {
            String[] parsedTags;
            ArrayList<String> newTags = new ArrayList<String>();
            String[] stringArray = parsedTags = TagsHelper.normalizeAndParseTags((String)tags);
            int n = parsedTags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                if (!this.fAllTags.contains(tag)) {
                    newTags.add(tag);
                }
                ++n2;
            }
            return newTags.toArray(new String[newTags.size()]);
        }
        return new String[0];
    }

    public IContentProposal[] getProposals(String contents, int position) {
        int beginOfWord = 0;
        int endOfWord = contents.length();
        if (position == 0) {
            endOfWord = 0;
        }
        String word = contents.substring(beginOfWord, position);
        ArrayList<TagContentProposal> proposals = new ArrayList<TagContentProposal>();
        WildcardMatcher matcher = new WildcardMatcher(String.valueOf(word) + '*');
        int millisecondsWaited = 0;
        try {
            while (this.fAllTags == null && millisecondsWaited < 2000) {
                Thread.sleep(100L);
                millisecondsWaited += 100;
            }
        }
        catch (InterruptedException interruptedException) {}
        if (this.fAllTags != null && this.fAllTags.size() > 0) {
            for (String tag : this.fAllTags) {
                if (!matcher.match(tag)) continue;
                proposals.add(new TagContentProposal(tag, beginOfWord, endOfWord));
            }
            Collections.sort(proposals, new Comparator<TagContentProposal>(){

                @Override
                public int compare(TagContentProposal o1, TagContentProposal o2) {
                    return o1.getLabel().compareTo(o2.getLabel());
                }
            });
            return proposals.toArray(new TagContentProposal[proposals.size()]);
        }
        return this.getErrorMessageContent();
    }

    private IContentProposal[] getErrorMessageContent() {
        String msg = BuildUICategoryDialogMessages.TagContentProposalProvider_NO_TAGS;
        if (this.fAllTags == null) {
            msg = BuildUICategoryDialogMessages.TagContentProposalProvider_NULL_TAGS;
        }
        final String message = msg;
        return new IContentProposal[]{new IContentProposal(){

            public String getContent() {
                return null;
            }

            public int getCursorPosition() {
                return 0;
            }

            public String getDescription() {
                return null;
            }

            public String getLabel() {
                return message;
            }
        }};
    }

    public ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }

    public IBuildDefinitionHandle[] getBuildDefinitionHandles() {
        return this.fBuildDefinitionHandles;
    }

    public IProjectAreaHandle getProjectAreaHandle() {
        return this.fProjectAreaHandle;
    }

    public boolean isLimitedByProjectArea() {
        return this.fIsLimitedByProjectArea;
    }

    public void dispose() {
        if (this.fFetchingJob != null) {
            this.fFetchingJob.cancel();
        }
    }

    protected HashSet<String> getAllTags() {
        return this.fAllTags;
    }

    public class FetchAllTagsJob
    extends TeamBuildJob {
        public FetchAllTagsJob() {
            super(BuildUICategoryDialogMessages.TagContentProposalProvider_JOB_NAME, false);
        }

        protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
            String[] allTags = null;
            allTags = TagContentProposalProvider.this.fIsLimitedByProjectArea ? ClientFactory.getTeamBuildClient((ITeamRepository)TagContentProposalProvider.this.fTeamRepository).getTags(new IProjectAreaHandle[]{TagContentProposalProvider.this.fProjectAreaHandle}, monitor) : ClientFactory.getTeamBuildClient((ITeamRepository)TagContentProposalProvider.this.fTeamRepository).getTags(TagContentProposalProvider.this.fBuildDefinitionHandles, monitor);
            TagContentProposalProvider.this.addTags(allTags);
            return Status.OK_STATUS;
        }
    }
}

