/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.scm;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.internal.ui.scm.Messages;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultContributionProvider;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultPage;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import com.ibm.team.filesystem.ui.views.TeamPlaceEditorInput;
import com.ibm.team.filesystem.ui.views.TeamPlacePart2;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.scm.common.IWorkspace;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;

public class WorkspaceContributionProvider
extends AbstractBuildResultContributionProvider {
    private IWorkspace fWorkspace;

    public WorkspaceContributionProvider(FormEditor buildEditor, String id, IBuildResultContext context) {
        super(buildEditor, id, context);
    }

    public void initializeContributionProvider(IProgressMonitor monitor) throws Exception {
        this.fWorkspace = null;
        ITeamRepository repository = this.getBuildResultContext().getTeamRepository();
        IBuildResultContribution[] contributions = this.getContributions();
        if (contributions.length > 0) {
            this.fWorkspace = (IWorkspace)repository.itemManager().fetchCompleteItem(contributions[0].getExtendedContribution(), 0, monitor);
        }
    }

    public BuildStatus getStatus() {
        return BuildStatus.INFO;
    }

    public String getSummaryText() {
        if (this.fWorkspace == null) {
            return Messages.WorkspaceContributionProvider_NO_WORKSPACE;
        }
        return this.fWorkspace.getName();
    }

    public boolean isSummaryLink() {
        return this.fWorkspace != null;
    }

    public void summaryLinkActivated() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            TeamPlacePart2.open((IWorkbenchPage)page, (TeamPlaceEditorInput)TeamPlaceEditorInput.newForEdit((AbstractPlaceWrapper)AbstractPlaceWrapper.newWrapper((IWorkspace)this.fWorkspace)));
        }
    }

    public AbstractBuildResultPage getBuildResultPage() {
        return null;
    }

    public String[] getExtendedContributionIds() {
        return new String[]{"buildWorkspace"};
    }

    public String getSummaryTitle() {
        return Messages.WorkspaceContributionProvider_SUMMARY_TITLE;
    }
}

