/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.scm;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.internal.ui.scm.Messages;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultContributionProvider;
import com.ibm.team.build.ui.editors.result.AbstractBuildResultPage;
import com.ibm.team.build.ui.editors.result.IBuildResultContext;
import com.ibm.team.filesystem.ui.views.SnapshotEditorInput;
import com.ibm.team.filesystem.ui.views.TeamPlacePart2;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.scm.common.IBaselineSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;

public class SnapshotContributionProvider
extends AbstractBuildResultContributionProvider {
    private IBaselineSet fSnapshot;

    public SnapshotContributionProvider(FormEditor buildEditor, String id, IBuildResultContext context) {
        super(buildEditor, id, context);
    }

    public void initializeContributionProvider(IProgressMonitor monitor) throws Exception {
        this.fSnapshot = null;
        ITeamRepository repository = this.getBuildResultContext().getTeamRepository();
        IBuildResultContribution[] contributions = this.getContributions();
        if (contributions.length > 0) {
            try {
                this.fSnapshot = (IBaselineSet)repository.itemManager().fetchCompleteItem(contributions[0].getExtendedContribution(), 0, monitor);
            }
            catch (ItemNotFoundException itemNotFoundException) {}
        }
    }

    public BuildStatus getStatus() {
        return BuildStatus.INFO;
    }

    public String getSummaryText() {
        if (this.fSnapshot == null) {
            if (this.getContributions().length > 0) {
                return Messages.SnapshotContributionProvider_SNAPSHOT_DELETED;
            }
            return Messages.SnapshotContributionProvider_NO_SNAPSHOT;
        }
        return this.fSnapshot.getName();
    }

    public boolean isSummaryLink() {
        return this.fSnapshot != null;
    }

    public void summaryLinkActivated() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            TeamPlacePart2.open((IWorkbenchPage)page, (SnapshotEditorInput)SnapshotEditorInput.newForEdit((IBaselineSet)this.fSnapshot));
        }
    }

    public AbstractBuildResultPage getBuildResultPage() {
        return null;
    }

    public String[] getExtendedContributionIds() {
        return new String[]{"buildSnapshot"};
    }

    public String getSummaryTitle() {
        return Messages.SnapshotContributionProvider_SUMMARY_TITLE;
    }
}

