/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.scm;

import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.build.internal.ui.helper.BuildUIHelper;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.internal.ui.query.BuildQueryRow;
import com.ibm.team.build.internal.ui.scm.Messages;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialog;
import com.ibm.team.filesystem.ui.changes.ChangesViewUtil;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;

public class CompareWithLatestActionDelegate
extends ActionDelegate {
    private IBuildResult fBuildResult;
    private IWorkspaceHandle fWorkspaceHandle;
    private IBaselineSetHandle fSnapshotHandle;
    private Shell fShell;

    public void run(IAction action) {
        String jobName = NLS.bind((String)Messages.CompareWithLatestActionDelegate_JOB_NAME, (Object)this.fBuildResult.getLabel());
        TeamBuildJob job = new TeamBuildJob(jobName, true){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                return CompareWithLatestActionDelegate.this.compare(monitor);
            }

            protected void jobFinished(IStatus status) {
                CompareWithLatestActionDelegate.this.handleJobDone(status);
            }
        };
        job.setUser(true);
        job.schedule();
    }

    protected void handleJobDone(IStatus status) {
    }

    private IStatus compare(IProgressMonitor monitor) throws Exception {
        if (this.fBuildResult != null && this.fShell != null && !this.fShell.isDisposed()) {
            this.fetchContributions(this.fBuildResult, monitor);
            if (this.fWorkspaceHandle != null) {
                if (this.fSnapshotHandle != null) {
                    ITeamRepository repository = (ITeamRepository)this.fBuildResult.getOrigin();
                    IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
                    IWorkspaceConnection workspaceConnection = workspaceManager.getWorkspaceConnection(this.fWorkspaceHandle, monitor);
                    List acceptSources = workspaceConnection.getFlowTable().acceptSources();
                    if (acceptSources.size() == 0) {
                        this.showWarningDialog(Messages.CompareWithLatestActionDelegate_NO_COLLABORATIONS_TITLE, Messages.CompareWithLatestActionDelegate_NO_COLLABORATIONS);
                    } else if (acceptSources.size() == 1) {
                        IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)((IFlowEntry)acceptSources.get(0)).getFlowNode();
                        this.compare(workspaceHandle, this.fSnapshotHandle);
                    } else if (acceptSources.size() > 1) {
                        this.getWorkspaceFromUser(workspaceConnection, this.fSnapshotHandle, repository);
                    }
                } else {
                    this.showWarningDialog(Messages.AbstractRepositoryActionDelegate_NO_SNAPSHOT_TITLE, Messages.CompareWithLatestActionDelegate_NO_SNAPSHOT);
                }
            } else {
                this.showWarningDialog(Messages.CompareWithLatestActionDelegate_NO_WORKSPACE_TITLE, Messages.CompareWithLatestActionDelegate_NO_WORKSPACE);
            }
        }
        return Status.OK_STATUS;
    }

    protected void showWarningDialog(String title, String message) {
        BuildUIHelper.showWarningDialog(this.fShell, title, message);
    }

    private void getWorkspaceFromUser(final IWorkspaceConnection workspaceConnection, final IBaselineSetHandle snapshotHandle, final ITeamRepository repository) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                CompareWithLatestActionDelegate.this.handleGetWorkspaceFromUserAsync(workspaceConnection, snapshotHandle, repository);
            }
        });
    }

    protected void handleGetWorkspaceFromUserAsync(IWorkspaceConnection workspaceConnection, IBaselineSetHandle snapshotHandle, ITeamRepository repository) {
        AbstractPlaceWrapper workspaceOrStream;
        if (this.fShell != null && !this.fShell.isDisposed() && (workspaceOrStream = this.openWorkspaceChooserDialog(workspaceConnection, repository)) != null) {
            this.compare((IWorkspaceHandle)workspaceOrStream.getWorkspace(), snapshotHandle);
        }
    }

    protected AbstractPlaceWrapper openWorkspaceChooserDialog(IWorkspaceConnection workspaceConnection, ITeamRepository repository) {
        return WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream((Shell)this.fShell, (ITeamRepository)repository, (IWorkspaceConnection)workspaceConnection, new ArrayList());
    }

    private void compare(final IWorkspaceHandle compareToWorkspace, final IBaselineSetHandle snapshotHandle) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                CompareWithLatestActionDelegate.this.handleCompareAsync(compareToWorkspace, snapshotHandle);
            }
        });
    }

    protected void handleCompareAsync(IWorkspaceHandle compareToWorkspace, IBaselineSetHandle snapshotHandle) {
        if (this.fShell != null && !this.fShell.isDisposed()) {
            this.openChangeExplorer(compareToWorkspace, snapshotHandle);
        }
    }

    protected void fetchContributions(IBuildResult buildResult, IProgressMonitor monitor) throws IllegalArgumentException, TeamRepositoryException {
        IBuildResultContribution[] contributions;
        this.fWorkspaceHandle = null;
        this.fSnapshotHandle = null;
        ITeamRepository repository = (ITeamRepository)buildResult.getOrigin();
        ITeamBuildClient client = (ITeamBuildClient)repository.getClientLibrary(ITeamBuildClient.class);
        IBuildResultContribution[] iBuildResultContributionArray = contributions = client.getBuildResultContributions((IBuildResultHandle)buildResult, new String[]{"buildWorkspace", "buildSnapshot"}, monitor);
        int n = contributions.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildResultContribution contribution = iBuildResultContributionArray[n2];
            if (contribution.getExtendedContributionTypeId().equals("buildWorkspace")) {
                this.fWorkspaceHandle = (IWorkspaceHandle)contribution.getExtendedContribution();
            } else if (contribution.getExtendedContributionTypeId().equals("buildSnapshot")) {
                this.fSnapshotHandle = (IBaselineSetHandle)contribution.getExtendedContribution();
            }
            ++n2;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fBuildResult = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            this.fShell = window.getShell();
        }
        if (selection instanceof IStructuredSelection) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            if (object instanceof IBuildResultRecord) {
                IBuildResultRecord record = (IBuildResultRecord)object;
                this.fBuildResult = record.getBuildResult();
            } else if (object instanceof BuildQueryRow) {
                BuildQueryRow row = (BuildQueryRow)object;
                this.fBuildResult = row.getBuildResult();
            }
        }
    }

    protected void openChangeExplorer(IWorkspaceHandle compareTargetWorkspace, IBaselineSetHandle snapshotHandle) {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            ChangesViewUtil.compareWorkspaceWithSnapshot((IWorkbenchPage)page, (ITeamRepository)((ITeamRepository)compareTargetWorkspace.getOrigin()), (IWorkspaceHandle)compareTargetWorkspace, (IBaselineSetHandle)snapshotHandle);
        }
    }
}

