/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.query;

import com.ibm.team.build.client.iterator.IBuildResultRecordIterator;
import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.common.model.dto.IBuildDefinitionStatusRecord;
import com.ibm.team.build.internal.ui.helper.BuildUIPreferencesHelper;
import com.ibm.team.build.internal.ui.query.BuildQuery;
import com.ibm.team.build.internal.ui.query.BuildQueryColumnKind;
import com.ibm.team.build.internal.ui.query.BuildQueryRow;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class BuildQueryForBuildQueue
extends BuildQuery {
    private IProjectAreaHandle fProjectAreaHandle;

    public BuildQueryForBuildQueue(String name, String description, BuildQueryRow.Factory buildQueryRowFactory, IProjectAreaHandle projectAreaHandle, ITeamRepository teamRepository) {
        super(name, description, buildQueryRowFactory, teamRepository);
        this.fProjectAreaHandle = projectAreaHandle;
    }

    public BuildQueryColumnKind[] getDefaultSortColumns() {
        return new BuildQueryColumnKind[]{BuildQueryColumnKind.StartTime, BuildQueryColumnKind.StartTime};
    }

    protected IProjectAreaHandle[] getConnectedProjectAreas() {
        List projectAreas = ConnectedProjectAreaRegistry.getDefault().getConnectedProjectAreas(this.getTeamRepository());
        return projectAreas.toArray(new IProjectAreaHandle[projectAreas.size()]);
    }

    protected IBuildResultRecordIterator getIterativeQuery(String[] buildResultProperties, IProgressMonitor monitor) throws TeamRepositoryException {
        BuildState[] states = new BuildState[]{BuildState.IN_PROGRESS, BuildState.NOT_STARTED};
        if (this.fProjectAreaHandle == null) {
            IBuildDefinitionStatusRecord[] records = this.getRecordClient().getBuildDefinitionStatusRecords(this.getConnectedProjectAreas(), monitor);
            IBuildDefinition[] definitions = null;
            if (records.length == 0) {
                definitions = new IBuildDefinition[]{(IBuildDefinition)IBuildDefinition.ITEM_TYPE.createItem()};
            } else {
                definitions = new IBuildDefinition[records.length];
                int i = 0;
                while (i < records.length) {
                    definitions[i] = records[i].getBuildDefinition();
                    ++i;
                }
                if (BuildUIPreferencesHelper.getBuildDefinitionPreferences("build.query.view.build.definitions").size() == 0) {
                    BuildUIPreferencesHelper.storeBuildDefinitionPreferences(definitions, "build.query.view.build.definitions");
                }
            }
            return this.getRecordClient().getBuildResultRecords((IBuildDefinitionHandle[])definitions, states, buildResultProperties, monitor);
        }
        return this.getRecordClient().getBuildResultRecords(this.fProjectAreaHandle, states, buildResultProperties, monitor);
    }
}

