/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.query;

import com.ibm.team.build.client.iterator.IBuildResultRecordIterator;
import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.IBuildEngineHandle;
import com.ibm.team.build.common.model.query.IBaseBuildResultQueryModel;
import com.ibm.team.build.internal.client.iterator.BuildResultRecordIterator;
import com.ibm.team.build.internal.ui.query.BuildQuery;
import com.ibm.team.build.internal.ui.query.BuildQueryColumnKind;
import com.ibm.team.build.internal.ui.query.BuildQueryRow;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.ast.IField;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.IString;
import org.eclipse.core.runtime.IProgressMonitor;

public class BuildQueryByEngine
extends BuildQuery {
    private IBuildEngineHandle fBuildEngineHandle;
    private IProjectAreaHandle fProjectAreaHandle;

    public BuildQueryByEngine(String name, String description, BuildQueryRow.Factory buildQueryRowFactory, IBuildEngineHandle buildEngineHandle, IProjectAreaHandle projectAreaHandle, ITeamRepository teamRepository) {
        super(name, description, buildQueryRowFactory, teamRepository);
        this.fBuildEngineHandle = buildEngineHandle;
        this.fProjectAreaHandle = projectAreaHandle;
    }

    protected IBuildResultRecordIterator getIterativeQuery(String[] buildResultProperties, IProgressMonitor monitor) throws TeamRepositoryException {
        IBaseBuildResultQueryModel.IBuildResultQueryModel buildResultQueryModel = IBaseBuildResultQueryModel.IBuildResultQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)buildResultQueryModel);
        IPredicate left = buildResultQueryModel.buildState()._eq((IString)query.newStringArg());
        IPredicate right = buildResultQueryModel.handler()._eq(query.newItemHandleArg());
        query.filter(left._and(right));
        query.orderByDsc((IField)buildResultQueryModel.buildStartTime());
        Object[] parameters = new Object[]{BuildState.IN_PROGRESS.name(), this.fBuildEngineHandle};
        IItemQueryPage queryPage = this.getBuildClient().queryItems(query, parameters, 512, monitor);
        return new BuildResultRecordIterator(this.getTeamRepository(), queryPage, buildResultProperties);
    }

    public BuildQueryColumnKind[] getDefaultSortColumns() {
        return new BuildQueryColumnKind[]{BuildQueryColumnKind.StartTime, BuildQueryColumnKind.StartTime};
    }

    public IBuildEngineHandle getBuildEngineHandle() {
        return this.fBuildEngineHandle;
    }

    public IProjectAreaHandle getProjectAreaHandle() {
        return this.fProjectAreaHandle;
    }
}

