/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.query;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.client.ITeamBuildRequestClient;
import com.ibm.team.build.client.iterator.IBuildResultRecordIterator;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.internal.client.ITeamBuildRecordClient;
import com.ibm.team.build.internal.common.helper.PropertyHelper;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.query.BuildQueryColumnKind;
import com.ibm.team.build.internal.ui.query.BuildQueryRow;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public abstract class BuildQuery {
    private final String fName;
    private String fDescription;
    private final BuildQueryRow.Factory fBuildQueryRowFactory;
    private final ITeamRepository fTeamRepository;

    public BuildQuery(String name, String description, BuildQueryRow.Factory buildQueryRowFactory, ITeamRepository teamRepository) {
        ValidationHelper.validateNotNull((String)"name", (Object)name);
        ValidationHelper.validateNotNull((String)"teamRepository", (Object)teamRepository);
        ValidationHelper.validateNotNull((String)"buildQueryRowFactory", (Object)buildQueryRowFactory);
        this.fName = name;
        this.fTeamRepository = teamRepository;
        this.fBuildQueryRowFactory = buildQueryRowFactory;
        this.fDescription = description != null ? description : name;
    }

    public String getName() {
        return this.fName;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public String getDisplayPreferencesKey() {
        return null;
    }

    public final IBuildResultRecordIterator doIterativeQuery(IProgressMonitor monitor) throws TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String[] buildResultProperties = PropertyHelper.union((String[])IBuildResult.PROPERTIES_VIEW_ITEM, (String[])new String[]{IBuildResult.PROPERTY_BUILD_REQUESTS});
        return this.getIterativeQuery(buildResultProperties, monitor);
    }

    public BuildQueryRow.Factory getRowFactory() {
        return this.fBuildQueryRowFactory;
    }

    protected abstract IBuildResultRecordIterator getIterativeQuery(String[] var1, IProgressMonitor var2) throws TeamRepositoryException;

    public abstract BuildQueryColumnKind[] getDefaultSortColumns();

    public ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }

    protected ITeamBuildClient getBuildClient() {
        return ClientFactory.getTeamBuildClient((ITeamRepository)this.fTeamRepository);
    }

    protected ITeamBuildRecordClient getRecordClient() {
        return (ITeamBuildRecordClient)this.fTeamRepository.getClientLibrary(ITeamBuildRecordClient.class);
    }

    protected ITeamBuildRequestClient getRequestClient() {
        return ClientFactory.getTeamBuildRequestClient((ITeamRepository)this.fTeamRepository);
    }

    protected IItemManager getItemManager() {
        return this.fTeamRepository.itemManager();
    }
}

