/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.properties;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.ui.properties.AbstractBuildPropertyEditor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class BuildPropertyEditorExtension {
    public static final String ID_ATTRIBUTE = "id";
    public static final String CLASS_ATTRIBUTE = "class";
    public static final String NAME_ATTRIBUTE = "name";
    private String fIdAttribute;
    private String fClassAttribute;
    private String fNameAttribute;
    private IConfigurationElement fConfigurationElement;

    public BuildPropertyEditorExtension(IConfigurationElement configurationElement) {
        ValidationHelper.validateNotNull((String)"configElement", (Object)configurationElement);
        this.fConfigurationElement = configurationElement;
        this.fIdAttribute = configurationElement.getAttribute(ID_ATTRIBUTE);
        this.fClassAttribute = configurationElement.getAttribute(CLASS_ATTRIBUTE);
        this.fNameAttribute = configurationElement.getAttribute(NAME_ATTRIBUTE);
        this.validateAttributes();
    }

    public String getClassAttribute() {
        return this.fClassAttribute;
    }

    public String getIdAttribute() {
        return this.fIdAttribute;
    }

    public String getNameAttribute() {
        return this.fNameAttribute;
    }

    public AbstractBuildPropertyEditor createPropertyEditor() throws IllegalArgumentException, CoreException {
        return this.createExecutableExtension();
    }

    public int hashCode() {
        return this.fIdAttribute.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BuildPropertyEditorExtension other = (BuildPropertyEditorExtension)obj;
        return this.fIdAttribute.equals(other.fIdAttribute);
    }

    public String toString() {
        return this.fNameAttribute;
    }

    private void validateAttributes() {
        ValidationHelper.validateNotNull((String)ID_ATTRIBUTE, (Object)this.fIdAttribute);
        ValidationHelper.validateNotEmpty((String)ID_ATTRIBUTE, (String)this.fIdAttribute.trim());
        ValidationHelper.validateNotNull((String)CLASS_ATTRIBUTE, (Object)this.fClassAttribute);
        ValidationHelper.validateNotEmpty((String)CLASS_ATTRIBUTE, (String)this.fClassAttribute.trim());
        ValidationHelper.validateNotNull((String)NAME_ATTRIBUTE, (Object)this.fNameAttribute);
        ValidationHelper.validateNotEmpty((String)NAME_ATTRIBUTE, (String)this.fNameAttribute.trim());
    }

    private AbstractBuildPropertyEditor createExecutableExtension() throws CoreException, IllegalArgumentException {
        Object executableExtension = this.fConfigurationElement.createExecutableExtension(CLASS_ATTRIBUTE);
        ValidationHelper.validateIsType((String)CLASS_ATTRIBUTE, AbstractBuildPropertyEditor.class, (Object)executableExtension);
        return (AbstractBuildPropertyEditor)executableExtension;
    }
}

