/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.jobs;

import com.ibm.team.build.common.MultipleErrorTeamBuildException;
import com.ibm.team.build.common.TeamBuildDuplicateItemException;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.helper.BuildUIHelper;
import com.ibm.team.build.internal.ui.helper.ItemNotFoundHelper;
import com.ibm.team.build.internal.ui.jobs.Messages;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJobHelper;
import com.ibm.team.foundation.client.util.FoundationJobContext;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIUtils;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.PermissionDeniedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public class TeamBuildJobContext
extends FoundationJobContext {
    protected static final String PLUGIN_ID = BuildUIPlugin.getUniqueIdentifier();
    protected boolean fPreconditionsFailed;
    protected IStatus fStatus;

    public boolean isExpectedStatus(Job job, IStatus status) {
        if (status.isMultiStatus()) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus childStatus = iStatusArray[n2];
                if (!this.isExpectedStatus(job, childStatus)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        if (this.isItemNotFound(status)) {
            return true;
        }
        if (status.getException() instanceof TeamBuildDuplicateItemException) {
            return true;
        }
        return super.isExpectedStatus(job, status);
    }

    public IStatus checkPreconditions(Job job, IProgressMonitor monitor) throws Exception {
        this.fPreconditionsFailed = false;
        IStatus connectStatus = Status.OK_STATUS;
        if (!((TeamBuildJob)job).isUserInitiated()) {
            return null;
        }
        if (((TeamBuildJob)job).getJobTeamRepository() != null) {
            connectStatus = this.validateRepository(((TeamBuildJob)job).getJobTeamRepository(), monitor);
            this.fPreconditionsFailed = !connectStatus.isOK() && connectStatus.getSeverity() != 2;
        }
        return connectStatus;
    }

    protected IStatus validateRepository(ITeamRepository repository, IProgressMonitor monitor) {
        return FoundationUIUtils.validateRepository((ITeamRepository)repository, (boolean)false, (IProgressMonitor)monitor);
    }

    public IStatus createStatus(Job job, Exception exception) {
        ValidationHelper.validateNotNull((String)"exception", (Object)exception);
        return this.createStatus(job, null, exception);
    }

    protected IStatus createStatus(Job job, String message, Throwable throwable) {
        if (throwable instanceof OperationCanceledException || throwable instanceof TeamOperationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        if (throwable instanceof MultipleErrorTeamBuildException) {
            String statusMessage = Messages.BuildJobContext_MULTIPLE_ERRORS;
            MultiStatus status = new MultiStatus(BuildUIPlugin.getUniqueIdentifier(), 0, statusMessage, null);
            Throwable[] throwableArray = ((MultipleErrorTeamBuildException)throwable).getErrors();
            int n = throwableArray.length;
            int n2 = 0;
            while (n2 < n) {
                Throwable t = throwableArray[n2];
                status.add((IStatus)new Status(4, BuildUIPlugin.getUniqueIdentifier(), this.getStatusMessage(t), t));
                ++n2;
            }
            return status;
        }
        String statusMessage = message == null ? this.getStatusMessage(throwable) : message;
        return new Status(4, PLUGIN_ID, statusMessage, throwable);
    }

    protected String getStatusMessage(Throwable throwable) {
        return TeamBuildJobHelper.getStatusMessage(throwable);
    }

    public final void handleStatus(Job job, IStatus status) {
        this.handleItemNotFoundExceptions(status);
        IStatus exposedStatus = status;
        if (!this.isProcessError(status)) {
            exposedStatus = this.internalHandleStatus(job, status);
        }
        ((TeamBuildJob)job).jobFinished(exposedStatus);
        this.fStatus = exposedStatus;
    }

    protected final boolean isProcessError(IStatus status) {
        return status.getException() instanceof PermissionDeniedException;
    }

    protected void handleItemNotFoundExceptions(IStatus status) {
        ItemNotFoundException exception;
        if (status.getException() instanceof ItemNotFoundException && (exception = (ItemNotFoundException)status.getException()).getData() != null && exception.getData() instanceof IItemHandle) {
            this.updateItemManager((IItemHandle)exception.getData());
        }
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            this.handleItemNotFoundExceptions(child);
            ++n2;
        }
    }

    public IStatus getStatus() {
        return this.fStatus;
    }

    protected boolean isItemNotFound(IStatus status) {
        return status.getException() instanceof ItemNotFoundException || status.getChildren().length == 1 && status.getChildren()[0].getException() instanceof ItemNotFoundException;
    }

    protected void updateItemManager(IItemHandle itemHandle) {
        ItemNotFoundHelper.updateItemManager(itemHandle);
    }

    protected IStatus internalHandleStatus(Job job, IStatus status) {
        TeamBuildJob teamBuildJob = (TeamBuildJob)job;
        Object exposedStatus = status;
        if (this.fPreconditionsFailed && !status.isOK()) {
            exposedStatus = status.getSeverity() == 8 ? new Status(2, PLUGIN_ID, Messages.BuildJobContext_LOGIN_CANCELED, null) : (status.getException() == null ? new Status(4, PLUGIN_ID, Messages.BuildJobContext_COULD_NOT_CONNECT, null) : this.createStatus(job, null, status.getException()));
        }
        if (status.getSeverity() == 4 && teamBuildJob.isWarnOnError()) {
            exposedStatus = TeamBuildJobHelper.convertToWarningStatus(exposedStatus);
        }
        if (teamBuildJob.isUserInitiated() && exposedStatus.getSeverity() == 4) {
            this.showErrorDialog(job, (IStatus)exposedStatus);
        }
        return exposedStatus;
    }

    protected void showErrorDialog(Job job, IStatus status) {
        String title = NLS.bind((String)Messages.BuildJobContext_ERROR_DURING_JOB, (Object)((TeamBuildJob)job).getShortName());
        IStatus temporaryStatusToShowInDialog = status;
        if (this.isExpectedStatus(job, status) && status.getSeverity() == 4 && !(status.getException() instanceof ItemNotFoundException)) {
            temporaryStatusToShowInDialog = TeamBuildJobHelper.convertToWarningStatus(status);
        }
        temporaryStatusToShowInDialog = TeamBuildJobHelper.createDisplayableStatus(temporaryStatusToShowInDialog);
        this.doShowErrorDialog(NLS.bind((String)Messages.BuildJobContext_JOB_FAILED, (Object)job.getName()), title, temporaryStatusToShowInDialog);
    }

    protected void asyncExec(Runnable runnable) {
        Display.getDefault().asyncExec(runnable);
    }

    protected void doShowErrorDialog(String message, String title, IStatus status) {
        BuildUIHelper.showErrorDialog(message, title, status);
    }
}

