/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ui.helper;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.helper.BuildUIHelperMessages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class ErrorHyperlinkHelper
extends HyperlinkAdapter {
    private final Composite fParent;
    private final FormToolkit fToolkit;

    public ErrorHyperlinkHelper(Composite parent, FormToolkit toolkit) {
        ValidationHelper.validateNotNull((String)"parent", (Object)parent);
        ValidationHelper.validateNotNull((String)"toolkit", (Object)toolkit);
        this.fParent = parent;
        this.fToolkit = toolkit;
    }

    public Hyperlink createErrorHyperlink(String errorMessage, int style) {
        return this.createErrorHyperlink(BuildUIHelperMessages.ErrorHyperlinkHelper_DEFAULT_LABEL, errorMessage, null, style);
    }

    public Hyperlink createErrorHyperlink(String label, String errorMessage, int style) {
        return this.createErrorHyperlink(label, errorMessage, null, style);
    }

    public Hyperlink createErrorHyperlink(String errorMessage, Exception exception, int style) {
        return this.createErrorHyperlink(BuildUIHelperMessages.ErrorHyperlinkHelper_DEFAULT_LABEL, errorMessage, exception, style);
    }

    public Hyperlink createErrorHyperlink(String label, String errorMessage, Exception exception, int style) {
        final Hyperlink hyperlink = this.fToolkit.createHyperlink(this.fParent, label, style);
        hyperlink.addHyperlinkListener(this.getHyperlinkListener(errorMessage, exception));
        Listener mouseListener = new Listener(){

            public void handleEvent(Event event) {
                hyperlink.setUnderlined(event.type == 6);
                hyperlink.setForeground(JFaceColors.getErrorText((Display)Display.getDefault()));
            }
        };
        hyperlink.addListener(6, mouseListener);
        hyperlink.addListener(7, mouseListener);
        hyperlink.setForeground(JFaceColors.getErrorText((Display)Display.getDefault()));
        return hyperlink;
    }

    protected IHyperlinkListener getHyperlinkListener(final String errorMessage, final Exception exception) {
        HyperlinkAdapter listener = new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ErrorHyperlinkHelper.this.handleLinkActivated(ErrorHyperlinkHelper.this.fParent.getShell(), BuildUIHelperMessages.ErrorHyperlinkHelper_DEFAULT_DIALOG_TITLE, exception == null ? errorMessage : null, new Status(1, BuildUIPlugin.getUniqueIdentifier(), exception == null ? null : errorMessage, (Throwable)exception));
            }
        };
        return listener;
    }

    protected void handleLinkActivated(Shell shell, String title, String errorMessage, Status status) {
        ErrorDialog.openError((Shell)shell, (String)title, (String)errorMessage, (IStatus)status);
    }
}

